/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.intrn.util.BytePack;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.pgm.receiver.AdminEvent;
import com.ibm.rmm.ptl.pgm.receiver.LongStreamHash;
import com.ibm.rmm.ptl.pgm.receiver.NackGenerator;
import com.ibm.rmm.ptl.pgm.receiver.PReceiver;
import com.ibm.rmm.ptl.pgm.receiver.PacketReceiver;
import com.ibm.rmm.ptl.pgm.receiver.StreamR;
import java.io.IOException;
import java.nio.ByteBuffer;

class PacketProcessor
extends Thread {
    static final String moduleName = "PTL_PGM_R";
    boolean isSleeping;
    PacketReceiver packetReceiver;
    PReceiver pRec;
    volatile int nRot;
    volatile boolean threadStopped = false;
    private BytePack bp;
    private ByteBuffer bb;
    private byte[] tagBuf;
    private int tagLen;
    private byte[] jniSrcAddress;
    private int jniSrcAddressLen;
    private int jniOff;
    private boolean ljEnabled;
    private int ljMarkerPos;
    private byte[] spmNEAddress;
    private int spmNEAddressLen;
    private byte[] rmmContrMcAddr;
    private int rmmContrMcAddrLen;
    private boolean hasFin;
    private byte isReliable;
    private byte optionsByte;
    private int hbTimeout;
    private int adminOptN;
    private byte[] adminOptKey;
    private byte[][] adminOptVal;
    private int[] requestedSeqN;
    private int requestedN;
    private boolean goOn = true;
    LongStreamHash streamHash;

    PacketProcessor(PReceiver prc, PacketReceiver par) {
        this.pRec = prc;
        this.packetReceiver = par;
        this.packetReceiver.packetProcessor = this;
        this.streamHash = new LongStreamHash(10);
        this.tagBuf = new byte[Short.MAX_VALUE];
        this.jniSrcAddress = new byte[16];
        this.spmNEAddress = new byte[16];
        this.rmmContrMcAddr = new byte[16];
        this.requestedSeqN = new int[63];
        this.adminOptKey = new byte[16];
        this.adminOptVal = new byte[16][];
    }

    private StreamR fetchStream(long sid, byte[] jni_address, int jni_addr_len, byte[] tag_buffer, int tag_length) {
        StreamR stream = this.streamHash.get(sid);
        if (stream != null) {
            return stream;
        }
        stream = this.pRec.fetchStream(sid, this.streamHash, this.bp.getDatagramPacket(), jni_address, jni_addr_len, tag_buffer, tag_length);
        return stream;
    }

    private void processDataPacket(byte type, long sid, int tsdu_len) throws IOException {
        int packet_n = this.bb.getInt();
        int trail_n = this.bb.getInt();
        StreamR stream = this.streamHash.get(sid);
        if (stream == null) {
            this.readOptions();
            if (this.hasFin) {
                return;
            }
            stream = this.fetchStream(sid, this.jniSrcAddress, this.jniSrcAddressLen, this.tagBuf, this.tagLen);
            if (stream == null) {
                return;
            }
            stream.mtlOffset = this.bb.position() - this.jniOff;
        } else if (stream.mtlOffset == 0) {
            this.readOptions();
            stream.mtlOffset = this.bb.position() - this.jniOff;
        } else {
            this.jumpOptions();
            stream.mtlOffset = this.bb.position() - this.jniOff;
        }
        stream.processDataPacket(type, packet_n, trail_n, this.ljEnabled, this.ljMarkerPos, this.hasFin, this.bp.getByteArray(), stream.mtlOffset + this.jniOff, tsdu_len);
    }

    private void processSpm(long sid) throws IOException {
        int spm_n = this.bb.getInt();
        int trail_n = this.bb.getInt();
        int front_n = this.bb.getInt();
        short nla_afi = this.bb.getShort();
        this.bb.getShort();
        this.spmNEAddressLen = nla_afi == 1 ? 4 : 16;
        this.bb.get(this.spmNEAddress, 0, this.spmNEAddressLen);
        this.readOptions();
        StreamR stream = this.streamHash.get(sid);
        if (stream == null) {
            if (this.hasFin) {
                return;
            }
            stream = this.fetchStream(sid, this.jniSrcAddress, this.jniSrcAddressLen, this.tagBuf, this.tagLen);
        }
        if (stream == null) {
            return;
        }
        stream.processSpm(front_n, trail_n, this.ljEnabled, this.ljMarkerPos, spm_n, this.hasFin, this.spmNEAddress, this.spmNEAddressLen, this.hbTimeout, this.isReliable, this.rmmContrMcAddr, this.rmmContrMcAddrLen, this.adminOptN, this.adminOptVal, this.adminOptKey);
    }

    private void processNak(byte type, long sid) throws IOException {
        StreamR stream = this.streamHash.get(sid);
        if (stream == null) {
            return;
        }
        this.requestedSeqN[0] = this.bb.getInt();
        this.requestedN = 1;
        if (this.optionsByte != 0) {
            short nla_afi = this.bb.getShort();
            this.bb.position(this.bb.position() + 2);
            int adr_len = nla_afi == 1 ? 4 : 16;
            this.bb.position(this.bb.position() + adr_len);
            nla_afi = this.bb.getShort();
            this.bb.position(this.bb.position() + 2);
            adr_len = nla_afi == 1 ? 4 : 16;
            this.bb.position(this.bb.position() + adr_len);
            this.readOptions();
        }
        if (stream.catchNacks) {
            long time = Clock.getTime();
            int i = 0;
            while (i < this.requestedN) {
                NackGenerator.NackInfo pnk = (NackGenerator.NackInfo)stream.nakObjmap.get(this.requestedSeqN[i]);
                if (pnk != null) {
                    pnk.newNakNcfTime = time;
                    pnk.flag = type;
                }
                ++i;
            }
        }
    }

    private void processReport(long sid) throws IOException {
        StreamR stream = this.streamHash.get(sid);
        if (stream == null) {
            return;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("PacketProcessor: Report received", moduleName);
        }
        if (stream.adminListener != null) {
            AdminEvent ev = new AdminEvent(16, stream);
            byte[] report = new byte[this.bp.getdataLength()];
            this.bb.rewind();
            this.bb.get(report);
            ev.objField = report;
            stream.adminListener.onEvent(ev);
        }
    }

    private void readOptions() throws IOException {
        this.ljEnabled = false;
        this.hasFin = false;
        byte type = this.bb.get();
        if (type != 0) {
            this.pRec.rmmLogger.baseWarn("No PGM_OPT_LEN", null, moduleName);
            this.bb.position(this.bb.position() - 1);
            return;
        }
        this.bb.get();
        int total_opt_len = this.bb.getShort();
        if (total_opt_len < 0) {
            total_opt_len -= -65536;
        }
        total_opt_len -= 4;
        block7: while (total_opt_len > 0) {
            type = this.bb.get();
            int opt_len = this.bb.get();
            if (opt_len < 0) {
                opt_len += 256;
            }
            this.bb.getShort();
            if (opt_len == 0) {
                this.pRec.rmmLogger.baseError("Option length is 0", null, moduleName);
                break;
            }
            total_opt_len -= opt_len;
            switch (type) {
                case 3: {
                    this.ljEnabled = true;
                    this.ljMarkerPos = this.bb.getInt();
                    break;
                }
                case 14: {
                    this.hasFin = true;
                    break;
                }
                case 33: {
                    this.rmmContrMcAddrLen = this.bb.get();
                    this.bb.get(this.rmmContrMcAddr, 0, this.rmmContrMcAddrLen);
                    this.isReliable = this.bb.get();
                    this.hbTimeout = this.bb.getInt();
                    this.adminOptN = this.bb.get();
                    int i = 0;
                    while (i < this.adminOptN) {
                        this.adminOptKey[i] = this.bb.get();
                        byte len = this.bb.get();
                        this.adminOptVal[i] = new byte[len];
                        this.bb.get(this.adminOptVal[i], 0, len);
                        ++i;
                    }
                    continue block7;
                }
                case -94: {
                    this.tagLen = opt_len - 4;
                    this.bb.get(this.tagBuf, 0, this.tagLen);
                    break;
                }
                case -126: {
                    int n_add = (opt_len - 4) / 4;
                    int i = 0;
                    while (i < n_add) {
                        this.requestedSeqN[i + 1] = this.bb.getInt();
                        ++this.requestedN;
                        ++i;
                    }
                    continue block7;
                }
                default: {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxWarn("Unknown option " + type, null, moduleName);
                    }
                    this.bb.position(this.bb.position() + opt_len - 4);
                }
            }
        }
    }

    private void jumpOptions() throws IOException {
        byte type = this.bb.get();
        if (type != 0) {
            this.pRec.rmmLogger.baseWarn("No PGM_OPT_LEN", null, moduleName);
            this.bb.position(this.bb.position() - 1);
            return;
        }
        this.bb.get();
        short total_opt_len = this.bb.getShort();
        this.bb.position(this.bb.position() + total_opt_len - 4);
    }

    void removeStream(StreamRIf stream) {
        this.streamHash.remove(stream.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(Object buffer) {
        ObjCyclQueue objCyclQueue = this.packetReceiver.bufferQueue;
        synchronized (objCyclQueue) {
            this.packetReceiver.bufferQueue.pushLast(buffer);
            if (this.packetReceiver.isSleeping) {
                this.packetReceiver.bufferQueue.notify();
            }
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketProcessor"}, null, moduleName);
        int cnt = 0;
        int nWfb = 0;
        ByteBuffer sidBB = ByteBuffer.allocate(16);
        byte[] sidBA = sidBB.array();
        this.isSleeping = false;
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                if (this.packetReceiver.packetQueue.qSize() == 0) {
                    PacketProcessor.yield();
                }
                ObjCyclQueue objCyclQueue = this.packetReceiver.packetQueue;
                synchronized (objCyclQueue) {
                    while (this.packetReceiver.packetQueue.qSize() == 0) {
                        if (++nWfb % 10000 == 0 && this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("PacketProcessor: waiting for buffer: " + nWfb + " " + this.packetReceiver.bufferQueue.qSize(), moduleName);
                        }
                        this.isSleeping = true;
                        this.packetReceiver.packetQueue.wait();
                        this.isSleeping = false;
                    }
                    this.bp = (BytePack)this.packetReceiver.packetQueue.popFirst();
                }
                this.bb = this.bp.getByteBuffer();
                this.bb.rewind();
                ++cnt;
                if (this.pRec.config.pgmOverIp) {
                    byte skip = this.bb.get();
                    this.bb.position(this.bb.position() + skip - 1);
                    this.jniSrcAddressLen = this.bb.get();
                    this.bb.get(this.jniSrcAddress, 0, this.jniSrcAddressLen);
                }
                this.jniOff = this.bb.position();
                this.bb.get(sidBA, 0, 2);
                int dst_port = this.bb.getShort();
                if (dst_port < 0) {
                    dst_port -= -65536;
                }
                byte packet_type = this.bb.get();
                this.optionsByte = this.bb.get();
                this.bb.getShort();
                this.bb.get(sidBA, 2, 6);
                sidBB.rewind();
                long sid = sidBB.getLong();
                int tsdu_len = this.bb.getShort();
                if (tsdu_len < 0) {
                    tsdu_len -= -65536;
                }
                if (packet_type != 8 && dst_port != this.pRec.config.dataPort) {
                    this.pRec.rmmLogger.baseWarn("Wrong destination port " + dst_port, null, moduleName);
                    return;
                }
                if (packet_type == 4 || packet_type == 5) {
                    this.processDataPacket(packet_type, sid, tsdu_len);
                } else if (packet_type == 0) {
                    this.processSpm(sid);
                } else if (packet_type == 8 || packet_type == 10) {
                    this.processNak(packet_type, sid);
                } else if (packet_type == 15) {
                    this.processReport(sid);
                } else {
                    this.pRec.rmmLogger.baseWarn("Unknown packet type. Stream: " + sid, null, moduleName);
                }
                this.returnBuffer(this.bp);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketProcessor: Exception in thread loop", ex, moduleName);
                this.returnBuffer(this.bp);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketProcessor"}, ex, moduleName);
                break;
            }
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketProcessor"}, null, moduleName);
    }
}

