/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.intrn.util.BytePack;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.PgmIpSocket;
import com.ibm.rmm.ptl.pgm.receiver.PReceiver;
import com.ibm.rmm.ptl.pgm.receiver.PacketProcessor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Vector;

class PacketReceiver
extends Thread {
    static final String moduleName = "PTL_PGM_R";
    PReceiver pRec;
    PacketProcessor packetProcessor;
    Vector mcastGroups;
    MulticastSocket udpMcSocket;
    PgmIpSocket ipMcSocket;
    volatile int nRot;
    volatile boolean threadStopped = false;
    boolean isSleeping = false;
    private boolean goOn = true;
    ObjCyclQueue bufferQueue;
    ObjCyclQueue packetQueue;
    private int thePort;

    PacketReceiver(PReceiver prc, int port2) {
        this.pRec = prc;
        this.thePort = port2;
        this.bufferQueue = new ObjCyclQueue(this.pRec.config.nBuffers);
        int i = 0;
        while (i < this.pRec.config.nBuffers) {
            this.bufferQueue.pushLast(new BytePack(this.pRec.config.packetSize, false));
            ++i;
        }
        this.packetQueue = new ObjCyclQueue(this.pRec.config.nBuffers);
        this.mcastGroups = new Vector();
        if (this.pRec.config.pgmOverIp) {
            try {
                this.ipMcSocket = PgmIpLayer.createRecIpSocket(true, this.pRec.mcInterf, this.pRec.config.socketBufferSize);
            }
            catch (IOException e2) {
                this.pRec.rmmLogger.baseLog(404, new Object[]{""}, e2, moduleName);
            }
        } else {
            this.udpMcSocket = this.createUdpSocket();
        }
    }

    private MulticastSocket createUdpSocket() {
        MulticastSocket ms = null;
        try {
            ms = new MulticastSocket(this.thePort);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(404, new Object[]{"" + this.thePort}, ex, moduleName);
            return null;
        }
        try {
            ms.setReceiveBufferSize(this.pRec.config.socketBufferSize);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(413, new Object[]{"Multicast UDP ReceiverBufferSize", "" + this.pRec.config.socketBufferSize}, ex, moduleName);
        }
        int real_size = 0;
        try {
            real_size = ms.getReceiveBufferSize();
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to measure Socket RecBuffer", ex, moduleName);
        }
        this.pRec.rmmLogger.baseInfo("Socket RecBufferSize set to " + real_size / 1024 + " Kbytes", moduleName);
        if (real_size < this.pRec.config.socketBufferSize) {
            this.pRec.rmmLogger.baseWarn("Socket RecBufferSize set to " + real_size / 1024 + " Kbytes. Different from configured size." + "\nCan lead to poor reception performance. Consult sysadmin to configure the UDP Reception Buffer size parameter of the OS", null, moduleName);
            this.pRec.rmmLogger.baseLog(413, new Object[]{"Multicast UDP ReceiverBufferSize", "" + this.pRec.config.socketBufferSize}, null, moduleName);
        }
        if (this.pRec.mcInterf != null) {
            try {
                this.pRec.rmmLogger.baseInfo("PacketReceiver: Setting interface to " + this.pRec.mcInterf, moduleName);
                ms.setInterface(this.pRec.mcInterf);
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseLog(405, new Object[]{this.pRec.mcInterf}, ex, moduleName);
            }
        }
        if (this.pRec.config.setLoopback != null) {
            boolean set = Boolean.valueOf(this.pRec.config.setLoopback);
            boolean res = false;
            try {
                ms.setLoopbackMode(set);
                res = ms.getLoopbackMode();
            }
            catch (SocketException e2) {
                this.pRec.rmmLogger.baseWarn("Failed to set/get Loopback mode", e2, moduleName);
            }
            if (set != res) {
                this.pRec.rmmLogger.baseWarn("Loopback mode set to " + res, null, moduleName);
            }
        }
        return ms;
    }

    boolean addGroup(InetAddress address) {
        int i = 0;
        while (i < this.mcastGroups.size()) {
            InetAddress tmp = (InetAddress)this.mcastGroups.elementAt(i);
            if (tmp.equals(address)) {
                return true;
            }
            ++i;
        }
        this.pRec.rmmLogger.baseInfo("Joining multicast group " + address.getHostAddress(), moduleName);
        this.mcastGroups.addElement(address);
        try {
            if (this.pRec.config.pgmOverIp) {
                this.ipMcSocket.joinGroup(address);
            } else {
                this.udpMcSocket.joinGroup(address);
            }
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(408, new Object[]{address.getHostAddress()}, ex, moduleName);
            return false;
        }
        return true;
    }

    boolean leaveGroup(InetAddress address) {
        if (!this.mcastGroups.contains(address)) {
            return true;
        }
        this.pRec.rmmLogger.baseInfo("Leaving multicast group " + address.getHostAddress(), moduleName);
        this.mcastGroups.removeElement(address);
        try {
            if (this.pRec.config.pgmOverIp) {
                this.ipMcSocket.leaveGroup(address);
            } else {
                this.udpMcSocket.leaveGroup(address);
            }
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseLog(408, new Object[]{address.getHostAddress()}, ex, moduleName);
            return false;
        }
        return true;
    }

    int getPort() {
        return this.thePort;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketReceiver"}, null, moduleName);
        int nWfb = 0;
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                BytePack bp;
                if (this.bufferQueue.qSize() == 0) {
                    PacketReceiver.yield();
                }
                ObjCyclQueue objCyclQueue = this.bufferQueue;
                synchronized (objCyclQueue) {
                    while (this.bufferQueue.qSize() == 0) {
                        if (++nWfb % 10000 == 0) {
                            this.pRec.rmmLogger.baseWarn("PacketReceiver: waiting for buffer: " + nWfb, null, moduleName);
                        } else if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxWarn("PacketReceiver: waiting for buffer", null, moduleName);
                        }
                        this.isSleeping = true;
                        this.bufferQueue.wait();
                        this.isSleeping = false;
                    }
                    bp = (BytePack)this.bufferQueue.popFirst();
                }
                DatagramPacket packet = bp.getDatagramPacket();
                if (this.pRec.config.pgmOverIp) {
                    this.ipMcSocket.receive(bp);
                } else {
                    this.udpMcSocket.receive(packet);
                    bp.setdataLength(packet.getLength());
                }
                if (bp.getdataLength() >= this.pRec.config.packetSize) {
                    this.pRec.rmmLogger.baseLog(415, new Object[]{"" + this.pRec.config.packetSize, packet.getAddress().getHostAddress()}, null, moduleName);
                    this.packetProcessor.returnBuffer(bp);
                    continue;
                }
                objCyclQueue = this.packetQueue;
                synchronized (objCyclQueue) {
                    this.packetQueue.pushLast(bp);
                    if (this.packetProcessor.isSleeping) {
                        this.packetQueue.notify();
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException || ex instanceof InterruptedIOException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketReceiver"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketReceiver: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketReceiver", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketReceiver"}, ex, moduleName);
                break;
            }
        }
        try {
            if (this.pRec.config.pgmOverIp) {
                this.ipMcSocket.close();
            } else {
                this.udpMcSocket.close();
            }
        }
        catch (Exception e2) {
            this.pRec.rmmLogger.baseError("PacketReceiver: failed to close socket", e2, moduleName);
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketReceiver"}, null, moduleName);
    }
}

