/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjMap;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.admin.AckSessionR;
import com.ibm.rmm.ptl.ifc.receiver.REventIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.pgm.receiver.AdminEvent;
import com.ibm.rmm.ptl.pgm.receiver.PEvent;
import com.ibm.rmm.ptl.pgm.receiver.PReceiver;
import com.ibm.rmm.ptl.pgm.receiver.StreamSet;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class StreamR
implements StreamRIf {
    static final String moduleName = "PTL_PGM_R";
    PReceiver pRec;
    long id;
    byte[] localId;
    byte[] gSi;
    byte[] tag;
    InetAddress sourceIP;
    byte[] sourceIPbytes;
    int sourceIpHandle;
    InetAddress mcastGroup;
    byte[] mcastGroupBytes;
    int mcastGroupHandle;
    int sourcePort;
    boolean isReliable;
    StreamSet mySet;
    DatagramPacket nackUPacket;
    DatagramPacket nackMPacket;
    int ngHead;
    int ngTail;
    ObjMap nakObjmap;
    InetAddress nackAddress;
    int nackAddressHandle;
    byte[] nackAddressBytes;
    boolean gotFirstSpm;
    int spmSeqN;
    DatagramPacket repUPacket;
    DatagramPacket repMPacket;
    ByteArrayOutputStream repBaos;
    DataOutputStream repDos;
    StreamBitmap strBitmap;
    int packSeqN;
    int frontSeqN;
    int trailSeqN;
    int lastContigN;
    int lateJoinMarkPos;
    boolean lateJoin;
    int tmpFront;
    int pCounter;
    int hbTimeout;
    long lastSpmOrDataTime;
    boolean transClosed;
    boolean hbHasTimedOut;
    boolean firstHbTimeoutCall;
    boolean catchNacks;
    Vector caughtNacks;
    boolean firstPack;
    byte[] lastNack;
    Object nackLock;
    boolean nackSuspend;
    boolean dataSuspend;
    AdminLayerListener adminListener;
    AckSessionR acker;
    boolean relEvSent;
    int mtlOffset;
    StreamRUpcalls dataListener;

    StreamR(PReceiver prc, StreamSet set, long id, byte[] tag, InetAddress source_address, int nack_port, boolean fifo) {
        byte[] tmp;
        this.pRec = prc;
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Receiving PTL stream " + id + " from " + source_address.getHostAddress() + ":" + nack_port, moduleName);
        }
        if (fifo) {
            this.pRec.rmmLogger.baseError("StreamR: currently FIFO is not supported at PTL layer. Stream: " + id, null, moduleName);
        }
        this.mySet = set;
        this.id = id;
        this.sourceIP = source_address;
        this.sourceIPbytes = this.sourceIP.getAddress();
        this.sourcePort = nack_port;
        this.tag = tag;
        try {
            tmp = Sutils.longToByteArray(id);
        }
        catch (IOException e2) {
            this.pRec.rmmLogger.baseError("Failed to convert TSI " + id + " to byte[]", e2, moduleName);
            return;
        }
        this.localId = new byte[2];
        this.gSi = new byte[6];
        System.arraycopy(tmp, 0, this.localId, 0, 2);
        System.arraycopy(tmp, 2, this.gSi, 0, 6);
        this.nackLock = new Object();
        this.transClosed = false;
        this.hbHasTimedOut = false;
        this.isReliable = !this.mySet.relOff;
        this.firstPack = true;
        this.caughtNacks = new Vector();
        this.frontSeqN = -1;
        this.trailSeqN = 0;
        this.lastContigN = -1;
        this.pCounter = 0;
        this.hbTimeout = 60000;
        this.lastSpmOrDataTime = System.currentTimeMillis();
        this.nackUPacket = new DatagramPacket(new byte[1], 1);
        this.nackUPacket.setPort(nack_port);
        this.repUPacket = new DatagramPacket(new byte[1], 1);
        this.repUPacket.setAddress(this.sourceIP);
        this.repUPacket.setPort(nack_port);
        if (this.pRec.config.pgmOverIp) {
            try {
                this.sourceIpHandle = PgmIpLayer.getAddressHandle(this.sourceIP.getHostAddress());
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseError("Failed to PgmIpLayer.getAddressHandle", ex, moduleName);
                return;
            }
        }
        this.nackMPacket = new DatagramPacket(new byte[1], 1);
        this.nackMPacket.setPort(this.pRec.config.dataPort);
        this.repMPacket = new DatagramPacket(new byte[1], 1);
        this.repMPacket.setPort(this.pRec.config.dataPort);
        this.repBaos = new ByteArrayOutputStream();
        this.repDos = new DataOutputStream(this.repBaos);
    }

    public byte[] getTag() {
        return this.tag;
    }

    public long getId() {
        return this.id;
    }

    public InetAddress getSourceAddress() {
        return this.sourceIP;
    }

    public InetAddress getMulticastGroup() {
        return this.mcastGroup;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getFrontSeqN() {
        return this.frontSeqN;
    }

    public int getContigSeqN() {
        if (this.dataListener == null) {
            return -1;
        }
        return this.dataListener.getContigiousSeqN();
    }

    public int getTotPacks() {
        return this.pCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReportPacket(byte[] report, boolean unicast, boolean multicast) {
        block24: {
            byte[] rep_p;
            block23: {
                if (!unicast && !multicast) {
                    this.pRec.rmmLogger.baseError("sendReportPacket(false, false). Was not sent. Stream: " + this.toString(), null, moduleName);
                    return;
                }
                this.repBaos.reset();
                try {
                    this.repDos.writeShort(this.pRec.config.dataPort);
                    this.repDos.write(this.localId);
                    this.repDos.writeByte(15);
                    this.repDos.writeByte(0);
                    this.repDos.writeShort(0);
                    this.repDos.write(this.gSi, 0, 6);
                    this.repDos.writeShort(0);
                    this.repDos.write(report);
                }
                catch (IOException ex) {
                    this.pRec.rmmLogger.baseError("Failed to write report. Stream: " + this.toString(), ex, moduleName);
                }
                rep_p = this.repBaos.toByteArray();
                if (unicast) {
                    try {
                        Object object;
                        if (this.pRec.config.pgmOverIp) {
                            object = this.pRec.streamNackSender.ipUcSocket;
                            synchronized (object) {
                                this.pRec.streamNackSender.ipUcSocket.send(this.sourceIpHandle, rep_p, rep_p.length);
                                break block23;
                            }
                        }
                        this.repUPacket.setData(rep_p);
                        this.repUPacket.setLength(rep_p.length);
                        object = this.pRec.streamNackSender.udpUcSocket;
                        synchronized (object) {
                            this.pRec.streamNackSender.udpUcSocket.send(this.repUPacket);
                        }
                    }
                    catch (IOException e2) {
                        this.pRec.rmmLogger.baseError("Failed to send report. Stream: " + this.toString(), e2, moduleName);
                        this.pRec.rmmLogger.baseLog(417, new Object[]{this.repUPacket.getAddress().getHostAddress()}, e2, moduleName);
                    }
                }
            }
            if (multicast && this.mcastGroup != null) {
                try {
                    Object e2;
                    if (this.pRec.config.pgmOverIp) {
                        e2 = this.pRec.streamNackSender.ipMcSocket;
                        synchronized (e2) {
                            this.pRec.streamNackSender.ipMcSocket.send(this.mcastGroupHandle, rep_p, rep_p.length);
                            break block24;
                        }
                    }
                    this.repMPacket.setData(rep_p);
                    this.repMPacket.setLength(rep_p.length);
                    e2 = this.pRec.streamNackSender.udpMcSocket;
                    synchronized (e2) {
                        this.pRec.streamNackSender.udpMcSocket.send(this.repMPacket);
                    }
                }
                catch (IOException e3) {
                    this.pRec.rmmLogger.baseError("Failed to send report suppression. Stream: " + this.toString(), e3, moduleName);
                    this.pRec.rmmLogger.baseLog(417, new Object[]{this.repMPacket.getAddress().getHostAddress()}, e3, moduleName);
                }
            }
        }
    }

    public void suspendDataAndNack() {
        this.pRec.rmmLogger.baseWarn("Reception suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(11, this);
        this.mySet.packetListener.onEvent(ev);
        this.dataSuspend = true;
        this.nackSuspend = true;
    }

    public void suspendDataReception() {
        this.pRec.rmmLogger.baseWarn("Reception suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(11, this);
        this.mySet.packetListener.onEvent(ev);
        this.dataSuspend = true;
    }

    public void suspendNackSending() {
        this.pRec.rmmLogger.baseWarn("Nacking suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(12, this);
        this.mySet.packetListener.onEvent(ev);
        this.nackSuspend = true;
    }

    public void resumeDataReception(boolean advance_contig) {
        PEvent ev = new PEvent(14, this);
        this.mySet.packetListener.onEvent(ev);
        if (advance_contig) {
            this.tmpFront = this.frontSeqN;
            this.lastContigN = this.frontSeqN;
        }
        this.dataSuspend = false;
    }

    public void resumeNackAndData() {
        PEvent ev = new PEvent(13, this);
        this.mySet.packetListener.onEvent(ev);
        this.tmpFront = this.frontSeqN;
        this.lastContigN = this.frontSeqN;
        this.dataSuspend = false;
        this.nackSuspend = false;
    }

    void processDataPacket(byte type, int packet_n, int trail_n, boolean lj_enabled, int lj_marker_pos, boolean fin, byte[] buffer, int offset, int length) {
        int gap;
        this.lastSpmOrDataTime = Clock.getTime();
        if (this.dataSuspend && type == 4) {
            return;
        }
        this.packSeqN = packet_n;
        if (this.firstPack) {
            if (lj_enabled) {
                this.trailSeqN = lj_marker_pos;
                this.lateJoin = true;
                this.lateJoinMarkPos = lj_marker_pos;
            } else {
                this.trailSeqN = this.packSeqN;
                this.lateJoin = false;
            }
            this.frontSeqN = this.packSeqN;
            this.strBitmap = new StreamBitmap(this.trailSeqN, 4096, 4096);
            this.nakObjmap = new ObjMap(this.trailSeqN, 4096, 4096);
            this.ngHead = this.trailSeqN - 1;
            this.ngTail = this.trailSeqN;
            this.firstPack = false;
        }
        if ((gap = this.packSeqN - this.frontSeqN) > 0) {
            this.frontSeqN = this.packSeqN;
        }
        if (this.strBitmap.has(this.packSeqN)) {
            return;
        }
        gap = this.packSeqN - this.trailSeqN;
        if (gap < 0) {
            return;
        }
        this.strBitmap.set(this.packSeqN);
        ++this.pCounter;
        if (!this.isReliable && this.pCounter % 70 == 0) {
            trail_n = this.frontSeqN - 50;
        }
        if ((gap = trail_n - this.trailSeqN) > 0) {
            this.advanceTrail(trail_n, gap);
        }
        if (fin && !this.transClosed) {
            PEvent ev = new PEvent(5, this);
            this.mySet.packetListener.onEvent(ev);
            this.transClosed = true;
            if (this.adminListener != null) {
                AdminEvent aev = new AdminEvent(5, this);
                this.adminListener.onEvent(aev);
            }
        }
        if (this.dataListener == null) {
            this.mySet.packetListener.onFirstPacket(this, this.packSeqN, buffer, offset, length, this.lateJoin, this.lateJoinMarkPos);
        } else {
            this.dataListener.onPacket(this.packSeqN, buffer, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void processSpm(int packet_n, int trail_n, boolean lj_enabled, int lj_marker_pos, int spm_n, boolean fin, byte[] nack_addr_bytes, int nack_addr_len, int hb_timeout, int rel, byte[] mc_group_bytes, int mc_group_len, int n_admin_opt, byte[][] admin_opt_val, byte[] admin_opt_type) {
        if (!this.gotFirstSpm) {
            this.spmSeqN = spm_n;
        } else {
            gap = spm_n - this.spmSeqN;
            if (gap <= 0) {
                return;
            }
            this.spmSeqN = spm_n;
        }
        if (fin) {
            if (!this.transClosed) {
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("Got FIN. Stream transmission closed by sender. Stream Id: " + this.id, "PTL_PGM_R");
                }
                ev = new PEvent(5, this);
                this.mySet.packetListener.onEvent(ev);
                this.transClosed = true;
                if (this.adminListener != null) {
                    aev = new AdminEvent(5, this);
                    this.adminListener.onEvent(aev);
                }
            }
            return;
        }
        this.lastSpmOrDataTime = Clock.getTime();
        assign_nack_addr = false;
        if (this.nackAddressBytes == null) {
            assign_nack_addr = true;
        } else if (this.nackAddressBytes.length != nack_addr_len) {
            assign_nack_addr = true;
        } else {
            i = 0;
            while (i < nack_addr_len) {
                if (this.nackAddressBytes[i] != nack_addr_bytes[i]) {
                    assign_nack_addr = true;
                    break;
                }
                ++i;
            }
        }
        if (assign_nack_addr) {
            block46: {
                this.nackAddressBytes = new byte[nack_addr_len];
                System.arraycopy(nack_addr_bytes, 0, this.nackAddressBytes, 0, nack_addr_len);
                try {
                    this.nackAddress = InetAddress.getByAddress(this.nackAddressBytes);
                    break block46;
                }
                catch (UnknownHostException e) {
                    tmp = "";
                    i = 0;
                    ** while (i < nack_addr_len)
                }
lbl-1000:
                // 1 sources

                {
                    tmp = String.valueOf(tmp) + this.nackAddressBytes[i] + ".";
                    ++i;
                    continue;
                }
lbl47:
                // 1 sources

                this.pRec.rmmLogger.baseError("Spm: Failed to convert Path NLA " + tmp + " to InetAddress ", e, "PTL_PGM_R");
                this.pRec.rmmLogger.baseLog(412, new Object[]{tmp}, e, "PTL_PGM_R");
            }
            this.nackUPacket.setAddress(this.nackAddress);
            if (this.pRec.config.pgmOverIp) {
                try {
                    this.nackAddressHandle = PgmIpLayer.getAddressHandle(this.nackAddress.getHostAddress());
                }
                catch (IOException e) {
                    this.pRec.rmmLogger.baseError("Failed to obtain nackAddressHandle for " + this.nackAddress.getHostAddress(), e, "PTL_PGM_R");
                    return;
                }
            }
        }
        this.hbTimeout = hb_timeout;
        v0 = isrel = rel == 1;
        if (isrel != this.isReliable && !this.relEvSent) {
            ev = new PEvent(4, this);
            this.mySet.packetListener.onEvent((REventIf)ev);
            if (this.isReliable) {
                this.isReliable = false;
            }
            this.relEvSent = true;
        }
        if (trail_n != 0 || packet_n != -2147483648) {
            if (this.firstPack) {
                if (lj_enabled) {
                    this.pRec.rmmLogger.baseInfo("Late join in CP " + lj_marker_pos + " " + packet_n + ". Stream: " + this.toString(), "PTL_PGM_R");
                    this.lateJoin = true;
                    this.lateJoinMarkPos = lj_marker_pos;
                    this.trailSeqN = lj_marker_pos;
                    this.frontSeqN = packet_n;
                    this.strBitmap = new StreamBitmap(this.trailSeqN, 4096, 4096);
                    this.firstPack = false;
                    ev = this.pRec.streamNackSender;
                    synchronized (ev) {
                        this.pRec.streamNackSender.notify();
                    }
                }
            } else {
                gap = packet_n - this.frontSeqN;
                if (gap > 0) {
                    ev = this.strBitmap;
                    synchronized (ev) {
                        this.frontSeqN = packet_n;
                    }
                }
                if ((gap = trail_n - this.trailSeqN) > 0) {
                    this.advanceTrail(trail_n, gap);
                }
            }
        }
        if (this.mcastGroup == null) {
            block47: {
                this.mcastGroupBytes = new byte[mc_group_len];
                System.arraycopy(mc_group_bytes, 0, this.mcastGroupBytes, 0, mc_group_len);
                ia = null;
                try {
                    ia = InetAddress.getByAddress(this.mcastGroupBytes);
                    break block47;
                }
                catch (UnknownHostException e) {
                    tmp = "";
                    i = 0;
                    ** while (i < nack_addr_len)
                }
lbl-1000:
                // 1 sources

                {
                    tmp = String.valueOf(tmp) + this.nackAddressBytes[i] + ".";
                    ++i;
                    continue;
                }
lbl109:
                // 1 sources

                this.pRec.rmmLogger.baseError("Rmm Spm Opt: Failed to convert Mcast group " + tmp + " to InetAddress ", e, "PTL_PGM_R");
                this.pRec.rmmLogger.baseLog(412, new Object[]{tmp}, e, "PTL_PGM_R");
            }
            if (ia != null) {
                this.nackMPacket.setAddress(ia);
                this.repMPacket.setAddress(ia);
                this.mcastGroup = ia;
                if (this.pRec.config.pgmOverIp) {
                    try {
                        this.mcastGroupHandle = PgmIpLayer.getAddressHandle(ia.getHostAddress());
                    }
                    catch (IOException e) {
                        this.pRec.rmmLogger.baseError("Failed to obtain mcastGroupHandle for " + ia.getHostAddress(), e, "PTL_PGM_R");
                        return;
                    }
                }
            }
        }
        if (n_admin_opt > 0) {
            if (this.adminListener != null) {
                i = 0;
                while (i < n_admin_opt) {
                    ev = new AdminEvent(15, this);
                    ev.objField = admin_opt_val[i];
                    ev.intField = admin_opt_type[i];
                    this.adminListener.onEvent(ev);
                    ++i;
                }
            } else {
                this.pRec.rmmLogger.baseWarn("PacketProcessor.processControlPacket: No admin listener (to control options). Stream: " + this.toString(), null, "PTL_PGM_R");
            }
        }
        this.gotFirstSpm = true;
    }

    public int missingPackets(int from, int to) {
        int n_missing = 0;
        int gap = to - from;
        if (gap < 0) {
            this.pRec.rmmLogger.baseWarn("StreamR.missingPackets: 'to' less than 'from'. Stream: " + this.toString(), null, moduleName);
            return 0;
        }
        int i = from;
        while (i != to) {
            if (!this.strBitmap.has(i)) {
                ++n_missing;
            }
            ++i;
        }
        return n_missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advanceTrail(int new_trail, int gap) {
        if (this.isReliable && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Trail advanced by " + (new_trail - this.trailSeqN) + " packet(s). Stream: " + this.toString(), moduleName);
        }
        int n_lost = 0;
        int tmp_gap = new_trail - this.trailSeqN;
        if (tmp_gap <= 0) {
            this.pRec.rmmLogger.baseError("StreamR.advanceTrail: new_trail less than trailSeqN. Stream: " + this.toString(), null, moduleName);
            return;
        }
        int i = this.trailSeqN;
        while (new_trail - i > 0) {
            if (!this.strBitmap.has(i)) {
                ++n_lost;
            }
            ++i;
        }
        if (n_lost > 0) {
            PEvent ev = new PEvent(1, this);
            ev.intField = n_lost;
            this.mySet.packetListener.onEvent(ev);
        }
        if (n_lost > 0 && this.isReliable) {
            this.pRec.rmmLogger.baseWarn("Unrecoverable loss of " + n_lost + " packet(s) out of " + gap + ". Stream: " + this.toString(), null, moduleName);
        }
        if (this.dataListener != null) {
            this.dataListener.onTrailAdvance(new_trail);
        }
        StreamBitmap streamBitmap = this.strBitmap;
        synchronized (streamBitmap) {
            this.trailSeqN = new_trail;
            this.strBitmap.setTrail(this.trailSeqN);
        }
    }

    public void setReliabilityOff() {
        this.isReliable = false;
    }

    public void setAdminListener(AdminLayerListener col) {
        if (this.adminListener != null) {
            this.pRec.rmmLogger.baseWarn("StreamR.setAdminListener: replacing existing listener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.adminListener = col;
    }

    public void setDataListener(StreamRUpcalls l) {
        this.dataListener = l;
    }

    public void removeAdminListener() {
        this.adminListener = null;
    }

    public String toString() {
        return "" + this.id;
    }

    public void setAckSessionR(AckSessionR acker) {
        this.acker = acker;
    }

    public AckSessionR getAckSessionR() {
        return this.acker;
    }

    public UnicastConnectionIf getConnection() {
        return null;
    }
}

