/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.pgm.transmitter.Config;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;
import com.ibm.rmm.util.RmmLogger;

public class CongestionControl {
    private static final String mn = "PTL_PGM_T";
    private float lowerLossRateTreshold;
    private float upperLossRateTreshold;
    private float heavyLossRateTreshold;
    private float slowStartConst;
    private float adaptiveConst;
    private float ssThresConst;
    private float minRateConst;
    private final float bandPassFilter = 0.075f;
    private int maxRate;
    private int minRate;
    private int ssThres;
    private int nextRate;
    private float lossRate = 0.0f;
    private int prevNacks = 0;
    private boolean heavyLossesWarning = false;
    private final TokenBucket bucket;
    StreamT myStream;
    private RmmLogger rmmLogger;

    CongestionControl(Config config2, TokenBucket bucket, int max_rate, StreamT stream) {
        this.rmmLogger = config2.rmmLogger;
        this.bucket = bucket;
        this.setConst(config2);
        this.resetValues(max_rate);
        this.myStream = stream;
    }

    private void setConst(Config config2) {
        this.lowerLossRateTreshold = config2.lowerLossRateTreshold;
        this.upperLossRateTreshold = config2.upperLossRateTreshold;
        this.heavyLossRateTreshold = config2.heavyLossRateTreshold;
        this.slowStartConst = config2.slowStartConst;
        this.adaptiveConst = config2.adaptiveConst;
        this.ssThresConst = config2.ssThresConst;
        this.minRateConst = config2.minRateConst;
    }

    void resetValues(int max_rate) {
        if (max_rate < 100) {
            this.rmmLogger.baseWarn("CongestionControl: can not set maximum rate below 100 Kbps", null, mn);
        }
        this.maxRate = Math.max(max_rate, 100);
        this.minRate = Math.max((int)((float)this.maxRate * this.minRateConst), 1);
        this.ssThres = Math.max((int)((float)this.maxRate * this.ssThresConst), 1);
        this.nextRate = this.minRate;
        this.bucket.setRate(this.minRate);
    }

    void calculateNextRate(int nacks, int oData, int rData, int front) {
        float loss_rate = oData == 0 && nacks == 0 ? 0.0f : (oData == 0 && nacks != 0 ? (nacks >= this.prevNacks ? 1.0f : 0.0f) : (float)nacks / (float)oData);
        this.lossRate = 0.075f * this.lossRate + 0.925f * loss_rate;
        if (this.lossRate <= this.lowerLossRateTreshold) {
            this.heavyLossesWarning = false;
            this.nextRate = this.nextRate >= this.maxRate ? this.maxRate : (this.nextRate < this.ssThres ? (this.slowStartConst * (float)this.nextRate > (float)this.ssThres ? this.ssThres : Math.max((int)(this.slowStartConst * (float)this.nextRate), this.nextRate + 1)) : Math.max((int)(this.adaptiveConst * (float)this.nextRate), this.nextRate + 1));
        } else if (this.lossRate > this.upperLossRateTreshold && this.lossRate <= this.heavyLossRateTreshold) {
            this.ssThres = Math.max(this.minRate, (this.ssThres + this.nextRate) / 2);
            this.nextRate = Math.max(this.minRate, this.nextRate / 2);
        } else if (this.lossRate > this.heavyLossRateTreshold) {
            if (!this.heavyLossesWarning && nacks > 2) {
                this.rmmLogger.baseWarn("CongestionControl: congested: " + nacks + " packets were lost.\n current rate is " + this.nextRate + " Kbps. maximum rate is set to " + this.maxRate + " Kbps. Stream" + this.myStream, null, mn);
                this.heavyLossesWarning = true;
            }
            this.nextRate = this.minRate;
        }
        this.prevNacks = nacks;
        this.bucket.setRate(this.nextRate);
    }
}

