/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.BytePack;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.ptl.pgm.transmitter.AdminEvent;
import com.ibm.rmm.ptl.pgm.transmitter.PTransmitter;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;

class NackServer
extends Thread {
    static final String moduleName = "PTL_PGM_T";
    volatile int nRot;
    private BytePack nack;
    private BytePack ncf;
    private BytePack sidBuffer;
    private PTransmitter pTrans;
    private boolean goOn = true;

    NackServer(PTransmitter ptr) {
        this.pTrans = ptr;
        this.nack = new BytePack(2 * this.pTrans.packetSize, false);
        this.ncf = new BytePack(2 * this.pTrans.packetSize, false);
        this.sidBuffer = new BytePack(16, false);
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"NackServer"}, null, moduleName);
        DatagramPacket dp = this.nack.getDatagramPacket();
        ByteBuffer bb = this.nack.getByteBuffer();
        byte[] sidBa = this.sidBuffer.getByteArray();
        ByteBuffer sidBb = this.sidBuffer.getByteBuffer();
        DatagramPacket udpPacket = this.ncf.getDatagramPacket();
        byte jni_addr_len = 0;
        byte[] jni_addr_4 = new byte[4];
        byte[] jni_addr_6 = new byte[16];
        int[] requested_seq_n = new int[63];
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                AdminEvent ev;
                InetAddress src_addr;
                if (this.pTrans.config.pgmOverIp) {
                    this.pTrans.ipNackSocket.receive(this.nack);
                } else {
                    try {
                        this.pTrans.udpNackSocket.receive(this.nack.getDatagramPacket());
                    }
                    catch (SocketException ex) {
                        if (!this.pTrans.isRunning) continue;
                        this.pTrans.rmmLogger.baseWarn("Failed Nack reception", ex, moduleName);
                        continue;
                    }
                }
                bb.rewind();
                if (this.pTrans.config.pgmOverIp) {
                    byte skip = bb.get();
                    bb.position(bb.position() + skip - 1);
                    jni_addr_len = bb.get();
                    if (jni_addr_len == 4) {
                        bb.get(jni_addr_4, 0, jni_addr_len);
                        src_addr = Inet4Address.getByAddress(jni_addr_4);
                    } else {
                        bb.get(jni_addr_6, 0, jni_addr_len);
                        src_addr = Inet6Address.getByAddress(jni_addr_6);
                    }
                } else {
                    src_addr = dp.getAddress();
                }
                int src_port = bb.getShort();
                if (src_port < 0) {
                    src_port -= -65536;
                }
                bb.get(sidBa, 0, 2);
                byte packet_type = bb.get();
                byte opt_byte = bb.get();
                if (packet_type != 8 && packet_type != 15) continue;
                bb.getShort();
                bb.get(sidBa, 2, 6);
                sidBb.rewind();
                long sid = sidBb.getLong();
                bb.getShort();
                StreamT stream = null;
                Short key = new Short(sidBb.getShort(0));
                stream = (StreamT)this.pTrans.streamHT.get(key);
                if (stream == null || stream.longId != sid) {
                    return;
                }
                if (packet_type == 15) {
                    if (stream.adminListener != null) {
                        ev = new AdminEvent(1, src_addr, src_port);
                        ev.intField = bb.position();
                        byte[] tmp = this.nack.getByteArray();
                        if (tmp == null) {
                            tmp = new byte[this.nack.getdataLength()];
                            bb.rewind();
                            bb.get(tmp);
                        }
                        ev.objField = tmp;
                        stream.adminListener.onEvent(ev);
                    }
                    return;
                }
                if (!stream.isReliable) {
                    return;
                }
                if (stream.nack_bitmap == null) {
                    stream.nack_bitmap = new StreamBitmap(stream.trailSeqN, 4096, 4096);
                }
                requested_seq_n[0] = bb.getInt();
                int requested_n = 1;
                if (opt_byte != 0) {
                    short nla_afi = bb.getShort();
                    bb.position(bb.position() + 2);
                    int adr_len = nla_afi == 1 ? 4 : 16;
                    bb.position(bb.position() + adr_len);
                    nla_afi = bb.getShort();
                    bb.position(bb.position() + 2);
                    adr_len = nla_afi == 1 ? 4 : 16;
                    bb.position(bb.position() + adr_len);
                    byte type = bb.get();
                    if (type != 0) {
                        this.pTrans.rmmLogger.baseWarn("No PGM_OPT_LEN", null, moduleName);
                    }
                    bb.get();
                    int total_opt_len = bb.getShort();
                    if (total_opt_len < 0) {
                        total_opt_len -= -65536;
                    }
                    if ((type = bb.get()) != -126) {
                        this.pTrans.rmmLogger.baseWarn("Not NAK_LIST option", null, moduleName);
                    } else {
                        int opt_len = bb.get();
                        if (opt_len < 0) {
                            opt_len += 256;
                        }
                        bb.position(bb.position() + 2);
                        if (opt_len == 0) {
                            this.pTrans.rmmLogger.baseError("Option length is 0", null, moduleName);
                        }
                        int n_add = (opt_len - 4) / 4;
                        int i = 0;
                        while (i < n_add) {
                            requested_seq_n[i + 1] = bb.getInt();
                            ++requested_n;
                            ++i;
                        }
                    }
                }
                this.ncf.setdataLength(this.writeNcf(stream, requested_n, requested_seq_n));
                if (this.pTrans.config.pgmOverIp) {
                    this.pTrans.ipNcfSocket.send(stream.mcastAddressHandle, this.ncf.getByteArray(), this.ncf.getdataLength());
                } else {
                    udpPacket.setLength(this.ncf.getdataLength());
                    udpPacket.setAddress(stream.mcastGroup);
                    udpPacket.setPort(stream.dataPort);
                    try {
                        this.pTrans.udpNcfSocket.send(udpPacket);
                    }
                    catch (IOException ex) {
                        this.pTrans.rmmLogger.baseWarn("Failed to send Ncf. Stream: " + stream, ex, moduleName);
                    }
                }
                StreamBitmap ex = stream.nack_bitmap;
                synchronized (ex) {
                    stream.nack_bitmap.setTrail(stream.trailSeqN);
                    int i = 0;
                    while (i < requested_n) {
                        stream.nack_bitmap.set(requested_seq_n[i]);
                        ++i;
                    }
                }
                if (requested_seq_n[0] - stream.minNackSeqN < 0) {
                    stream.minNackSeqN = requested_seq_n[0];
                }
                this.pTrans.rDataSender.wakeUp(true);
                stream.lastNackTime = Clock.getTime();
                stream.lastNackSource = src_addr;
                stream.lastNackQuant = requested_n;
                stream.lastNackPort = src_port;
                this.pTrans.rmmLogger.maxLog(3, new Object[]{String.valueOf(requested_n) + " on Stream " + stream, stream.lastNackSource.getHostAddress()}, null, moduleName);
                if (stream.adminListener != null) {
                    ev = new AdminEvent(2, stream.lastNackSource, stream.lastNackPort);
                    ev.intField = requested_n;
                    ev.longField = stream.lastNackTime;
                    stream.adminListener.onEvent(ev);
                }
                NackServer.yield();
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException || ex instanceof InterruptedIOException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"NackServer"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("NackServer: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop NackServer", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"NackServer"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"NackServer"}, null, moduleName);
    }

    private int writeNcf(StreamT stream, int n_missing, int[] missing) {
        if (n_missing <= 0 || n_missing > 63) {
            this.pTrans.rmmLogger.baseWarn("Trying to write Nack for " + n_missing + " missing packets", null, moduleName);
        }
        ByteBuffer bb = this.ncf.getByteBuffer();
        bb.clear();
        try {
            bb.putShort(stream.shortId);
            bb.putShort((short)this.pTrans.config.dataPort);
            bb.put((byte)10);
            if (n_missing > 1) {
                if (this.pTrans.config.optAcc2Rfc) {
                    bb.put((byte)-64);
                } else {
                    bb.put((byte)3);
                }
            } else {
                bb.put((byte)0);
            }
            bb.putShort((short)0);
            bb.put(this.pTrans.gsiPart1, 0, 4);
            bb.putShort((short)this.pTrans.nackPort);
            bb.putShort((short)0);
            bb.putInt(missing[0]);
            if (this.pTrans.localAddressBytes.length == 16) {
                bb.putShort((short)2);
            } else {
                bb.putShort((short)1);
            }
            bb.putShort((short)0);
            bb.put(this.pTrans.localAddressBytes);
            if (stream.mcastGroupBytes.length == 16) {
                bb.putShort((short)2);
            } else {
                bb.putShort((short)1);
            }
            bb.putShort((short)0);
            bb.put(stream.mcastGroupBytes);
            if (n_missing > 1) {
                bb.put((byte)0);
                bb.put((byte)4);
                bb.putShort((short)(8 + 4 * (n_missing - 1)));
                bb.put((byte)-126);
                bb.put((byte)(4 + 4 * (n_missing - 1)));
                bb.putShort((short)0);
                int i = 1;
                while (i < n_missing) {
                    bb.putInt(missing[i]);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            this.pTrans.rmmLogger.baseError("Failed to write NCF packet. Stream: " + stream, ex, moduleName);
            return 0;
        }
        return bb.position();
    }
}

