/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.ptl.pgm.transmitter.PTransmitter;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;
import com.ibm.rmm.ptl.pgm.transmitter.TEvent;
import java.io.IOException;

class ODataSender
extends Thread {
    static final String moduleName = "PTL_PGM_T";
    boolean isSleeping;
    boolean notifyPending;
    boolean goDown;
    int sleepTime = 100;
    volatile int nRot;
    volatile int curPos;
    PTransmitter pTrans;

    ODataSender(PTransmitter ptr) {
        this.pTrans = ptr;
        this.isSleeping = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            ODataSender oDataSender = this;
            synchronized (oDataSender) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goDown = true;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"ODataSender"}, null, moduleName);
        this.isSleeping = false;
        int n_max = this.pTrans.maxTrans;
        RmmBuffer[] tmpQ = new RmmBuffer[n_max];
        int exc_count = 0;
        while (!this.goDown) {
            ++this.nRot;
            try {
                boolean sent = false;
                boolean ttNotified = false;
                int n_pend = 0;
                int i2 = this.pTrans.nStreams - 1;
                while (i2 >= 0) {
                    StreamT stream = this.pTrans.streamList[i2];
                    if (stream != null) {
                        int n_pckts = stream.pendingPackets.qSize();
                        n_pend += n_pckts;
                        if (!stream.limitRate || stream.oDataBucket.hasToken()) {
                            int n_trans = 0;
                            if (n_pckts > 0) {
                                n_trans = n_pckts > n_max ? n_max : n_pckts;
                            } else if (!ttNotified && stream.mtlSize > 0) {
                                ttNotified = true;
                                this.pTrans.timingThrd.wakeUp(true);
                            }
                            if (n_trans != 0) {
                                RmmBuffer packet;
                                int j;
                                sent = true;
                                BufferCyclQueue bufferCyclQueue = stream.pendingPackets;
                                synchronized (bufferCyclQueue) {
                                    j = 0;
                                    while (j < n_trans) {
                                        tmpQ[j] = packet = stream.pendingPackets.popFirst();
                                        if (stream.limitRate) {
                                            stream.oDataBucket.commitToken(packet.dataLength);
                                            if (!stream.oDataBucket.hasToken()) {
                                                n_trans = j + 1;
                                                break;
                                            }
                                        }
                                        ++j;
                                    }
                                    if (stream.isWaiting) {
                                        stream.pendingPackets.notify();
                                    }
                                }
                                int j22 = 0;
                                while (j22 < n_trans) {
                                    packet = tmpQ[j22];
                                    if (this.pTrans.config.limitRate != 0) {
                                        this.pTrans.tokenBucket.waitForToken(packet.dataLength);
                                    }
                                    if (this.pTrans.config.pgmOverIp) {
                                        this.pTrans.ipOdataSocket.send(stream.mcastAddressHandle, packet.dataBuffer, packet.dataLength);
                                    } else {
                                        stream.udpPacket.setData(packet.dataBuffer);
                                        stream.udpPacket.setLength(packet.dataLength);
                                        int r = 0;
                                        while (r < 10) {
                                            try {
                                                this.pTrans.udpOdataSocket.send(stream.udpPacket);
                                                break;
                                            }
                                            catch (IOException ex) {
                                                if (r == 9) {
                                                    this.pTrans.rmmLogger.baseError("Failed to send data packet. Stream: " + stream, ex, moduleName);
                                                    this.pTrans.rmmLogger.baseLog(417, new Object[]{stream.udpPacket.getAddress().getHostAddress()}, ex, moduleName);
                                                    TEvent ev = new TEvent(4, 0L, 0, null, stream.longId, stream.udpPacket.getAddress(), stream.udpPacket.getPort());
                                                    stream.eventListener.onEvent(ev);
                                                } else {
                                                    ODataSender.sleep(1L);
                                                }
                                                ++r;
                                            }
                                        }
                                    }
                                    ++j22;
                                }
                                if (stream.isReliable) {
                                    BufferCyclQueue j22 = stream.sentPackets;
                                    synchronized (j22) {
                                        j = 0;
                                        while (j < n_trans) {
                                            packet = tmpQ[j];
                                            stream.sentPackets.pushLast(packet);
                                            ++j;
                                        }
                                        stream.sentFrontSeqN += n_trans;
                                    }
                                } else {
                                    j22 = 0;
                                    while (j22 < n_trans) {
                                        packet = tmpQ[j22];
                                        this.pTrans.returnBuffer(packet);
                                        ++j22;
                                    }
                                    stream.sentFrontSeqN += n_trans;
                                }
                            }
                        }
                    }
                    --i2;
                }
                this.pTrans.nPending = n_pend;
                if (!sent) {
                    ODataSender i2 = this;
                    synchronized (i2) {
                        if (this.notifyPending) {
                            this.notifyPending = false;
                        } else {
                            this.isSleeping = true;
                            this.wait(this.sleepTime);
                            this.isSleeping = false;
                        }
                        continue;
                    }
                }
                this.notifyPending = false;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"ODataSender"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("ODataSender: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop ODataSender", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"ODataSender"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"ODataSender"}, null, moduleName);
    }
}

