/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.BufferPool;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.PgmIpSocket;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.pgm.transmitter.Config;
import com.ibm.rmm.ptl.pgm.transmitter.NackServer;
import com.ibm.rmm.ptl.pgm.transmitter.ODataSender;
import com.ibm.rmm.ptl.pgm.transmitter.RDataSender;
import com.ibm.rmm.ptl.pgm.transmitter.SPMSender;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;
import com.ibm.rmm.ptl.pgm.transmitter.TimingThread;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PTransmitter
implements PTransmitterIf {
    static final String moduleName = "PTL_PGM_T";
    PReceiverIf myPReceiver;
    RmmAddress rmmAddress;
    RmmLogger rmmLogger;
    TaskManager taskMan;
    MulticastSocket udpOdataSocket;
    MulticastSocket udpSpmSocket;
    MulticastSocket udpNcfSocket;
    MulticastSocket udpRdataSocket;
    PgmIpSocket ipOdataSocket;
    PgmIpSocket ipRdataSocket;
    PgmIpSocket ipSpmSocket;
    PgmIpSocket ipNcfSocket;
    DatagramSocket udpNackSocket;
    PgmIpSocket ipNackSocket;
    int nackPort;
    byte[] gsiPart1;
    BufferPool bufferPool;
    boolean logError;
    int packetSize;
    int ptlHeaderSize;
    int tracingLevel;
    TokenBucket tokenBucket;
    int maxTrans;
    int nPending;
    int nPendingMax;
    int nSentMax;
    InetAddress mcInterf;
    Vector fullBufListeners;
    Object memCleanMutex;
    long memCleanTime;
    long memCleanTimer = 0L;
    long memCleanTimeout;
    int n_packs;
    int n_hist;
    int n_pend;
    int n_idle;
    Object streamListLock;
    Hashtable streamHT;
    private int nStreamsMax;
    StreamT[] streamList;
    int nStreams;
    boolean isRunning;
    private short idSeed;
    ODataSender oDataSender;
    NackServer nackServer;
    RDataSender rDataSender;
    SPMSender spmSender;
    TimingThread timingThrd;
    private boolean needRelServices = false;
    private boolean relSrvRun = false;
    byte[] localAddressBytes;
    Config config;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, short max_packet_size, InetAddress interf) {
        try {
            byte[] addr;
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.packetSize = max_packet_size;
            this.ptlHeaderSize = 44;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.nPendingMax = this.config.maxPendingSize / this.packetSize;
            this.nSentMax = this.config.maxStreamHistorySize / this.packetSize;
            this.bufferPool = new BufferPool((int)(1.5 * (double)this.nSentMax + (double)this.nPendingMax), this.packetSize + 100);
            if (this.nSentMax + this.nPendingMax < 300) {
                this.rmmLogger.baseWarn("Very low buffer space allocated for multicast transmitter " + this.nPendingMax + " " + this.nPendingMax, null, moduleName);
            }
            this.fullBufListeners = new Vector();
            this.memCleanMutex = new Object();
            this.maxTrans = 50;
            if (this.config.limitRate != 0) {
                this.tokenBucket = new TokenBucket(this.config.transmissionRateKbps, this.rmmLogger, this.taskMan);
            }
            if (this.config.limitRate == 2) {
                this.rmmLogger.baseInfo("Starting Global Congestion Control", moduleName);
            }
            this.idSeed = 0;
            this.mcInterf = interf;
            this.udpNackSocket = this.rmmAddress.getUdpSocket();
            this.nackPort = this.udpNackSocket.getLocalPort();
            this.localAddressBytes = this.rmmAddress.getInetAddress().getAddress();
            this.rmmLogger.baseInfo("Nack port:" + this.nackPort, moduleName);
            if (this.config.pgmOverIp) {
                PgmIpLayer.init(this.rmmLogger);
                this.ipNackSocket = PgmIpLayer.createRecIpSocket(false, this.udpNackSocket.getLocalAddress(), -1);
            }
            if ((addr = this.rmmAddress.getInetAddress().getAddress()).length == 4) {
                this.gsiPart1 = addr;
                this.rmmLogger.baseInfo("Building GSI I - use IPV4 address", moduleName);
            } else {
                String host_name = this.rmmAddress.getInetAddress().getCanonicalHostName();
                int host_name_hash = host_name.hashCode();
                this.gsiPart1 = new byte[4];
                Sutils.insertInt(this.gsiPart1, 0, host_name_hash);
                this.rmmLogger.baseInfo("Building GSI I - Address length - " + addr.length + ". Not IPv4. Using hash of the Canonical host name " + host_name, moduleName);
            }
            this.rmmLogger.baseInfo("GSI I: " + this.gsiPart1[0] + ":" + this.gsiPart1[1] + ":" + this.gsiPart1[2] + ":" + this.gsiPart1[3], moduleName);
            if (this.config.pgmOverIp) {
                this.ipOdataSocket = this.createMcTrIpSocket(this.config.timeToLive, this.mcInterf, this.config.socketBufferSize, false);
                this.ipSpmSocket = this.createMcTrIpSocket(this.config.timeToLive, this.mcInterf, -1, true);
                this.ipNcfSocket = this.createMcTrIpSocket(this.config.timeToLive, this.mcInterf, -1, true);
                this.ipRdataSocket = this.createMcTrIpSocket(this.config.timeToLive, this.mcInterf, this.config.socketBufferSize, true);
            } else {
                this.udpOdataSocket = this.createTrUdpSocket(this.config.timeToLive, this.mcInterf, this.config.socketBufferSize);
                this.udpSpmSocket = this.createTrUdpSocket(this.config.timeToLive, this.mcInterf, -1);
                this.udpNcfSocket = this.createTrUdpSocket(this.config.timeToLive, this.mcInterf, -1);
                this.udpRdataSocket = this.createTrUdpSocket(this.config.timeToLive, this.mcInterf, this.config.socketBufferSize);
            }
            this.streamListLock = new Object();
            this.streamHT = new Hashtable();
            this.nStreamsMax = 100;
            this.streamList = new StreamT[this.nStreamsMax];
            this.nStreams = 0;
            this.oDataSender = new ODataSender(this);
            this.oDataSender.setName("Ptl_Pgm_ODataSender");
            this.oDataSender.setPriority(10);
            this.spmSender = new SPMSender(this);
            this.spmSender.setName("Ptl_Pgm_SpmSender");
            this.spmSender.setPriority(10);
            this.timingThrd = new TimingThread(this);
            this.timingThrd.setName("Ptl_Pgm_TimingThread");
            this.timingThrd.setPriority(10);
            this.start();
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PTransmitter", e2, moduleName);
            return false;
        }
        return true;
    }

    private PgmIpSocket createMcTrIpSocket(int ttl, InetAddress interf, int buffer_size, boolean router_alert) {
        PgmIpSocket ms;
        try {
            ms = PgmIpLayer.createTrIpSocket(true, ttl, interf, buffer_size, router_alert ? 1 : 0);
        }
        catch (IOException ex) {
            this.rmmLogger.baseLog(404, new Object[]{""}, ex, moduleName);
            return null;
        }
        return ms;
    }

    private MulticastSocket createTrUdpSocket(int ttl, InetAddress interf, int buffer_size) {
        MulticastSocket ms;
        try {
            ms = new MulticastSocket();
        }
        catch (IOException ex) {
            this.rmmLogger.baseLog(404, new Object[]{""}, ex, moduleName);
            return null;
        }
        try {
            ms.setTimeToLive(ttl);
        }
        catch (IOException ex) {
            this.rmmLogger.baseLog(407, new Object[]{"" + this.config.timeToLive}, ex, moduleName);
        }
        if (interf != null) {
            try {
                ms.setInterface(interf);
            }
            catch (SocketException ex) {
                this.rmmLogger.baseLog(405, new Object[]{"" + this.mcInterf}, ex, moduleName);
            }
        }
        if (buffer_size > 0) {
            try {
                ms.setSendBufferSize(buffer_size);
            }
            catch (SocketException e2) {
                this.rmmLogger.baseLog(413, new Object[]{"Multicast UDP SendBufferSize", "" + buffer_size}, e2, moduleName);
            }
            this.rmmLogger.baseInfo("Setting Socket SendBuffer size to: " + buffer_size, moduleName);
        }
        try {
            int buf_s = ms.getSendBufferSize();
            this.rmmLogger.baseInfo("Socket SendBufferSize is " + buf_s, moduleName);
            if (buffer_size != 0 && buf_s != buffer_size) {
                this.rmmLogger.baseWarn("SendBufferSize is different from configured", null, moduleName);
            }
            if (buf_s < this.config.packetSize) {
                this.rmmLogger.baseError("SendBufferSize is smaller than PacketSize", null, moduleName);
            }
        }
        catch (IOException ex) {
            this.rmmLogger.baseError("Failed to measure Socket SendBuffer size", ex, moduleName);
        }
        return ms;
    }

    public synchronized StreamTIf createStreamTransmitter(boolean reliable, InetAddress address, int port2, byte[] tag, boolean lj_enabled) {
        if (tag != null && tag.length > 250) {
            this.rmmLogger.baseError("Tag (topic) length is " + tag.length + " exceeds limit 250", null, moduleName);
            return null;
        }
        short sid = this.idSeed;
        while ((sid = (short)(sid + 1)) != this.idSeed) {
            if (this.streamHT.containsKey(new Short(sid))) continue;
        }
        if (sid == this.idSeed) {
            this.rmmLogger.baseError("Could not assign a unique stream id for a new stream", null, moduleName);
            return null;
        }
        this.idSeed = sid;
        StreamT str = new StreamT(this);
        if (port2 < 0) {
            port2 = this.config.dataPort;
        }
        if (!str.init(tag, sid, reliable, address, port2, lj_enabled)) {
            return null;
        }
        if (this.config.limitRate == 2) {
            str.startCongestionControl(this.config.transmissionRateKbps);
        }
        this.addStream(str);
        if (!this.needRelServices && reliable) {
            this.needRelServices = true;
            if (this.isRunning && !this.relSrvRun) {
                this.startRelServices();
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            if (this.nStreams == this.nStreamsMax) {
                StreamT[] tmp = new StreamT[2 * this.nStreamsMax];
                int i = 0;
                while (i < this.nStreamsMax) {
                    tmp[i] = this.streamList[i];
                    ++i;
                }
                this.nStreamsMax *= 2;
                this.streamList = tmp;
            }
            this.streamList[this.nStreams] = stream;
            this.streamHT.put(new Short(stream.shortId), stream);
            ++this.nStreams;
        }
        this.oDataSender.sleepTime = 32 + this.nStreams;
        if (this.nStreams == 1) {
            this.oDataSender.wakeUp(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nStreams) {
                if (this.streamList[i] == stream) break;
                ++i;
            }
            if (i == this.nStreams) {
                this.rmmLogger.baseWarn("Removing stream: not found!", null, moduleName);
                return;
            }
            --this.nStreams;
            this.streamList[i] = this.streamList[this.nStreams];
            this.streamList[this.nStreams] = null;
            this.streamHT.remove(new Short(stream.shortId));
        }
        this.oDataSender.sleepTime = this.nStreams == 0 ? 100 : 32 + this.nStreams;
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Removing stream from Transmitter list " + stream, moduleName);
        }
    }

    public int bufferStatus() {
        return this.bufferPool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RmmBuffer getBuffer(StreamT stream) {
        RmmBuffer res;
        while (this.bufferPool.getUtilization() > 85) {
            int streamShare;
            if (!stream.isActive) {
                return null;
            }
            int streamBuffs = stream.sentPackets.qSize() + stream.pendingPackets.qSize();
            if (streamBuffs <= (streamShare = this.bufferPool.fullSize() / this.nStreams)) break;
            Object object = this.memCleanMutex;
            synchronized (object) {
                this.tryToCleanMemory();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                this.rmmLogger.baseLog(406, new Object[]{"Waiting on stream buffers."}, ex, moduleName);
                Thread.currentThread().interrupt();
                break;
            }
        }
        while (true) {
            try {
                res = this.bufferPool.getBuffer();
                if (res != null) break;
                if (!stream.isActive) {
                    return null;
                }
                Object streamBuffs = this.memCleanMutex;
                synchronized (streamBuffs) {
                    this.tryToCleanMemory();
                }
                res = this.bufferPool.getBuffer();
                if (res != null) break;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    this.rmmLogger.baseLog(406, new Object[]{"Waiting on empty buffer pool."}, ex, moduleName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (Throwable e2) {
                this.rmmLogger.baseError("getBuffer: failed to allocate new buffer, more memory is probably needed.", e2, moduleName);
                res = null;
                break;
            }
        }
        return res;
    }

    void returnBuffer(RmmBuffer buffer) {
        this.bufferPool.returnBuffer(buffer);
    }

    public void changeTransmissionRate(int new_rate_Kbps) {
        this.tokenBucket.setRate(new_rate_Kbps);
    }

    public double getAverageRetransmissionRate() {
        return this.rDataSender.averageTotalLossRate;
    }

    public long getPendingQueueSize() {
        return this.nPending * this.packetSize;
    }

    public String getProtocolVersion() {
        return "PGM";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("oDataSender: p").append(this.oDataSender.curPos).append(" r").append(this.oDataSender.nRot);
            stat.append(". SpmSender: p").append(this.spmSender.curPos).append(" r").append(this.spmSender.nRot).append(". NS: r").append(this.nackServer.nRot);
            stat.append(". rDataSender: r").append(this.rDataSender.nRot).append(". TimingThrd: p").append(this.timingThrd.curPos).append(" r").append(this.timingThrd.nRot);
            stat.append("\n_RMM_STATS_ Buffer pool size: ").append(this.bufferPool.size()).append('\n');
            return stat.toString();
        }
        catch (NullPointerException ex) {
            return "Not started";
        }
    }

    public StreamTIf getStream(byte[] tag) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && Sutils.compareByteArrays(stream.getTag(), tag)) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public Enumeration listStreams() {
        return new EnumArray(this.streamHT, false);
    }

    public void addFullBufferListener(FullBufferListener list) {
        this.fullBufListeners.add(list);
    }

    public void removeFullBufferListener(FullBufferListener list) {
        this.fullBufListeners.remove(list);
    }

    private void startRelServices() {
        this.nackServer = new NackServer(this);
        this.nackServer.setName("Ptl_Pgm_NackServer");
        this.nackServer.setPriority(10);
        this.nackServer.start();
        this.rDataSender = new RDataSender(this);
        this.rDataSender.setName("Ptl_Pgm_RDataSender");
        this.rDataSender.setPriority(10);
        this.rDataSender.start();
        this.relSrvRun = true;
    }

    private void start() {
        this.isRunning = true;
        this.oDataSender.start();
        this.spmSender.start();
        this.timingThrd.start();
        if (this.needRelServices) {
            this.startRelServices();
        }
    }

    public synchronized boolean stop(boolean soft) {
        this.rmmLogger.baseLog(2, new Object[]{"PTransmitter"}, null, moduleName);
        int i2 = this.nStreams - 1;
        while (i2 >= 0) {
            StreamT stream = this.streamList[i2];
            if (stream != null) {
                stream.close(soft);
            }
            --i2;
        }
        if (soft) {
            this.rmmLogger.baseInfo("Waiting for " + this.config.cpTimeout / 1000 + "sec (control packet timeout)\n" + "to let transmitter send pending packets and receivers complete the reception", moduleName);
            try {
                Thread.sleep(this.config.cpTimeout);
            }
            catch (InterruptedException i2) {}
        } else {
            this.rmmLogger.baseInfo("Fast PTL Transmitter Stop", moduleName);
        }
        this.isRunning = false;
        this.spmSender.interrupt();
        if (this.timingThrd != null) {
            this.timingThrd.interrupt();
        }
        if (this.oDataSender != null) {
            this.oDataSender.interrupt();
        }
        if (this.nackServer != null) {
            this.nackServer.interrupt();
            this.udpNackSocket.close();
            if (this.config.pgmOverIp) {
                try {
                    this.ipNackSocket.close();
                }
                catch (Exception e2) {
                    this.rmmLogger.baseError("Failed to close nackServer socket", e2, moduleName);
                }
            }
        }
        if (this.rDataSender != null) {
            this.rDataSender.interrupt();
        }
        if (this.config.pgmOverIp) {
            PgmIpLayer.stop();
        } else {
            this.udpOdataSocket.close();
            this.udpSpmSocket.close();
            this.udpNcfSocket.close();
            this.udpRdataSocket.close();
        }
        if (this.tokenBucket != null) {
            this.tokenBucket.stop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryToCleanMemory() {
        StreamT stream;
        this.n_packs = 0;
        this.n_hist = 0;
        this.n_pend = 0;
        this.n_idle = 0;
        int i = this.nStreams - 1;
        while (i >= 0) {
            stream = this.streamList[i];
            if (stream != null) {
                this.n_hist += stream.sentPackets.qSize();
                this.n_pend += stream.pendingPackets.qSize();
            }
            --i;
        }
        int to_erase = this.n_hist - this.nSentMax;
        this.n_idle = this.bufferStatus();
        this.n_packs = this.n_idle + this.n_pend + this.n_hist;
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Pool: " + this.n_idle + " Pending: " + this.n_pend + ". History: " + this.n_hist + " nSentMax: " + this.nSentMax + ". Total Buffers: " + this.n_packs + " to erase " + to_erase, moduleName);
        }
        if (to_erase <= 0) {
            return false;
        }
        boolean cleaned = false;
        boolean had_to_clean = false;
        int i2 = this.nStreams - 1;
        while (i2 >= 0) {
            block21: {
                int s_to_erase;
                block23: {
                    int mustkeep;
                    int sps;
                    block22: {
                        int delta;
                        stream = this.streamList[i2];
                        if (stream == null || !stream.isReliable || (s_to_erase = (sps = stream.sentPackets.qSize()) * to_erase / this.n_hist) < 1) break block21;
                        had_to_clean = true;
                        mustkeep = stream.pendFrontSeqN + 1000;
                        int tmpmark = stream.getRedLine();
                        if (mustkeep - tmpmark > 0) {
                            mustkeep = tmpmark;
                        }
                        if (mustkeep - (tmpmark = stream.getPossibleJoin()) > 0) {
                            mustkeep = tmpmark;
                        }
                        if ((delta = s_to_erase - ((mustkeep -= 2) - stream.trailSeqN)) <= 0) break block22;
                        s_to_erase = mustkeep - stream.trailSeqN;
                        if (this.rmmLogger.isMaxLogLevel()) {
                            this.rmmLogger.maxWarn("Cannot erase enough packets: hit red line (" + stream.redLine + "," + stream.ljOptionValue + "). Stream: " + stream, null, moduleName);
                        }
                        if (s_to_erase >= 1) break block23;
                        break block21;
                    }
                    if (stream.redLineSet && stream.ljOptionSet) {
                        s_to_erase = Math.min(sps - 2, mustkeep - stream.trailSeqN);
                    }
                }
                BufferCyclQueue bufferCyclQueue = stream.sentPackets;
                synchronized (bufferCyclQueue) {
                    int j = 0;
                    while (j < s_to_erase) {
                        this.returnBuffer(stream.sentPackets.popFirst());
                        ++j;
                    }
                }
                stream.sendSpm = true;
                this.rmmLogger.maxLog(100, new Object[]{" Stream " + stream + ". Np " + s_to_erase}, null, moduleName);
                cleaned = true;
                stream.trailSeqN += s_to_erase;
            }
            --i2;
        }
        if (!cleaned && had_to_clean) {
            if (this.memCleanTimer == 0L) {
                this.memCleanTimer = Clock.getTime();
            } else if (Clock.getTime() > this.memCleanTimer + this.memCleanTimeout) {
                if (this.fullBufListeners.size() > 0) {
                    i2 = 0;
                    while (i2 < this.fullBufListeners.size()) {
                        ((FullBufferListener)this.fullBufListeners.elementAt(i2)).onFullBuffer(to_erase);
                        ++i2;
                    }
                } else {
                    this.rmmLogger.baseWarn("MemCleaner: Failed to free " + to_erase + " packets. Due to red lines.", null, moduleName);
                }
                this.memCleanTimer = 0L;
            }
        }
        if (cleaned) {
            this.memCleanTimer = 0L;
            this.memCleanTime = Clock.getTime();
            this.spmSender.wakeUp(true);
        }
        return cleaned;
    }

    public synchronized void setPreceiver(PReceiverIf pReceiver) {
        this.myPReceiver = pReceiver;
    }

    public synchronized boolean receiverReportConnection(InetSocketAddress remoteAddress, Object socket, boolean closed, Object connection) {
        this.rmmLogger.baseError("receiverReportConnection called on Multicast transmitter", null, moduleName);
        return false;
    }

    public int getHeaderSize() {
        return this.ptlHeaderSize;
    }

    public void gotConnStreams(Object socket, long[] stream_ids, int nstreams) {
        this.rmmLogger.baseError("gotConnStreams called on Multicast Transmitter", null, moduleName);
    }

    public boolean stopChfw() {
        return false;
    }
}

