/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.ptl.pgm.transmitter.PTransmitter;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;
import java.io.IOException;
import java.net.DatagramPacket;

class SPMSender
extends Thread {
    static final String moduleName = "PTL_PGM_T";
    static final int interHeartbeatMinMilli = 500;
    static final int interHeartbeatMaxMilli = 5000;
    static final int interHeartbeatAmbientMilli = 5000;
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    boolean isSleeping;
    boolean notifyPending;
    private boolean goOn = true;

    SPMSender(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            SPMSender sPMSender = this;
            synchronized (sPMSender) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"SpmThread"}, null, moduleName);
        DatagramPacket udpPacket = new DatagramPacket(new byte[1], 1);
        udpPacket.setPort(this.pTrans.config.dataPort);
        int ihbAmb = 5000;
        int ihbMin = 500;
        int ihbMax = 5000;
        this.curPos = 1;
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                SPMSender sPMSender = this;
                synchronized (sPMSender) {
                    if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.wait(ihbMin);
                        this.isSleeping = false;
                    }
                }
                this.curPos = 2;
                int i = this.pTrans.nStreams - 1;
                while (i >= 0) {
                    StreamT stream = this.pTrans.streamList[i];
                    if (stream != null) {
                        if (!stream.isActive && Clock.getTime() - stream.closeTime > (long)this.pTrans.config.cpTimeout) {
                            this.curPos = 5;
                            stream.isClosed = true;
                            this.pTrans.removeStream(stream);
                            stream.cleanAfterClose();
                        } else {
                            boolean sendSpm;
                            this.curPos = 6;
                            long currTime = Clock.getTime();
                            long diffTime = currTime - stream.spmLast;
                            boolean bl = sendSpm = stream.sendSpm || diffTime > (long)ihbAmb;
                            if (stream.spmFront != (long)stream.getFrontSeqNum()) {
                                stream.spmFront = stream.getFrontSeqNum();
                                stream.spmDiff = ihbMin;
                            } else if (sendSpm |= diffTime > stream.spmDiff) {
                                if (stream.spmDiff < (long)ihbMin) {
                                    stream.spmDiff = ihbMin;
                                }
                                stream.spmDiff *= 2L;
                                if (stream.spmDiff > (long)ihbMax) {
                                    stream.spmDiff = ihbMax;
                                }
                            }
                            if (sendSpm) {
                                stream.spmLast = currTime;
                                stream.writeSpm();
                                if (this.pTrans.config.pgmOverIp) {
                                    this.curPos = 7;
                                    this.pTrans.ipSpmSocket.send(stream.mcastAddressHandle, stream.spmPacket, stream.spmLength);
                                } else {
                                    udpPacket.setData(stream.spmPacket);
                                    udpPacket.setLength(stream.spmLength);
                                    udpPacket.setAddress(stream.mcastGroup);
                                    udpPacket.setPort(stream.dataPort);
                                    this.curPos = 8;
                                    int r = 0;
                                    while (r < 10) {
                                        try {
                                            this.pTrans.udpNcfSocket.send(udpPacket);
                                            break;
                                        }
                                        catch (IOException ex) {
                                            if (r == 9) {
                                                this.pTrans.rmmLogger.baseError("Failed to send SPM packet. Stream: " + stream, ex, moduleName);
                                                this.pTrans.rmmLogger.baseLog(417, new Object[]{udpPacket.getAddress().getHostAddress()}, ex, moduleName);
                                            } else {
                                                SPMSender.sleep(1L);
                                            }
                                            ++r;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    --i;
                }
                SPMSender.yield();
                this.curPos = 9;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"SpmThread"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("SpmThread: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop SPMSender", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"SPMSender"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"SpmThread"}, null, moduleName);
    }
}

