/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.PersistByteArrayOutputStream;
import com.ibm.rmm.intrn.util.PgmIpLayer;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.StreamBitmap;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.ifc.transmitter.EventListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.pgm.transmitter.AdminEvent;
import com.ibm.rmm.ptl.pgm.transmitter.CongestionControl;
import com.ibm.rmm.ptl.pgm.transmitter.PTransmitter;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class StreamT
implements StreamTIf {
    static final String moduleName = "PTL_PGM_T";
    private final int nPendingMax = 10;
    PTransmitter pTrans;
    short shortId;
    long longId;
    byte[] tag;
    short tagLength;
    boolean isReliable;
    InetAddress mcastGroup;
    int dataPort;
    DatagramPacket udpPacket;
    String mcastAddress;
    long cpTimestamp;
    long lastNackTime;
    InetAddress lastNackSource;
    int lastNackQuant;
    int lastNackPort;
    int pendFrontSeqN;
    int sentFrontSeqN;
    int trailSeqN;
    byte[] spmPacket;
    int spmLength;
    boolean sendSpm;
    BufferCyclQueue pendingPackets;
    BufferCyclQueue sentPackets;
    int oldFront;
    boolean isActive;
    boolean isClosed;
    boolean isWaiting;
    long closeTime;
    Object ljLock = new Object();
    boolean lateJoinEnabled;
    boolean ljOptionSet;
    int ljOptionValue;
    private DataOutputStream spmDos;
    private DataOutputStream optDos;
    private PersistByteArrayOutputStream spmBaos;
    private PersistByteArrayOutputStream optBaos;
    private BufferRequestListener bufferRequestListener;
    AdminLayerListener adminListener;
    TokenBucket oDataBucket;
    CongestionControl congestionControl;
    StreamTUpcalls mCleanUp;
    boolean limitRate = false;
    byte[] dataOptField;
    byte[] spmOptField;
    int dataOptVer;
    int spmOptVer;
    int optUpd;
    private int ncOptions;
    private byte[] cOptionType;
    private byte[][] cOptionVal;
    private Object cOptionLock;
    int noReListContr;
    Object redLock = new Object();
    boolean redLineSet = false;
    int redLine;
    int minNackSeqN;
    double avrgLossRate;
    StreamBitmap nack_bitmap;
    int spmSeqN;
    long spmFront;
    long spmLast;
    long spmDiff;
    long bytesTransmitted;
    long bytesRetransmitted;
    int mtlSize;
    boolean sendPartial;
    Object sendPartialMutex;
    EventListener eventListener;
    int mcastAddressHandle;
    byte[] mcastGroupBytes;
    byte[] headerStart;

    StreamT(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    boolean init(byte[] tag, short id, boolean is_reliable, InetAddress mcast_address, int port2, boolean lj_enabled) {
        this.tag = tag;
        this.tagLength = (short)tag.length;
        this.shortId = id;
        this.isReliable = is_reliable;
        this.lateJoinEnabled = lj_enabled;
        this.mcastGroup = mcast_address;
        this.mcastGroupBytes = this.mcastGroup.getAddress();
        this.dataPort = port2;
        this.mcastAddress = this.mcastGroup.getHostAddress();
        if (this.pTrans.config.pgmOverIp) {
            try {
                this.mcastAddressHandle = PgmIpLayer.getAddressHandle(this.mcastAddress);
            }
            catch (IOException ex) {
                this.pTrans.rmmLogger.baseError("Failed to PgmIpLayer.getAddressHandle", ex, moduleName);
                return false;
            }
        }
        this.ncOptions = 0;
        this.cOptionType = new byte[16];
        this.cOptionVal = new byte[16][];
        this.cOptionLock = new Object();
        this.noReListContr = 0;
        this.isActive = true;
        this.isClosed = false;
        this.isWaiting = false;
        this.spmSeqN = 0;
        this.udpPacket = new DatagramPacket(new byte[1], 1, this.mcastGroup, this.dataPort);
        this.spmBaos = new PersistByteArrayOutputStream();
        this.spmDos = new DataOutputStream(this.spmBaos);
        this.optBaos = new PersistByteArrayOutputStream();
        this.optDos = new DataOutputStream(this.optBaos);
        this.sendPartialMutex = new Object();
        this.sendPartial = false;
        this.pendFrontSeqN = 0;
        this.sentFrontSeqN = this.pendFrontSeqN - 1;
        this.trailSeqN = this.pendFrontSeqN;
        this.ljOptionValue = this.pendFrontSeqN - 1;
        try {
            this.optDos.writeShort(this.shortId);
            this.optDos.write(this.pTrans.gsiPart1, 0, 4);
            this.optDos.writeShort(this.pTrans.nackPort);
            this.longId = Sutils.byteArrayToLong(this.optBaos.toByteArray());
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write stream id", ex, moduleName);
            return false;
        }
        ++this.optUpd;
        this.pendingPackets = new BufferCyclQueue(128);
        if (this.isReliable) {
            this.sentPackets = new BufferCyclQueue(128);
        }
        this.optBaos.reset();
        try {
            this.optDos.writeShort(this.shortId);
            this.optDos.writeShort(this.pTrans.config.dataPort);
            this.optDos.writeByte(4);
            if (this.pTrans.config.optAcc2Rfc) {
                this.optDos.writeByte(-128);
            } else {
                this.optDos.writeByte(1);
            }
            this.optDos.writeShort(0);
            this.optDos.write(this.pTrans.gsiPart1, 0, 4);
            this.optDos.writeShort(this.pTrans.nackPort);
            this.headerStart = this.optBaos.toByteArray();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write pgm header start", ex, moduleName);
            return false;
        }
        this.optBaos.reset();
        return true;
    }

    public synchronized boolean close(boolean soft) {
        if (!this.isActive) {
            return true;
        }
        this.isActive = false;
        this.closeTime = Clock.getTime();
        ++this.optUpd;
        this.pTrans.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "") + "Closing Transmitter Stream: " + this.longId, moduleName);
        if (!soft) {
            this.pTrans.spmSender.wakeUp(true);
            Thread.yield();
            this.isClosed = true;
            this.pTrans.removeStream(this);
            this.cleanAfterClose();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAfterClose() {
        int i;
        int sps;
        if (this.oDataBucket != null) {
            this.oDataBucket.stop();
        }
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            sps = this.pendingPackets.qSize();
            i = 0;
            while (i < sps) {
                this.pTrans.returnBuffer(this.pendingPackets.popFirst());
                ++i;
            }
        }
        if (this.sentPackets != null) {
            bufferCyclQueue = this.sentPackets;
            synchronized (bufferCyclQueue) {
                sps = this.sentPackets.qSize();
                i = 0;
                while (i < sps) {
                    this.pTrans.returnBuffer(this.sentPackets.popFirst());
                    ++i;
                }
            }
        }
        if (this.mCleanUp != null) {
            this.mCleanUp.cleanAfterClose();
        }
        this.mCleanUp = null;
        this.bufferRequestListener = null;
    }

    public int cleanBuffer(int new_trail) {
        return 0;
    }

    public int getFrontSeqNum() {
        return this.pendFrontSeqN - 1;
    }

    public int getTrailSeqNum() {
        return this.trailSeqN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPossibleJoin() {
        Object object = this.ljLock;
        synchronized (object) {
            if (this.ljOptionSet) {
                return this.ljOptionValue;
            }
            return this.getFrontSeqNum();
        }
    }

    public InetAddress getMulticastGroup() {
        return this.mcastGroup;
    }

    public long getId() {
        return this.longId;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public long getPendingQueueSize() {
        return this.pendingPackets.qSize() * this.pTrans.packetSize;
    }

    public long getBytesRetransmitted() {
        return this.bytesRetransmitted;
    }

    public int getPort() {
        return this.dataPort;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public short getTagLength() {
        return this.tagLength;
    }

    public long lastNackTime() {
        return this.lastNackTime;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isReliable() {
        return this.isReliable;
    }

    public boolean isQuarantined() {
        return false;
    }

    public boolean isConnected(String address, int port2) {
        return false;
    }

    boolean requestPartialPacket() {
        boolean ret;
        if (this.bufferRequestListener != null) {
            ret = this.bufferRequestListener.onRequest();
        } else {
            ++this.noReListContr;
            if (this.noReListContr > 5) {
                this.pTrans.rmmLogger.baseWarn("StreamT:requestPartialPacket bufferRequestListener is null. Stream: " + this.toString(), null, moduleName);
            }
            ret = false;
        }
        return ret;
    }

    public void setBufReqListener(BufferRequestListener listener) {
        if (this.bufferRequestListener != null) {
            this.pTrans.rmmLogger.baseWarn("Replacing bufferRequestListener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.bufferRequestListener = listener;
    }

    public void setAdminListener(AdminLayerListener fl) {
        this.adminListener = fl;
        if (this.adminListener == null) {
            return;
        }
        if (this.lastNackSource != null) {
            AdminEvent ev = new AdminEvent(2, this.lastNackSource, this.lastNackPort);
            ev.intField = this.lastNackQuant;
            ev.longField = this.lastNackTime;
            fl.onEvent(ev);
        }
    }

    public void setCleanUpListener(StreamTUpcalls mcu) {
        this.mCleanUp = mcu;
    }

    public void setEventListener(EventListener el) {
        this.eventListener = el;
    }

    public void setLjMarker() {
        this.advanceLjMarker(this.pendFrontSeqN);
    }

    public boolean addP2Pdestination(InetSocketAddress dest, boolean useExisting) {
        this.pTrans.rmmLogger.baseError("Adding p2p destination on multicast stream. No effect", null, moduleName);
        return false;
    }

    public boolean addP2PdestinationNonBlocking(InetSocketAddress dest, CreateConnectionListener listener, int timeout) {
        this.pTrans.rmmLogger.baseError("Adding p2p destination on multicast stream. No effect", null, moduleName);
        return false;
    }

    public void removeP2Pdestination(InetSocketAddress dest) {
        this.pTrans.rmmLogger.baseError("Removing p2p destination on multicast stream. No effect", null, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceLjMarker(int pack_n) {
        if (pack_n - this.pendFrontSeqN > 0) {
            this.pTrans.rmmLogger.baseWarn("Trying to set late join mark " + pack_n + " past current front " + this.pendFrontSeqN + ". Ignored. Stream: " + this.toString(), null, moduleName);
            return;
        }
        if (pack_n - this.trailSeqN < 0) {
            if (this.pendFrontSeqN - this.trailSeqN > 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set late join mark " + pack_n + " below current trail " + this.trailSeqN + " Setting to trail. Stream:" + this, null, moduleName);
            }
            pack_n = this.trailSeqN;
        }
        Object object = this.ljLock;
        synchronized (object) {
            if (this.ljOptionSet && pack_n - this.ljOptionValue < 0) {
                this.pTrans.rmmLogger.baseWarn("StreamT.advanceLjMarker: new packet " + pack_n + " lower than previously set " + this.ljOptionValue + ". Ignored. Stream: " + this, null, moduleName);
                return;
            }
            this.ljOptionSet = true;
            this.ljOptionValue = pack_n;
        }
        ++this.optUpd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOptions(boolean spm) {
        PersistByteArrayOutputStream persistByteArrayOutputStream = this.optBaos;
        synchronized (persistByteArrayOutputStream) {
            this.optBaos.reset();
            short opt_length = 0;
            int rmm_opt_pos = 0;
            int rmm_opt_len = 0;
            try {
                int admin_opt_len;
                this.optDos.writeByte(0);
                this.optDos.writeByte(4);
                this.optDos.writeShort(opt_length);
                opt_length = 4;
                if (this.ljOptionSet) {
                    this.optDos.writeByte(3);
                    this.optDos.writeByte(8);
                    this.optDos.writeShort(0);
                    this.optDos.writeInt(this.ljOptionValue);
                    opt_length = (short)(opt_length + 8);
                }
                if (spm && !this.isActive) {
                    this.optDos.writeByte(14);
                    this.optDos.writeByte(4);
                    this.optDos.writeShort(0);
                    opt_length = (short)(opt_length + 4);
                }
                this.optDos.writeByte(33);
                rmm_opt_pos = opt_length + 1;
                this.optDos.writeByte(0);
                this.optDos.writeShort(0);
                this.optDos.writeByte(this.mcastGroupBytes.length);
                this.optDos.write(this.mcastGroupBytes);
                this.optDos.writeByte(this.isReliable ? 1 : 0);
                this.optDos.writeInt(this.pTrans.config.cpTimeout);
                Object object = this.cOptionLock;
                synchronized (object) {
                    this.optDos.writeByte(this.ncOptions);
                    admin_opt_len = 1;
                    int i = 0;
                    while (i < this.ncOptions) {
                        this.optDos.writeByte(this.cOptionType[i]);
                        this.optDos.writeByte(this.cOptionVal[i].length);
                        this.optDos.write(this.cOptionVal[i]);
                        admin_opt_len += 2 + this.cOptionVal[i].length;
                        ++i;
                    }
                }
                rmm_opt_len = 10 + this.mcastGroupBytes.length + admin_opt_len;
                if (rmm_opt_len > 255) {
                    this.pTrans.rmmLogger.baseError("RMM_Option length exceeds 255 bytes", null, moduleName);
                }
                opt_length = (short)(opt_length + rmm_opt_len);
                this.optDos.writeByte(-94);
                this.optDos.writeByte(4 + this.tagLength);
                this.optDos.writeShort(0);
                this.optDos.write(this.tag, 0, this.tagLength);
                opt_length = (short)(opt_length + (4 + this.tagLength));
            }
            catch (IOException ex) {
                this.pTrans.rmmLogger.baseError("Failed to write options. Stream: " + this.toString(), ex, moduleName);
                return;
            }
            byte[] res = this.optBaos.getBuffer();
            int len = this.optBaos.getPosition();
            Sutils.insertShort(res, 2, opt_length);
            res[rmm_opt_pos] = (byte)rmm_opt_len;
            if (spm) {
                if (this.spmOptField == null || this.spmOptField.length != len) {
                    this.spmOptField = new byte[len];
                }
                System.arraycopy(res, 0, this.spmOptField, 0, len);
                this.spmOptVer = this.optUpd;
            } else {
                if (this.dataOptField == null || this.dataOptField.length != len) {
                    this.dataOptField = new byte[len];
                }
                System.arraycopy(res, 0, this.dataOptField, 0, len);
                this.dataOptVer = this.optUpd;
            }
            this.optBaos.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitPacketData(byte[] mtlhdr, int off1, int len1, byte[] mtldat, int off2, int len2) {
        RmmBuffer packet = this.pTrans.getBuffer(this);
        if (packet == null) {
            return false;
        }
        ByteBuffer bb = packet.bb;
        bb.clear();
        try {
            bb.put(this.headerStart);
            bb.putShort((short)(len1 + len2));
            bb.putInt(this.pendFrontSeqN);
            bb.putInt(this.trailSeqN);
            if (this.dataOptVer != this.optUpd) {
                this.writeOptions(false);
            }
            bb.put(this.dataOptField);
            bb.put(mtlhdr, off1, len1);
            bb.put(mtldat, off2, len2);
        }
        catch (Exception ex) {
            this.pTrans.rmmLogger.baseError("Failed to write data packet. Stream: " + this.toString(), ex, moduleName);
            this.pTrans.returnBuffer(packet);
            return false;
        }
        packet.dataLength = bb.position();
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            if (this.isClosed) {
                this.pTrans.returnBuffer(packet);
                return false;
            }
            while (this.isCongested()) {
                try {
                    this.isWaiting = true;
                    this.pendingPackets.wait(50L);
                    this.isWaiting = false;
                }
                catch (InterruptedException ex) {
                    this.isWaiting = false;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"Waiting on full pending queue. Stream: " + this.getId()}, ex, moduleName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            this.pendingPackets.pushLast(packet);
        }
        this.pTrans.oDataSender.wakeUp(true);
        if (this.pTrans.config.collectStats) {
            this.bytesTransmitted += (long)bb.position();
        }
        ++this.pendFrontSeqN;
        return true;
    }

    public boolean isCongested() {
        return this.pTrans.nPending > this.pTrans.nPendingMax && this.pendingPackets.qSize() > 10;
    }

    public void wakeUp() {
        this.pTrans.oDataSender.wakeUp(false);
    }

    void writeSpm() {
        this.spmBaos.reset();
        try {
            this.spmDos.writeShort(this.shortId);
            this.spmDos.writeShort(this.pTrans.config.dataPort);
            this.spmDos.writeByte(0);
            if (this.pTrans.config.optAcc2Rfc) {
                this.spmDos.writeByte(-128);
            } else {
                this.spmDos.writeByte(1);
            }
            this.spmDos.writeShort(0);
            this.spmDos.write(this.pTrans.gsiPart1, 0, 4);
            this.spmDos.writeShort(this.pTrans.nackPort);
            this.spmDos.writeShort(0);
            this.spmDos.writeInt(this.spmSeqN);
            ++this.spmSeqN;
            this.spmDos.writeInt(this.trailSeqN);
            this.spmDos.writeInt(this.sentFrontSeqN);
            if (this.pTrans.localAddressBytes.length == 16) {
                this.spmDos.writeShort(2);
            } else {
                this.spmDos.writeShort(1);
            }
            this.spmDos.writeShort(0);
            this.spmDos.write(this.pTrans.localAddressBytes);
            if (this.spmOptVer != this.optUpd) {
                this.writeOptions(true);
            }
            this.spmDos.write(this.spmOptField);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write SPM. Stream: " + this.toString(), ex, moduleName);
            return;
        }
        this.spmPacket = this.spmBaos.getBuffer();
        this.spmLength = this.spmBaos.getPosition();
        this.spmBaos.reset();
    }

    public void setTransmissionRate(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
            this.limitRate = true;
        }
        if (this.congestionControl == null) {
            this.oDataBucket.setRate(rate_kbps);
        } else {
            this.congestionControl.resetValues(rate_kbps);
        }
    }

    public synchronized void startCongestionControl(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
        }
        if (this.congestionControl == null) {
            this.congestionControl = new CongestionControl(this.pTrans.config, this.oDataBucket, rate_kbps, this);
        } else {
            this.congestionControl.resetValues(rate_kbps);
        }
        this.limitRate = true;
    }

    public void stopCongestionControl() {
        this.limitRate = false;
        this.congestionControl = null;
        if (this.oDataBucket != null) {
            this.oDataBucket.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdminOption(byte type, byte[] option) {
        if (this.ncOptions >= 16) {
            this.pTrans.rmmLogger.baseWarn("StreamT.setAdminOption: failed: too many options set. Stream: " + this.toString(), null, moduleName);
            return;
        }
        if (option.length > 120) {
            this.pTrans.rmmLogger.baseWarn("StreamT.setAdminOption: failed: option is too long. Stream: " + this.toString(), null, moduleName);
            return;
        }
        Object object = this.cOptionLock;
        synchronized (object) {
            int i = 0;
            while (i < this.ncOptions) {
                if (this.cOptionType[i] == type) break;
                ++i;
            }
            if (i >= this.ncOptions) {
                if (this.ncOptions >= this.cOptionType.length) {
                    this.pTrans.rmmLogger.baseWarn("StreamT.setControlOption: failed: too many options set. Stream: " + this.toString(), null, moduleName);
                    return;
                }
                this.cOptionType[this.ncOptions++] = type;
            }
            if (this.cOptionVal[i] == null || this.cOptionVal[i].length != option.length) {
                this.cOptionVal[i] = new byte[option.length];
            }
            System.arraycopy(option, 0, this.cOptionVal[i], 0, option.length);
        }
        ++this.optUpd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedLine(int pack_seq_n) {
        if (pack_seq_n - this.pendFrontSeqN > 0) {
            this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " past current front " + this.pendFrontSeqN + ". Ignored. Stream: " + this.toString(), null, moduleName);
            return;
        }
        if (pack_seq_n - this.trailSeqN < 0) {
            if (this.sentFrontSeqN - this.trailSeqN > 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " below current trail. Setting it to trail " + this.trailSeqN + ". Stream:" + this, null, moduleName);
            }
            pack_seq_n = this.trailSeqN;
        }
        Object object = this.redLock;
        synchronized (object) {
            this.redLineSet = true;
            if (pack_seq_n - this.redLine < 0) {
                this.pTrans.rmmLogger.baseWarn("Trying to set red line " + pack_seq_n + " below current redLine " + this.redLine + ". Ignored. Stream: " + this.toString(), null, moduleName);
                return;
            }
            this.redLine = pack_seq_n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRedLine() {
        Object object = this.redLock;
        synchronized (object) {
            if (this.redLineSet) {
                return this.redLine;
            }
            return this.getFrontSeqNum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRedLine() {
        Object object = this.redLock;
        synchronized (object) {
            this.redLineSet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdminOption(byte type) {
        Object object = this.cOptionLock;
        synchronized (object) {
            int i = 0;
            while (i < this.ncOptions) {
                if (this.cOptionType[i] == type) {
                    --this.ncOptions;
                    this.cOptionType[i] = this.cOptionType[this.ncOptions];
                    this.cOptionVal[i] = this.cOptionVal[this.ncOptions];
                    break;
                }
                ++i;
            }
        }
        ++this.optUpd;
    }

    public String toString() {
        return "" + this.longId;
    }

    public boolean sendHeartbeat() {
        this.pTrans.rmmLogger.baseWarn("sendHeartbeat() (API) called on multicast topic", null, moduleName);
        return false;
    }

    public UnicastConnectionIf getUnicastConnection() {
        this.pTrans.rmmLogger.baseWarn("getUnicastConnection() (API) called on multicast topic", null, moduleName);
        return null;
    }

    public boolean addP2Pdestination(UnicastConnectionIf connection) {
        this.pTrans.rmmLogger.baseWarn("addP2Pdestination() (API) called on multicast topic", null, moduleName);
        return false;
    }

    public void setMtlSize(int size) {
        this.mtlSize = size;
    }
}

