/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.pgm.transmitter;

import com.ibm.rmm.ptl.pgm.transmitter.PTransmitter;
import com.ibm.rmm.ptl.pgm.transmitter.StreamT;

class TimingThread
extends Thread {
    static final String moduleName = "PTL_PGM_T";
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    boolean isSleeping;
    boolean notifyPending;
    boolean goDown;

    TimingThread(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp(boolean lock) {
        if (lock || this.isSleeping) {
            TimingThread timingThread = this;
            synchronized (timingThread) {
                if (this.isSleeping) {
                    this.notify();
                } else {
                    this.notifyPending = true;
                }
            }
        } else {
            this.notifyPending = true;
        }
    }

    public void interrupt() {
        this.goDown = true;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.curPos = 1;
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"TimingThread"}, null, moduleName);
        int exc_count = 0;
        while (!this.goDown) {
            ++this.nRot;
            try {
                this.curPos = 2;
                int i22 = this.pTrans.nStreams - 1;
                while (i22 >= 0) {
                    StreamT stream = this.pTrans.streamList[i22];
                    if (stream != null) {
                        this.curPos = 3;
                        if (stream.pendingPackets.qSize() == 0 && stream.mtlSize > 0) {
                            stream.requestPartialPacket();
                        }
                    }
                    --i22;
                }
                this.curPos = 6;
                TimingThread i22 = this;
                synchronized (i22) {
                    if (this.notifyPending) {
                        this.notifyPending = false;
                    } else {
                        this.isSleeping = true;
                        this.wait();
                        this.isSleeping = false;
                    }
                }
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"TimingThread"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("TimingThread: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop TimingThread", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"TimingThread"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"TimingThread"}, null, moduleName);
    }
}

