/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

class Config
extends com.ibm.rmm.ptl.tchan.transmitter.Config {
    static final String moduleName = "PTL_TCHAN_R";
    RmmLogger rmmLogger;
    static final int MAX_BUFFER_SIZE = 66560;
    int packetSize;
    int socketBufferSize;
    String channelConfigFile;
    int serverPort;
    int nBuffers;
    boolean isOK;
    String networkInterface;
    int hbTimeoutMillis;
    int maxTagLength = 32000;
    int closeWaitForPermission = 10;
    int closeWaitForPermissionTimeOut = 20000;

    Config(RmmLogger rlog, Properties java_props) {
        this.rmmLogger = rlog;
        this.isOK = true;
        String tmp = java_props.getProperty("PacketBuffers");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"PacketBuffers"}, null, moduleName);
        } else {
            try {
                this.nBuffers = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("PacketBuffers", tmp, e2, moduleName);
                this.isOK = false;
                return;
            }
            if (this.nBuffers <= 0) {
                this.rmmLogger.baseBadParam("PacketBuffers", "" + this.nBuffers, null, moduleName);
                this.isOK = false;
                return;
            }
            if (this.nBuffers > 5000) {
                this.rmmLogger.baseWarn("PacketBuffers value: " + this.nBuffers, null, moduleName);
            }
        }
        if (this.nBuffers <= 0) {
            this.rmmLogger.baseInfo("Using default PacketBuffers: 500", moduleName);
            this.nBuffers = 500;
        }
        if ((tmp = java_props.getProperty("PacketBufferSizeBytes")) == null) {
            this.packetSize = 33000;
        } else {
            try {
                this.packetSize = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("PacketBufferSizeBytes", tmp, e3, moduleName);
                this.isOK = false;
                return;
            }
            if (this.packetSize < 1500 || this.packetSize > 33000) {
                this.rmmLogger.baseWarn("PacketBufferSizeBytes value: " + this.packetSize, null, moduleName);
            }
            this.packetSize += 100;
        }
        this.channelConfigFile = java_props.getProperty("TcpChannelConfigFile");
        if (this.channelConfigFile == null) {
            this.channelConfigFile = "tc_conf.xml";
        }
        if ((tmp = java_props.getProperty("ServerSocketPort")) != null) {
            try {
                this.serverPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("ServerSocketPort", tmp, e4, moduleName);
                this.isOK = false;
                return;
            }
            if (this.serverPort <= 0 || this.serverPort > 65535) {
                this.rmmLogger.baseBadParam("ServerSocketPort", "" + this.serverPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("MaximalTagLength")) != null) {
            try {
                this.maxTagLength = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("MaximalTagLength", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.maxTagLength <= 0) {
                this.rmmLogger.baseBadParam("MaximalTagLength", "" + this.maxTagLength, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("HeartbeatTimeoutMillis")) != null) {
            try {
                this.hbTimeoutMillis = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e6) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMillis", tmp, e6, moduleName);
                this.isOK = false;
                return;
            }
            if (this.hbTimeoutMillis < 1) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMillis", "" + this.hbTimeoutMillis, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("MulticastInterface")) == null) {
            this.rmmLogger.baseLog(402, new Object[]{"MulticastInterface"}, null, moduleName);
            this.isOK = false;
            return;
        }
        if (tmp.equalsIgnoreCase("none") || tmp.equalsIgnoreCase("all")) {
            tmp = "*";
        }
        this.networkInterface = tmp;
    }
}

