/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tchan.receiver.P2PConnectionR;
import com.ibm.rmm.ptl.tchan.receiver.PEvent;
import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import com.ibm.rmm.ptl.tchan.receiver.StreamR;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.util.Vector;

final class HeartbeatProcessor
extends Thread {
    static final String moduleName = "PTL_TCHAN_R";
    PReceiver pRec;
    volatile int nRot;
    private int hbTimeoutMillis;
    private int sleepTime;
    private Object hbLock;
    private Vector closedUcon;
    private boolean goOn = true;

    HeartbeatProcessor(PReceiver prc) {
        this.pRec = prc;
        this.sleepTime = 1000;
        this.hbLock = new Object();
        this.closedUcon = new Vector();
        if (this.pRec.config.hbTimeoutMillis > 0) {
            this.pRec.rmmLogger.baseInfo("HeartbeatTimeout specified for Receiver (" + this.pRec.config.hbTimeoutMillis + " millis). Overriding the values configured in Transmitter", moduleName);
            this.hbTimeoutMillis = this.pRec.config.hbTimeoutMillis;
            this.sleepTime = this.hbTimeoutMillis > 50000 ? 5000 : this.hbTimeoutMillis / 10;
        }
    }

    void removeClosedConnections() {
        long time = Clock.getTime();
        if (this.pRec.closedVC.isEmpty()) {
            return;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("removeClosedConnections: found " + this.pRec.closedVC.size() + " elements in closedVC", moduleName);
        }
        EnumArray connections = new EnumArray(this.pRec.closedVC, true);
        while (connections.hasMoreElements()) {
            VirtualConnection vc = (VirtualConnection)connections.nextElement();
            if (vc == null) continue;
            P2PConnectionR con = (P2PConnectionR)this.pRec.closedVC.get(vc);
            long diff = time - con.timeCreated;
            if (diff < (long)this.pRec.config.closeWaitForPermissionTimeOut) {
                try {
                    if (!vc.requestPermissionToClose(10L)) continue;
                    this.pRec.closedVC.remove(vc);
                    if (vc instanceof OutboundVirtualConnection) {
                        OutboundVirtualConnection obvc = (OutboundVirtualConnection)vc;
                        obvc.close(new Exception("Closing OutboundVirtualConnection from HeartbeatProcessor"));
                        this.pRec.rmmLogger.baseInfo("HeartbeatProcessor: closed OutboundVirtualConnection vc " + obvc, moduleName);
                    } else {
                        if (con.unicastLink != null && con.unicastLink.deviceLink != null) {
                            con.unicastLink.deviceLink.close(vc, new Exception("Closing InboundVirtualConnection from HeartbeatProcessor"));
                        }
                        this.pRec.rmmLogger.baseInfo("HeartbeatProcessor: closed InboundVirtualConnection vc " + vc + " unicastLink " + (Object)((Object)con.unicastLink), moduleName);
                    }
                    if (con.unicastLink == null) continue;
                    con.unicastLink.cleanUp();
                }
                catch (Exception ex) {
                    this.pRec.rmmLogger.baseWarn("HeartbeatProcessor: Exception when closing VirualConnection " + vc, ex, moduleName);
                }
                continue;
            }
            this.pRec.rmmLogger.baseWarn("HeartbeatProcessor: could not close VirualConnection after waiting " + diff + " ms, vc " + vc, null, moduleName);
            this.pRec.closedVC.remove(vc);
        }
    }

    private boolean checkClosedStreams() {
        StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
        int i = 0;
        while (i < streams.length) {
            if (streams[i].heartbeatTimeout || streams[i].connectionFailed) {
                StreamR stream = streams[i];
                if (stream.transClosed) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("checkClosedStreams: Removing Stream " + stream + ", TRANS_CLOSED.", moduleName);
                    }
                } else if (stream.connectionFailed) {
                    this.pRec.rmmLogger.baseWarn("checkClosedStreams: Removing Stream " + stream + ", Connection faile.", null, moduleName);
                } else {
                    this.pRec.rmmLogger.baseWarn("checkClosedStreams: Removing Stream " + stream + ", Heartbeat timeout.", null, moduleName);
                }
                if (!stream.connectionFailed) {
                    PEvent ev = new PEvent(2, stream);
                    stream.mySet.packetListener.onEvent(ev);
                    if (stream.adminListener != null) {
                        stream.adminListener.onEvent(ev);
                    }
                }
                stream.mySet.packetListener.onHeartbeatTimeout(stream);
                stream.mySet.removeStream(stream);
            } else if (streams[i].transClosed) {
                int timeout;
                long time = Clock.getTime();
                if (this.hbTimeoutMillis > 0) {
                    timeout = this.hbTimeoutMillis;
                } else {
                    int n = timeout = streams[i].cpTimeout > 0 ? streams[i].cpTimeout * 1000 : 10000;
                }
                if (timeout > 120000) {
                    timeout = 120000;
                }
                if (time - streams[i].lastCpOrDataTime > (long)timeout) {
                    streams[i].heartbeatTimeout = true;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean checkConnectionHeartBeat(P2PConnectionR con) {
        if (con.unicastLink != null && !con.unicastLink.isClosed && (con.requestClose || con.unicastLink.unicastConnection != null && !con.unicastLink.unicastConnection.isValid())) {
            con.reportTimeout = false;
            con.hbTimeoutDetected = true;
            this.pRec.rmmLogger.baseWarn("checkConnectionHeartBeat found connection with requestClose/ucon.invalid " + Sutils.printIsa(con.destination), null, moduleName);
            StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
            int i = 0;
            while (i < streams.length) {
                if (((Object)((Object)streams[i].unicastLink)).equals((Object)con.unicastLink)) {
                    streams[i].heartbeatTimeout = true;
                }
                ++i;
            }
            return false;
        }
        if (con.timeout <= 0 && !con.hbTimeoutDetected) {
            return true;
        }
        long time = Clock.getTime();
        int timeout = this.hbTimeoutMillis > 0 ? this.hbTimeoutMillis : con.timeout * 1000;
        Object object = this.hbLock;
        synchronized (object) {
            long diff = time - con.timeCreated;
            if (diff > (long)(timeout / 3) && diff < (long)(timeout / 3 + this.sleepTime * 2) && this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxWarn("No Heartbeat received in last " + timeout / 3 + " milliseconds on connection " + Sutils.printIsa(con.destination), null, moduleName);
            }
            if (time - con.timeCreated < (long)timeout) {
                con.hbTimeoutDetected = false;
                return true;
            }
        }
        if (!con.hbTimeoutDetected) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Connection Heartbeat timeout detected on CF connection. Ignoring once. " + Sutils.printIsa(con.destination) + ", reportTimeout " + con.reportTimeout, moduleName);
            }
            con.hbTimeoutDetected = true;
            return true;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxWarn("Connection Heartbeat timeout " + Sutils.printIsa(con.destination) + ", reportTimeout " + con.reportTimeout, null, moduleName);
        }
        StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
        int i = 0;
        while (i < streams.length) {
            if (((Object)((Object)streams[i].unicastLink)).equals((Object)con.unicastLink)) {
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("Stream " + streams[i].id + ", Heartbeat timeout due to connection timeout " + Sutils.printIsa(con.destination) + ", reportTimeout " + con.reportTimeout, moduleName);
                }
                streams[i].heartbeatTimeout = true;
            }
            ++i;
        }
        return false;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"HeartbeatProcessor"}, null, moduleName);
        int exc_count = 0;
        this.pRec.rmmLogger.baseInfo("HeartbeatProcessor sleeptime is " + this.sleepTime, moduleName);
        while (this.goOn) {
            ++this.nRot;
            try {
                boolean found_hbt = false;
                this.checkClosedStreams();
                this.removeClosedConnections();
                EnumArray connections = new EnumArray(this.pRec.packetProcessor.connectionsHT, false);
                while (connections.hasMoreElements()) {
                    P2PConnectionR con = (P2PConnectionR)connections.nextElement();
                    if (con == null || this.checkConnectionHeartBeat(con)) continue;
                    found_hbt = true;
                    if (con.unicastLink != null && con.unicastLink.unicastConnection != null) {
                        this.closedUcon.add(con.unicastLink.unicastConnection);
                    }
                    if (con.unicastLink == null || con.unicastLink.isClosed) continue;
                    this.pRec.packetProcessor.connectionsHT.remove((Object)con.unicastLink);
                    if (this.pRec.myPTransmitter != null && con.reportTimeout && con.unicastLink.tcpWriteInterface != null) {
                        this.pRec.myPTransmitter.receiverReportConnection(con.destination, con.unicastLink.tcpWriteInterface, true, con.unicastLink.myVC);
                    }
                    if (con.unicastLink == null) continue;
                    this.pRec.rmmLogger.baseInfo("Removing connection after heartbeat timeout, remote address " + Sutils.printIsa(con.destination), moduleName);
                    if (con.unicastLink.rccb != null && !con.unicastLink.rccb.sdh.releaseBuffer()) {
                        this.pRec.rmmLogger.baseWarn("HeartbeatProcessor error when releasing sdh.byteBuffer", null, moduleName);
                    }
                    if (con.unicastLink.destroyed || con.unicastLink.myVC == null) continue;
                    P2PConnectionR closed_con = new P2PConnectionR(con.destination, con.unicastLink, 10000);
                    this.pRec.closedVC.put(con.unicastLink.myVC, closed_con);
                }
                if (found_hbt) {
                    this.checkClosedStreams();
                    this.removeClosedConnections();
                    UnicastConnection ucon = null;
                    while (!this.closedUcon.isEmpty()) {
                        ucon = (UnicastConnection)this.closedUcon.remove(0);
                        if (ucon == null) continue;
                        ucon.closeConnection(0);
                        ucon.isRxClosed = true;
                        if (!this.pRec.rmmLogger.isMaxLogLevel()) continue;
                        this.pRec.rmmLogger.maxInfo("HeartbeatProcessor: set isRxClosed = true for " + ucon.toString(), moduleName);
                    }
                }
                this.closedUcon.clear();
                HeartbeatProcessor.sleep(this.sleepTime);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"HeartbeatProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("HeartbeatProcessor: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop HeartbeatProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"HeartbeatProcessor"}, ex, moduleName);
                break;
            }
        }
        this.pRec.rmmLogger.baseLog(2, new Object[]{"HeartbeatProcessor"}, null, moduleName);
    }
}

