/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.ptl.tchan.receiver.StreamR;

public class LongStreamHash {
    private int hashMaxSize;
    private int nEl;
    private long[] keys;
    private StreamR[] values;
    private StreamR[] _values;
    private boolean v_updated;

    public LongStreamHash(int initial_size) {
        this.hashMaxSize = initial_size;
        this.keys = new long[this.hashMaxSize];
        this.values = new StreamR[this.hashMaxSize];
        this.nEl = 0;
        this.v_updated = true;
    }

    public synchronized StreamR[] getValues() {
        if (this.v_updated) {
            this._values = new StreamR[this.nEl];
            int i = 0;
            while (i < this.nEl) {
                this._values[i] = this.values[i];
                ++i;
            }
            this.v_updated = false;
        }
        return this._values;
    }

    public synchronized void put(long key, StreamR value2) {
        this.v_updated = true;
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                this.values[i] = value2;
                return;
            }
            ++i;
        }
        if (this.nEl == this.hashMaxSize) {
            long[] tmp_k = new long[2 * this.hashMaxSize];
            StreamR[] tmp_v = new StreamR[2 * this.hashMaxSize];
            int i2 = 0;
            while (i2 < this.hashMaxSize) {
                tmp_k[i2] = this.keys[i2];
                tmp_v[i2] = this.values[i2];
                ++i2;
            }
            this.keys = tmp_k;
            this.values = tmp_v;
            this.hashMaxSize *= 2;
        }
        this.keys[this.nEl] = key;
        this.values[this.nEl] = value2;
        ++this.nEl;
    }

    public synchronized StreamR get(long key) {
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized boolean containsKey(long key) {
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized boolean remove(long key) {
        int indx = 0;
        boolean found = false;
        int i = 0;
        while (i < this.nEl) {
            if (this.keys[i] == key) {
                indx = i;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            return false;
        }
        this.v_updated = true;
        --this.nEl;
        this.keys[indx] = this.keys[this.nEl];
        this.values[indx] = this.values[this.nEl];
        this.keys[this.nEl] = 0L;
        this.values[this.nEl] = null;
        return true;
    }

    int size() {
        return this.nEl;
    }
}

