/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.PacManOut;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetUpcalls;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.tchan.receiver.Config;
import com.ibm.rmm.ptl.tchan.receiver.HeartbeatProcessor;
import com.ibm.rmm.ptl.tchan.receiver.P2PConnectionR;
import com.ibm.rmm.ptl.tchan.receiver.Packet;
import com.ibm.rmm.ptl.tchan.receiver.PacketProcessor;
import com.ibm.rmm.ptl.tchan.receiver.ReadCompleteCB;
import com.ibm.rmm.ptl.tchan.receiver.RumMultiplex;
import com.ibm.rmm.ptl.tchan.receiver.StreamR;
import com.ibm.rmm.ptl.tchan.receiver.StreamSet;
import com.ibm.rmm.ptl.tchan.receiver.UnicastLink;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.channel.framework.internals.InboundVirtualConnection;
import com.ibm.ws.channel.samples.configloader.ConfigurationLoader;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PReceiver
implements PReceiverIf {
    static final String moduleName = "PTL_TCHAN_R";
    PTransmitterIf myPTransmitter;
    Config config;
    RmmAddress rmmAddress;
    RmmLogger rmmLogger;
    TaskManager taskMan;
    HeartbeatProcessor heartbeatProcessor;
    PacketProcessor packetProcessor;
    InetAddress mcInterf;
    boolean isRunning;
    boolean relSrvRun = false;
    private boolean hasRumStarted = false;
    ObjCyclQueue packetPool;
    ObjCyclQueue packetQueue;
    int packetPool_nBuffers;
    ChannelFramework channelFramework;
    Hashtable closedVC;
    int sendSnp;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, InetAddress mc_interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.isRunning = true;
            this.mcInterf = mc_interf;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.packetProcessor = new PacketProcessor(this);
            this.packetProcessor.setName("Ptl_Tchan_PacketProcessor");
            this.packetProcessor.setPriority(10);
            this.heartbeatProcessor = new HeartbeatProcessor(this);
            this.heartbeatProcessor.setName("Ptl_Tchan_HeartbeatProcessor");
            this.heartbeatProcessor.setPriority(10);
            this.packetPool = new ObjCyclQueue(1);
            this.packetPool_nBuffers = 0;
            this.packetQueue = new ObjCyclQueue(this.config.nBuffers);
            this.closedVC = new Hashtable();
            RumMultiplex.putRumInstance(this.config.networkInterface, "" + this.config.serverPort, this);
            if (config_map != null) {
                this.channelFramework = (ChannelFramework)config_map.get("ChannelFrameWorkObject");
            }
            if (this.channelFramework == null) {
                this.rmmLogger.baseWarn("Couldnt find ChannelFramework object. Config map: \n" + config_map + "\nCreating tester CF", null, moduleName);
                this.channelFramework = ConfigurationLoader.loadConfiguration((String)this.config.channelConfigFile);
                this.channelFramework.initChain("UnicastChain");
                this.channelFramework.startChain("UnicastChain");
            }
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PReceiver", e2, moduleName);
            return false;
        }
        return true;
    }

    synchronized void startRumServices() {
        if (!this.hasRumStarted) {
            this.packetProcessor.start();
            this.heartbeatProcessor.start();
            this.hasRumStarted = true;
        }
    }

    public synchronized StreamSetIf createStreamSet(StreamSelector matcher, StreamSetUpcalls list, boolean reliable, boolean fifo) {
        if (fifo) {
            this.rmmLogger.baseError("PReceiver: currently FIFO is not supported at PTL layer", null, moduleName);
        }
        StreamSet str_set = new StreamSet(this, !reliable, false);
        str_set.setStreamSelector(matcher);
        str_set.setPacketListener(list);
        this.packetProcessor.addStreamSet(str_set);
        return str_set;
    }

    public boolean joinMulticastGroup(InetAddress address) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to join a multicast group " + address, null, moduleName);
        return false;
    }

    public boolean leaveMulticastGroup(InetAddress address) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to leave a multicast group " + address, null, moduleName);
        return false;
    }

    public boolean joinMulticastGroup(InetAddress address, int port2) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to join a multicast group", null, moduleName);
        return false;
    }

    public boolean leaveMulticastGroup(InetAddress address, int port2) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to leave a multicast group", null, moduleName);
        return false;
    }

    public boolean stop() {
        this.rmmLogger.baseInfo("STOPPING RMReceiver", moduleName);
        this.isRunning = false;
        InetSocketAddress isa = null;
        EnumArray connections = new EnumArray(this.packetProcessor.connectionsHT, true);
        while (connections.hasMoreElements()) {
            try {
                UnicastLink uniLink = (UnicastLink)((Object)connections.nextElement());
                if (uniLink == null) continue;
                isa = null;
                if (uniLink.myVC == null || !(uniLink.myVC instanceof InboundVirtualConnection)) continue;
                isa = new InetSocketAddress(uniLink.sourceAddress, uniLink.sourcePort);
                boolean permission = uniLink.myVC.requestPermissionToClose(50L);
                if (permission) {
                    if (uniLink.deviceLink == null) continue;
                    uniLink.deviceLink.close(uniLink.myVC, new Exception("Closing connection on pReceiver stop"));
                    if (!this.rmmLogger.isMaxLogLevel()) continue;
                    this.rmmLogger.maxInfo("Close InboundVirtualConnection on receiver stop " + Sutils.printIsa(isa) + ", permission " + permission + ", vc " + uniLink.myVC, moduleName);
                    continue;
                }
                this.rmmLogger.baseWarn("Did not get permission to close InboundVirtualConnection on receiver stop " + Sutils.printIsa(isa) + ", permission " + permission + ", vc " + uniLink.myVC, null, moduleName);
            }
            catch (Exception exp) {
                this.rmmLogger.baseWarn("Failed to close InboundVirtualConnection on receiver stop " + isa, exp, moduleName);
            }
        }
        this.packetProcessor.interrupt();
        int i = 0;
        while (!this.packetProcessor.threadStopped && i < 5) {
            this.packetProcessor.interrupt();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException permission) {
                // empty catch block
            }
            ++i;
        }
        if (!this.packetProcessor.threadStopped) {
            this.rmmLogger.baseError("Failed to properly stop PacketProcessor thread", null, moduleName);
        }
        if (this.heartbeatProcessor != null) {
            this.heartbeatProcessor.interrupt();
        }
        while (!this.packetQueue.isEmpty()) {
            Packet packet = (Packet)this.packetQueue.popFirst();
            if (packet == null) continue;
            packet.buffer.release();
        }
        connections = new EnumArray(this.packetProcessor.connectionsHT, true);
        while (connections.hasMoreElements()) {
            UnicastLink uniLink = (UnicastLink)((Object)connections.nextElement());
            if (uniLink == null) continue;
            try {
                if (uniLink.rccb == null || uniLink.rccb.sdh == null) continue;
                uniLink.rccb.sdh.releaseBuffer();
            }
            catch (Exception exp) {
                this.rmmLogger.baseWarn("Failed to release SDH buffer when stopping receiver", exp, moduleName);
            }
        }
        return true;
    }

    public void clearRejectedStreamList() {
        if (this.packetProcessor != null) {
            this.packetProcessor.clearRejectedStreamList();
        }
    }

    public StreamRIf getStream(long id) {
        return this.packetProcessor.streamHash.get(id);
    }

    public StreamRIf getStream(byte[] tag, InetAddress source_addr, int source_port) {
        this.rmmLogger.baseError("PTransmitter.getStream: P2P stream is not uniquely identified by tag/src/port", null, moduleName);
        return null;
    }

    public String getProtocolVersion() {
        return "100";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append(" HBProc: r").append(this.heartbeatProcessor.nRot).append(". PProc: r").append(this.packetProcessor.nRot).append(". connections: ").append(this.packetProcessor.connectionsHT.size()).append("\n");
            this.packetProcessor.printRejectedStreamList(stat);
            return stat.toString();
        }
        catch (Exception ex) {
            return "Not started";
        }
    }

    public synchronized void setPtransmitter(PTransmitterIf pTransmitter) {
        this.myPTransmitter = pTransmitter;
    }

    public int getServerSocketPort() {
        return this.config.serverPort;
    }

    public void registerNewConnection(Object socket, InetAddress address, int port2) throws Exception {
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Entering PReceiver.registerNewConnection on " + address + ":" + port2, moduleName);
        }
        UnicastConnection ucon = (UnicastConnection)socket;
        TCPReadRequestContext tcpReadInterface = ucon.getTCPConnectionContext().getReadInterface();
        UnicastLink ul = new UnicastLink(this);
        ul.unicastConnection = ucon;
        ul.myVC = ucon.getVC();
        ul.sourceAddress = address;
        ul.sourcePort = port2;
        ul.tcpWriteInterface = tcpReadInterface.getInterface().getWriteInterface();
        ul.tcpReadInterface = tcpReadInterface;
        ul.tcpInterface = tcpReadInterface.getInterface();
        ReadCompleteCB rccb = new ReadCompleteCB(ul);
        if (rccb.sdh.byteBuffer == null) {
            this.rmmLogger.baseError("registerNewConnection failed, rccb.sdh.byteBuffer is null", null, moduleName);
            throw new Exception("registerNewConnection failed, rccb.sdh.byteBuffer is null");
        }
        ul.rccb = rccb;
        if (tcpReadInterface == null || ul.tcpWriteInterface == null || rccb.sdh.byteBuffer == null) {
            this.rmmLogger.baseError("registerNewConnection failed to setup unicastLink " + tcpReadInterface + " " + rccb.sdh.byteBuffer, null, moduleName);
            throw new Exception("registerNewConnection failed to setup unicastLink");
        }
        tcpReadInterface.setBuffer(rccb.sdh.byteBuffer);
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Calling complete(read(.. )) in PReceiver.registerNewConnection", moduleName);
        }
        rccb.complete(tcpReadInterface.read(1L, (TCPReadCompletedCallback)rccb, true, -1), tcpReadInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOrRemoveConnection(Object socket, InetSocketAddress address, boolean checkOnly) {
        P2PConnectionR p2pcon;
        boolean res = false;
        if (socket == null) {
            this.rmmLogger.baseError("checkOrRemoveConnection: virtual connection (socket) is null", null, moduleName);
            return false;
        }
        VirtualConnection vc = (VirtualConnection)socket;
        UnicastLink unilink = null;
        EnumArray connections = new EnumArray(this.packetProcessor.connectionsHT, false);
        while (connections.hasMoreElements()) {
            p2pcon = (P2PConnectionR)connections.nextElement();
            if (p2pcon == null || p2pcon.unicastLink == null || p2pcon.unicastLink.myVC != vc) continue;
            unilink = p2pcon.unicastLink;
            break;
        }
        boolean bl = res = unilink != null;
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("checkOrRemoveConnection: looking for connection to " + Sutils.printIsa(address) + ", res " + res + " checkOnly " + checkOnly, moduleName);
        }
        if (checkOnly) {
            return res;
        }
        if (unilink != null) {
            Hashtable hashtable = this.packetProcessor.connectionsHT;
            synchronized (hashtable) {
                p2pcon = (P2PConnectionR)this.packetProcessor.connectionsHT.get((Object)unilink);
                if (p2pcon != null) {
                    p2pcon.requestClose = true;
                    res = true;
                } else {
                    res = false;
                }
            }
        }
        return res;
    }

    WsByteBuffer getWsByteBuffer(int size) {
        WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocate(size);
        if (wsbb == null) {
            return null;
        }
        wsbb.clear();
        wsbb.order(ByteOrder.BIG_ENDIAN);
        return wsbb;
    }

    public int getConnStreams(Object socket, PacManOut pmo) {
        try {
            if (socket == null || pmo == null) {
                return -1;
            }
            UnicastConnection ucon = (UnicastConnection)socket;
            StreamR[] streams = this.packetProcessor.streamHash.getValues();
            int npos = pmo.getPosition();
            pmo.writeInt(0);
            int n = 0;
            int i = streams.length - 1;
            while (i >= 0) {
                if (streams[i] != null && streams[i].unicastLink.unicastConnection == ucon) {
                    pmo.writeLong(streams[i].id);
                    ++n;
                }
                --i;
            }
            if (n > 0) {
                int mpos = pmo.getPosition();
                pmo.setPosition(npos);
                pmo.writeInt(n);
                pmo.setPosition(mpos);
            }
            return n;
        }
        catch (Throwable ex) {
            this.rmmLogger.baseError("getConnStreams: got exception!!", ex, moduleName);
            return -1;
        }
    }

    public int updSendSnp(int add) {
        this.sendSnp += add;
        return this.sendSnp;
    }
}

