/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.tchan.receiver.AdminEvent;
import com.ibm.rmm.ptl.tchan.receiver.LongStreamHash;
import com.ibm.rmm.ptl.tchan.receiver.P2PConnectionR;
import com.ibm.rmm.ptl.tchan.receiver.PEvent;
import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import com.ibm.rmm.ptl.tchan.receiver.Packet;
import com.ibm.rmm.ptl.tchan.receiver.StreamR;
import com.ibm.rmm.ptl.tchan.receiver.StreamSet;
import com.ibm.rmm.ptl.tchan.receiver.UnicastLink;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.rmm.util.RMMRejectAndCloseConnectionException;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Hashtable;

class PacketProcessor
extends Thread {
    static final String moduleName = "PTL_TCHAN_R";
    PReceiver pRec;
    boolean isSleeping;
    LongStreamHash streamHash;
    volatile int nRot;
    volatile boolean threadStopped = false;
    private Packet packet;
    private WsByteBuffer wsbb;
    private byte[] buffer;
    private byte[] tagBuf;
    private int nSets;
    private int setQsize = 100;
    private StreamSet[] setList;
    private long[] rejectedStreams;
    private Object rejectedStreamLock;
    private int rejectedStreamNumber;
    private int rejectedStreamSize;
    private int rejectedVersion;
    private boolean goOn = true;
    private long[] connStreams;
    Hashtable connectionsHT;

    PacketProcessor(PReceiver prc) {
        this.pRec = prc;
        this.streamHash = new LongStreamHash(10);
        this.rejectedStreamNumber = 0;
        this.rejectedStreamSize = 10;
        this.rejectedStreams = new long[this.rejectedStreamSize];
        this.rejectedStreamLock = new Object();
        this.rejectedVersion = 0;
        this.tagBuf = new byte[Short.MAX_VALUE];
        this.nSets = 0;
        this.setList = new StreamSet[this.setQsize];
        this.connectionsHT = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            this.setList[this.nSets] = set;
            ++this.nSets;
            if (this.nSets == this.setQsize) {
                StreamSet[] tmp = this.setList;
                this.setList = new StreamSet[2 * this.setQsize];
                int i = 0;
                while (i < this.nSets) {
                    this.setList[i] = tmp[i];
                    ++i;
                }
                this.setQsize *= 2;
            }
            this.clearRejectedStreamList();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRejectedStreamList() {
        Object object = this.rejectedStreamLock;
        synchronized (object) {
            this.rejectedStreamNumber = 0;
            this.rejectedStreamSize = 10;
            this.rejectedStreams = new long[this.rejectedStreamSize];
            ++this.rejectedVersion;
        }
    }

    void printRejectedStreamList(StringBuffer sb) {
        long[] streams = this.rejectedStreams;
        if (streams == null || this.rejectedStreamNumber == 0) {
            sb.append("_RMM_STATS_ RejectedStreamSize: 0");
            return;
        }
        int len = this.rejectedStreamNumber;
        if (len > streams.length) {
            len = streams.length;
        }
        sb.append("_RMM_STATS_  RejectedStreamSize: ").append(this.rejectedStreamNumber).append(", ").append(len);
        int i = 0;
        while (i < len) {
            if (i % 20 == 0) {
                sb.append("\n_RMM_STATS_  ");
            }
            sb.append(" | ").append(streams[i]);
            ++i;
        }
        sb.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int ind = 0;
            boolean found = false;
            int i = 0;
            while (i < this.nSets) {
                if (this.setList[i] == set) {
                    ind = i;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.pRec.rmmLogger.baseWarn("removeStreamSet: no set found", null, moduleName);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            i = ind;
            while (i < this.nSets - 1) {
                this.setList[i] = this.setList[i + 1];
                ++i;
            }
            --this.nSets;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int i2 = 0;
            while (i2 < set.streamList.size()) {
                StreamR str = (StreamR)set.streamList.elementAt(i2);
                this.removeStream(str);
                ++i2;
            }
            return;
        }
    }

    void removeStream(StreamRIf stream) {
        boolean res = this.streamHash.remove(stream.getId());
        if (res) {
            this.pRec.sendSnp = 5;
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Removing PTL Stream " + stream.getId() + " Remaining: " + this.streamHash.size(), moduleName);
            }
        } else if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxWarn("Failed to remove PTL Stream " + stream.getId() + " Remaining: " + this.streamHash.size(), null, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContrPack(StreamR stream, boolean stream_closed) {
        Object object = stream.hbLock;
        synchronized (object) {
            stream.lastCpOrDataTime = Clock.getTime();
        }
        stream.cpTimeout = this.wsbb.getShort();
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Got heartbeat on stream " + stream.id + ". Time: " + stream.lastCpOrDataTime + ". T.O. Interval: " + stream.cpTimeout, moduleName);
        }
        if (stream_closed && !stream.transClosed) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Stream transmission closed by sender. Stream Id: " + stream.id, moduleName);
            }
            stream.transClosed = true;
            PEvent ev = new PEvent(5, stream);
            stream.mySet.packetListener.onEvent(ev);
            if (stream.adminListener != null) {
                AdminEvent aev = new AdminEvent(5, stream);
                stream.adminListener.onEvent(aev);
            }
        }
    }

    void processHBPacket(Packet packet, short hb_timeout, boolean is_heartbeat) {
        P2PConnectionR connection = (P2PConnectionR)this.connectionsHT.get((Object)packet.source);
        if (connection != null) {
            connection.timeCreated = Clock.getTime();
        } else {
            InetSocketAddress isa = new InetSocketAddress(packet.source.sourceAddress, packet.source.sourcePort);
            EnumArray connections = new EnumArray(this.connectionsHT, false);
            while (connections.hasMoreElements()) {
                connection = (P2PConnectionR)connections.nextElement();
                if (connection == null || !connection.destination.equals(isa)) continue;
                long diff = Clock.getTime() - connection.timeCreated;
                this.pRec.rmmLogger.baseWarn("processHBPacket: Found existing connection in connectionsHT " + connection.destination + " last HB " + diff + " " + isa, null, moduleName);
            }
            if (packet.source.isClosed) {
                this.pRec.rmmLogger.baseWarn("Error when adding connection to connectionsHT source is closed " + Sutils.printIsa(isa), null, moduleName);
                return;
            }
            connection = new P2PConnectionR(isa, packet.source, hb_timeout);
            connection.timeCreated = Clock.getTime();
            if (this.connectionsHT.put(packet.source, connection) != null) {
                this.pRec.rmmLogger.baseError("Error when adding connection to connectionsHT entry exists " + Sutils.printIsa(connection.destination) + "  entries " + this.connectionsHT.size(), null, moduleName);
            } else if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Adding connection to connectionsHT " + Sutils.printIsa(connection.destination) + "  entries " + this.connectionsHT.size(), moduleName);
            }
        }
        if (is_heartbeat && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Got heartbeat on connection from " + Sutils.printIsa(connection.destination) + ". Time: " + connection.timeCreated + ". T.O. Interval: " + hb_timeout, moduleName);
        }
    }

    private void processSLPacket() {
        StreamR[] streamList = this.streamHash.getValues();
        try {
            UnicastConnection ucon = this.packet.source.unicastConnection;
            int ns = this.wsbb.getInt();
            if (this.connStreams == null || this.connStreams.length < ns) {
                this.connStreams = new long[(ns + 15) / 16 * 16];
            }
            int n = 0;
            while (n < ns) {
                this.connStreams[n] = this.wsbb.getLong();
                ++n;
            }
            int i = streamList.length - 1;
            while (i >= 0) {
                StreamR stream = streamList[i];
                if (stream != null && !stream.transClosed && !stream.heartbeatTimeout && stream.unicastLink != null && stream.mySet.packetListener != null && stream.snpEvent < 2 && stream.unicastLink.unicastConnection == ucon) {
                    int n2 = ns;
                    while (n2-- > 0) {
                        if (stream.id == this.connStreams[n2]) break;
                    }
                    if (n2 < 0 && ++stream.snpEvent >= 2) {
                        this.pRec.rmmLogger.baseInfo("gotConnStreams: put STREAM_NOT_PRESENT_AT_SOURCE event for stream " + stream.id, moduleName);
                        PEvent ev = new PEvent(20, stream);
                        stream.mySet.packetListener.onEvent(ev);
                        stream.transClosed = true;
                    }
                }
                --i;
            }
            if (this.pRec.myPTransmitter != null) {
                ns = this.wsbb.getInt();
                if (this.connStreams == null || this.connStreams.length < ns) {
                    this.connStreams = new long[(ns + 15) / 16 * 16];
                }
                n = 0;
                while (n < ns) {
                    this.connStreams[n] = this.wsbb.getLong();
                    ++n;
                }
                this.pRec.myPTransmitter.gotConnStreams(ucon, this.connStreams, ns);
            }
        }
        catch (Throwable ex) {
            this.pRec.rmmLogger.baseWarn("processSLPacket: caought Exception: ", ex, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamR fetchStream(boolean stream_closed, Packet packet, long sid, short tag_length, byte[] tag_buffer) {
        StreamR stream = this.streamHash.get(sid);
        if (stream != null) {
            return stream;
        }
        if (stream_closed) {
            return null;
        }
        StreamSet[] streamSetArray = this.rejectedStreamLock;
        synchronized (this.rejectedStreamLock) {
            int i = 0;
            while (i < this.rejectedStreamNumber) {
                if (this.rejectedStreams[i] == sid) {
                    // ** MonitorExit[var9_7] (shouldn't be in output)
                    return null;
                }
                ++i;
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            if (tag_length == -1) {
                return null;
            }
            streamSetArray = this.streamHash;
            synchronized (streamSetArray) {
                stream = this.streamHash.get(sid);
                if (stream != null) {
                    return stream;
                }
            }
            streamSetArray = this.setList;
            synchronized (this.setList) {
                int rv;
                i = 0;
                while (i < this.rejectedStreamNumber) {
                    if (this.rejectedStreams[i] == sid) {
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    ++i;
                }
                int tmp = (int)sid;
                int nack_port = tmp;
                if (nack_port < 0) {
                    nack_port -= -65536;
                }
                Object object = this.rejectedStreamLock;
                synchronized (object) {
                    rv = this.rejectedVersion;
                }
                int i2 = 0;
                while (i2 < this.nSets) {
                    boolean accept;
                    StreamSet set = this.setList[i2];
                    if (packet.source != null && packet.source.unicastConnection != null) {
                        if (packet.source.unicastConnection.isInvalid()) {
                            this.pRec.rmmLogger.baseWarn("fetchStream found closed UnicastConnection " + packet.source.unicastConnection.toString(), null, moduleName);
                            // ** MonitorExit[var9_7] (shouldn't be in output)
                            return null;
                        }
                    } else {
                        this.pRec.rmmLogger.baseWarn("fetchStream found packet with null UnicastConnection ", null, moduleName);
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    try {
                        accept = set.getStreamSelector().acceptStream(tag_buffer, tag_length, sid, packet.source.sourceAddress, nack_port);
                    }
                    catch (RMMRejectAndCloseConnectionException e2) {
                        InetSocketAddress remote = null;
                        if (packet.source != null) {
                            remote = new InetSocketAddress(packet.source.sourceAddress, packet.source.sourcePort);
                            boolean res = this.closeRejectedConnection(packet.source);
                            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                                this.pRec.rmmLogger.maxInfo("RMMRejectAndCloseConnectionException on stream " + sid + ", trying to close connection from " + Sutils.printIsa(remote) + ", resault " + res, moduleName);
                            }
                        } else {
                            this.pRec.rmmLogger.baseError("RMMRejectAndCloseConnectionException packet.source is null", null, moduleName);
                        }
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    if (accept) {
                        byte[] tag = new byte[tag_length];
                        System.arraycopy(tag_buffer, 0, tag, 0, tag_length);
                        stream = set.addStream(sid, tag, packet.source.sourceAddress, nack_port);
                        stream.unicastLink = packet.source;
                        this.streamHash.put(sid, stream);
                        this.pRec.sendSnp = 5;
                        PEvent ev = new PEvent(10, stream);
                        ev.objField = stream.unicastLink.unicastConnection;
                        set.packetListener.onEvent(ev);
                        if (set.adminListener != null) {
                            set.adminListener.onEvent(ev);
                        }
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("New stream accepted, stream id " + sid + " TagLen " + tag_length + " " + tag.length, moduleName);
                        }
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return stream;
                    }
                    ++i2;
                }
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("New stream rejected, stream id " + sid + " TagLen " + tag_length, moduleName);
                }
                Object object2 = this.rejectedStreamLock;
                synchronized (object2) {
                    if (rv == this.rejectedVersion) {
                        if (this.rejectedStreamNumber == this.rejectedStreamSize) {
                            long[] tmpl = this.rejectedStreams;
                            this.rejectedStreamSize *= 2;
                            this.rejectedStreams = new long[this.rejectedStreamSize];
                            int i3 = 0;
                            while (i3 < this.rejectedStreamNumber) {
                                this.rejectedStreams[i3] = tmpl[i3];
                                ++i3;
                            }
                        }
                        this.rejectedStreams[this.rejectedStreamNumber] = sid;
                        ++this.rejectedStreamNumber;
                    }
                    this.pRec.sendSnp = 5;
                }
                // ** MonitorExit[var9_7] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnBuffer(Packet pack) {
        ObjCyclQueue objCyclQueue = this.pRec.packetPool;
        synchronized (objCyclQueue) {
            pack.buffer.release();
            --this.pRec.packetPool_nBuffers;
            this.pRec.packetPool.notifyAll();
        }
    }

    boolean closeRejectedConnection(UnicastLink uniLink) {
        boolean res = true;
        if (uniLink == null || uniLink.myVC == null) {
            this.pRec.rmmLogger.baseError("closeRejectedConnection: called with null uniLink or vc " + (Object)((Object)uniLink), null, moduleName);
            return false;
        }
        VirtualConnection vc = uniLink.myVC;
        InetSocketAddress remoteISA = null;
        this.pRec.rmmLogger.baseInfo("closeRejectedConnection: now closing VirtualConnection.", moduleName);
        try {
            uniLink.isClosed = true;
            remoteISA = new InetSocketAddress(uniLink.sourceAddress, uniLink.sourcePort);
            this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Connection from " + Sutils.printIsa(remoteISA) + " rejected and will be closed", null, moduleName);
            if (this.pRec.myPTransmitter != null && uniLink.tcpWriteInterface != null) {
                this.pRec.myPTransmitter.receiverReportConnection(remoteISA, uniLink.tcpWriteInterface, true, vc);
            }
            this.connectionsHT.remove((Object)uniLink);
            StreamR[] streams = this.streamHash.getValues();
            int i = 0;
            while (i < streams.length) {
                if (streams[i].unicastLink == uniLink) {
                    PEvent ev = new PEvent(5, streams[i]);
                    streams[i].mySet.packetListener.onEvent(ev);
                    if (streams[i].adminListener != null) {
                        streams[i].adminListener.onEvent(ev);
                    }
                    streams[i].connectionFailed = true;
                }
                ++i;
            }
            if (uniLink.rccb != null && !uniLink.rccb.sdh.releaseBuffer()) {
                this.pRec.rmmLogger.baseWarn("closeRejectedConnection error when releasing sdh.byteBuffer", null, moduleName);
            }
        }
        catch (Exception ex) {
            this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Exception when processing connection close  vc: " + vc, ex, moduleName);
        }
        boolean isInbound = true;
        try {
            if (vc instanceof OutboundVirtualConnection) {
                isInbound = false;
                OutboundVirtualConnection ovc = (OutboundVirtualConnection)vc;
                if (ovc.requestPermissionToClose((long)this.pRec.config.closeWaitForPermission)) {
                    ovc.close(new Exception("Closing OutboundVirtualConnection from closeRejectedConnection"));
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("OutboundVirtualConnection closed from closeRejectedConnection, vc " + vc, moduleName);
                    }
                } else {
                    P2PConnectionR con = new P2PConnectionR(remoteISA, uniLink, 10000);
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("Did not get permission to close OutboundVirtualConnection from closeRejectedConnection, vc " + vc, moduleName);
                    }
                    if (this.pRec.closedVC.put(vc, con) != null && this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("closeRejectedConnection: OutboundVirtualConnection already exists in closedVC, vc " + vc, moduleName);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Exception when closing outbound  vc: " + vc, ex, moduleName);
            res = false;
        }
        if (isInbound && uniLink.deviceLink != null) {
            try {
                if (vc.requestPermissionToClose((long)this.pRec.config.closeWaitForPermission)) {
                    IOException t = new IOException("Closing InboundVirtualConnection from closeRejectedConnection");
                    uniLink.deviceLink.close(vc, (Exception)t);
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("InboundVirtualConnection closed from closeRejectedConnection, vc " + vc, moduleName);
                    }
                } else {
                    P2PConnectionR con = new P2PConnectionR(remoteISA, uniLink, 10000);
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("Did not get permission to close InboundVirtualConnection from closeRejectedConnection, vc " + vc, moduleName);
                    }
                    if (this.pRec.closedVC.put(vc, con) != null && this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("closeRejectedConnection: InboundVirtualConnection already exists in closedVC, vc " + vc, moduleName);
                    }
                }
            }
            catch (Exception exp) {
                this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Exception when closing unicast link  vc: " + vc, exp, moduleName);
                res = false;
            }
        }
        uniLink.cleanUp();
        return res;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketProcessor"}, null, moduleName);
        int packet_n = 0;
        int trail_n = 0;
        int cnt = 0;
        short tag_len = 0;
        this.isSleeping = false;
        int exc_count = 0;
        this.pRec.rmmLogger.baseInfo("PacketProcessor: waiting for StreamSets.", moduleName);
        int loops = 20;
        while (this.nSets == 0) {
            if (--loops <= 0) break;
            try {
                PacketProcessor.sleep(50L);
            }
            catch (InterruptedException e1) {
                break;
            }
        }
        try {
            PacketProcessor.sleep(50L);
        }
        catch (InterruptedException e1) {}
        while (this.goOn) {
            ++this.nRot;
            try {
                int pack_data_length;
                int pack_data_offset;
                if (this.pRec.packetQueue.qSize() == 0) {
                    PacketProcessor.yield();
                }
                ObjCyclQueue e1 = this.pRec.packetQueue;
                synchronized (e1) {
                    while ((this.packet = (Packet)this.pRec.packetQueue.popFirst()) == null) {
                        this.isSleeping = true;
                        this.pRec.packetQueue.wait();
                    }
                }
                this.isSleeping = false;
                ++cnt;
                this.wsbb = this.packet.buffer;
                this.wsbb.rewind();
                if (this.packet.source != null && (this.packet.source.isClosed || !this.packet.source.unicastConnection.isValid())) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxWarn("PacketProcessor found packet of closed source " + this.packet.source.unicastConnection, null, moduleName);
                    }
                    this.returnBuffer(this.packet);
                    continue;
                }
                byte protver = this.wsbb.get();
                if (protver != 100) {
                    this.pRec.rmmLogger.baseWarn("Version conflict " + protver + " vs " + 100, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                byte packet_type = this.wsbb.get();
                if (packet_type == 5) {
                    short hb_timeout = this.wsbb.getShort();
                    this.processHBPacket(this.packet, hb_timeout, true);
                    if (this.packet.length > this.wsbb.position() && this.wsbb.get() == 6) {
                        this.processSLPacket();
                    }
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (packet_type != 1 && packet_type != 2) {
                    this.pRec.rmmLogger.baseWarn("Bad packet type " + packet_type + " should be " + 1 + " or " + 2, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                long sid = this.wsbb.getLong();
                packet_n = this.wsbb.getInt();
                int n_options = this.wsbb.get();
                int length_of_options = 1;
                boolean stream_closed = false;
                int i = 0;
                while (i < n_options) {
                    byte opt_type = this.wsbb.get();
                    short opt_len = this.wsbb.getShort();
                    length_of_options += 3 + opt_len;
                    if (opt_type == 2) {
                        stream_closed = true;
                    } else {
                        this.wsbb.position(this.wsbb.position() + opt_len);
                    }
                    ++i;
                }
                tag_len = this.wsbb.getShort();
                if (tag_len > this.pRec.config.maxTagLength || tag_len <= 0) {
                    if (tag_len <= 0) {
                        this.pRec.rmmLogger.baseError("PacketProcessor found packet with invalid tag length " + tag_len + ", stream " + sid + " packet type " + packet_type + " options " + n_options + " " + length_of_options, null, moduleName);
                    }
                    this.pRec.rmmLogger.baseLog(420, new Object[]{this.packet.source.sourceAddress.getHostAddress(), "" + tag_len, "" + this.pRec.config.maxTagLength}, null, moduleName);
                    this.closeRejectedConnection(this.packet.source);
                    this.returnBuffer(this.packet);
                    continue;
                }
                this.wsbb.get(this.tagBuf, 0, (int)tag_len);
                StreamR stream = this.fetchStream(stream_closed, this.packet, sid, tag_len, this.tagBuf);
                if (stream == null) {
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (packet_type != 1) {
                    this.processContrPack(stream, stream_closed);
                    this.processHBPacket(this.packet, stream.cpTimeout, false);
                    this.returnBuffer(this.packet);
                    continue;
                }
                stream.packSeqN = packet_n;
                if (stream.firstPack) {
                    stream.frontSeqN = stream.packSeqN;
                    stream.trailSeqN = stream.packSeqN;
                    stream.lateJoin = false;
                    stream.firstPack = false;
                }
                if (stream.packSeqN == stream.trailSeqN) {
                    stream.frontSeqN = stream.packSeqN;
                    stream.trailSeqN = stream.packSeqN + 1;
                } else {
                    this.pRec.rmmLogger.baseError("Out of order packet in TCP stream " + stream.id + " . packet# " + stream.packSeqN + "trail# " + stream.trailSeqN, null, moduleName);
                    if (stream.packSeqN > stream.trailSeqN) {
                        stream.frontSeqN = stream.packSeqN;
                        stream.trailSeqN = stream.packSeqN + 1;
                        this.pRec.rmmLogger.baseWarn("Setting front to trail after out of order packet in TCP stream " + stream.id + " . packet# " + stream.packSeqN + "new trail# " + stream.trailSeqN, null, moduleName);
                    } else {
                        this.returnBuffer(this.packet);
                        continue;
                    }
                }
                ++stream.pCounter;
                if (stream.pCounter % 100 == 0 && (trail_n = stream.frontSeqN - 1000) > 0 && stream.dataListener != null) {
                    stream.dataListener.onTrailAdvance(trail_n);
                }
                this.processHBPacket(this.packet, stream.cpTimeout, false);
                if (this.wsbb.hasArray()) {
                    pack_data_offset = 16 + tag_len + length_of_options;
                    pack_data_length = this.packet.getLength() - pack_data_offset;
                    this.buffer = this.wsbb.array();
                } else {
                    pack_data_offset = 0;
                    pack_data_length = this.packet.getLength() - (16 + tag_len + length_of_options);
                    this.buffer = new byte[pack_data_length];
                    this.wsbb.get(this.buffer);
                }
                if (!stream.dataSuspend) {
                    if (stream.dataListener == null) {
                        stream.mySet.packetListener.onFirstPacket(stream, stream.packSeqN, this.buffer, pack_data_offset, pack_data_length, stream.lateJoin, stream.lateJoinMarkPos);
                    } else {
                        stream.dataListener.onPacket(stream.packSeqN, this.buffer, pack_data_offset, pack_data_length);
                    }
                }
                this.returnBuffer(this.packet);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketProcessor: Exception in thread loop", ex, moduleName);
                this.returnBuffer(this.packet);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketProcessor"}, ex, moduleName);
                break;
            }
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketProcessor"}, null, moduleName);
    }
}

