/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class RumMultiplex {
    static final String moduleName = "PTL_TCHAN_R";
    private static Hashtable map;

    static synchronized void putRumInstance(String nw_interf, String port2, PReceiver value2) {
        String key;
        if (map == null) {
            map = new Hashtable();
        }
        if (map.containsKey(key = String.valueOf(nw_interf) + ":" + port2)) {
            value2.rmmLogger.baseError("Another RUM instance already registered with address:port " + key, null, moduleName);
            return;
        }
        boolean match = false;
        String similar_key = null;
        EnumArray list = new EnumArray(map, false);
        while (list.hasMoreElements()) {
            PReceiver prc = (PReceiver)list.nextElement();
            if (prc == null) continue;
            String p_port = "" + prc.config.serverPort;
            String p_interf = prc.config.networkInterface;
            if (!p_port.equalsIgnoreCase(port2)) continue;
            if (nw_interf.equals("*") || p_interf.equals("*")) {
                match = true;
                similar_key = String.valueOf(p_interf) + ":" + p_port;
                break;
            }
            try {
                InetAddress a1 = InetAddress.getByName(p_interf);
                InetAddress a2 = InetAddress.getByName(nw_interf);
                if (!a1.equals(a2)) continue;
                match = true;
                similar_key = String.valueOf(p_interf) + ":" + p_port;
                break;
            }
            catch (UnknownHostException e2) {
                prc.rmmLogger.baseError("Failed to resolve an address", e2, moduleName);
                prc.rmmLogger.baseLog(412, new Object[]{String.valueOf(p_interf) + " or " + nw_interf}, e2, moduleName);
            }
        }
        if (match) {
            value2.rmmLogger.baseError("Trying to register an  RUM instance on " + key + ". Another instance registered on " + similar_key, null, moduleName);
            return;
        }
        map.put(key, value2);
    }

    static synchronized PReceiver getRumInstance(String nw_interf, String port2) {
        String key;
        PReceiver prc;
        if (map == null) {
            map = new Hashtable();
        }
        if ((prc = (PReceiver)map.get(key = String.valueOf(nw_interf) + ":" + port2)) != null) {
            prc.rmmLogger.baseInfo("CF Channel found PReceiver. Key: " + key, moduleName);
            return prc;
        }
        EnumArray list = new EnumArray(map, false);
        while (list.hasMoreElements()) {
            prc = (PReceiver)list.nextElement();
            if (prc == null) continue;
            String p_port = "" + prc.config.serverPort;
            String p_interf = prc.config.networkInterface;
            boolean match = false;
            if (p_port.equalsIgnoreCase(port2)) {
                if (nw_interf.equals("*") || p_interf.equals("*")) {
                    match = true;
                } else {
                    try {
                        InetAddress a1 = InetAddress.getByName(p_interf);
                        InetAddress a2 = InetAddress.getByName(nw_interf);
                        if (a1.equals(a2)) {
                            match = true;
                        }
                    }
                    catch (UnknownHostException e2) {
                        prc.rmmLogger.baseError("Failed to resolve an address", e2, moduleName);
                        prc.rmmLogger.baseLog(412, new Object[]{String.valueOf(p_interf) + " or " + nw_interf}, e2, moduleName);
                    }
                }
            }
            prc.rmmLogger.baseInfo("CF Channel looking for PReceiver. PReceiver address- " + p_interf + ":" + p_port + ". CF address- " + key + " Match: " + match, moduleName);
            if (!match) continue;
            return prc;
        }
        return null;
    }
}

