/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.ptl.admin.AckSessionR;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.tchan.receiver.PEvent;
import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import com.ibm.rmm.ptl.tchan.receiver.StreamSet;
import com.ibm.rmm.ptl.tchan.receiver.UnicastLink;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;

public class StreamR
implements StreamRIf {
    static final String moduleName = "PTL_TCHAN_R";
    PReceiver pRec;
    UnicastLink unicastLink;
    long id;
    byte[] tag;
    InetAddress sourceIP;
    int sourcePort;
    boolean isReliable;
    StreamSet mySet;
    int packSeqN;
    int frontSeqN;
    int trailSeqN;
    int lastContigN;
    int lateJoinMarkPos;
    boolean lateJoin;
    int tmpFront;
    int pCounter;
    short cpTimeout;
    long lastCpOrDataTime;
    boolean transClosed;
    boolean heartbeatTimeout;
    boolean connectionFailed;
    int snpEvent;
    boolean firstPack;
    boolean dataSuspend;
    AdminLayerListener adminListener;
    boolean relEvSent;
    StreamRUpcalls dataListener;
    Object hbLock;

    StreamR(StreamSet set, long id, byte[] tag, InetAddress nack_address, int nack_port, boolean fifo) {
        this.pRec = set.pRec;
        this.hbLock = new Object();
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Receiving PTL stream " + id + " from " + nack_address.getHostAddress() + ":" + nack_port, moduleName);
        }
        if (fifo) {
            this.pRec.rmmLogger.baseError("StreamR: currently FIFO is not supported at PTL layer. Stream: " + id, null, moduleName);
        }
        this.mySet = set;
        this.id = id;
        this.sourceIP = nack_address;
        this.sourcePort = nack_port;
        this.tag = tag;
        this.transClosed = false;
        this.heartbeatTimeout = false;
        this.connectionFailed = false;
        this.isReliable = !this.mySet.relOff;
        this.firstPack = true;
        this.frontSeqN = -1;
        this.trailSeqN = 0;
        this.lastContigN = 0;
        this.pCounter = 0;
        this.cpTimeout = (short)60;
        this.lastCpOrDataTime = System.currentTimeMillis();
    }

    void clean() {
        this.dataSuspend = true;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public long getId() {
        return this.id;
    }

    public InetAddress getSourceAddress() {
        return this.sourceIP;
    }

    public InetAddress getMulticastGroup() {
        return null;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public int getFrontSeqN() {
        return this.frontSeqN;
    }

    public int getContigSeqN() {
        if (this.dataListener == null) {
            return -1;
        }
        return this.dataListener.getContigiousSeqN();
    }

    public int getTotPacks() {
        return this.pCounter;
    }

    public void sendReportPacket(byte[] report, boolean unicast, boolean multicast) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeByte(100);
            dos.writeByte(4);
            dos.writeLong(this.id);
            dos.write(report);
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to write report. Stream: " + this.toString(), ex, moduleName);
        }
    }

    public void suspendDataAndNack() {
        this.pRec.rmmLogger.baseWarn("Reception suspended. Stream: " + this.toString(), null, moduleName);
        PEvent ev = new PEvent(11, this);
        this.mySet.packetListener.onEvent(ev);
        this.dataSuspend = true;
    }

    public void suspendDataReception() {
        this.pRec.rmmLogger.baseWarn("TCP PTL: Trying to suspend Data reception", null, moduleName);
    }

    public void suspendNackSending() {
        this.pRec.rmmLogger.baseWarn("TCP PTL: Trying to suspend Nacking", null, moduleName);
    }

    public void resumeDataReception(boolean advance_contig) {
        this.pRec.rmmLogger.baseWarn("TCP PTL: Trying to resume reception", null, moduleName);
    }

    public void resumeNackAndData() {
        this.pRec.rmmLogger.baseWarn("TCP PTL: Trying to resume Nacking", null, moduleName);
    }

    public int missingPackets(int from, int to) {
        int n_missing = 0;
        int gap = to - from;
        if (gap < 0) {
            this.pRec.rmmLogger.baseWarn("StreamR.missingPackets: 'to' less than 'from'. Stream: " + this.toString(), null, moduleName);
            return 0;
        }
        return n_missing;
    }

    public void setReliabilityOff() {
        this.isReliable = false;
    }

    public void setAdminListener(AdminLayerListener col) {
        if (this.adminListener != null) {
            this.pRec.rmmLogger.baseWarn("StreamR.setAdminListener: replacing existing listener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.adminListener = col;
    }

    public void setDataListener(StreamRUpcalls l) {
        this.dataListener = l;
    }

    public void removeAdminListener() {
        this.adminListener = null;
    }

    public String toString() {
        return "" + this.id;
    }

    public void setAckSessionR(AckSessionR acker) {
    }

    public AckSessionR getAckSessionR() {
        return null;
    }

    public UnicastConnectionIf getConnection() {
        if (this.unicastLink != null) {
            return this.unicastLink.unicastConnection;
        }
        return null;
    }
}

