/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import com.ibm.rmm.ptl.tchan.receiver.RumMultiplex;
import com.ibm.rmm.ptl.tchan.receiver.UnicastLink;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.Discriminator;
import com.ibm.wsspi.channel.base.InboundApplicationChannel;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.util.Map;

public class UnicastChannel
extends InboundApplicationChannel
implements Discriminator {
    static final String moduleName = "PTL_TCHAN_R";
    PReceiver pRec;
    com.ibm.wsspi.channel.framework.ChannelData config;
    String channelName;
    String interfAddress;
    String port;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public UnicastChannel(com.ibm.wsspi.channel.framework.ChannelData cc) {
        super(cc);
        this.config = cc;
    }

    public int discriminate(VirtualConnection vc, Object discrimData) {
        if (discrimData == null) {
            return -1;
        }
        WsByteBuffer wsbb = ((WsByteBuffer[])discrimData)[0];
        if (wsbb == null) {
            return -1;
        }
        int ret = 0;
        int position = wsbb.position();
        if (position < 4) {
            this.pRec.rmmLogger.baseInfo("Discriminator called with less than 4 bytes in buffer", moduleName);
            return -1;
        }
        wsbb.position(0);
        int signature = wsbb.getInt();
        wsbb.position(position);
        ret = this.inspectSignature(signature);
        this.pRec.rmmLogger.baseInfo("Discriminator called, signature is " + signature + " (" + 1562696995 + ") return " + ret, moduleName);
        return ret;
    }

    int inspectSignature(int sig) {
        if (sig == 1562696995) {
            return 1;
        }
        return 0;
    }

    public void cleanUpState(VirtualConnection vc) {
    }

    public Class getDiscriminatoryDataType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.wsspi.buffermgmt.WsByteBuffer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Channel getChannel() {
        return this;
    }

    public int getWeight() {
        return this.getConfig().getDiscriminatorWeight();
    }

    public Discriminator getDiscriminator() {
        return this;
    }

    public ConnectionLink getConnectionLink(VirtualConnection vc) {
        return new UnicastLink(this.pRec);
    }

    public void start() throws ChannelException {
        try {
            ChannelFramework channelFramework = this.config.getChannelFramework();
            ChainData[] chainData = channelFramework.getInternalRunningChains(this.config.getName());
            ChannelData tcpChannelData = chainData[0].getChannelList()[0];
            Map bag = tcpChannelData.getPropertyBag();
            this.interfAddress = (String)bag.get("hostname");
            this.port = (String)bag.get("listeningPort");
            this.pRec = RumMultiplex.getRumInstance(this.interfAddress, this.port);
        }
        catch (Throwable e2) {
            throw new ChannelException("Caught an exception in Channel start. Interface: " + this.interfAddress + ". Port: " + this.port, e2);
        }
        if (this.pRec == null) {
            throw new ChannelException("Could not find reference to RUM PReceiver. Interface: " + this.interfAddress + ". Port: " + this.port);
        }
        try {
            this.channelName = this.getConfig().getExternalName();
            this.pRec.rmmLogger.baseInfo("Channel " + this.channelName + " has started", moduleName);
            this.pRec.startRumServices();
        }
        catch (Throwable e3) {
            throw new ChannelException("Caught an exception in Channel start", e3);
        }
    }

    public void stop(long millisec) throws ChannelException {
        if (this.pRec != null && this.pRec.rmmLogger != null) {
            if (this.pRec.myPTransmitter != null) {
                this.pRec.myPTransmitter.stopChfw();
                if (this.pRec.myPTransmitter.isRunning()) {
                    this.pRec.rmmLogger.baseWarn("Calling transmitter.stopChfw after Channel " + this.channelName + "(" + this.interfAddress + ":" + this.port + ") was stopped by CF", null, moduleName);
                }
            }
            if (this.pRec.isRunning) {
                this.pRec.rmmLogger.baseWarn("Channel " + this.channelName + "(" + this.interfAddress + ":" + this.port + ") was stopped by CF, with param millisec =" + millisec, null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"UnicastChannel"}, null, moduleName);
            } else {
                this.pRec.rmmLogger.baseInfo("Channel " + this.channelName + "(" + this.interfAddress + ":" + this.port + ") was stopped by CF after RMM was stopped. param millisec =" + millisec, moduleName);
            }
        }
    }

    public void init() throws ChannelException {
    }

    public void destroy() throws ChannelException {
    }

    public Class getDeviceInterface() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.wsspi.tcp.channel.TCPConnectionContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void update(com.ibm.wsspi.channel.framework.ChannelData cc) {
    }
}

