/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.receiver;

import com.ibm.rmm.ptl.tchan.receiver.PReceiver;
import com.ibm.rmm.ptl.tchan.receiver.ReadCompleteCB;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;

public class UnicastLink
extends InboundApplicationLink {
    static final String moduleName = "PTL_TCHAN_R";
    TCPConnectionContext tcpInterface = null;
    VirtualConnection myVC = null;
    TCPReadRequestContext tcpReadInterface = null;
    TCPWriteRequestContext tcpWriteInterface = null;
    PReceiver pRec;
    ReadCompleteCB rccb;
    ConnectionLink deviceLink = null;
    boolean destroyed = false;
    volatile boolean isClosed = false;
    InetAddress sourceAddress;
    int sourcePort = 0;
    int remoteLocalPort = 0;
    int localPort = 0;
    UnicastConnection unicastConnection;

    UnicastLink(PReceiver prc) {
        this.pRec = prc;
    }

    public void ready(VirtualConnection vc) {
        if (vc == null) {
            this.pRec.rmmLogger.baseError("UnicastLink.ready called with null VirtualConnection", null, moduleName);
            return;
        }
        if (this.pRec == null || !this.pRec.isRunning) {
            this.closeVC(vc, this.getDeviceLink());
            return;
        }
        this.myVC = vc;
        this.deviceLink = this.getDeviceLink();
        Object tcpObject = this.deviceLink.getChannelAccessor();
        this.tcpInterface = (TCPConnectionContext)tcpObject;
        this.tcpReadInterface = this.tcpInterface.getReadInterface();
        this.tcpWriteInterface = this.tcpInterface.getWriteInterface();
        this.localPort = this.tcpInterface.getLocalPort();
        this.sourceAddress = this.tcpInterface.getRemoteAddress();
        this.remoteLocalPort = this.tcpInterface.getRemotePort();
        this.pRec.rmmLogger.baseInfo("Got TCP connection from " + this.sourceAddress.getHostAddress() + ":" + this.remoteLocalPort, moduleName);
        WsByteBuffer wsbb = null;
        if (this.tcpReadInterface != null) {
            wsbb = this.tcpReadInterface.getBuffer();
        }
        if (wsbb == null) {
            this.pRec.rmmLogger.baseError("Unicastlink.ready called with null buffer, closing connection!", null, moduleName);
            this.closeVC(vc, this.deviceLink);
            return;
        }
        int position = wsbb.position();
        if (position < 8) {
            this.pRec.rmmLogger.baseWarn("Read less than 8 bytes, trying to read more bytes, pos " + position + " " + wsbb.capacity() + " " + wsbb.limit(), null, moduleName);
            if (wsbb.capacity() < 8) {
                this.pRec.rmmLogger.baseError("Capacity of wsbb too small! closing connection, pos " + position + " " + wsbb.capacity() + " " + wsbb.limit(), null, moduleName);
                this.closeVC(vc, this.deviceLink);
                return;
            }
            if (!vc.requestPermissionToRead()) {
                this.pRec.rmmLogger.baseWarn("UnicastLink.ready: Failed to obtain permission to read, vc " + vc, null, moduleName);
                this.pRec.rmmLogger.baseWarn("UnicastLink.ready: Did not get permission to read! closing connection! vc " + vc, null, moduleName);
                this.closeVC(vc, this.deviceLink);
                return;
            }
            try {
                UnicastLinkReadCompleteCB ulrcb = new UnicastLinkReadCompleteCB();
                this.tcpReadInterface.read((long)(8 - position), (TCPReadCompletedCallback)ulrcb, true, 1000);
                int rounds = 15;
                while (rounds-- > 0 && ulrcb.status == 0) {
                    Thread.sleep(100L);
                }
                if (wsbb.position() < 8 || ulrcb.status == -1) {
                    this.pRec.rmmLogger.baseWarn("Less than 8 bytes failed to check signature. Ststus " + ulrcb.status, null, moduleName);
                    this.closeVC(vc, this.deviceLink);
                    return;
                }
                this.pRec.rmmLogger.baseInfo("Completed reading first 8 bytes from vc " + vc + ", pos " + position, moduleName);
            }
            catch (Exception ex1) {
                this.pRec.rmmLogger.baseWarn("Exception on read, failed to check signature", ex1, moduleName);
                this.closeVC(vc, this.deviceLink);
                return;
            }
        }
        wsbb.flip();
        int signature = wsbb.getInt();
        if (signature != 1562696995) {
            this.pRec.rmmLogger.baseWarn("ready called, Error in signature " + signature + " (" + 1562696995 + ")", null, moduleName);
            this.closeVC(vc, this.deviceLink);
            return;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("ready called, signature is " + signature + " match RMM signature (" + 1562696995 + ")", moduleName);
        }
        this.sourcePort = wsbb.getInt();
        if (this.sourcePort < 0 || this.sourcePort > 65536) {
            this.pRec.rmmLogger.baseError("ready called, invalid remotePort value " + this.sourcePort, null, moduleName);
            this.closeVC(vc, this.deviceLink);
            return;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("ready called, remotePort is " + this.sourcePort, moduleName);
        }
        this.unicastConnection = new UnicastConnection(this.sourceAddress, this.remoteLocalPort, this.localPort, this.sourcePort, vc, this.tcpInterface, false);
        this.rccb = new ReadCompleteCB(this);
        if (this.rccb.sdh.byteBuffer == null) {
            this.pRec.rmmLogger.baseError("ready called, Error rccb.sdh.byteBuffer is null", null, moduleName);
            this.closeVC(vc, this.deviceLink);
            return;
        }
        this.rccb.sdh.byteBuffer.put(wsbb);
        this.tcpReadInterface.setBuffer(this.rccb.sdh.byteBuffer);
        wsbb.release();
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Calling complete(read(.. )) in UnicastLink.ready; ntotal " + this.rccb.sdh.byteBuffer.position() + ";  ucon " + this.unicastConnection.toString() + " vc " + vc, moduleName);
        }
        if (!vc.requestPermissionToRead()) {
            this.pRec.rmmLogger.baseWarn("UnicastLink.ready - Failed to obtain permission to read, vc " + vc, null, moduleName);
            this.closeVC(vc, this.deviceLink);
            this.destroy(new IOException("UnicastLink.ready - Failed to obtain read permission"));
            return;
        }
        this.rccb.complete(vc, this.tcpReadInterface);
    }

    public void destroy(Exception e2) {
        block6: {
            try {
                if (this.destroyed) break block6;
                this.destroyed = true;
                this.isClosed = true;
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("Destroying Inbound UnicastLink sourceAddress " + this.sourceAddress + ":" + this.sourcePort + " (remoteLocalPort " + this.remoteLocalPort + ")" + " , exception " + e2, moduleName);
                }
                if (this.rccb != null) {
                    this.rccb.sdh.releaseBuffer();
                }
                try {
                    super.destroy(e2);
                }
                catch (Exception ex) {
                    this.pRec.rmmLogger.baseError("Exception in UnicastLink.super.destroy", ex, moduleName);
                }
                this.cleanUp();
            }
            catch (Exception exp) {
                this.pRec.rmmLogger.baseError("Exception in UnicastLink.destroy", exp, moduleName);
            }
        }
    }

    void cleanUp() {
        this.tcpInterface = null;
        this.myVC = null;
        this.tcpReadInterface = null;
        this.tcpWriteInterface = null;
    }

    private boolean closeVC(VirtualConnection vc, ConnectionLink tcpLink) {
        if (vc == null || tcpLink == null) {
            return false;
        }
        try {
            boolean permission = vc.requestPermissionToClose(1000L);
            if (permission) {
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("UnicastLink.closeVC: closing connection permission " + permission + ", vc " + vc, moduleName);
                }
                tcpLink.close(vc, new Exception("unable to set UnicastLink"));
            } else {
                this.pRec.rmmLogger.maxInfo("UnicastLink.closeVC: did not get permission to close vc,  permission " + permission + ", vc " + vc, moduleName);
            }
        }
        catch (Exception ex) {
            this.pRec.rmmLogger.baseWarn("CF Exception when trying to close UnicastLink", ex, moduleName);
            return false;
        }
        return true;
    }

    public class UnicastLinkReadCompleteCB
    implements TCPReadCompletedCallback {
        volatile int status = 0;
        private WsByteBuffer bb = null;

        public void complete(VirtualConnection vc, TCPReadRequestContext tcpRRC) {
            if (this.status == -1) {
                return;
            }
            if (vc != null) {
                vc.setReadStateToDone();
            }
            if (tcpRRC != null) {
                this.bb = tcpRRC.getBuffer();
            }
            if (this.bb == null) {
                UnicastLink.this.pRec.rmmLogger.baseError("ready.UnicastLinkReadCompleteCB called with null buffer", null, UnicastLink.moduleName);
                this.status = -1;
                return;
            }
            int position = this.bb.position();
            if (position >= 8) {
                this.status = 1;
                return;
            }
            this.status = -1;
        }

        public void error(VirtualConnection vc, TCPReadRequestContext arg1, IOException arg2) {
            this.status = -1;
            if (vc != null) {
                vc.setReadStateToDone();
            }
        }
    }
}

