/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.tchan.transmitter.P2PConnectionT;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;

public class AsyncConnectCB
implements ConnectionReadyCallback,
TCPWriteCompletedCallback {
    static final String moduleName = "PTL_TCHAN_T";
    static final int expireTimeout = 180000;
    PTransmitter pTrans;
    UnicastConnection unicastConnection;
    OutboundVirtualConnection outboundVirtualCon;
    InetSocketAddress remote;
    CreateConnectionListener conListener;
    StreamT stream;
    long stream_id;
    long timeout;
    long create_time;
    long expire_time;
    Object accbLock;
    volatile int writeCBStatus = 0;
    volatile int beforeDestroy;
    volatile boolean destroyedFromReady;

    public AsyncConnectCB(PTransmitter ptr, UnicastConnection ucon, InetSocketAddress remoteDest, CreateConnectionListener listener, StreamT streamT, long to) {
        this.pTrans = ptr;
        this.unicastConnection = ucon;
        this.outboundVirtualCon = (OutboundVirtualConnection)ucon.vc;
        this.remote = remoteDest;
        this.conListener = listener;
        this.stream = streamT;
        this.stream_id = streamT.longId;
        this.beforeDestroy = 0;
        this.destroyedFromReady = false;
        this.accbLock = new Object();
        this.create_time = Clock.getTime();
        this.timeout = to;
        this.expire_time = this.create_time + this.timeout + 180000L;
    }

    private void cleanUp() {
        this.destroyedFromReady = true;
        this.pTrans = null;
        this.outboundVirtualCon = null;
        this.remote = null;
        this.conListener = null;
        this.stream = null;
        this.unicastConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Exception ex) {
        block10: {
            try {
                Object object = this.accbLock;
                synchronized (object) {
                    if (this.beforeDestroy != 0) {
                        this.pTrans.rmmLogger.baseWarn("AsyncConnectCB.destroy() called more than once! " + this.unicastConnection + ", exp " + ex, null, moduleName);
                        return;
                    }
                    this.beforeDestroy = 1;
                }
                long dtime = Clock.getTime() - this.create_time;
                if (dtime > 8L * this.timeout) {
                    Exception e2 = new Exception("AsyncConnectCB.destroy(): Channel Framework Problem! Connection establish timeout exeeded " + dtime + ", connection: " + this.unicastConnection);
                    this.pTrans.rmmLogger.baseLog(421, new Object[]{"" + this.remote}, e2, moduleName);
                }
                this.pTrans.rmmLogger.baseInfo("Failed to Establish a new TCP connection to " + Sutils.printIsa(this.remote) + ", stream " + this.stream_id + ", dtime " + dtime + ", exception: " + ex, moduleName);
                boolean res = this.conListener.closeTopic();
                this.conListener.onFailure();
                if (!res) {
                    this.pTrans.rmmLogger.baseError("Failed to close stream after trying to connect to " + this.remote, null, moduleName);
                }
                if (this.unicastConnection != null) {
                    this.unicastConnection.closeConnection(0);
                }
                this.cleanUp();
            }
            catch (Exception exp) {
                if (this.pTrans != null) {
                    this.pTrans.rmmLogger.baseError("Exception in AsyncConnectCB.destroy connection to" + this.remote + ", conListener " + this.conListener, exp, moduleName);
                }
                if (this.conListener == null) break block10;
                this.conListener.onFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready(VirtualConnection arg0) {
        try {
            WsByteBuffer signature_bb;
            Object object = this.accbLock;
            synchronized (object) {
                if (this.beforeDestroy != 0) {
                    this.pTrans.rmmLogger.baseWarn("AsyncConnectCB.ready() called more than once! " + this.unicastConnection, null, moduleName);
                    if (this.beforeDestroy == 1) {
                        this.closeVC();
                    }
                    return;
                }
                this.beforeDestroy = 2;
            }
            if (this.unicastConnection == null || this.stream == null) {
                this.pTrans.rmmLogger.baseError("AsyncConnectCB.ready: invalid parameters unicastConnection, stream " + Sutils.printIsa(this.remote) + "stream " + this.stream, null, moduleName);
                this.destroyFromReady();
                return;
            }
            this.unicastConnection.remotePort = this.unicastConnection.tCPConnectionContext.getRemotePort();
            this.unicastConnection.localPort = this.unicastConnection.tCPConnectionContext.getLocalPort();
            long dtime = Clock.getTime() - this.create_time;
            if (dtime > 8L * this.timeout) {
                Exception e2 = new Exception("AsyncConnectCB.ready(): Channel Framework Problem! Excessive connection establish time " + dtime + ", connection: " + this.unicastConnection);
                this.pTrans.rmmLogger.baseLog(421, new Object[]{"" + this.remote}, e2, moduleName);
            }
            if ((signature_bb = this.pTrans.getWsByteBuffer(8)) == null) {
                this.pTrans.rmmLogger.baseError("AsyncConnectCB.ready failed to allocate signature_bb", null, moduleName);
                this.destroyFromReady();
                return;
            }
            signature_bb.putInt(1562696995);
            if (this.pTrans.myPReceiver != null) {
                signature_bb.putInt(this.pTrans.myPReceiver.getServerSocketPort());
            } else {
                signature_bb.putInt(0);
            }
            signature_bb.flip();
            TCPConnectionContext tcc = this.unicastConnection.tCPConnectionContext;
            TCPWriteRequestContext tcpWRC = tcc.getWriteInterface();
            VirtualConnection vc = null;
            tcpWRC.setBuffer(signature_bb);
            if (!this.outboundVirtualCon.requestPermissionToWrite()) {
                this.pTrans.rmmLogger.baseError("AsyncConnectCB.ready failed to obtain permission to write signature_bb", null, moduleName);
                this.destroyFromReady();
                return;
            }
            try {
                vc = tcpWRC.write(8L, (TCPWriteCompletedCallback)this, false, 2000);
                if (vc == null) {
                    int rounds = 25;
                    while (rounds-- > 0 && this.writeCBStatus == 0) {
                        Thread.sleep(100L);
                    }
                } else {
                    this.writeCBStatus = 1;
                    vc.setWriteStateToDone();
                }
            }
            catch (Exception e1) {
                this.outboundVirtualCon.setWriteStateToDone();
                this.writeCBStatus = -1;
                this.pTrans.rmmLogger.baseWarn("Failed to write RMM signature when creating OutboundVirtualConnection", e1, moduleName);
                this.destroyFromReady();
                return;
            }
            if (this.writeCBStatus != 1) {
                this.pTrans.rmmLogger.baseError("Failed to write RMM signature when creating OutboundVirtualConnection; writeCBStatus " + this.writeCBStatus + " stream " + this.stream_id + " ucon " + this.unicastConnection, null, moduleName);
                this.writeCBStatus = -1;
                this.destroyFromReady();
                signature_bb.release();
                return;
            }
            if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                this.pTrans.rmmLogger.maxInfo("Wrote RMM signature when creating OutboundVirtualConnection, stream " + this.stream_id + ", ucon " + this.unicastConnection, moduleName);
            }
            signature_bb.release();
            if (this.pTrans.myPReceiver != null) {
                if (!this.outboundVirtualCon.requestPermissionToRead()) {
                    this.pTrans.rmmLogger.baseError("AsyncConnectCB.ready failed to obtain permission to read before register new connection", null, moduleName);
                    this.destroyFromReady();
                    return;
                }
                try {
                    this.pTrans.myPReceiver.registerNewConnection(this.unicastConnection, this.unicastConnection.inetAddress, this.unicastConnection.remoteServerPort);
                }
                catch (Exception ex) {
                    this.pTrans.rmmLogger.baseError("Failed to register new TCP connection with PacketReceiver " + Sutils.printIsa(this.unicastConnection.inetSocketAddress) + " stream" + this.stream_id, ex, moduleName);
                    this.destroyFromReady();
                    return;
                }
            }
            if (this.stream != null && !this.stream.connectionClosed && this.conListener != null) {
                this.stream.virtualConn = this.unicastConnection.vc;
                this.stream.unicastConnection = this.unicastConnection;
                this.conListener.onSuccess();
                if (!this.stream.isActive) {
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("stream closed from onSuccess " + this.stream.longId + ", ucon " + this.unicastConnection, moduleName);
                    }
                    this.pTrans.checkAndRemoveConnection(this.unicastConnection, false);
                    this.cleanUp();
                    return;
                }
                this.stream.destination = tcpWRC;
                this.stream.openTime = Clock.getTime();
                this.pTrans.sendSnp = 5;
                this.pTrans.streamFireout.wakeUp(this.stream);
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("Wrote destination for stream after establishing async TChannel connection " + this.stream_id, moduleName);
                }
            } else {
                this.pTrans.rmmLogger.baseError("AsyncConnect error in ready method " + Sutils.printIsa(this.unicastConnection.inetSocketAddress) + ", " + this.stream + " " + this.conListener, null, moduleName);
                this.destroyFromReady();
                return;
            }
            this.pTrans.rmmLogger.baseInfo("Established (async) a new TChannel connection to " + Sutils.printIsa(this.remote) + " ucon " + this.unicastConnection.toString() + ", stream " + this.stream_id, moduleName);
            this.pTrans.gdAdd(this.unicastConnection);
        }
        catch (Throwable ex) {
            if (this.pTrans != null) {
                this.pTrans.rmmLogger.baseError("AsyncConnect.ready exception", ex, moduleName);
            }
            if (this.conListener != null) {
                this.conListener.onFailure();
            }
            this.closeVC();
        }
        this.cleanUp();
    }

    boolean closeVC() {
        try {
            if (this.outboundVirtualCon != null) {
                if (this.outboundVirtualCon.requestPermissionToClose(10L)) {
                    this.outboundVirtualCon.close(new Exception("closing outBoundVirtualConnection from AsyncConnectCB"));
                    this.pTrans.rmmLogger.baseInfo("Closed OutboundVirtualConnection from closeVC, vc " + this.outboundVirtualCon, moduleName);
                } else {
                    P2PConnectionT con = new P2PConnectionT(this.remote, null, (VirtualConnection)this.outboundVirtualCon, null, 10000);
                    this.pTrans.rmmLogger.baseWarn("Did not get permission to close OutboundVirtualConnection from closeVC, vc " + this.outboundVirtualCon, null, moduleName);
                    if (this.pTrans.closedVC.put(this.outboundVirtualCon, con) != null) {
                        this.pTrans.rmmLogger.baseWarn("AsyncCB.closeVC: OutboundVirtualConnection already exists in closedVC, vc " + this.outboundVirtualCon, null, moduleName);
                    }
                }
            }
        }
        catch (Throwable ex) {
            if (this.pTrans != null) {
                this.pTrans.rmmLogger.baseError("AsyncConnectCB.ready: Failed to destroy VirtualConnection (p2pcon=null)" + Sutils.printIsa(this.remote), ex, moduleName);
            }
            return false;
        }
        return true;
    }

    private void destroyFromReady() {
        block6: {
            if (!this.destroyedFromReady) {
                this.destroyedFromReady = true;
                try {
                    this.pTrans.rmmLogger.baseInfo("destroyFromReady called from AsyncConnectCB.ready after trying to connect to " + Sutils.printIsa(this.remote), moduleName);
                    boolean res = this.conListener.closeTopic();
                    this.conListener.onFailure();
                    if (!res) {
                        this.pTrans.rmmLogger.baseError("Failed to close stream from AsyncConnectCB.ready after trying to connect to " + Sutils.printIsa(this.remote), null, moduleName);
                    }
                    this.closeVC();
                    if (this.unicastConnection != null) {
                        this.unicastConnection.closeConnection(0);
                    }
                    this.cleanUp();
                }
                catch (Exception exp) {
                    if (this.pTrans != null) {
                        this.pTrans.rmmLogger.baseError("Exception in AsyncConnectCB.destroyedFromReady connection to" + Sutils.printIsa(this.remote) + ", conListener " + this.conListener, exp, moduleName);
                    }
                    if (this.conListener == null) break block6;
                    this.conListener.onFailure();
                }
            }
        }
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext arg1) {
        if (vc != null) {
            vc.setWriteStateToDone();
        }
        if (this.writeCBStatus == -1) {
            return;
        }
        this.writeCBStatus = 1;
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext arg1, IOException e1) {
        try {
            this.pTrans.rmmLogger.baseWarn("Failed to write RMM signature when creating OutboundVirtualConnection", e1, moduleName);
            this.writeCBStatus = -1;
            if (vc != null) {
                vc.setWriteStateToDone();
            }
        }
        catch (Exception ex) {
            this.writeCBStatus = -1;
        }
    }
}

