/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjLifoQueue;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;
import java.net.InetSocketAddress;
import java.util.LinkedList;

class CheckConnectionPending
extends Thread {
    static final String moduleName = "PTL_TCHAN_T";
    private PTransmitter pTrans;
    volatile int nRot;
    volatile int nPos;
    private boolean goOn;
    private int exc_count;
    private LinkedList connQ = new LinkedList();
    private ObjLifoQueue reqPool = new ObjLifoQueue(256, false);

    CheckConnectionPending(PTransmitter ptr) {
        this.pTrans = ptr;
        this.goOn = true;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean requestConnectionNonBlocking(InetSocketAddress remote, CreateConnectionListener listener, int timeout, StreamT stream) {
        LinkedList linkedList = this.connQ;
        synchronized (linkedList) {
            block5: {
                if (!this.pTrans.chfwStopped) break block5;
                this.pTrans.rmmLogger.baseWarn("requestConnectionNonBlocking: chfwStopped!!! cannot complete request for stream " + stream + ", dest " + remote, null, moduleName);
                return false;
            }
            RequestInfo req = (RequestInfo)this.reqPool.get();
            if (req == null) {
                req = new RequestInfo();
            }
            req.setValues(remote, listener, timeout, stream);
            this.connQ.addLast(req);
            this.connQ.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"CheckConnectionPending"}, null, moduleName);
        RequestInfo req = null;
        while (this.goOn) {
            ++this.nRot;
            try {
                this.nPos = 0;
                LinkedList linkedList = this.connQ;
                synchronized (linkedList) {
                    if (req != null) {
                        this.reqPool.put(req);
                    }
                    while (this.goOn && this.connQ.isEmpty()) {
                        this.connQ.wait();
                    }
                    if (!this.goOn) {
                        break;
                    }
                    req = (RequestInfo)this.connQ.removeFirst();
                }
                this.nPos = 1;
                if (req == null) continue;
                long dtime = Clock.getTime() - req.create_time;
                if (dtime > (long)req.timeout) {
                    this.pTrans.rmmLogger.baseWarn("CheckConnectionPending: delay calling CHFW connectAsync " + dtime + " connecting to " + Sutils.printIsa(req.remote) + " waiting: " + this.getWaiting(), null, moduleName);
                }
                if (this.pTrans.chfwStopped) {
                    this.pTrans.rmmLogger.baseWarn("CheckConnectionPending: detected chfwStopped when processing request for stream " + req.stream + ", dest " + req.remote, null, moduleName);
                    continue;
                }
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("CheckConnectionPending: calling establishConnectionNonBlocking for stream " + req.stream, moduleName);
                }
                long stime = System.currentTimeMillis();
                if (this.pTrans.establishConnectionNonBlocking(req.remote, req.listener, req.timeout, req.stream) == null) {
                    if (req.listener != null) {
                        req.listener.closeTopic();
                        req.listener.onFailure();
                    }
                    this.pTrans.rmmLogger.baseWarn("CheckConnectionPending: delivered onFailure after establishConnectionNonBlocking returned null, stream " + req.stream + ", dest " + req.remote, null, moduleName);
                }
                if ((dtime = System.currentTimeMillis() - stime) <= 5000L) continue;
                this.pTrans.rmmLogger.baseWarn("CheckConnectionPending: CHFW connectAsync excessive delay of " + dtime + " connecting to " + Sutils.printIsa(req.remote), null, moduleName);
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"CheckConnectionPending"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("CheckConnectionPending: Exception in thread loop", ex, moduleName);
                ++this.exc_count;
                if (this.exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop CheckConnectionPending", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"CheckConnectionPending"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"CheckConnectionPending"}, null, moduleName);
    }

    public int getWaiting() {
        return this.connQ.size();
    }

    class RequestInfo {
        InetSocketAddress remote;
        CreateConnectionListener listener;
        int timeout;
        StreamT stream;
        long create_time;

        RequestInfo() {
        }

        void setValues(InetSocketAddress remote, CreateConnectionListener listener, int timeout, StreamT stream) {
            this.remote = remote;
            this.listener = listener;
            this.timeout = timeout;
            this.stream = stream;
            this.create_time = Clock.getTime();
        }
    }
}

