/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

public class Config {
    static final String moduleName = "PTL_TCHAN_T";
    RmmLogger rmmLogger;
    public static final int RMM_CF_SIGNATURE = 1562696995;
    public static final byte PROTOCOL_VERSION = 100;
    public static final int MAX_EXC_COUNT = 0;
    public static final int EXC_RESET_INTERVAL = 500;
    public static final int MAX_CLOSE_WAIT_TIME = 120000;
    public static final int DELAY_NOT_PRESENT_EVENT = 120000;
    public static final int SDP_MIN_HEADER_SIZE = 14;
    public static final byte STREAM_DATA = 1;
    public static final byte STREAM_CP = 2;
    public static final byte STREAM_REPORT = 4;
    public static final byte CONNECTION_HB = 5;
    public static final byte CONNECTION_SL = 6;
    public static final int NO_RATE_LIMIT = 0;
    public static final int STATIC_RATE_LIMIT = 1;
    int cpTimeout;
    int heartbeatInterval;
    int limitRate;
    int transmissionRateKbps;
    int socketBufferSize = 0;
    int maxPendingSize;
    int closeWaitTime = 120000;
    boolean bindAll = false;
    boolean collectStats;
    int statsPeriod = 2000;
    int partialRate = 0;
    boolean tcpKeepAlive = false;
    boolean perConnectionHB = true;
    int closeWaitForPermission = 10;
    int closeWaitForPermissionTimeOut = 10000;
    boolean isOK;

    protected Config() {
    }

    Config(RmmLogger rlog, Properties props) {
        this.rmmLogger = rlog;
        this.isOK = true;
        String tmp = props.getProperty("LimitTransRate");
        if (tmp == null) {
            this.rmmLogger.baseLog(402, new Object[]{"LimitTransRate"}, null, moduleName);
            this.limitRate = 0;
        } else if (tmp.equalsIgnoreCase("static")) {
            this.limitRate = 1;
        } else if (tmp.equalsIgnoreCase("disabled") || tmp.equalsIgnoreCase("dynamic")) {
            this.limitRate = 0;
        } else {
            this.limitRate = 0;
            this.rmmLogger.baseBadParam("LimitTransRate", tmp, null, moduleName);
            this.isOK = false;
            return;
        }
        if (this.limitRate != 0) {
            tmp = props.getProperty("TransRateLimitKbps");
            if (tmp == null) {
                this.rmmLogger.baseLog(402, new Object[]{"TransRateLimitKbps"}, null, moduleName);
                this.isOK = false;
                return;
            }
            try {
                this.transmissionRateKbps = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("TransRateLimitKbps", tmp, e2, moduleName);
                this.isOK = false;
                return;
            }
            if (this.transmissionRateKbps <= 10) {
                this.rmmLogger.baseBadParam("TransRateLimitKbps", "" + this.transmissionRateKbps, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("HeartbeatTimeoutSec")) != null) {
            try {
                this.cpTimeout = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutSec", tmp, e3, moduleName);
                this.isOK = false;
                return;
            }
            if (this.cpTimeout < 1) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutSec", "" + this.cpTimeout, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("HeartbeatTimeoutMillis")) != null) {
            try {
                this.cpTimeout = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMillis", tmp, e4, moduleName);
                this.isOK = false;
                return;
            }
            if (this.cpTimeout < 1) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMills", "" + this.cpTimeout, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.cpTimeout == 0) {
            this.rmmLogger.baseLog(402, new Object[]{"HeartbeatTimeout"}, null, moduleName);
            this.isOK = false;
            return;
        }
        tmp = props.getProperty("HeartbeatIntervalMillis");
        if (tmp != null) {
            try {
                this.heartbeatInterval = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("HeartbeatIntervalMillis", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.heartbeatInterval < 1) {
                this.rmmLogger.baseBadParam("HeartbeatIntervalMillis", "" + this.heartbeatInterval, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.heartbeatInterval < 1) {
            this.rmmLogger.baseInfo("Using default HeartbeatIntervalMillis: 1000", moduleName);
            this.heartbeatInterval = 1000;
        }
        if ((tmp = props.getProperty("CollectStats")) != null) {
            this.collectStats = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("StatisticsPeriodSec")) != null) {
            try {
                this.statsPeriod = 1000 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e6) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", tmp, e6, moduleName);
                this.isOK = false;
                return;
            }
            if (this.statsPeriod <= 0) {
                this.rmmLogger.baseBadParam("StatisticsPeriodSec", "" + this.statsPeriod, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = props.getProperty("MaximalPendingQueueKBytes")) == null) {
            this.maxPendingSize = 0x400000;
        } else {
            try {
                this.maxPendingSize = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e7) {
                this.rmmLogger.baseBadParam("MaximalPendingQueueKBytes", tmp, e7, moduleName);
                this.isOK = false;
                return;
            }
            if (this.maxPendingSize < 65536) {
                this.rmmLogger.baseBadParam("MaximalPendingQueueKBytes", "" + this.maxPendingSize, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        tmp = props.getProperty("TcpKeepAlive");
        if (tmp != null) {
            if (!tmp.equalsIgnoreCase("true") && !tmp.equalsIgnoreCase("false")) {
                this.rmmLogger.baseBadParam("TcpKeepAlive", tmp, null, moduleName);
                this.isOK = false;
                return;
            }
            this.tcpKeepAlive = Boolean.valueOf(tmp);
        } else {
            this.tcpKeepAlive = false;
        }
        if (this.tcpKeepAlive) {
            this.rmmLogger.baseWarn("Using TCP KeepAlive mechanism, RMM heartbeats will not be sent!", null, moduleName);
            this.cpTimeout = -1;
        }
        if ((tmp = props.getProperty("BindAllInterfaces")) != null) {
            this.bindAll = Boolean.valueOf(tmp);
        }
        if ((tmp = props.getProperty("MaxPartialPacketsPerSec")) == null) {
            this.partialRate = 0;
        } else {
            try {
                this.partialRate = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e8) {
                this.rmmLogger.baseBadParam("MaxPartialPacketsPerSec", tmp, e8, moduleName);
                this.isOK = false;
                return;
            }
            if (this.partialRate < 0 || this.partialRate > 16384) {
                this.rmmLogger.baseBadParam("MaxPartialPacketsPerSec", "" + this.partialRate, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if (this.closeWaitTime > this.cpTimeout) {
            this.closeWaitTime = this.cpTimeout;
        }
    }
}

