/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.PacManOut;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.tchan.transmitter.AsyncConnectCB;
import com.ibm.rmm.ptl.tchan.transmitter.CheckConnectionPending;
import com.ibm.rmm.ptl.tchan.transmitter.Config;
import com.ibm.rmm.ptl.tchan.transmitter.ConnectRequestContext;
import com.ibm.rmm.ptl.tchan.transmitter.P2PConnectionT;
import com.ibm.rmm.ptl.tchan.transmitter.PacketFireout;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;
import com.ibm.rmm.ptl.tchan.transmitter.TEvent;
import com.ibm.rmm.ptl.tchan.transmitter.TimingThread;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PTransmitter
implements PTransmitterIf {
    static final String moduleName = "PTL_TCHAN_T";
    PReceiverIf myPReceiver;
    RmmLogger rmmLogger;
    RmmAddress rmmAddress;
    TaskManager taskMan;
    Config config;
    byte[] ipAddress;
    int maxWSbuffers;
    int curWSbuffers;
    Object pendingWaitMutex = new Object();
    boolean logError;
    int packetSize;
    int ptlHeaderSize;
    int tracingLevel;
    TokenBucket tokenBucket;
    int maxTrans;
    int nPending;
    int nPendingMax;
    InetAddress localInterf;
    Object streamListLock;
    private int nStreamsMax;
    StreamT[] streamList;
    int nStreams;
    int sendSnp;
    int snpCount = 0;
    int ccpCount = 0;
    Vector pendingClosedStreams;
    Vector rateLimitStreams;
    Vector pendingAsyncConnectCB;
    CheckAsyncConnectCB cacTask;
    RemoveClosedStreams rcsTask;
    CheckLostMsg clmTask;
    RemoveClosedConnections rccTask;
    CheckLimitedStreams clsTask;
    SendControlPacket scpTask;
    CheckConnectionPending checkConnectionPending;
    boolean isRunning;
    private short idSeed;
    int nackPort;
    PacketFireout streamFireout;
    TimingThread timingThrd;
    ArrayList globalDestinations;
    boolean gdUpdated;
    Object globalLock;
    Hashtable receiverReportedConnection;
    VirtualConnectionFactory tcpVirConFactory = null;
    Hashtable closedVC;
    public volatile boolean chfwStopped;
    static boolean cfInit = false;
    static /* synthetic */ Class class$0;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, short max_packet_size, InetAddress interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.packetSize = max_packet_size;
            this.ptlHeaderSize = 24;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.nPendingMax = this.config.maxPendingSize / this.packetSize;
            this.maxWSbuffers = (int)(1.1 * (double)this.nPendingMax);
            this.curWSbuffers = 0;
            this.maxTrans = 5;
            this.idSeed = (short)(System.currentTimeMillis() / 1000L);
            this.rmmLogger.baseInfo("PTransmitter idSeed set to " + this.idSeed, moduleName);
            if (this.config.limitRate != 0) {
                this.tokenBucket = new TokenBucket(this.config.transmissionRateKbps, this.rmmLogger, this.taskMan);
            }
            this.localInterf = interf;
            this.nackPort = this.rmmAddress.getPort();
            byte[] addr = this.rmmAddress.getInetAddress().getAddress();
            if (addr.length == 4) {
                this.ipAddress = addr;
                this.rmmLogger.baseInfo("Building GSI I - use IPV4 address", moduleName);
            } else {
                String host_name = this.rmmAddress.getInetAddress().getCanonicalHostName();
                int host_name_hash = host_name.hashCode();
                this.ipAddress = new byte[4];
                Sutils.insertInt(this.ipAddress, 0, host_name_hash);
                this.rmmLogger.baseInfo("Building GSI I - Address length - " + addr.length + ". Not IPv4. Using hash of the Canonical host name " + host_name, moduleName);
            }
            this.rmmLogger.baseInfo("GSI I: " + this.ipAddress[0] + ":" + this.ipAddress[1] + ":" + this.ipAddress[2] + ":" + this.ipAddress[3], moduleName);
            this.streamListLock = new Object();
            this.nStreamsMax = 100;
            this.streamList = new StreamT[this.nStreamsMax];
            this.nStreams = 0;
            this.globalDestinations = new ArrayList();
            this.gdUpdated = true;
            this.globalLock = new Object();
            this.pendingClosedStreams = new Vector();
            this.rateLimitStreams = new Vector();
            this.pendingAsyncConnectCB = new Vector();
            this.closedVC = new Hashtable();
            this.streamFireout = new PacketFireout(this);
            this.streamFireout.setName("Ptl_Tchan_Fireout");
            this.streamFireout.setPriority(10);
            this.timingThrd = new TimingThread(this);
            this.timingThrd.setName("Ptl_Tchan_TimingThread");
            this.timingThrd.setPriority(10);
            this.checkConnectionPending = new CheckConnectionPending(this);
            this.checkConnectionPending.setName("Ptl_Tchan_checkConnectionPending");
            if (config_map != null) {
                this.tcpVirConFactory = (VirtualConnectionFactory)config_map.get("TcpChannelVCF");
            } else {
                this.rmmLogger.baseWarn("Configuration map is null", null, moduleName);
            }
            if (this.tcpVirConFactory == null) {
                this.rmmLogger.baseWarn("Connection Factory is null. Config map: \n" + config_map + "\nCreating tester CF, Channel", null, moduleName);
                boolean succ = this.initTesterCF();
                if (!succ) {
                    return false;
                }
            } else {
                this.rmmLogger.baseInfo("Connection Factory is provided", moduleName);
            }
            this.start();
            this.cacTask = new CheckAsyncConnectCB(60000L);
            this.taskMan.addTask(this.cacTask);
            this.rcsTask = new RemoveClosedStreams(1000L);
            this.taskMan.addTask(this.rcsTask);
            this.clmTask = new CheckLostMsg(1000L);
            this.taskMan.addTask(this.clmTask);
            this.clsTask = new CheckLimitedStreams(50L);
            this.taskMan.addTask(this.clsTask);
            this.rccTask = new RemoveClosedConnections(1000L);
            this.taskMan.addTask(this.rccTask);
            this.scpTask = new SendControlPacket(this.config.heartbeatInterval < 30000 ? this.config.heartbeatInterval : 30000);
            this.taskMan.addTask(this.scpTask);
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PTransmitter", e2, moduleName);
            return false;
        }
        return true;
    }

    private synchronized boolean initTesterCF() {
        ChannelFrameworkImpl channelFramework = new ChannelFrameworkImpl();
        String outboundTcpChainName = "RUM-TCP-CHAIN";
        String TCP_OUT = "RUM-TCP";
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.ws.tcp.channel.impl.TCPChannelFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            channelFramework.addChannel(TCP_OUT, (Class)clazz, null, FlowType.OUTBOUND.getOrdinal());
            String[] tcp = new String[]{TCP_OUT};
            channelFramework.addChain(outboundTcpChainName, FlowType.OUTBOUND, tcp);
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to create Tester ChannelFramework or ChannelChain", e2, moduleName);
            return false;
        }
        try {
            this.tcpVirConFactory = channelFramework.getOutboundVCFactory(outboundTcpChainName);
        }
        catch (ChannelException e3) {
            this.rmmLogger.baseError("Failed to get Tester VCFactory " + outboundTcpChainName, e3, moduleName);
            return false;
        }
        catch (ChainException e4) {
            this.rmmLogger.baseError("Failed to get Tester VCFactory " + outboundTcpChainName, e4, moduleName);
            return false;
        }
        return true;
    }

    public synchronized StreamTIf createStreamTransmitter(boolean reliable, InetAddress address, int port2, byte[] tag, boolean lj_enabled) {
        short sid = this.idSeed;
        while ((sid = (short)(sid + 1)) != this.idSeed) {
            if (this.getStream(sid) != null) continue;
        }
        if (sid == this.idSeed) {
            this.rmmLogger.baseError("Could not assign a unique stream id for a new stream", null, moduleName);
            return null;
        }
        this.idSeed = sid;
        StreamT str = new StreamT(this);
        if (!str.init(tag, sid, reliable, address, lj_enabled)) {
            return null;
        }
        this.addStream(str);
        return str;
    }

    UnicastConnection establishConnection(InetSocketAddress remote) {
        TCPWriteRequestContext tcpWRC = null;
        OutboundVirtualConnection ova = null;
        UnicastConnection ucon = null;
        if (this.chfwStopped) {
            return null;
        }
        try {
            ova = (OutboundVirtualConnection)this.tcpVirConFactory.createConnection();
        }
        catch (ChannelException e2) {
            this.rmmLogger.baseError("CreateConnection Exception", e2, moduleName);
        }
        catch (ChainException e3) {
            this.rmmLogger.baseError("CreateConnection Exception", e3, moduleName);
        }
        if (ova == null) {
            this.rmmLogger.baseError("Failed to create OutboundVirtualConnection", null, moduleName);
            return null;
        }
        InetSocketAddress isa = null;
        if (this.localInterf != null && !this.config.bindAll) {
            isa = new InetSocketAddress(this.localInterf, 0);
        }
        int timeout = 10000;
        ConnectRequestContext dest = new ConnectRequestContext(remote, isa, timeout);
        try {
            ova.connect((Object)dest);
        }
        catch (Exception ex) {
            this.rmmLogger.baseWarn("Failed to establish TCP connection to " + Sutils.printIsa(remote), null, moduleName);
            this.closeVC(ova, remote);
            return null;
        }
        try {
            long bw;
            TCPConnectionContext tcc = (TCPConnectionContext)ova.getChannelAccessor();
            if (tcc == null) {
                this.rmmLogger.baseWarn("Failed to obtain TCPConnectionContext when establishing TCP connection to " + Sutils.printIsa(remote), null, moduleName);
                this.closeVC(ova, remote);
                return null;
            }
            tcpWRC = tcc.getWriteInterface();
            WsByteBuffer signature_bb = this.getWsByteBuffer(8);
            if (signature_bb == null) {
                this.rmmLogger.baseError("Failed to allocate signatureByteBuffer when establishing TCP connection to " + Sutils.printIsa(remote), null, moduleName);
                this.closeVC(ova, remote);
                return null;
            }
            signature_bb.putInt(1562696995);
            if (this.myPReceiver != null) {
                signature_bb.putInt(this.myPReceiver.getServerSocketPort());
            } else {
                signature_bb.putInt(0);
            }
            signature_bb.flip();
            tcpWRC.setBuffer(signature_bb);
            try {
                bw = tcpWRC.write(8L, 1000);
            }
            catch (IOException e1) {
                this.rmmLogger.baseWarn("establishConnection: Failed to write RMM signature when creating OutboundVirtualConnection", e1, moduleName);
                signature_bb.release();
                this.closeVC(ova, remote);
                return null;
            }
            signature_bb.release();
            if (bw < 8L) {
                this.rmmLogger.baseError("establishConnection: Failed to write RMM signature when creating OutboundVirtualConnection; bytes written " + bw + " (should be >= 8)", null, moduleName);
                this.closeVC(ova, remote);
                return null;
            }
            if (this.rmmLogger.isMaxLogLevel()) {
                this.rmmLogger.maxInfo("establishConnection: Wrote RMM signature when creating OutboundVirtualConnection", moduleName);
            }
            ucon = new UnicastConnection(remote.getAddress(), tcc.getRemotePort(), tcc.getLocalPort(), remote.getPort(), (VirtualConnection)ova, tcc, true);
            this.gdAdd(ucon);
        }
        catch (Exception ex) {
            this.rmmLogger.baseError("establishConnection unexpected Exception", ex, moduleName);
            try {
                if (ova != null) {
                    if (!ova.requestPermissionToClose(50L)) {
                        P2PConnectionT con = new P2PConnectionT(remote, null, (VirtualConnection)ova, null, 10000);
                        this.rmmLogger.baseWarn("establishConnection: Did not get permission to close OutboundVirtualConnection from closeVC, vc " + ova, null, moduleName);
                        this.closedVC.put(ova, con);
                    } else {
                        this.closeVC(ova, remote);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        this.rmmLogger.baseInfo("Established (sync) a new TChannel connection to " + Sutils.printIsa(remote) + ". Local port: " + ucon.localPort + "ucon " + ucon.toString(), moduleName);
        return ucon;
    }

    UnicastConnection establishConnectionNonBlocking(InetSocketAddress remote, CreateConnectionListener listener, int timeout, StreamT stream) {
        TCPWriteRequestContext tcpWRC = null;
        OutboundVirtualConnection ova = null;
        ConnectRequestContext dest = null;
        AsyncConnectCB async_CB = null;
        UnicastConnection ucon = null;
        try {
            ova = (OutboundVirtualConnection)this.tcpVirConFactory.createConnection();
        }
        catch (ChannelException e2) {
            this.rmmLogger.baseError("CreateConnection Exception", e2, moduleName);
        }
        catch (ChainException e3) {
            this.rmmLogger.baseError("CreateConnection Exception", e3, moduleName);
        }
        if (ova == null) {
            this.rmmLogger.baseError("Failed to create OutboundVirtualConnection", null, moduleName);
            return null;
        }
        InetSocketAddress isa = null;
        if (this.localInterf != null && !this.config.bindAll) {
            isa = new InetSocketAddress(this.localInterf, 0);
        }
        try {
            TCPConnectionContext tcc = (TCPConnectionContext)ova.getChannelAccessor();
            if (tcc != null) {
                tcpWRC = tcc.getWriteInterface();
            }
            if (tcpWRC == null) {
                this.rmmLogger.baseError("establishConnectionNonBlocking Failed to get TCPConnectionContext", null, moduleName);
                return null;
            }
            ucon = new UnicastConnection(remote.getAddress(), 0, 0, remote.getPort(), (VirtualConnection)ova, tcc, true);
            dest = new ConnectRequestContext(remote, isa, timeout);
            async_CB = new AsyncConnectCB(this, ucon, remote, listener, stream, timeout);
        }
        catch (Exception exp) {
            this.rmmLogger.baseError("establishConnectionNonBlocking Exception before connect", exp, moduleName);
            return null;
        }
        try {
            ova.connectAsynch((Object)dest, (ConnectionReadyCallback)async_CB);
        }
        catch (Exception ex) {
            this.rmmLogger.baseError("Illegal state when establishing TCP connection to " + Sutils.printIsa(remote), null, moduleName);
            try {
                this.closeVC(ova, remote);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        this.pendingAsyncConnectCB.add(async_CB);
        return ucon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndRemoveConnection(UnicastConnection ucon, boolean check) {
        if (ucon == null || ucon.vc == null) {
            return;
        }
        VirtualConnection virtCon = ucon.vc;
        InetSocketAddress remote = ucon.inetSocketAddress;
        if (check) {
            Object object = this.globalLock;
            synchronized (object) {
                boolean needed = false;
                int i = this.nStreams - 1;
                while (i >= 0) {
                    StreamT str = this.streamList[i];
                    if (str != null && str.unicastConnection != null && str.unicastConnection.vc == virtCon) {
                        needed = true;
                        break;
                    }
                    --i;
                }
                if (!needed) {
                    this.gdRemove(ucon);
                }
                if (!needed && this.myPReceiver != null) {
                    needed = this.myPReceiver.checkOrRemoveConnection(virtCon, remote, true);
                }
                if (needed) {
                    return;
                }
                this.rmmLogger.baseInfo("Removing TChannel connection to " + Sutils.printIsa(remote) + ", ucon " + ucon, moduleName);
            }
        }
        ucon.closeConnection(0);
        if (virtCon != null) {
            try {
                if (virtCon instanceof OutboundVirtualConnection) {
                    if (virtCon.requestPermissionToClose((long)this.config.closeWaitForPermission)) {
                        OutboundVirtualConnection ovc = (OutboundVirtualConnection)virtCon;
                        ovc.close(null);
                        this.rmmLogger.baseInfo("checkAndRemoveConnection close OutboundVirtualConnection to " + Sutils.printIsa(remote), moduleName);
                    } else {
                        P2PConnectionT con = new P2PConnectionT(remote, null, virtCon, null, 10000);
                        this.rmmLogger.baseWarn("Did not get permission to close OutboundVirtualConnection from checkAndRemoveConnection, vc " + virtCon, null, moduleName);
                        if (this.closedVC.put(virtCon, con) != null) {
                            this.rmmLogger.baseWarn("checkAndRemoveConnection: OutboundVirtualConnection already exists in closedVC, vc " + virtCon, null, moduleName);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.rmmLogger.baseWarn("checkAndRemoveConnection exception on close OutboundVirtualConnection to " + Sutils.printIsa(remote), ex, moduleName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClosedConnection(VirtualConnection vc, TCPWriteRequestContext wrc) {
        int found = 0;
        if (wrc == null) {
            this.rmmLogger.baseWarn("removeClosedConnection: TCPWriteRequestContext param is null on entry!", null, moduleName);
            return;
        }
        Object object = this.globalLock;
        synchronized (object) {
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT str = this.streamList[i];
                if (str != null && !str.isClosed && str.destination != null && (str.destination.equals(wrc) || str.virtualConn.equals(vc))) {
                    str.connectionClosed = true;
                    str.destination = null;
                    this.sendSnp = 5;
                    str.cpRetries = 100;
                    ++found;
                    this.rmmLogger.baseInfo("removeClosedConnection: put CONNECTION_CLOSED event for stream " + str.longId, moduleName);
                    TEvent ev = new TEvent(3, 0L, 0, str.unicastConnection, str.longId, str.unicastConnection.inetAddress, str.unicastConnection.remoteServerPort);
                    str.eventListener.onEvent(ev);
                    if (str.unicastConnection != null) {
                        str.unicastConnection.isTxClosed = true;
                        if (this.rmmLogger.isMaxLogLevel()) {
                            this.rmmLogger.maxInfo("removeClosedConnection: set isTxClosed = true for " + str.unicastConnection.toString(), moduleName);
                        }
                        this.gdRemove(str.unicastConnection);
                    }
                }
                --i;
            }
        }
        this.rmmLogger.baseInfo("removeClosedConnection: found " + found + " streams to remove", moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            if (this.nStreams == this.nStreamsMax) {
                StreamT[] tmp = new StreamT[2 * this.nStreamsMax];
                int i = 0;
                while (i < this.nStreamsMax) {
                    tmp[i] = this.streamList[i];
                    ++i;
                }
                this.nStreamsMax *= 2;
                this.streamList = tmp;
            }
            this.streamList[this.nStreams] = stream;
            ++this.nStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nStreams) {
                if (this.streamList[i] == stream) break;
                ++i;
            }
            if (i == this.nStreams) {
                this.rmmLogger.baseWarn("Removing stream: not found!", null, moduleName);
                return;
            }
            --this.nStreams;
            this.streamList[i] = this.streamList[this.nStreams];
            this.streamList[this.nStreams] = null;
        }
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Removing stream from Transmitter list " + stream + ", Remaining " + this.nStreams, moduleName);
        }
    }

    public int bufferStatus() {
        return this.maxWSbuffers - this.curWSbuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getBuffer(StreamT stream, int size) {
        WsByteBuffer wsbb = null;
        Object object = this.pendingWaitMutex;
        synchronized (object) {
            while (this.curWSbuffers > 4 * this.maxWSbuffers / 5) {
                if (!stream.isActive) {
                    return null;
                }
                if (this.nStreams * stream.pendingPackets.qSize() <= this.maxWSbuffers) break;
                try {
                    this.pendingWaitMutex.wait(50L);
                }
                catch (InterruptedException ex) {
                    this.rmmLogger.baseLog(406, new Object[]{"Waiting on stream buffers."}, ex, moduleName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            wsbb = this.getWsByteBuffer(size + 4);
            if (wsbb != null) {
                ++this.curWSbuffers;
            }
        }
        return wsbb;
    }

    WsByteBuffer getWsByteBuffer(int size) {
        WsByteBuffer wsbb = WsByteBufferPoolManagerImpl.getRef().allocate(size);
        if (wsbb == null) {
            return null;
        }
        wsbb.clear();
        wsbb.order(ByteOrder.BIG_ENDIAN);
        return wsbb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnBuffer(Object buffer) {
        WsByteBuffer wsbb = (WsByteBuffer)buffer;
        wsbb.release();
        Object object = this.pendingWaitMutex;
        synchronized (object) {
            --this.curWSbuffers;
            this.pendingWaitMutex.notifyAll();
        }
    }

    public synchronized void changeTransmissionRate(int new_rate_Kbps) {
        this.tokenBucket.setRate(new_rate_Kbps);
    }

    public double getAverageRetransmissionRate() {
        return 0.0;
    }

    public long getPendingQueueSize() {
        int n_pend = 0;
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && !stream.isClosed) {
                n_pend += stream.pendingPackets.qSize();
            }
            --i;
        }
        this.nPending = n_pend;
        return this.nPending * this.packetSize;
    }

    public String getProtocolVersion() {
        return "100";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("Fireout: p").append(this.streamFireout.curPos).append(" r").append(this.streamFireout.nRot);
            stat.append(". HBSender: ccp").append(this.ccpCount).append(" snp").append(this.snpCount);
            stat.append(". TimingThrd: p").append(this.timingThrd.curPos).append(" r").append(this.timingThrd.nRot);
            stat.append(". ConnPending: r").append(this.checkConnectionPending.nRot).append(" p").append(this.checkConnectionPending.nPos).append(" np").append(this.checkConnectionPending.getWaiting()).append(" asyncCB").append(this.pendingAsyncConnectCB.size()).append('\n');
            return stat.toString();
        }
        catch (NullPointerException ex) {
            return "Not started";
        }
    }

    public StreamTIf getStream(byte[] tag) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && Sutils.compareByteArrays(stream.getTag(), tag)) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public StreamT getStream(short key) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && stream.shortId == key) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration listStreams() {
        Object object = this.streamListLock;
        synchronized (object) {
            Vector<StreamT> tmp = new Vector<StreamT>(this.nStreams);
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = this.streamList[i];
                if (stream != null) {
                    tmp.add(stream);
                }
                --i;
            }
            return tmp.elements();
        }
    }

    public void addFullBufferListener(FullBufferListener list) {
        this.rmmLogger.baseWarn("Setting FullBufferListener on TCP stream", null, moduleName);
    }

    public void removeFullBufferListener(FullBufferListener list) {
    }

    private void start() {
        this.isRunning = true;
        this.streamFireout.start();
        this.timingThrd.start();
        this.checkConnectionPending.start();
    }

    public synchronized boolean stop(boolean soft) {
        StreamT stream;
        this.rmmLogger.baseLog(2, new Object[]{"PTransmitter"}, null, moduleName);
        int i2 = this.nStreams - 1;
        while (i2 >= 0) {
            stream = this.streamList[i2];
            if (stream != null) {
                stream.close(soft);
            }
            --i2;
        }
        if (soft && this.nStreams > 0) {
            this.rmmLogger.baseInfo("PTL Transmitter Stop: Waiting for " + this.config.closeWaitTime / 1000 + "sec (control packet timeout)\n" + "to let transmitter send pending packets and receivers complete the reception", moduleName);
            try {
                Thread.sleep(this.config.closeWaitTime);
            }
            catch (InterruptedException i2) {}
        } else {
            this.rmmLogger.baseInfo("Fast PTL Transmitter Stop", moduleName);
        }
        this.taskMan.removeTask(this.cacTask);
        this.taskMan.removeTask(this.rcsTask);
        this.taskMan.removeTask(this.clmTask);
        this.taskMan.removeTask(this.clsTask);
        this.taskMan.removeTask(this.rccTask);
        this.taskMan.removeTask(this.scpTask);
        this.pendingAsyncConnectCB.clear();
        this.isRunning = false;
        if (this.streamFireout != null) {
            this.streamFireout.interrupt();
        }
        if (this.timingThrd != null) {
            this.timingThrd.interrupt();
        }
        if (this.checkConnectionPending != null) {
            this.checkConnectionPending.interrupt();
        }
        UnicastConnection ucon = null;
        int i3 = this.globalDestinations.size() - 1;
        while (i3 >= 0) {
            try {
                ucon = (UnicastConnection)this.globalDestinations.get(i3);
                if (ucon != null && ucon.vc != null && ucon.vc instanceof OutboundVirtualConnection) {
                    OutboundVirtualConnection ovc = (OutboundVirtualConnection)ucon.vc;
                    boolean permission = ovc.requestPermissionToClose(50L);
                    if (permission) {
                        ovc.close(new Exception("closing connection on pTransmitter.stop"));
                        if (this.rmmLogger.isMaxLogLevel()) {
                            this.rmmLogger.maxInfo("Close OutboundVirtualConnection on transmitter stop " + ucon + ", permission " + permission, moduleName);
                        }
                    } else {
                        this.rmmLogger.baseWarn("Did not get permission to close OutboundVirtualConnection on transmitter stop " + ucon + ", permission " + permission, null, moduleName);
                    }
                }
            }
            catch (Exception exp) {
                if (ucon != null) {
                    this.rmmLogger.baseWarn("Failed to close OutboundVirtualConnection on transmitter stop " + ucon, exp, moduleName);
                }
                this.rmmLogger.baseError("Transmitter stop: exception when processing entry of globalDestinationHash", exp, moduleName);
            }
            --i3;
        }
        try {
            i3 = this.nStreams - 1;
            while (i3 >= 0) {
                stream = this.streamList[i3];
                if (stream != null) {
                    stream.cleanAfterClose();
                }
                --i3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tokenBucket != null) {
            this.tokenBucket.stop();
        }
        return true;
    }

    public synchronized void setPreceiver(PReceiverIf pReceiver) {
        this.myPReceiver = pReceiver;
    }

    public int getHeaderSize() {
        return this.ptlHeaderSize;
    }

    public synchronized boolean receiverReportConnection(InetSocketAddress remoteISA, Object socket, boolean close, Object connection) {
        if (socket == null || connection == null) {
            this.rmmLogger.baseError("receiverReportConnection parameter Error: socket/connection is null " + socket + " " + connection, null, moduleName);
            return false;
        }
        if (close) {
            if (this.rmmLogger.isMaxLogLevel()) {
                this.rmmLogger.maxInfo("receiverReportConnection: close connection to " + Sutils.printIsa(remoteISA), moduleName);
            }
            this.streamFireout.closedConnections.put(connection, socket);
            this.streamFireout.wakeUp(null);
            return true;
        }
        this.rmmLogger.baseError("receiverReportConnection Error: ADD reports not expected", null, moduleName);
        return true;
    }

    public void gotConnStreams(Object socket, long[] stream_ids, int nstreams) {
        try {
            if (socket == null) {
                this.rmmLogger.baseError("gotConnStreams: given 1st arg is null", null, moduleName);
                return;
            }
            if (stream_ids == null) {
                this.rmmLogger.baseError("getConnStreams: given 2nd arg is null", null, moduleName);
                return;
            }
            UnicastConnection ucon = (UnicastConnection)socket;
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = this.streamList[i];
                if (stream != null && stream.destination != null && stream.isActive && !stream.isClosed && stream.eventListener != null && Clock.getTime() >= stream.openTime + 120000L && stream.snpEvent < 2 && stream.unicastConnection == ucon) {
                    int n = nstreams;
                    while (n-- > 0) {
                        if (stream.longId == stream_ids[n]) break;
                    }
                    if (n < 0 && ++stream.snpEvent >= 2) {
                        this.rmmLogger.baseInfo("gotConnStreams: put STREAM_NOT_PRESENT_AT_DESTINATION event for stream " + stream.longId, moduleName);
                        TEvent ev = new TEvent(5, 0L, 0, ucon, stream.longId, ucon.inetAddress, ucon.remoteServerPort);
                        stream.eventListener.onEvent(ev);
                    }
                }
                --i;
            }
        }
        catch (Throwable ex) {
            this.rmmLogger.baseError("gotConnStreams got Exception Transmitter", ex, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gdAdd(UnicastConnection ucon) {
        boolean ok;
        ArrayList arrayList = this.globalDestinations;
        synchronized (arrayList) {
            boolean bl = ok = !this.globalDestinations.contains(ucon);
            if (ok) {
                this.globalDestinations.add(ucon);
                this.gdUpdated = true;
            }
        }
        if (this.rmmLogger.isMaxLogLevel() && ok) {
            this.rmmLogger.maxInfo("gdAdd: Adding ucon to globalDestination table, ucon: " + ucon, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gdRemove(UnicastConnection ucon) {
        boolean ok;
        ArrayList arrayList = this.globalDestinations;
        synchronized (arrayList) {
            ok = this.globalDestinations.remove(ucon);
            if (ok) {
                this.gdUpdated = true;
            }
        }
        if (this.rmmLogger.isMaxLogLevel() && ok) {
            this.rmmLogger.maxInfo("gdRemove: Removing ucon from globalDestination table, ucon: " + ucon, moduleName);
        }
    }

    public boolean stopChfw() {
        this.chfwStopped = true;
        this.rmmLogger.baseInfo("stopChfw called on transmitter", moduleName);
        return true;
    }

    private void closeVC(OutboundVirtualConnection outboundVirtualCon, InetSocketAddress remote) {
        try {
            if (outboundVirtualCon == null) {
                return;
            }
            if (outboundVirtualCon.requestPermissionToClose(500L)) {
                outboundVirtualCon.close(new Exception("closing outBoundVirtualConnection from PTransmitter"));
                this.rmmLogger.baseInfo("Closed OutboundVirtualConnection from closeVC, vc " + outboundVirtualCon, moduleName);
            } else {
                P2PConnectionT con = new P2PConnectionT(remote, null, (VirtualConnection)outboundVirtualCon, null, 10000);
                this.rmmLogger.baseWarn("Did not get permission to close OutboundVirtualConnection from PTransmitter.closeVC, vc " + outboundVirtualCon, null, moduleName);
                if (this.closedVC.put(outboundVirtualCon, con) != null) {
                    this.rmmLogger.baseWarn("PTransmitter.closeVC: OutboundVirtualConnection already exists in closedVC, vc " + outboundVirtualCon, null, moduleName);
                }
            }
        }
        catch (Throwable ex) {
            this.rmmLogger.baseWarn("PTransmitter.closeVC: Exception while trying to close OutboundVirtualConnection, vc " + outboundVirtualCon, ex, moduleName);
        }
    }

    class RemoveClosedStreams
    implements TaskIf {
        private long next_time;
        private long interval;

        public RemoveClosedStreams(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            long next_interval = this.interval;
            int i = PTransmitter.this.pendingClosedStreams.size() - 1;
            while (i >= 0) {
                StreamT stream = (StreamT)PTransmitter.this.pendingClosedStreams.get(i);
                if (stream.closeTime == 0L) {
                    if (stream.controlPacket != null && stream.cpRetries++ < 2) {
                        PTransmitter.this.streamFireout.wakeUp(stream);
                        next_interval = 10L;
                    } else if (stream.controlPacket == null) {
                        stream.writeCP(false);
                        stream.closeTime = curTime;
                    } else if (stream.destination != null) {
                        if (stream.cpRetries++ < 100) {
                            if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                                PTransmitter.this.rmmLogger.maxWarn("removeClosedStreams: could not write control packet with FIN indication, stream " + stream.longId + " cpRetries " + stream.cpRetries + " inPS " + stream.inPS + " inZD " + stream.inZD + " destination " + stream.destination + " ucon " + stream.unicastConnection + ", will try agian", null, PTransmitter.moduleName);
                            }
                        } else {
                            PTransmitter.this.rmmLogger.baseError("removeClosedStreams: failed to write control packet with FIN indication, stream " + stream.longId + " Destination " + stream.destination + " cpRetries " + stream.cpRetries, null, PTransmitter.moduleName);
                            stream.closeTime = curTime;
                        }
                    } else {
                        stream.cpRetries = 100;
                        stream.closeTime = curTime;
                    }
                } else if (curTime - stream.closeTime > (long)PTransmitter.this.config.closeWaitTime) {
                    if (!stream.isClosed) {
                        stream.isClosed = true;
                        if (stream.destination != null) {
                            PTransmitter.this.sendSnp = 5;
                        }
                    } else {
                        PTransmitter.this.removeStream(stream);
                        if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                            PTransmitter.this.rmmLogger.maxInfo("Removing stream " + stream + ".  Remaining: " + PTransmitter.this.nStreams, PTransmitter.moduleName);
                        }
                        stream.cleanAfterClose();
                        PTransmitter.this.pendingClosedStreams.remove(i);
                    }
                }
                --i;
            }
            this.next_time = curTime + next_interval;
        }
    }

    class CheckAsyncConnectCB
    implements TaskIf {
        private long next_time;
        private long interval;

        public CheckAsyncConnectCB(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.pendingAsyncConnectCB.size() - 1;
            while (i >= 0) {
                AsyncConnectCB asynCB = (AsyncConnectCB)PTransmitter.this.pendingAsyncConnectCB.get(i);
                if (asynCB != null) {
                    if (asynCB.beforeDestroy > 0) {
                        PTransmitter.this.pendingAsyncConnectCB.remove(i);
                    } else if (asynCB.expire_time < curTime) {
                        long diff = curTime - asynCB.create_time;
                        Exception e2 = new Exception("CheckAsyncConnectCB: Channel Framework Problem! A request for connection establishment was not completed after " + diff + " ms, (original timeout was " + asynCB.timeout + " ms). Connection: " + asynCB.unicastConnection);
                        PTransmitter.this.rmmLogger.baseLog(421, new Object[]{"" + asynCB.remote}, e2, PTransmitter.moduleName);
                        asynCB.destroy(null);
                        PTransmitter.this.pendingAsyncConnectCB.remove(i);
                    }
                }
                --i;
            }
        }
    }

    class CheckLostMsg
    implements TaskIf {
        private long next_time;
        private long interval;

        public CheckLostMsg(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = PTransmitter.this.streamList[i];
                if (stream != null && stream.destination != null && !stream.isClosed) {
                    if (!(stream.inPS || stream.controlPacket == null && stream.pendingPackets.qSize() <= 0)) {
                        PTransmitter.this.streamFireout.wakeUp(stream);
                    }
                    if (!stream.inZD && stream.mtlSize > 0 && stream.pendingPackets.qSize() == 0) {
                        PTransmitter.this.timingThrd.wakeUp(stream);
                    }
                }
                --i;
            }
        }
    }

    class CheckLimitedStreams
    implements TaskIf {
        private long next_time;
        private long interval;

        public CheckLimitedStreams(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.rateLimitStreams.size() - 1;
            while (i >= 0) {
                StreamT stream = (StreamT)PTransmitter.this.rateLimitStreams.get(i);
                if (stream == null || !stream.limitRate || stream.oDataBucket == null || stream.isClosed) {
                    PTransmitter.this.rateLimitStreams.remove(i);
                } else {
                    try {
                        if (stream.oDataBucket.getToken(0, false, false, false)) {
                            PTransmitter.this.rateLimitStreams.remove(i);
                            PTransmitter.this.streamFireout.wakeUp(stream);
                        }
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
                --i;
            }
        }
    }

    class RemoveClosedConnections
    implements TaskIf {
        private long next_time;
        private long interval;

        public RemoveClosedConnections(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            if (PTransmitter.this.closedVC.isEmpty()) {
                return;
            }
            if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                PTransmitter.this.rmmLogger.maxInfo("RemoveClosedConnections: found " + PTransmitter.this.closedVC.size() + " elements in closedVC", PTransmitter.moduleName);
            }
            EnumArray connections = new EnumArray(PTransmitter.this.closedVC, true);
            while (connections.hasMoreElements()) {
                P2PConnectionT p2pcon;
                VirtualConnection vc = (VirtualConnection)connections.nextElement();
                if (vc == null || (p2pcon = (P2PConnectionT)PTransmitter.this.closedVC.get(vc)) == null) continue;
                long diff = curTime - p2pcon.timeCreated;
                if (diff < (long)PTransmitter.this.config.closeWaitForPermissionTimeOut) {
                    try {
                        if (!vc.requestPermissionToClose(10L)) continue;
                        PTransmitter.this.closedVC.remove(vc);
                        if (!(vc instanceof OutboundVirtualConnection)) continue;
                        OutboundVirtualConnection obvc = (OutboundVirtualConnection)vc;
                        obvc.close(new Exception("Closing OutboundVirtualConnection from ConterolPacketSender"));
                        PTransmitter.this.rmmLogger.baseInfo("ConterolPacketSender: closed OutboundVirtualConnection vc " + obvc, PTransmitter.moduleName);
                    }
                    catch (Exception ex) {
                        PTransmitter.this.rmmLogger.baseWarn("ConterolPacketSender: Exception when closing outbound vc " + vc, ex, PTransmitter.moduleName);
                    }
                    continue;
                }
                PTransmitter.this.rmmLogger.baseWarn("ConterolPacketSender: could not close outbound VC after waiting " + diff + " ms, vc will not be closed. vc " + vc, null, PTransmitter.moduleName);
                PTransmitter.this.closedVC.remove(vc);
            }
        }
    }

    class SendControlPacket
    implements TaskIf {
        private long next_time;
        private long last_time;
        private long interval;
        private PacManOut pmo;
        private UnicastConnection[] ucons;
        private int m;
        private int ncons;
        private int npos;

        public SendControlPacket(long chk_period) {
            this.interval = chk_period;
            this.pmo = new PacManOut();
        }

        public long getNextTime() {
            return this.next_time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(long curTime) {
            boolean isSnp = PTransmitter.this.sendSnp > 0 || PTransmitter.this.myPReceiver != null && PTransmitter.this.myPReceiver.updSendSnp(0) > 0;
            this.next_time = curTime + this.interval;
            if (!isSnp && (PTransmitter.this.config.tcpKeepAlive || curTime < this.last_time + (long)PTransmitter.this.config.heartbeatInterval)) {
                return;
            }
            if (isSnp) {
                --PTransmitter.this.sendSnp;
                if (PTransmitter.this.myPReceiver != null) {
                    PTransmitter.this.myPReceiver.updSendSnp(-1);
                }
                ++PTransmitter.this.snpCount;
            }
            ++PTransmitter.this.ccpCount;
            this.last_time = curTime;
            ArrayList arrayList = PTransmitter.this.globalDestinations;
            synchronized (arrayList) {
                if (PTransmitter.this.gdUpdated) {
                    this.ncons = PTransmitter.this.globalDestinations.size();
                    if (this.ucons == null || this.ucons.length < this.ncons) {
                        this.ucons = new UnicastConnection[(this.ncons + 15) / 16 * 16];
                    }
                    int i = 0;
                    while (i < this.ncons) {
                        this.ucons[i] = (UnicastConnection)PTransmitter.this.globalDestinations.get(i);
                        ++i;
                    }
                    PTransmitter.this.gdUpdated = false;
                }
            }
            int i = 0;
            while (i < this.ncons) {
                block35: {
                    UnicastConnection ucon = this.ucons[i];
                    if (ucon != null) {
                        if (!ucon.isValid()) {
                            if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                                PTransmitter.this.rmmLogger.baseWarn("SendControlPacket: Found invalid ucon: " + ucon, null, PTransmitter.moduleName);
                            }
                            if (ucon.vc != null && ucon.tCPWriteRequestContext != null) {
                                PTransmitter.this.streamFireout.closedConnections.put(ucon.vc, ucon.tCPWriteRequestContext);
                                PTransmitter.this.streamFireout.wakeUp(null);
                                PTransmitter.this.gdRemove(ucon);
                            } else {
                                PTransmitter.this.rmmLogger.baseError("SendControlPacket: Found invalid ucon with null TCPWriteRequestContext " + ucon, null, PTransmitter.moduleName);
                            }
                        }
                        try {
                            this.pmo.reset();
                            this.pmo.writeInt(0);
                            this.pmo.writeByte(100);
                            this.pmo.writeByte(5);
                            if (!PTransmitter.this.config.tcpKeepAlive) {
                                this.pmo.writeShort(PTransmitter.this.config.cpTimeout / 1000);
                            } else {
                                this.pmo.writeShort(-1);
                            }
                            if (isSnp) {
                                this.pmo.writeByte(6);
                                this.npos = this.pmo.getPosition();
                                this.pmo.writeInt(0);
                            }
                            int n = 0;
                            boolean cp_pending = false;
                            StreamT send_stream = null;
                            int j = PTransmitter.this.nStreams - 1;
                            while (j >= 0) {
                                StreamT stream = PTransmitter.this.streamList[j];
                                if (stream != null && stream.destination != null && !stream.isClosed && stream.unicastConnection == ucon) {
                                    if (stream.controlPacket != null) {
                                        PTransmitter.this.streamFireout.wakeUp(stream);
                                        cp_pending = true;
                                        if (!PTransmitter.this.rmmLogger.isMaxLogLevel()) break;
                                        PTransmitter.this.rmmLogger.baseWarn("SendControlPacket: Could not send CP, stream.controlPacket != null , stream= " + stream.longId + " dest= " + Sutils.printIsa(ucon.inetSocketAddress), null, PTransmitter.moduleName);
                                        break;
                                    }
                                    if (send_stream == null) {
                                        send_stream = stream;
                                    }
                                    if (!isSnp) break;
                                    this.pmo.writeLong(stream.longId);
                                    ++n;
                                }
                                --j;
                            }
                            if (cp_pending) break block35;
                            if (send_stream == null) {
                                if (ucon.isValid) {
                                    PTransmitter.this.rmmLogger.baseWarn("SendControlPacket: No active streams on a valid connection to " + ucon, null, PTransmitter.moduleName);
                                }
                                break block35;
                            }
                            if (isSnp) {
                                if (n <= 0) {
                                    if (ucon.isValid) {
                                        PTransmitter.this.rmmLogger.baseWarn("SendControlPacket: No active streams on a valid connection ucon " + ucon, null, PTransmitter.moduleName);
                                    }
                                    break block35;
                                }
                                int mpos = this.pmo.getPosition();
                                this.pmo.setPosition(this.npos);
                                this.pmo.writeInt(n);
                                this.pmo.setPosition(mpos);
                                this.m = 0;
                                if (PTransmitter.this.myPReceiver != null) {
                                    this.m = PTransmitter.this.myPReceiver.getConnStreams(ucon, this.pmo);
                                    if (this.m < 0) {
                                        PTransmitter.this.rmmLogger.baseError("SendControlPacket: myPReceiver.getConnStreams failed for destination " + Sutils.printIsa(ucon.inetSocketAddress), null, PTransmitter.moduleName);
                                        break block35;
                                    }
                                } else {
                                    this.pmo.writeInt(0);
                                }
                            }
                            int len = this.pmo.getPosition() - 4;
                            this.pmo.reset();
                            this.pmo.writeInt(len);
                            this.pmo.safeSkip(len);
                            send_stream.controlPacket = this.pmo.toByteArray();
                            PTransmitter.this.streamFireout.wakeUp(send_stream);
                            if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                                if (isSnp) {
                                    PTransmitter.this.rmmLogger.maxInfo("Connection HB Packet written with " + n + " T_streams and " + this.m + " R_streams for destination " + Sutils.printIsa(ucon.inetSocketAddress) + " , stream " + send_stream, PTransmitter.moduleName);
                                } else {
                                    PTransmitter.this.rmmLogger.maxInfo("Connection HB Packet written for destination " + Sutils.printIsa(ucon.inetSocketAddress) + " , stream " + send_stream, PTransmitter.moduleName);
                                }
                            }
                        }
                        catch (Exception ex) {
                            PTransmitter.this.rmmLogger.baseError("SendControlPacket: Exception while building HB for destination " + Sutils.printIsa(ucon.inetSocketAddress), ex, PTransmitter.moduleName);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

