/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;

class PacketFireout
extends Thread {
    static final String moduleName = "PTL_TCHAN_T";
    PTransmitter pTrans;
    HashMap quarantinedDestinations;
    LinkedList quarantinedStreams;
    Hashtable closedConnections;
    boolean rmvCC;
    ObjCyclQueue pendingStreams;
    long lastExceptionTime;
    volatile int nRot;
    volatile int curPos;
    private boolean goOn = true;

    PacketFireout(PTransmitter ptr) {
        this.pTrans = ptr;
        this.quarantinedDestinations = new HashMap();
        this.quarantinedStreams = new LinkedList();
        this.closedConnections = new Hashtable();
        this.pendingStreams = new ObjCyclQueue(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQuarantinedStreams(TCPWriteRequestContext wrc) {
        if (wrc == null) {
            return;
        }
        HashMap hashMap = this.quarantinedDestinations;
        synchronized (hashMap) {
            int n = this.quarantinedStreams.size();
            while (n-- > 0) {
                try {
                    StreamT stream = (StreamT)this.quarantinedStreams.removeFirst();
                    if (stream == null || stream.destination == null) continue;
                    if (stream.destination.equals(wrc)) {
                        this.wakeUp(stream);
                        continue;
                    }
                    this.quarantinedStreams.addLast(stream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClosedConnections() {
        if (this.closedConnections.isEmpty()) {
            return;
        }
        EnumArray connections = new EnumArray(this.closedConnections, true);
        while (connections.hasMoreElements()) {
            VirtualConnection vc = (VirtualConnection)connections.nextElement();
            if (vc == null) continue;
            TCPWriteRequestContext wrc = (TCPWriteRequestContext)this.closedConnections.get(vc);
            this.pTrans.removeClosedConnection(vc, wrc);
            HashMap hashMap = this.quarantinedDestinations;
            synchronized (hashMap) {
                if (this.quarantinedDestinations.remove(wrc) != null) {
                    this.removeQuarantinedStreams(wrc);
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("removeClosedConnections - connection released from quarantine, vc" + vc, moduleName);
                    }
                }
            }
            this.closedConnections.remove(vc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(StreamT stream) {
        ObjCyclQueue objCyclQueue = this.pendingStreams;
        synchronized (objCyclQueue) {
            if (stream == null) {
                this.rmvCC = true;
                this.pendingStreams.notify();
            } else if (!stream.inPS) {
                stream.inPS = true;
                this.pendingStreams.pushLast(stream);
                this.pendingStreams.notify();
            }
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"PacketFireout"}, null, moduleName);
        this.curPos = 1;
        int n_max = this.pTrans.maxTrans;
        StreamT stream = null;
        int exc_count = 0;
        boolean streamOk = false;
        while (this.goOn) {
            ++this.nRot;
            try {
                this.curPos = 3;
                Object object = this.pendingStreams;
                synchronized (object) {
                    if (streamOk && stream != null && !stream.inPS) {
                        stream.inPS = true;
                        this.pendingStreams.pushLast(stream);
                    }
                    stream = null;
                    while (!this.rmvCC && (stream = (StreamT)this.pendingStreams.popFirst()) == null) {
                        this.pendingStreams.wait();
                    }
                    if (stream != null) {
                        stream.inPS = false;
                    }
                }
                if (this.rmvCC) {
                    this.rmvCC = false;
                    this.removeClosedConnections();
                }
                streamOk = false;
                if (stream == null || stream.isClosed || stream.virtualConn == null) continue;
                if (stream.unicastConnection != null && !stream.unicastConnection.isValid) {
                    if (!stream.isActive || stream.connectionClosed) continue;
                    this.pTrans.rmmLogger.baseWarn("FireOut found a stream with invalid unicastConnection " + stream.longId + " removing connection, ucon " + stream.unicastConnection, null, moduleName);
                    if (stream.destination != null) {
                        this.closedConnections.put(stream.virtualConn, stream.destination);
                    } else {
                        this.pTrans.rmmLogger.baseWarn("FireOut found a stream with invalid unicastConnection but null destination" + stream + " ucon " + stream.unicastConnection, null, moduleName);
                    }
                    this.rmvCC = true;
                    continue;
                }
                if (stream.limitRate && !stream.oDataBucket.hasToken()) {
                    this.pTrans.rateLimitStreams.add(stream);
                    continue;
                }
                this.curPos = 6;
                if (stream.quarantine) continue;
                this.curPos = 7;
                object = this.quarantinedDestinations;
                synchronized (object) {
                    if (!this.quarantinedDestinations.isEmpty()) {
                        n_max = 1;
                        this.curPos = 8;
                        if (stream.destination != null && this.quarantinedDestinations.containsKey(stream.destination)) {
                            this.quarantinedStreams.addLast(stream);
                            continue;
                        }
                    } else {
                        n_max = this.pTrans.maxTrans;
                    }
                }
                this.curPos = 85;
                int n_trans = 0;
                n_trans = stream.pendingPackets.qSize();
                if (n_trans > n_max) {
                    n_trans = n_max;
                }
                if (stream.controlPacket != null) {
                    ++n_trans;
                }
                if (n_trans == 0) {
                    this.curPos = 11;
                    if (stream.mtlSize > 0) {
                        this.pTrans.timingThrd.wakeUp(stream);
                    }
                }
                this.curPos = 13;
                if (stream.destination == null || n_trans == 0 || stream.isClosed) continue;
                try {
                    streamOk = true;
                    this.curPos = 14;
                    int j = 0;
                    while (streamOk && j < n_trans) {
                        block58: {
                            WsByteBuffer bb;
                            boolean is_control_packet;
                            int packet_length;
                            if (!stream.virtualConn.requestPermissionToWrite()) {
                                if (stream.busyRetries > 1) {
                                    this.pTrans.rmmLogger.baseWarn("could not obtain permission to write after " + stream.busyRetries + " tries, stream " + stream.longId + " removing connection", null, moduleName);
                                    stream.unicastConnection.closeConnection(0);
                                    this.closedConnections.put(stream.virtualConn, stream.destination);
                                    streamOk = false;
                                    this.rmvCC = true;
                                    break;
                                }
                                ++stream.busyRetries;
                                break;
                            }
                            stream.busyRetries = 0;
                            if (stream.limitRate && !stream.oDataBucket.hasToken()) {
                                streamOk = false;
                                this.pTrans.rateLimitStreams.add(stream);
                                break;
                            }
                            this.curPos = 15;
                            ObjCyclQueue objCyclQueue = stream.pendingPackets;
                            synchronized (objCyclQueue) {
                                block57: {
                                    if (stream.controlPacket != null) {
                                        this.curPos = 152;
                                        byte[] packet = stream.controlPacket;
                                        packet_length = packet.length;
                                        is_control_packet = true;
                                        this.curPos = 1521;
                                        bb = stream.cpByteBuffer;
                                        bb.clear();
                                        this.curPos = 1522;
                                        try {
                                            bb.put(packet, 0, packet_length);
                                            break block57;
                                        }
                                        catch (Exception e2) {
                                            this.pTrans.rmmLogger.baseError("Fireout exception bb.put controlPacket " + packet_length + " bb " + bb, e2, moduleName);
                                            stream.cpByteBuffer = this.pTrans.getWsByteBuffer(packet_length + 1024);
                                            break block58;
                                        }
                                    }
                                    this.curPos = 153;
                                    bb = (WsByteBuffer)stream.pendingPackets.popFirst();
                                    packet_length = bb.position();
                                    is_control_packet = false;
                                    if (stream.limitRate) {
                                        stream.oDataBucket.commitToken(packet_length);
                                    }
                                }
                            }
                            this.curPos = 16;
                            if (this.pTrans.config.limitRate != 0) {
                                this.pTrans.tokenBucket.waitForToken(packet_length);
                            }
                            bb.flip();
                            TCPWriteRequestContext destination = stream.destination;
                            if (destination == null) break;
                            this.curPos = 17;
                            Object object2 = stream.quarantineLock;
                            synchronized (object2) {
                                this.curPos = 171;
                                destination.setBuffer(bb);
                                VirtualConnection vc = destination.write(-1L, (TCPWriteCompletedCallback)stream.writeCallback, false, 0);
                                if (vc == null) {
                                    if (this.closedConnections.containsValue(destination)) {
                                        this.rmvCC = true;
                                        streamOk = false;
                                    } else if (stream.quarantine || this.quarantinedDestinations.containsKey(destination)) {
                                        this.pTrans.rmmLogger.baseError("Quarantined stream/destination already in Quarantine " + stream.longId + " stream.quarantine " + stream.quarantine, null, moduleName);
                                    }
                                    this.curPos = 18;
                                    this.curPos = 19;
                                    HashMap hashMap = this.quarantinedDestinations;
                                    synchronized (hashMap) {
                                        StreamT str = this.quarantinedDestinations.put(destination, stream);
                                        if (str != null) {
                                            this.quarantinedStreams.addLast(str);
                                        }
                                        stream.quarantine = true;
                                    }
                                } else {
                                    vc.setWriteStateToDone();
                                }
                                this.curPos = 20;
                                if (stream.quarantine) {
                                    streamOk = false;
                                    break;
                                }
                                if (!is_control_packet) {
                                    ++stream.sentFrontSeqN;
                                    this.pTrans.returnBuffer(bb);
                                } else {
                                    stream.controlPacket = null;
                                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                                        this.pTrans.rmmLogger.maxInfo("Sent heartbeat on stream " + stream.longId, moduleName);
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    this.curPos = 21;
                }
                catch (NullPointerException ex) {
                    this.pTrans.rmmLogger.baseError("PacketFireout: NullPointerException when processing stream " + stream.longId + ", stream closed " + stream.isClosed, ex, moduleName);
                    if (stream.isClosed) {
                        // empty if block
                    }
                    streamOk = false;
                    continue;
                }
                this.curPos = 22;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"PacketFireout"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("PacketFireout: Exception in thread loop", ex, moduleName);
                long time = Clock.getTime();
                if (time - this.lastExceptionTime > 500L) {
                    exc_count = 0;
                }
                this.lastExceptionTime = time;
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop PacketFireout", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"PacketFireout"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"PacketFireout"}, null, moduleName);
    }
}

