/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.ifc.transmitter.EventListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.UnicastConnection;
import com.ibm.rmm.ptl.tchan.transmitter.WriteCompleteCB;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;

public class StreamT
implements StreamTIf {
    static final String moduleName = "PTL_TCHAN_T";
    PTransmitter pTrans;
    short shortId;
    long longId;
    byte[] tag;
    short tagLength;
    int pendFrontSeqN;
    int sentFrontSeqN;
    byte[] controlPacket;
    Object cpLock;
    Object quarantineLock;
    ObjCyclQueue pendingPackets;
    int oldFront;
    boolean isActive;
    boolean isClosed;
    boolean inZD;
    boolean inPS;
    long openTime;
    long closeTime;
    private DataOutputStream cpDos;
    private DataOutputStream miscDos;
    private ByteArrayOutputStream cpBaos;
    private ByteArrayOutputStream miscBaos;
    private BufferRequestListener bufferRequestListener;
    AdminLayerListener adminListener;
    TokenBucket oDataBucket;
    boolean limitRate = false;
    byte[] optionsField;
    private Hashtable controlOptions;
    int noReListContr;
    UnicastConnection unicastConnection;
    TCPWriteRequestContext destination;
    EventListener eventListener;
    StreamTUpcalls mCleanUp;
    boolean quarantine;
    long bytesTransmitted;
    long bytesRetransmitted;
    long last_bytesTransmitted;
    int mtlSize;
    boolean sendPartial;
    Object sendPartialMutex;
    WriteCompleteCB writeCallback;
    WsByteBuffer cpByteBuffer;
    int cpRetries = 0;
    volatile boolean connectionClosed = false;
    int busyRetries = 0;
    VirtualConnection virtualConn;
    int snpEvent;

    StreamT(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    boolean init(byte[] tag, short id, boolean is_reliable, InetAddress mcast_address, boolean lj_enabled) {
        this.tag = tag;
        this.tagLength = (short)tag.length;
        this.shortId = id;
        int cplen = this.tagLength < 900 ? 1024 : this.tagLength + 256;
        this.cpByteBuffer = this.pTrans.getWsByteBuffer(cplen);
        if (this.cpByteBuffer == null || this.cpByteBuffer.capacity() < cplen - 64) {
            this.pTrans.rmmLogger.baseError("Failed to allocate cpByteBuffer for new stream, cpByteBuffer" + this.cpByteBuffer + ", cplen " + cplen, null, moduleName);
            return false;
        }
        this.cpByteBuffer.clear();
        this.optionsField = new byte[1];
        this.optionsField[0] = 0;
        this.controlOptions = new Hashtable();
        this.noReListContr = 0;
        this.isActive = true;
        this.isClosed = false;
        this.cpBaos = new ByteArrayOutputStream();
        this.cpDos = new DataOutputStream(this.cpBaos);
        this.miscBaos = new ByteArrayOutputStream();
        this.miscDos = new DataOutputStream(this.miscBaos);
        this.sendPartialMutex = new Object();
        this.sendPartial = false;
        this.pendFrontSeqN = 0;
        this.sentFrontSeqN = this.pendFrontSeqN - 1;
        try {
            this.miscDos.writeShort(this.shortId);
            this.miscDos.write(this.pTrans.ipAddress, 0, 4);
            this.miscDos.writeShort(this.pTrans.nackPort);
            ByteArrayInputStream bais1 = new ByteArrayInputStream(this.miscBaos.toByteArray());
            DataInputStream dis1 = new DataInputStream(bais1);
            this.longId = dis1.readLong();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write stream id", ex, moduleName);
            return false;
        }
        this.miscBaos.reset();
        this.cpLock = new Object();
        this.quarantineLock = new Object();
        this.pendingPackets = new ObjCyclQueue(128);
        this.writeCallback = new WriteCompleteCB(this);
        return this.writeCP(false);
    }

    public synchronized boolean close(boolean soft) {
        if (!this.isActive) {
            return true;
        }
        this.pTrans.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "Fast ") + "Closing Transmitter Stream: " + this.longId, moduleName);
        this.isActive = false;
        if (soft) {
            this.closeTime = 0L;
        } else {
            this.isClosed = true;
            if (this.destination == null) {
                this.closeTime = Clock.getTime() - (long)this.pTrans.config.closeWaitTime + 5000L;
            } else {
                this.closeTime = Clock.getTime();
                this.pTrans.sendSnp = 5;
            }
        }
        this.pTrans.pendingClosedStreams.add(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAfterClose() {
        if (this.oDataBucket != null) {
            this.oDataBucket.stop();
        }
        ObjCyclQueue objCyclQueue = this.pendingPackets;
        synchronized (objCyclQueue) {
            int sps = this.pendingPackets.qSize();
            int i = 0;
            while (i < sps) {
                this.pTrans.returnBuffer(this.pendingPackets.popFirst());
                ++i;
            }
        }
        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
            this.pTrans.rmmLogger.maxInfo("Cleaned up pending Q of stream " + this.longId, moduleName);
        }
        try {
            this.pTrans.checkAndRemoveConnection(this.unicastConnection, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mCleanUp != null) {
            this.mCleanUp.cleanAfterClose();
        }
        if (this.cpByteBuffer != null) {
            this.cpByteBuffer.release();
        }
        this.cpByteBuffer = null;
        this.mCleanUp = null;
        this.bufferRequestListener = null;
        this.writeCallback.stream = null;
        this.writeCallback = null;
        this.destination = null;
        this.unicastConnection = null;
    }

    public int cleanBuffer(int new_trail) {
        this.pTrans.rmmLogger.baseWarn("Cleaning TcpStream buffer: No effect", null, moduleName);
        return 0;
    }

    public int getFrontSeqNum() {
        return this.pendFrontSeqN;
    }

    public int getTrailSeqNum() {
        this.pTrans.rmmLogger.baseWarn("Getting trail of TcpStream: Returns 0", null, moduleName);
        return 0;
    }

    public int getPossibleJoin() {
        return this.getFrontSeqNum();
    }

    public InetAddress getMulticastGroup() {
        return null;
    }

    public long getId() {
        return this.longId;
    }

    public int getPort() {
        return -1;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public long getPendingQueueSize() {
        return this.pendingPackets.qSize() * this.pTrans.packetSize;
    }

    public long getBytesRetransmitted() {
        return -1L;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public short getTagLength() {
        return this.tagLength;
    }

    public long lastNackTime() {
        this.pTrans.rmmLogger.baseWarn("Getting lastNackTime of TcpStream: Returns 0", null, moduleName);
        return 0L;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isReliable() {
        return true;
    }

    public boolean isQuarantined() {
        return this.quarantine;
    }

    public boolean isConnected(String address, int port2) {
        InetAddress itmp = null;
        if (port2 < 0 || port2 > 65535) {
            return false;
        }
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            return false;
        }
        return this.unicastConnection.remoteServerPort == port2 && this.unicastConnection.inetAddress.equals(itmp);
    }

    boolean requestPartialPacket() {
        boolean ret;
        if (this.bufferRequestListener != null) {
            ret = this.bufferRequestListener.onRequest();
        } else {
            ++this.noReListContr;
            if (this.noReListContr > 5) {
                this.pTrans.rmmLogger.baseWarn("StreamT:requestPartialPacket bufferRequestListener is null. Stream: " + this.toString(), null, moduleName);
            }
            ret = false;
        }
        return ret;
    }

    public void setBufReqListener(BufferRequestListener listener) {
        if (this.bufferRequestListener != null) {
            this.pTrans.rmmLogger.baseWarn("Replacing bufferRequestListener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.bufferRequestListener = listener;
    }

    public void setAdminListener(AdminLayerListener fl) {
        this.adminListener = fl;
        if (this.adminListener == null) {
            return;
        }
    }

    public void setCleanUpListener(StreamTUpcalls mcu) {
        this.mCleanUp = mcu;
    }

    public void setEventListener(EventListener el) {
        this.eventListener = el;
    }

    public synchronized void setLjMarker() {
        this.advanceLjMarker(this.pendFrontSeqN);
    }

    public boolean addP2Pdestination(UnicastConnectionIf connection) {
        UnicastConnection ucon = null;
        try {
            ucon = (UnicastConnection)connection;
        }
        catch (Throwable ex) {
            this.pTrans.rmmLogger.baseError("addP2Pdestination invalid connection object", ex, moduleName);
            return false;
        }
        if (ucon == null || !ucon.isValid) {
            this.pTrans.rmmLogger.baseError("addP2Pdestination invalid connection object " + ucon, null, moduleName);
            return false;
        }
        this.virtualConn = ucon.vc;
        this.unicastConnection = ucon;
        this.destination = ucon.tCPConnectionContext.getWriteInterface();
        this.openTime = Clock.getTime();
        this.pTrans.sendSnp = 5;
        this.pTrans.gdAdd(ucon);
        this.pTrans.streamFireout.wakeUp(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addP2Pdestination(InetSocketAddress dest, boolean useExisting) {
        if (dest == null) {
            return false;
        }
        TCPWriteRequestContext sock = null;
        UnicastConnection ucon = null;
        UnicastConnection foundCon = null;
        if (useExisting) {
            int found = 0;
            ArrayList arrayList = this.pTrans.globalDestinations;
            synchronized (arrayList) {
                int i = this.pTrans.globalDestinations.size() - 1;
                while (i >= 0) {
                    ucon = (UnicastConnection)this.pTrans.globalDestinations.get(i);
                    if (ucon != null && ucon.isValid && ucon.inetSocketAddress.equals(dest)) {
                        foundCon = ucon;
                        ++found;
                        break;
                    }
                    --i;
                }
            }
            if (found == 1) {
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("addP2Pdestination with useExisting (" + Sutils.printIsa(dest) + "), found ucon " + foundCon.toString(), moduleName);
                }
                return this.addP2Pdestination(foundCon);
            }
            if (found > 1) {
                this.pTrans.rmmLogger.baseError("Failed to addP2Pdestination with useExisting (" + Sutils.printIsa(dest) + "), found = " + found, null, moduleName);
                return false;
            }
        }
        Object object = this.pTrans.globalLock;
        synchronized (object) {
            OutboundVirtualConnection obvc;
            block22: {
                block23: {
                    block21: {
                        block20: {
                            ucon = this.pTrans.establishConnection(dest);
                            if (ucon != null) break block20;
                            return false;
                        }
                        obvc = (OutboundVirtualConnection)ucon.vc;
                        TCPConnectionContext tcc = (TCPConnectionContext)obvc.getChannelAccessor();
                        if (tcc != null) {
                            sock = tcc.getWriteInterface();
                        }
                        if (sock != null) break block21;
                        this.pTrans.rmmLogger.baseError("Failed to resolve TCPReadRequestContext from OutboundVC (" + Sutils.printIsa(dest) + ").", null, moduleName);
                        return false;
                    }
                    if (this.pTrans.myPReceiver == null) break block22;
                    if (obvc.requestPermissionToRead()) break block23;
                    this.pTrans.rmmLogger.baseError("addP2Pdestination failed to obtain permission to write signature_bb", null, moduleName);
                    return false;
                }
                try {
                    this.pTrans.myPReceiver.registerNewConnection(ucon, dest.getAddress(), dest.getPort());
                }
                catch (Exception ex) {
                    this.pTrans.rmmLogger.baseError("Failed to register new TCP connection with PacketReceiver (" + Sutils.printIsa(dest) + ").", ex, moduleName);
                    return false;
                }
            }
            this.virtualConn = obvc;
            this.unicastConnection = ucon;
            this.destination = sock;
            this.openTime = Clock.getTime();
            this.pTrans.sendSnp = 5;
            this.pTrans.streamFireout.wakeUp(this);
        }
        return true;
    }

    public boolean addP2PdestinationNonBlocking(InetSocketAddress dest, CreateConnectionListener listener, int timeout) {
        if (dest == null) {
            return false;
        }
        boolean res = this.pTrans.checkConnectionPending.requestConnectionNonBlocking(dest, listener, timeout, this);
        return res;
    }

    public void removeP2Pdestination(InetSocketAddress dest) {
    }

    public boolean removeDestination(InetSocketAddress dest, TCPWriteRequestContext wrc) {
        boolean found = false;
        return found;
    }

    public synchronized void advanceLjMarker(int pack_n) {
        this.pTrans.rmmLogger.baseError("Calling StreamT.advanceLjMarker on unicast stream", null, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitPacketData(byte[] mtlhdr, int off1, int len1, byte[] mtldat, int off2, int len2) {
        WsByteBuffer wsbb;
        byte[] options = this.optionsField;
        int len = 14 + options.length + 2 + this.tagLength + len1 + len2;
        if (len + 4 > this.pTrans.packetSize) {
            this.pTrans.rmmLogger.baseLog(415, new Object[]{"" + (len + 4), "submitPacketData: len > packetSize: " + len + " " + 14 + " " + options.length + " " + this.tagLength + " " + len1 + " " + len2}, null, moduleName);
            this.pTrans.rmmLogger.baseError("submitPacketData: len > packetSize: " + len + " " + 14 + " " + options.length + " " + this.tagLength + " " + len1 + " " + len2, null, moduleName);
        }
        if ((wsbb = (WsByteBuffer)this.pTrans.getBuffer(this, len)) == null) {
            return false;
        }
        wsbb.clear();
        wsbb.putInt(len);
        wsbb.put((byte)100);
        wsbb.put((byte)1);
        wsbb.putLong(this.longId);
        wsbb.putInt(this.pendFrontSeqN);
        wsbb.put(options);
        wsbb.putShort(this.tagLength);
        wsbb.put(this.tag, 0, (int)this.tagLength);
        wsbb.put(mtlhdr, off1, len1);
        wsbb.put(mtldat, off2, len2);
        ObjCyclQueue objCyclQueue = this.pendingPackets;
        synchronized (objCyclQueue) {
            block7: {
                if (!this.isClosed) break block7;
                this.pTrans.returnBuffer(wsbb);
                return false;
            }
            this.pendingPackets.pushLast(wsbb);
        }
        this.pTrans.streamFireout.wakeUp(this);
        if (this.pTrans.config.collectStats) {
            this.bytesTransmitted += (long)wsbb.position();
        }
        ++this.pendFrontSeqN;
        return true;
    }

    public boolean isCongested() {
        return this.pTrans.maxWSbuffers - this.pTrans.curWSbuffers < 20;
    }

    public void wakeUp() {
        if (!this.inZD && this.pendingPackets.qSize() == 0) {
            this.pTrans.timingThrd.wakeUp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeCP(boolean heartbeatOnly) {
        Object object = this.cpLock;
        synchronized (object) {
            this.cpBaos.reset();
            if (heartbeatOnly) {
                try {
                    int len = 4;
                    this.cpDos.writeInt(len);
                    this.cpDos.writeByte(100);
                    this.cpDos.writeByte(5);
                    if (!this.pTrans.config.tcpKeepAlive) {
                        this.cpDos.writeShort((short)(this.pTrans.config.cpTimeout / 1000));
                    } else {
                        this.cpDos.writeShort(-1);
                    }
                }
                catch (IOException ex) {
                    this.pTrans.rmmLogger.baseError("Failed to write Connection HB packet.", ex, moduleName);
                    return false;
                }
                this.controlPacket = this.cpBaos.toByteArray();
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("HeartbeatPacket written for stream: " + this.toString(), moduleName);
                }
            } else {
                try {
                    this.writeOptions();
                    int len = 18 + this.tagLength + this.optionsField.length;
                    this.cpDos.writeInt(len);
                    this.cpDos.writeByte(100);
                    this.cpDos.writeByte(2);
                    this.cpDos.writeLong(this.longId);
                    this.cpDos.writeInt(this.sentFrontSeqN);
                    this.cpDos.write(this.optionsField);
                    this.cpDos.writeShort(this.tagLength);
                    this.cpDos.write(this.tag, 0, this.tagLength);
                    if (!this.pTrans.config.tcpKeepAlive) {
                        this.cpDos.writeShort((short)(this.pTrans.config.cpTimeout / 1000));
                    } else {
                        this.cpDos.writeShort(-1);
                    }
                }
                catch (IOException ex) {
                    this.pTrans.rmmLogger.baseError("Failed to write ControlPacket. Stream: " + this.toString(), ex, moduleName);
                    return false;
                }
                this.controlPacket = this.cpBaos.toByteArray();
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("ControlPacket written for stream: " + this.toString(), moduleName);
                }
            }
            this.pTrans.streamFireout.wakeUp(this);
            this.cpBaos.reset();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOptions() {
        ByteArrayOutputStream byteArrayOutputStream = this.miscBaos;
        synchronized (byteArrayOutputStream) {
            this.miscBaos.reset();
            int n_options = this.isActive ? 0 : 1;
            try {
                this.miscDos.writeByte(n_options);
                if (!this.isActive) {
                    this.miscDos.writeByte(2);
                    int opt_len = 0;
                    this.miscDos.writeShort(opt_len);
                }
            }
            catch (IOException ex) {
                this.pTrans.rmmLogger.baseError("Failed to write options. Stream: " + this.toString(), ex, moduleName);
                return;
            }
            this.optionsField = this.miscBaos.toByteArray();
        }
    }

    public void setTransmissionRate(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
            this.limitRate = true;
        }
    }

    public void startCongestionControl(int rate_kbps) {
        this.pTrans.rmmLogger.baseWarn("Setting congestion control in TCP stream. Has no effect", null, moduleName);
    }

    public void stopCongestionControl() {
        this.pTrans.rmmLogger.baseWarn("Stopping congestion control in TCP stream. Has no effect", null, moduleName);
    }

    public void setAdminOption(byte type, byte[] option) {
        if (this.controlOptions.size() > 64) {
            this.pTrans.rmmLogger.baseWarn("StreamT.setControlOption: failed: too many options set. Stream: " + this.toString(), null, moduleName);
            return;
        }
        this.controlOptions.put(new Byte(type), option);
        this.writeCP(false);
    }

    public synchronized void setRedLine(int pack_seq_n) {
        this.pTrans.rmmLogger.baseWarn("Setting red line of TcpStream: No effect", null, moduleName);
    }

    public synchronized void removeRedLine() {
        this.pTrans.rmmLogger.baseWarn("Removing red line of TcpStream: No effect", null, moduleName);
    }

    public synchronized int getRedLine() {
        this.pTrans.rmmLogger.baseWarn("No red line for TcpStream.", null, moduleName);
        return -1;
    }

    public void removeAdminOption(byte type) {
        this.controlOptions.remove(new Byte(type));
        this.writeCP(false);
    }

    public String toString() {
        return "" + this.longId;
    }

    public boolean sendHeartbeat() {
        boolean res = false;
        if (this.controlPacket == null) {
            res = this.writeCP(false);
        }
        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
            this.pTrans.rmmLogger.maxInfo("sendHeartbeat called on stream " + this.longId + ", return value " + res, moduleName);
        }
        return res;
    }

    public UnicastConnectionIf getUnicastConnection() {
        return this.unicastConnection;
    }

    public void setMtlSize(int size) {
        this.mtlSize = size;
    }
}

