/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;

class TimingThread
extends Thread {
    static final String moduleName = "PTL_TCHAN_T";
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    volatile int nwk;
    volatile int nwks;
    private boolean goOn = true;
    private TokenBucket myTb;
    private ObjCyclQueue pendingStreams;

    TimingThread(PTransmitter ptr) {
        this.pTrans = ptr;
        this.pendingStreams = new ObjCyclQueue(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(StreamT stream) {
        ObjCyclQueue objCyclQueue = this.pendingStreams;
        synchronized (objCyclQueue) {
            if (!stream.inZD) {
                stream.inZD = true;
                this.pendingStreams.pushLast(stream);
                this.pendingStreams.notify();
            }
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.curPos = 1;
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"TimingThread"}, null, moduleName);
        StreamT stream = null;
        int rate = this.pTrans.config.partialRate;
        if (rate > 0) {
            this.myTb = new TokenBucket(rate / 128, this.pTrans.rmmLogger, this.pTrans.taskMan);
        }
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                ObjCyclQueue objCyclQueue = this.pendingStreams;
                synchronized (objCyclQueue) {
                    while ((stream = (StreamT)this.pendingStreams.popFirst()) == null) {
                        this.pendingStreams.wait();
                    }
                    stream.inZD = false;
                }
                if (stream.isClosed || stream.mtlSize <= 0 || stream.pendingPackets.qSize() != 0 || !stream.requestPartialPacket() || rate <= 0) continue;
                this.myTb.getToken(1, true, false, false);
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"TimingThread"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("TimingThread: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop TimingThread", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"TimingThread"}, ex, moduleName);
                break;
            }
        }
        if (this.myTb != null) {
            this.myTb.stop();
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"TimingThread"}, null, moduleName);
    }
}

