/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.util.UnicastConnectionIf;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class UnicastConnection
implements UnicastConnectionIf {
    volatile boolean isValid = true;
    InetAddress inetAddress;
    int localPort;
    int remotePort;
    int remoteServerPort;
    VirtualConnection vc;
    TCPConnectionContext tCPConnectionContext;
    TCPWriteRequestContext tCPWriteRequestContext;
    boolean isOutbound;
    InetSocketAddress inetSocketAddress;
    public boolean isRxClosed;
    public boolean isTxClosed;
    private Object closeMutex;

    public UnicastConnection(InetAddress inetAdd, int rPort, int lPort, int sPort, VirtualConnection vcon, TCPConnectionContext tcc, boolean isOut) {
        this.inetAddress = inetAdd;
        this.localPort = lPort;
        this.remotePort = rPort;
        this.remoteServerPort = sPort;
        this.vc = vcon;
        this.tCPConnectionContext = tcc;
        this.isOutbound = isOut;
        this.inetSocketAddress = new InetSocketAddress(this.inetAddress, this.remoteServerPort);
        this.isRxClosed = false;
        this.isTxClosed = false;
        this.closeMutex = new Object();
        try {
            this.tCPWriteRequestContext = this.tCPConnectionContext.getWriteInterface();
        }
        catch (Exception ex) {
            this.tCPWriteRequestContext = null;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public InetAddress getRemoteAddress() {
        return this.inetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public VirtualConnection getVC() {
        return this.vc;
    }

    public TCPConnectionContext getTCPConnectionContext() {
        return this.tCPConnectionContext;
    }

    public String toString() {
        return "UnicastConnection@" + this.hashCode() + ", address: " + Sutils.printIsa(this.inetSocketAddress) + " | " + this.localPort + ", isOutbound: " + this.isOutbound + ", isValid: " + this.isValid + " (" + this.isRxClosed + " " + this.isTxClosed + ")" + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection(int timeout_milli) {
        Object object = this.closeMutex;
        synchronized (object) {
            this.isValid = false;
        }
        if (timeout_milli <= 0) {
            return false;
        }
        int max_wait = timeout_milli;
        int waited = 0;
        boolean closed = false;
        while (waited < max_wait) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                break;
            }
            Object object2 = this.closeMutex;
            synchronized (object2) {
                if (this.isRxClosed && this.isTxClosed) {
                    closed = true;
                    break;
                }
            }
            waited += 20;
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeMutex;
        synchronized (object) {
            return this.isRxClosed && this.isTxClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalid() {
        Object object = this.closeMutex;
        synchronized (object) {
            return !this.isValid;
        }
    }
}

