/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tchan.transmitter;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tchan.transmitter.P2PConnectionT;
import com.ibm.rmm.ptl.tchan.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tchan.transmitter.StreamT;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class WriteCompleteCB
implements TCPWriteCompletedCallback {
    static final String moduleName = "PTL_TCHAN_T";
    StreamT stream;
    PTransmitter pTrans;
    long streamID;

    WriteCompleteCB(StreamT str) {
        this.stream = str;
        this.pTrans = this.stream.pTrans;
        this.streamID = this.stream.longId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc, TCPWriteRequestContext wrc) {
        if (!this.pTrans.isRunning) {
            return;
        }
        if (vc != null) {
            vc.setWriteStateToDone();
        } else {
            this.pTrans.rmmLogger.baseWarn("WriteCompleteCB.complete called with null vc", null, moduleName);
        }
        if (this.stream == null && wrc != null) {
            wrc.getBuffer().release();
            this.pTrans.streamFireout.removeQuarantinedStreams(wrc);
            return;
        }
        try {
            Object object = this.stream.quarantineLock;
            synchronized (object) {
                WsByteBuffer bb = wrc.getBuffer();
                if (bb != this.stream.cpByteBuffer) {
                    ++this.stream.sentFrontSeqN;
                    this.pTrans.returnBuffer(bb);
                } else {
                    this.stream.controlPacket = null;
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("Sent heartbeat (quarantine) on stream " + this.stream.longId, moduleName);
                    }
                }
                HashMap hashMap = this.pTrans.streamFireout.quarantinedDestinations;
                synchronized (hashMap) {
                    if (this.pTrans.streamFireout.quarantinedDestinations.remove(wrc) != null && !this.pTrans.streamFireout.quarantinedDestinations.containsValue(this.stream)) {
                        this.stream.quarantine = false;
                    }
                }
            }
        }
        catch (Exception exp) {
            this.pTrans.rmmLogger.baseWarn("Exception during WriteCompleteCB.complete", exp, moduleName);
        }
        this.pTrans.streamFireout.removeQuarantinedStreams(wrc);
        this.pTrans.streamFireout.wakeUp(this.stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, TCPWriteRequestContext wrc, IOException t) {
        InetSocketAddress dest;
        block32: {
            if (!this.pTrans.isRunning) {
                return;
            }
            if (vc != null) {
                vc.setWriteStateToDone();
            } else {
                this.pTrans.rmmLogger.baseWarn("WriteCompleteCB.error called with null vc", null, moduleName);
            }
            if (this.stream == null || this.pTrans.streamFireout == null) {
                this.pTrans.rmmLogger.baseWarn("WriteCompleteCB.error called on closed (null) stream or null streamFireout " + this.stream, null, moduleName);
                if (this.pTrans.streamFireout == null) {
                    return;
                }
            }
            dest = null;
            try {
                block31: {
                    WsByteBuffer bb = wrc.getBuffer();
                    if (this.stream != null) {
                        Object object = this.stream.quarantineLock;
                        synchronized (object) {
                            if (bb != this.stream.cpByteBuffer) {
                                ++this.stream.sentFrontSeqN;
                                this.pTrans.returnBuffer(bb);
                            }
                        }
                    } else {
                        bb.release();
                        if (this.pTrans.curWSbuffers > 0) {
                            --this.pTrans.curWSbuffers;
                        }
                    }
                    try {
                        InetAddress addr = wrc.getInterface().getRemoteAddress();
                        int port2 = wrc.getInterface().getRemotePort();
                        dest = new InetSocketAddress(addr, port2);
                    }
                    catch (Exception ex) {
                        if (!this.pTrans.isRunning) break block31;
                        this.pTrans.rmmLogger.baseWarn("WriteCompleteCB.error exception when trying to obtain destination from TcpWriteRequestContext", ex, moduleName);
                    }
                }
                if (this.stream != null && this.stream.unicastConnection != null) {
                    this.stream.unicastConnection.closeConnection(0);
                }
                if (vc != null && wrc != null) {
                    this.pTrans.streamFireout.closedConnections.put(vc, wrc);
                    this.pTrans.streamFireout.wakeUp(null);
                } else if (this.pTrans.isRunning) {
                    this.pTrans.rmmLogger.baseError("WriteCompleteCB.error found null vc/wrc " + vc + " " + wrc, null, moduleName);
                }
                this.pTrans.rmmLogger.baseWarn("Connection closed to " + Sutils.printIsa(dest) + ", stream " + this.streamID + ".\n" + t, null, moduleName);
            }
            catch (Exception exp) {
                if (!this.pTrans.isRunning) break block32;
                this.pTrans.rmmLogger.baseError("Exception in WriteCompleteCB.error " + dest + " " + wrc, exp, moduleName);
            }
        }
        if (wrc != null) {
            this.pTrans.streamFireout.removeQuarantinedStreams(wrc);
        }
        if (vc != null) {
            try {
                if (vc instanceof OutboundVirtualConnection) {
                    OutboundVirtualConnection obvc = (OutboundVirtualConnection)vc;
                    if (obvc.requestPermissionToClose((long)this.pTrans.config.closeWaitForPermission)) {
                        obvc.close(new Exception("Closing OutboundVirtualConnection from WriteCompleteCB"));
                        this.pTrans.rmmLogger.baseInfo("WriteCompleteCB: closed OutboundVirtualConnection to " + Sutils.printIsa(dest), moduleName);
                    } else {
                        P2PConnectionT con = new P2PConnectionT(dest, null, (VirtualConnection)obvc, null, 10000);
                        this.pTrans.rmmLogger.baseWarn("WriteCompleteCB: Did not get permission to close OutboundVirtualConnection from checkAndRemoveConnection, vc " + obvc, null, moduleName);
                        if (this.pTrans.closedVC.put(obvc, con) != null) {
                            this.pTrans.rmmLogger.baseWarn("WriteCompleteCB: OutboundVirtualConnection already exists in closedVC, vc " + obvc, null, moduleName);
                        }
                    }
                } else {
                    boolean res = false;
                    if (this.pTrans.myPReceiver != null) {
                        res = this.pTrans.myPReceiver.checkOrRemoveConnection(vc, dest, false);
                    }
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("WriteCompleteCB.error called with InboundVirtualConnection to " + Sutils.printIsa(dest) + " res " + res, moduleName);
                    }
                }
            }
            catch (Exception ex) {
                this.pTrans.rmmLogger.baseWarn("WriteCompleteCB: Exception when closing outbound vc " + vc + " t " + t, ex, moduleName);
            }
        }
    }
}

