/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.receiver;

import com.ibm.rmm.util.RmmLogger;
import java.util.Properties;

class Config
extends com.ibm.rmm.ptl.tcp.transmitter.Config {
    static final String moduleName = "PTL_TCP_R";
    RmmLogger rmmLogger;
    static final int MAX_BUFFER_SIZE = 66560;
    int packetSize;
    int socketBufferSize = 0;
    int serverPort;
    int nBuffers;
    boolean bindAll = true;
    boolean isOK;
    int hbTimeoutMillis;
    int maxTagLength = 32000;

    Config(RmmLogger rlog, Properties java_props) {
        this.rmmLogger = rlog;
        this.isOK = true;
        String tmp = java_props.getProperty("ServerSocketPort");
        if (tmp != null) {
            try {
                this.serverPort = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e2) {
                this.rmmLogger.baseBadParam("ServerSocketPort", tmp, e2, moduleName);
                this.isOK = false;
                return;
            }
            if (this.serverPort <= 0 || this.serverPort > 65535) {
                this.rmmLogger.baseBadParam("ServerSocketPort", "" + this.serverPort, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("RecvTcpSocketBufferSizeKbyte")) == null) {
            tmp = java_props.getProperty("RecvTcpSocketBufferSizeKbytes");
        }
        if (tmp == null) {
            tmp = java_props.getProperty("TcpSocketBufferSizeKbyte");
        }
        if (tmp == null) {
            tmp = java_props.getProperty("TcpSocketBufferSizeKbytes");
        }
        if (tmp != null) {
            try {
                this.socketBufferSize = 1024 * Integer.parseInt(tmp);
            }
            catch (NumberFormatException e3) {
                this.rmmLogger.baseBadParam("TcpSocketBufferSizeKbytes", tmp, e3, moduleName);
                this.isOK = false;
                return;
            }
            if (this.socketBufferSize < 0) {
                this.rmmLogger.baseBadParam("TcpSocketBufferSizeKbytes", "" + this.socketBufferSize, null, moduleName);
                this.isOK = false;
                return;
            }
            if (this.socketBufferSize < 65000 || this.socketBufferSize > 100000000) {
                this.rmmLogger.baseWarn("TcpSocketBufferSizeKbytes value: " + this.socketBufferSize, null, moduleName);
            }
        }
        if ((tmp = java_props.getProperty("PacketBuffers")) == null) {
            this.rmmLogger.baseLog(402, new Object[]{"PacketBuffers"}, null, moduleName);
        } else {
            try {
                this.nBuffers = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e4) {
                this.rmmLogger.baseBadParam("PacketBuffers", tmp, e4, moduleName);
                this.isOK = false;
                return;
            }
            if (this.nBuffers <= 0) {
                this.rmmLogger.baseBadParam("PacketBuffers", "" + this.nBuffers, null, moduleName);
                this.isOK = false;
                return;
            }
            if (this.nBuffers > 5000) {
                this.rmmLogger.baseWarn("PacketBuffers value: " + this.nBuffers, null, moduleName);
            }
        }
        if (this.nBuffers <= 0) {
            this.rmmLogger.baseInfo("Using default PacketBuffers: 500", moduleName);
            this.nBuffers = 500;
        }
        if ((tmp = java_props.getProperty("PacketBufferSizeBytes")) == null) {
            this.packetSize = 33000;
        } else {
            try {
                this.packetSize = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e5) {
                this.rmmLogger.baseBadParam("PacketBufferSizeBytes", tmp, e5, moduleName);
                this.isOK = false;
                return;
            }
            if (this.packetSize < 1500 || this.packetSize > 33000) {
                this.rmmLogger.baseWarn("PacketBufferSizeBytes value: " + this.packetSize, null, moduleName);
            }
            this.packetSize += 100;
        }
        tmp = java_props.getProperty("HeartbeatTimeoutMillis");
        if (tmp != null) {
            try {
                this.hbTimeoutMillis = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e6) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMillis", tmp, e6, moduleName);
                this.isOK = false;
                return;
            }
            if (this.hbTimeoutMillis <= 50) {
                this.rmmLogger.baseBadParam("HeartbeatTimeoutMillis", "" + this.hbTimeoutMillis, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("MaximalTagLength")) != null) {
            try {
                this.maxTagLength = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e7) {
                this.rmmLogger.baseBadParam("MaximalTagLength", tmp, e7, moduleName);
                this.isOK = false;
                return;
            }
            if (this.maxTagLength <= 0) {
                this.rmmLogger.baseBadParam("MaximalTagLength", "" + this.maxTagLength, null, moduleName);
                this.isOK = false;
                return;
            }
        }
        if ((tmp = java_props.getProperty("BindAllInterfaces")) != null) {
            this.bindAll = Boolean.valueOf(tmp);
        }
    }
}

