/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tcp.receiver.PEvent;
import com.ibm.rmm.ptl.tcp.receiver.PReceiver;
import com.ibm.rmm.ptl.tcp.receiver.StreamR;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Vector;

final class HeartbeatProcessor
extends Thread {
    static final String moduleName = "PTL_TCP_R";
    PReceiver pRec;
    volatile int nRot;
    private int hbTimeoutMillis;
    private int sleepTime;
    private Object hbLock;
    private Vector closedUcon;
    private boolean goOn = true;

    HeartbeatProcessor(PReceiver prc) {
        this.pRec = prc;
        this.sleepTime = 1000;
        this.hbLock = new Object();
        this.closedUcon = new Vector();
        if (this.pRec.config.hbTimeoutMillis > 0) {
            this.pRec.rmmLogger.baseInfo("HeartbeatTimeout specified for Receiver (" + this.pRec.config.hbTimeoutMillis + " millis). Overriding the values configured in Transmitter", moduleName);
            this.hbTimeoutMillis = this.pRec.config.hbTimeoutMillis;
            this.sleepTime = this.hbTimeoutMillis > 50000 ? 5000 : this.hbTimeoutMillis / 10;
        }
    }

    private boolean checkClosedStreams() {
        StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
        int i = 0;
        while (i < streams.length) {
            if (streams[i].heartbeatTimeout) {
                StreamR stream = streams[i];
                if (stream.transClosed) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxInfo("Heartbeat timeout on Stream " + stream + ". Was orderly closed by transmitter", moduleName);
                    }
                } else {
                    this.pRec.rmmLogger.baseWarn("Heartbeat timeout on Stream " + stream, null, moduleName);
                }
                PEvent ev = new PEvent(2, stream);
                stream.mySet.packetListener.onEvent(ev);
                if (stream.adminListener != null) {
                    stream.adminListener.onEvent(ev);
                }
                stream.mySet.packetListener.onHeartbeatTimeout(stream);
                stream.mySet.removeStream(stream);
            } else if (streams[i].transClosed) {
                int timeout;
                long time = Clock.getTime();
                if (this.hbTimeoutMillis > 0) {
                    timeout = this.hbTimeoutMillis;
                } else {
                    int n = timeout = streams[i].cpTimeout > 0 ? streams[i].cpTimeout * 1000 : 10000;
                }
                if (timeout > 120000) {
                    timeout = 120000;
                }
                if (time - streams[i].lastCpOrDataTime > (long)timeout) {
                    streams[i].heartbeatTimeout = true;
                }
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean checkConnectionHeartBeat(UnicastConnection con) {
        if (!con.isValid()) {
            con.reportTimeout = false;
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxWarn("checkConnectionHeartBeat: found invalid unicastConnection " + con + " destination " + Sutils.printIsa(con.inetSocketAddress), null, moduleName);
            }
            StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
            int i = 0;
            while (i < streams.length) {
                if (streams[i].socketChannel.equals(con.getSocketChannel())) {
                    streams[i].heartbeatTimeout = true;
                }
                ++i;
            }
            return false;
        }
        if (con.timeout <= 0) {
            return true;
        }
        long time = Clock.getTime();
        int timeout = this.hbTimeoutMillis > 0 ? this.hbTimeoutMillis : con.timeout * 1000;
        Object object = this.hbLock;
        synchronized (object) {
            long diff = time - con.timeCreated;
            if (diff > (long)(timeout / 3) && diff < (long)(timeout / 3 + this.sleepTime * 2) && this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxWarn("No Heartbeat received in last " + timeout / 3 + " milliseconds on connection " + Sutils.printIsa(con.inetSocketAddress), null, moduleName);
            }
            if (time - con.timeCreated < (long)timeout) {
                con.hbTimeoutDetected = false;
                return true;
            }
        }
        if (con.getSocketChannel().isOpen() && !con.hbTimeoutDetected) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxWarn("Connection Heartbeat timeout detected on open socket. Ignoring once. " + Sutils.printIsa(con.inetSocketAddress) + ", reportTimeout " + con.reportTimeout, null, moduleName);
            }
            con.hbTimeoutDetected = true;
            return true;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxWarn("Connection Heartbeat timeout " + Sutils.printIsa(con.inetSocketAddress) + ", reportTimeout " + con.reportTimeout + " isOpen " + con.getSocketChannel().isOpen(), null, moduleName);
        }
        StreamR[] streams = this.pRec.packetProcessor.streamHash.getValues();
        int i = 0;
        while (i < streams.length) {
            if (streams[i].socketChannel.equals(con.getSocketChannel())) {
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("Stream " + streams[i].id + ", Heartbeat timeout after connection timeout " + Sutils.printIsa(con.inetSocketAddress) + ", reportTimeout " + con.reportTimeout, moduleName);
                }
                streams[i].heartbeatTimeout = true;
            }
            ++i;
        }
        return false;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"HeartbeatProcessor"}, null, moduleName);
        int exc_count = 0;
        SocketChannel socket = null;
        this.pRec.rmmLogger.baseInfo("HeartbeatProcessor sleeptime is " + this.sleepTime, moduleName);
        while (this.goOn) {
            ++this.nRot;
            try {
                UnicastConnection con;
                boolean found_hbt = false;
                this.checkClosedStreams();
                EnumArray connections = new EnumArray(this.pRec.packetProcessor.connectionsHT, false);
                while (connections.hasMoreElements()) {
                    con = (UnicastConnection)connections.nextElement();
                    if (con == null) continue;
                    socket = con.getSocketChannel();
                    if (this.checkConnectionHeartBeat(con)) continue;
                    found_hbt = true;
                    this.closedUcon.add(con);
                    this.pRec.packetProcessor.connectionsHT.remove(con.getSocketChannel());
                    if (this.pRec.myPTransmitter != null && con.reportTimeout) {
                        this.pRec.myPTransmitter.receiverReportConnection(null, null, true, con);
                    }
                    boolean isOpen = socket.isOpen();
                    this.pRec.rmmLogger.baseInfo("Removing " + (isOpen ? "Opened" : "Closed") + " connection after heartbeat timeout, ucon " + con, moduleName);
                    try {
                        if (socket.isOpen() && socket.socket().isConnected()) {
                            socket.socket().shutdownOutput();
                            socket.socket().shutdownInput();
                        }
                    }
                    catch (Throwable ex) {
                        this.pRec.rmmLogger.baseWarn("Failed to shutdown output/input of socket channel after heartbeat timeout remote address" + Sutils.printIsa(con.inetSocketAddress), ex, moduleName);
                    }
                    try {
                        if (!socket.socket().isClosed()) {
                            socket.socket().close();
                        }
                        socket.close();
                    }
                    catch (IOException ex) {
                        this.pRec.rmmLogger.baseWarn("Failed to close socket channel after heartbeat timeout remote address" + Sutils.printIsa(con.inetSocketAddress), ex, moduleName);
                    }
                    catch (Throwable exp) {
                        this.pRec.rmmLogger.baseError("Error when closing socket channel after heartbeat timeout remote address" + Sutils.printIsa(con.inetSocketAddress), exp, moduleName);
                    }
                    con.closeConnection(0);
                }
                if (found_hbt) {
                    this.checkClosedStreams();
                    while (!this.closedUcon.isEmpty()) {
                        con = (UnicastConnection)this.closedUcon.remove(0);
                        if (con == null) continue;
                        con.isRxClosed = true;
                        if (!this.pRec.rmmLogger.isMaxLogLevel()) continue;
                        this.pRec.rmmLogger.maxInfo("HeartbeatProcessor: set isRxClosed = true for " + con.toString(), moduleName);
                    }
                }
                this.closedUcon.clear();
                HeartbeatProcessor.sleep(this.sleepTime);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"HeartbeatProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("HeartbeatProcessor: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop HeartbeatProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"HeartbeatProcessor"}, ex, moduleName);
                break;
            }
        }
        this.pRec.rmmLogger.baseLog(2, new Object[]{"HeartbeatProcessor"}, null, moduleName);
    }
}

