/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.receiver;

import com.ibm.rmm.intrn.util.PacManOut;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamSetUpcalls;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.tcp.receiver.Config;
import com.ibm.rmm.ptl.tcp.receiver.HeartbeatProcessor;
import com.ibm.rmm.ptl.tcp.receiver.PacketProcessor;
import com.ibm.rmm.ptl.tcp.receiver.PacketReceiver;
import com.ibm.rmm.ptl.tcp.receiver.StreamR;
import com.ibm.rmm.ptl.tcp.receiver.StreamSet;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class PReceiver
implements PReceiverIf {
    static final String moduleName = "PTL_TCP_R";
    PTransmitterIf myPTransmitter;
    Config config;
    RmmAddress rmmAddress;
    RmmLogger rmmLogger;
    TaskManager taskMan;
    HeartbeatProcessor heartbeatProcessor;
    PacketProcessor packetProcessor;
    PacketReceiver packetReceiver;
    InetAddress mcInterf;
    boolean isRunning;
    boolean relSrvRun = false;
    int sendSnp;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, InetAddress mc_interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.isRunning = true;
            this.mcInterf = mc_interf;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.packetReceiver = new PacketReceiver(this);
            this.packetReceiver.setName("Ptl_Tcp_PacketReceiver");
            this.packetReceiver.setPriority(10);
            this.packetProcessor = new PacketProcessor(this);
            this.packetProcessor.setName("Ptl_Tcp_PacketProcessor");
            this.packetProcessor.setPriority(10);
            this.heartbeatProcessor = new HeartbeatProcessor(this);
            this.heartbeatProcessor.setName("Ptl_Tcp_HeartbeatProcessor");
            this.heartbeatProcessor.setPriority(10);
            this.packetReceiver.start();
            this.packetProcessor.start();
            this.heartbeatProcessor.start();
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PReceiver", e2, moduleName);
            return false;
        }
        return true;
    }

    public synchronized StreamSetIf createStreamSet(StreamSelector matcher, StreamSetUpcalls list, boolean reliable, boolean fifo) {
        if (fifo) {
            this.rmmLogger.baseError("PReceiver: currently FIFO is not supported at PTL layer", null, moduleName);
        }
        StreamSet str_set = new StreamSet(this, !reliable, false);
        str_set.setStreamSelector(matcher);
        str_set.setPacketListener(list);
        this.packetProcessor.addStreamSet(str_set);
        return str_set;
    }

    public boolean joinMulticastGroup(InetAddress address) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to join a multicast group " + address, null, moduleName);
        return false;
    }

    public boolean leaveMulticastGroup(InetAddress address) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to leave a multicast group " + address, null, moduleName);
        return false;
    }

    public boolean joinMulticastGroup(InetAddress address, int port2) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to join a multicast group", null, moduleName);
        return false;
    }

    public boolean leaveMulticastGroup(InetAddress address, int port2) {
        this.rmmLogger.baseWarn("TCP PTL: Trying to leave a multicast group", null, moduleName);
        return false;
    }

    public boolean stop() {
        this.rmmLogger.baseInfo("STOPPING RMReceiver", moduleName);
        this.isRunning = false;
        this.packetReceiver.interrupt();
        this.packetReceiver.wakeupSelector();
        this.packetProcessor.interrupt();
        if (this.heartbeatProcessor != null) {
            this.heartbeatProcessor.interrupt();
        }
        int i = 0;
        while (!this.packetReceiver.threadStopped && i < 5) {
            this.packetReceiver.interrupt();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (!this.packetReceiver.threadStopped) {
            this.rmmLogger.baseError("Failed to properly stop PacketReceiver thread", null, moduleName);
        }
        i = 0;
        while (!this.packetProcessor.threadStopped && i < 5) {
            this.packetProcessor.interrupt();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        if (!this.packetProcessor.threadStopped) {
            this.rmmLogger.baseError("Failed to properly stop PacketProcessor thread", null, moduleName);
        }
        return true;
    }

    public void clearRejectedStreamList() {
        if (this.packetProcessor != null) {
            this.packetProcessor.clearRejectedStreamList();
        }
    }

    public StreamRIf getStream(long id) {
        return this.packetProcessor.streamHash.get(id);
    }

    public StreamRIf getStream(byte[] tag, InetAddress source_addr, int source_port) {
        this.rmmLogger.baseError("PTransmitter.getStream: P2P stream is not uniquely identified by tag/src/port", null, moduleName);
        return null;
    }

    public String getProtocolVersion() {
        return "100";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("HBProc: r").append(this.heartbeatProcessor.nRot);
            stat.append(". PProc: r").append(this.packetProcessor.nRot);
            stat.append(" wfp ").append(this.packetProcessor.nWfp);
            stat.append(" pQ ").append(this.packetReceiver.packetQueue.qSize());
            stat.append(". PRec: r").append(this.packetReceiver.nRot);
            stat.append(" p").append(this.packetReceiver.curPos);
            stat.append(" wfb ").append(this.packetReceiver.nWfb);
            stat.append(" bQ ").append(this.packetReceiver.packetPool.qSize());
            stat.append(". connections: ").append(this.packetProcessor.connectionsHT.size());
            stat.append(" registerRequests ").append(this.packetReceiver.registerRequests.size()).append("\n");
            this.packetProcessor.printRejectedStreamList(stat);
            return stat.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "Not started";
        }
    }

    public synchronized void setPtransmitter(PTransmitterIf pTransmitter) {
        this.myPTransmitter = pTransmitter;
    }

    public int getServerSocketPort() {
        return this.config.serverPort;
    }

    public void registerNewConnection(Object socket, InetAddress address, int port2) throws Exception {
        this.packetReceiver.registerNewConnection((UnicastConnection)socket, port2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOrRemoveConnection(Object socket, InetSocketAddress address, boolean checkOnly) {
        SocketChannel sock = (SocketChannel)socket;
        boolean res = false;
        if (sock != null) {
            res = this.packetProcessor.connectionsHT.containsKey(sock);
            if (this.rmmLogger.isMaxLogLevel()) {
                this.rmmLogger.maxInfo("removeConnection: looking for connection to " + Sutils.printIsa(address) + ", res " + res + " onlyCheckExist " + checkOnly, moduleName);
            }
            if (checkOnly) {
                return res;
            }
            Hashtable hashtable = this.packetProcessor.connectionsHT;
            synchronized (hashtable) {
                UnicastConnection ucon = (UnicastConnection)this.packetProcessor.connectionsHT.get(sock);
                if (ucon != null) {
                    ucon.requestClose = true;
                    res = true;
                } else {
                    res = false;
                }
            }
        } else {
            if (!checkOnly) {
                this.rmmLogger.baseError("removeConnection: socket is null", null, moduleName);
            }
            return false;
        }
        return res;
    }

    public int getConnStreams(Object socket, PacManOut pmo) {
        try {
            if (socket == null || pmo == null) {
                return -1;
            }
            UnicastConnection ucon = (UnicastConnection)socket;
            StreamR[] streams = this.packetProcessor.streamHash.getValues();
            int npos = pmo.getPosition();
            pmo.writeInt(0);
            int n = 0;
            int i = streams.length - 1;
            while (i >= 0) {
                if (streams[i] != null && streams[i].unicastonnection == ucon) {
                    pmo.writeLong(streams[i].id);
                    ++n;
                }
                --i;
            }
            if (n > 0) {
                int mpos = pmo.getPosition();
                pmo.setPosition(npos);
                pmo.writeInt(n);
                pmo.setPosition(mpos);
            }
            return n;
        }
        catch (Throwable ex) {
            this.rmmLogger.baseError("getConnStreams: got exception!!", ex, moduleName);
            return -1;
        }
    }

    public int updSendSnp(int add) {
        this.sendSnp += add;
        return this.sendSnp;
    }
}

