/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.EnumArray;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.PersistByteArrayInputStream;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.ptl.tcp.receiver.AdminEvent;
import com.ibm.rmm.ptl.tcp.receiver.LongStreamHash;
import com.ibm.rmm.ptl.tcp.receiver.PEvent;
import com.ibm.rmm.ptl.tcp.receiver.PReceiver;
import com.ibm.rmm.ptl.tcp.receiver.Packet;
import com.ibm.rmm.ptl.tcp.receiver.StreamR;
import com.ibm.rmm.ptl.tcp.receiver.StreamSet;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import com.ibm.rmm.util.RMMRejectAndCloseConnectionException;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;

class PacketProcessor
extends Thread {
    static final String moduleName = "PTL_TCP_R";
    PReceiver pRec;
    boolean isSleeping;
    LongStreamHash streamHash;
    volatile int nRot;
    volatile int nWfp;
    volatile boolean threadStopped = false;
    private Packet packet;
    private PersistByteArrayInputStream bais;
    private DataInputStream dis;
    private byte[] buffer;
    private byte[] tagBuf;
    private int nSets;
    private int setQsize = 100;
    private StreamSet[] setList;
    private long[] rejectedStreams;
    private Object rejectedStreamLock;
    private int rejectedStreamNumber;
    private int rejectedStreamSize;
    private int rejectedVersion;
    private boolean goOn = true;
    Hashtable connectionsHT;
    private long[] connStreams;

    PacketProcessor(PReceiver prc) {
        this.pRec = prc;
        this.streamHash = new LongStreamHash(10);
        this.rejectedStreamNumber = 0;
        this.rejectedStreamSize = 10;
        this.rejectedStreams = new long[this.rejectedStreamSize];
        this.rejectedStreamLock = new Object();
        this.rejectedVersion = 0;
        this.tagBuf = new byte[Short.MAX_VALUE];
        this.nSets = 0;
        this.setList = new StreamSet[this.setQsize];
        this.bais = new PersistByteArrayInputStream(new byte[1]);
        this.dis = new DataInputStream(this.bais);
        this.connectionsHT = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            this.setList[this.nSets] = set;
            ++this.nSets;
            if (this.nSets == this.setQsize) {
                StreamSet[] tmp = this.setList;
                this.setList = new StreamSet[2 * this.setQsize];
                int i = 0;
                while (i < this.nSets) {
                    this.setList[i] = tmp[i];
                    ++i;
                }
                this.setQsize *= 2;
            }
            this.clearRejectedStreamList();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void printRejectedStreamList(StringBuffer sb) {
        long[] streams = this.rejectedStreams;
        if (streams == null || this.rejectedStreamNumber == 0) {
            sb.append("_RMM_STATS_ RejectedStreamSize: 0");
            return;
        }
        int len = this.rejectedStreamNumber;
        if (len > streams.length) {
            len = streams.length;
        }
        sb.append("_RMM_STATS_  RejectedStreamSize: ").append(this.rejectedStreamNumber).append(", ").append(len);
        int i = 0;
        while (i < len) {
            if (i % 20 == 0) {
                sb.append("\n_RMM_STATS_  ");
            }
            sb.append(" | ").append(streams[i]);
            ++i;
        }
        sb.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRejectedStreamList() {
        Object object = this.rejectedStreamLock;
        synchronized (object) {
            this.rejectedStreamNumber = 0;
            this.rejectedStreamSize = 10;
            this.rejectedStreams = new long[this.rejectedStreamSize];
            ++this.rejectedVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStreamSet(StreamSet set) {
        StreamSet[] streamSetArray = this.setList;
        synchronized (this.setList) {
            int ind = 0;
            boolean found = false;
            int i = 0;
            while (i < this.nSets) {
                if (this.setList[i] == set) {
                    ind = i;
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.pRec.rmmLogger.baseWarn("removeStreamSet: no set found", null, moduleName);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            i = ind;
            while (i < this.nSets - 1) {
                this.setList[i] = this.setList[i + 1];
                ++i;
            }
            --this.nSets;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int i2 = 0;
            while (i2 < set.streamList.size()) {
                StreamR str = (StreamR)set.streamList.elementAt(i2);
                this.removeStream(str);
                ++i2;
            }
            return;
        }
    }

    void removeStream(StreamRIf stream) {
        this.streamHash.remove(stream.getId());
        this.pRec.sendSnp = 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContrPack(StreamR stream, boolean stream_closed) {
        Object object = stream.hbLock;
        synchronized (object) {
            stream.lastCpOrDataTime = Clock.getTime();
        }
        try {
            stream.cpTimeout = this.dis.readShort();
        }
        catch (IOException ex) {
            this.pRec.rmmLogger.baseError("Failed to parse ControlPacket. Stream: " + stream, ex, moduleName);
            return;
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Got heartbeat on stream " + stream.id + ". Time: " + stream.lastCpOrDataTime + ". T.O. Interval: " + stream.cpTimeout, moduleName);
        }
        if (stream.cpTimeout < 0) {
            this.pRec.rmmLogger.baseWarn("cpTimeout value is " + stream.cpTimeout + ", TCP keepalive is used; stream will not announce heartbeat timeout", null, moduleName);
        }
        if (stream_closed && !stream.transClosed) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Stream transmission closed by sender. Stream Id: " + stream.id, moduleName);
            }
            stream.transClosed = true;
            PEvent ev = new PEvent(5, stream);
            stream.mySet.packetListener.onEvent(ev);
            if (stream.adminListener != null) {
                AdminEvent aev = new AdminEvent(5, stream);
                stream.adminListener.onEvent(aev);
            }
        }
    }

    private void processHBPacket(Packet packet, short hb_timeout, boolean is_heartbeat) {
        UnicastConnection connection = null;
        if (packet == null) {
            this.pRec.rmmLogger.baseWarn("processHBPacket: null packet arg!", null, moduleName);
            return;
        }
        if (packet.source == null) {
            this.pRec.rmmLogger.baseWarn("processHBPacket: packet.source is null!", null, moduleName);
            return;
        }
        connection = (UnicastConnection)this.connectionsHT.get(packet.source);
        if (connection != null) {
            connection.timeCreated = Clock.getTime();
        } else {
            if (packet.sourceAddr == null) {
                this.pRec.rmmLogger.baseWarn("processHBPacket: packet.sourceAddr is null!", null, moduleName);
                return;
            }
            InetSocketAddress isa = new InetSocketAddress(packet.sourceAddr, packet.sourcePort);
            EnumArray connections = new EnumArray(this.connectionsHT, false);
            while (connections.hasMoreElements()) {
                connection = (UnicastConnection)connections.nextElement();
                if (connection == null || !connection.inetSocketAddress.equals(isa)) continue;
                long diff = Clock.getTime() - connection.timeCreated;
                this.pRec.rmmLogger.baseWarn("processHBPacket: Found existing connection in connectionsHT " + connection.inetSocketAddress + " is open " + connection.getSocketChannel().isOpen() + " last HB " + diff + " " + isa, null, moduleName);
            }
            connection = packet.ucon;
            if (!packet.source.isOpen() || connection == null) {
                this.pRec.rmmLogger.baseWarn("Error when adding connection to connectionsHT source is closed " + Sutils.printIsa(isa), null, moduleName);
                return;
            }
            connection.timeCreated = Clock.getTime();
            connection.timeout = hb_timeout;
            if (this.connectionsHT.put(packet.source, connection) != null) {
                this.pRec.rmmLogger.baseError("Error when adding connection to connectionsHT entry exists " + Sutils.printIsa(connection.inetSocketAddress) + "  entries " + this.connectionsHT.size(), null, moduleName);
            } else if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Adding connection to connectionsHT " + Sutils.printIsa(connection.inetSocketAddress) + "  entries " + this.connectionsHT.size(), moduleName);
            }
        }
        if (is_heartbeat && this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Got heartbeat on connection from " + Sutils.printIsa(connection.inetSocketAddress) + ". Time: " + connection.timeCreated + ". T.O. Interval: " + hb_timeout, moduleName);
        }
    }

    private void processSLPacket() {
        StreamR[] streamList = this.streamHash.getValues();
        try {
            UnicastConnection ucon = this.packet.ucon;
            int ns = this.dis.readInt();
            if (this.connStreams == null || this.connStreams.length < ns) {
                this.connStreams = new long[(ns + 15) / 16 * 16];
            }
            int n = 0;
            while (n < ns) {
                this.connStreams[n] = this.dis.readLong();
                ++n;
            }
            int i = streamList.length - 1;
            while (i >= 0) {
                StreamR stream = streamList[i];
                if (stream != null && !stream.transClosed && !stream.heartbeatTimeout && stream.unicastonnection != null && stream.mySet.packetListener != null && stream.snpEvent < 2 && stream.unicastonnection == ucon) {
                    int n2 = ns;
                    while (n2-- > 0) {
                        if (stream.id == this.connStreams[n2]) break;
                    }
                    if (n2 < 0 && ++stream.snpEvent >= 2) {
                        this.pRec.rmmLogger.baseInfo("gotConnStreams: put STREAM_NOT_PRESENT_AT_SOURCE event for stream " + stream.id, moduleName);
                        PEvent ev = new PEvent(20, stream);
                        stream.mySet.packetListener.onEvent(ev);
                        stream.transClosed = true;
                    }
                }
                --i;
            }
            if (this.pRec.myPTransmitter != null) {
                ns = this.dis.readInt();
                if (this.connStreams == null || this.connStreams.length < ns) {
                    this.connStreams = new long[(ns + 15) / 16 * 16];
                }
                n = 0;
                while (n < ns) {
                    this.connStreams[n] = this.dis.readLong();
                    ++n;
                }
                this.pRec.myPTransmitter.gotConnStreams(ucon, this.connStreams, ns);
            }
        }
        catch (Throwable ex) {
            this.pRec.rmmLogger.baseWarn("processSLPacket: caought Exception: ", ex, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamR fetchStream(boolean stream_closed, Packet packet, long sid, short tag_length, byte[] tag_buffer) {
        StreamR stream = this.streamHash.get(sid);
        if (stream != null) {
            return stream;
        }
        if (stream_closed) {
            return null;
        }
        StreamSet[] streamSetArray = this.rejectedStreamLock;
        synchronized (this.rejectedStreamLock) {
            int i = 0;
            while (i < this.rejectedStreamNumber) {
                if (this.rejectedStreams[i] == sid) {
                    // ** MonitorExit[var9_7] (shouldn't be in output)
                    return null;
                }
                ++i;
            }
            // ** MonitorExit[var9_7] (shouldn't be in output)
            if (tag_length == -1) {
                return null;
            }
            streamSetArray = this.setList;
            synchronized (this.setList) {
                int rv;
                i = 0;
                while (i < this.rejectedStreamNumber) {
                    if (this.rejectedStreams[i] == sid) {
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    ++i;
                }
                int tmp = (int)sid;
                int nack_port = tmp;
                if (nack_port < 0) {
                    nack_port -= -65536;
                }
                Object object = this.rejectedStreamLock;
                synchronized (object) {
                    rv = this.rejectedVersion;
                }
                int i2 = 0;
                while (i2 < this.nSets) {
                    StreamSet set = this.setList[i2];
                    if (packet.sourceAddr == null) {
                        this.pRec.rmmLogger.baseWarn("could not get InetAddress from packet in fetchStream, stream id " + sid, null, moduleName);
                    }
                    if (packet.ucon.isInvalid()) {
                        this.pRec.rmmLogger.baseWarn("fetchStream found closed UnicastConnection " + packet.ucon.toString(), null, moduleName);
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    boolean accept = false;
                    try {
                        accept = set.getStreamSelector().acceptStream(tag_buffer, tag_length, sid, packet.sourceAddr, nack_port);
                    }
                    catch (RMMRejectAndCloseConnectionException e2) {
                        InetSocketAddress remote = new InetSocketAddress(packet.sourceAddr, packet.sourcePort);
                        boolean res = this.closeRejectedConnection(packet.source);
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("RMMRejectAndCloseConnectionException on stream " + sid + ", trying to close connection from " + Sutils.printIsa(remote) + ", resault " + res, moduleName);
                        }
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return null;
                    }
                    if (accept) {
                        if (!packet.source.isOpen()) {
                            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                                this.pRec.rmmLogger.maxWarn("fetchStream found new stream on closed connection " + sid, null, moduleName);
                            }
                            // ** MonitorExit[var9_7] (shouldn't be in output)
                            return null;
                        }
                        byte[] tag = new byte[tag_length];
                        System.arraycopy(tag_buffer, 0, tag, 0, tag_length);
                        stream = set.addStream(sid, tag, packet.sourceAddr, nack_port);
                        stream.socketChannel = packet.source;
                        stream.unicastonnection = packet.ucon;
                        this.streamHash.put(sid, stream);
                        this.pRec.sendSnp = 5;
                        PEvent ev = new PEvent(10, stream);
                        ev.objField = packet.ucon;
                        set.packetListener.onEvent(ev);
                        if (set.adminListener != null) {
                            set.adminListener.onEvent(ev);
                        }
                        if (this.pRec.rmmLogger.isMaxLogLevel()) {
                            this.pRec.rmmLogger.maxInfo("New stream accepted, stream id " + sid + " TagLen " + tag_length + " " + tag.length, moduleName);
                        }
                        // ** MonitorExit[var9_7] (shouldn't be in output)
                        return stream;
                    }
                    ++i2;
                }
                if (this.pRec.rmmLogger.isMaxLogLevel()) {
                    this.pRec.rmmLogger.maxInfo("New stream rejected, stream id " + sid + " TagLen " + tag_length, moduleName);
                }
                Object object2 = this.rejectedStreamLock;
                synchronized (object2) {
                    if (rv == this.rejectedVersion) {
                        if (this.rejectedStreamNumber == this.rejectedStreamSize) {
                            long[] tmpl = this.rejectedStreams;
                            this.rejectedStreamSize *= 2;
                            this.rejectedStreams = new long[this.rejectedStreamSize];
                            int i3 = 0;
                            while (i3 < this.rejectedStreamNumber) {
                                this.rejectedStreams[i3] = tmpl[i3];
                                ++i3;
                            }
                        }
                        this.rejectedStreams[this.rejectedStreamNumber] = sid;
                        ++this.rejectedStreamNumber;
                    }
                    this.pRec.sendSnp = 5;
                }
                // ** MonitorExit[var9_7] (shouldn't be in output)
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnBuffer(Packet pack) {
        ObjCyclQueue objCyclQueue = this.pRec.packetReceiver.packetPool;
        synchronized (objCyclQueue) {
            this.pRec.packetReceiver.packetPool.pushLast(pack);
            if (this.pRec.packetReceiver.isSleeping) {
                this.pRec.packetReceiver.packetPool.notify();
            }
        }
    }

    int getSetNumber() {
        return this.nSets;
    }

    boolean closeRejectedConnection(SocketChannel sc) {
        boolean res = true;
        if (sc == null) {
            return false;
        }
        StreamR[] streams = this.streamHash.getValues();
        int i = 0;
        while (i < streams.length) {
            if (streams[i].socketChannel.equals(sc)) {
                PEvent ev = new PEvent(5, streams[i]);
                streams[i].mySet.packetListener.onEvent(ev);
                streams[i].heartbeatTimeout = true;
            }
            ++i;
        }
        try {
            if (sc.isOpen()) {
                sc.socket().shutdownInput();
                sc.socket().shutdownOutput();
            }
        }
        catch (IOException ex1) {
            this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Failed to shutdown input/output of socket channel.", ex1, moduleName);
        }
        try {
            sc.socket().close();
            sc.close();
        }
        catch (IOException ex2) {
            this.pRec.rmmLogger.baseWarn("closeRejectedConnection: Failed to close socket channel.", ex2, moduleName);
            res = false;
        }
        catch (Throwable ex3) {
            this.pRec.rmmLogger.baseError("closeRejectedConnection: Error when closing socket channel.", ex3, moduleName);
            res = false;
        }
        return res;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketProcessor"}, null, moduleName);
        int packet_n = 0;
        int trail_n = 0;
        int cnt = 0;
        short tag_len = 0;
        this.isSleeping = false;
        int exc_count = 0;
        while (this.goOn) {
            ++this.nRot;
            try {
                StreamR stream;
                if (this.pRec.packetReceiver.packetQueue.qSize() == 0) {
                    PacketProcessor.yield();
                }
                ObjCyclQueue objCyclQueue = this.pRec.packetReceiver.packetQueue;
                synchronized (objCyclQueue) {
                    while ((this.packet = (Packet)this.pRec.packetReceiver.packetQueue.popFirst()) == null) {
                        ++this.nWfp;
                        this.isSleeping = true;
                        this.pRec.packetReceiver.packetQueue.wait();
                        this.isSleeping = false;
                    }
                }
                ++cnt;
                this.buffer = this.packet.buffer;
                if (this.packet.ucon != null && !this.packet.ucon.isValid()) {
                    if (this.pRec.rmmLogger.isMaxLogLevel()) {
                        this.pRec.rmmLogger.maxWarn("PacketProcessor found packet of closed source " + this.packet.ucon, null, moduleName);
                    }
                    this.returnBuffer(this.packet);
                    continue;
                }
                this.bais.setBuffer(this.buffer);
                byte protver = this.dis.readByte();
                if (protver != 100) {
                    this.pRec.rmmLogger.baseWarn("Version conflict " + protver + " vs " + 100, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                byte packet_type = this.dis.readByte();
                if (packet_type == 5) {
                    short hb_timeout = this.dis.readShort();
                    this.processHBPacket(this.packet, hb_timeout, true);
                    if (this.packet.length > this.bais.getPosition() && this.dis.readByte() == 6) {
                        this.processSLPacket();
                    }
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (packet_type != 1 && packet_type != 2) {
                    this.pRec.rmmLogger.baseWarn("Bad packet type " + packet_type + " should be " + 1 + " or " + 2, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                long sid = this.dis.readLong();
                packet_n = this.dis.readInt();
                int n_options = this.dis.readByte();
                int length_of_options = 1;
                boolean stream_closed = false;
                int i = 0;
                while (i < n_options) {
                    byte opt_type = this.dis.readByte();
                    short opt_len = this.dis.readShort();
                    length_of_options += 3 + opt_len;
                    if (opt_type == 2) {
                        stream_closed = true;
                    } else {
                        long skipped = this.dis.skip(opt_len);
                        if (skipped != (long)opt_len) {
                            while (skipped < (long)opt_len) {
                                ++skipped;
                                this.dis.readByte();
                            }
                        }
                    }
                    ++i;
                }
                tag_len = this.dis.readShort();
                if (tag_len > this.pRec.config.maxTagLength || tag_len <= 0) {
                    if (tag_len <= 0) {
                        this.pRec.rmmLogger.baseError("PacketProcessor found packet with invalid tag length " + tag_len + ", stream " + sid + " packet type " + packet_type + " options " + n_options + " " + length_of_options, null, moduleName);
                    }
                    this.pRec.rmmLogger.baseLog(420, new Object[]{this.packet.sourceAddr, "" + tag_len, "" + this.pRec.config.maxTagLength}, null, moduleName);
                    this.closeRejectedConnection(this.packet.source);
                    this.returnBuffer(this.packet);
                    continue;
                }
                int bytes_read = this.dis.read(this.tagBuf, 0, tag_len);
                if (bytes_read != tag_len) {
                    this.pRec.rmmLogger.baseError("Error when reading Tag, bytes_read " + bytes_read + " tag length " + tag_len + ", stream " + sid + " packet type " + packet_type + " options " + n_options + " " + length_of_options, null, moduleName);
                }
                if ((stream = this.fetchStream(stream_closed, this.packet, sid, tag_len, this.tagBuf)) == null) {
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (packet_type != 1) {
                    this.processContrPack(stream, stream_closed);
                    this.processHBPacket(this.packet, stream.cpTimeout, true);
                    this.returnBuffer(this.packet);
                    continue;
                }
                stream.packSeqN = packet_n;
                if (stream.firstPack) {
                    stream.frontSeqN = stream.packSeqN;
                    stream.trailSeqN = stream.packSeqN;
                    stream.lateJoin = false;
                    stream.firstPack = false;
                }
                if (stream.packSeqN != stream.trailSeqN) {
                    this.pRec.rmmLogger.baseError("Out of order packet in TCP stream " + stream.id + " . packet# " + stream.packSeqN + "trail# " + stream.trailSeqN, null, moduleName);
                    this.returnBuffer(this.packet);
                    continue;
                }
                stream.frontSeqN = stream.packSeqN;
                stream.trailSeqN = stream.packSeqN + 1;
                ++stream.pCounter;
                if (stream.pCounter % 100 == 0 && (trail_n = stream.frontSeqN - 1000) > 0 && stream.dataListener != null) {
                    stream.dataListener.onTrailAdvance(trail_n);
                }
                int pack_data_offset = 16 + tag_len + length_of_options;
                int pack_data_length = this.packet.getLength() - pack_data_offset;
                this.processHBPacket(this.packet, stream.cpTimeout, false);
                if (stream.dataSuspend) {
                    this.returnBuffer(this.packet);
                    continue;
                }
                if (stream.dataListener == null) {
                    stream.mySet.packetListener.onFirstPacket(stream, stream.packSeqN, this.buffer, pack_data_offset, pack_data_length, stream.lateJoin, stream.lateJoinMarkPos);
                } else {
                    stream.dataListener.onPacket(stream.packSeqN, this.buffer, pack_data_offset, pack_data_length);
                }
                this.returnBuffer(this.packet);
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketProcessor"}, ex, moduleName);
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketProcessor: Exception in thread loop", ex, moduleName);
                this.returnBuffer(this.packet);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketProcessor", null, moduleName);
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketProcessor"}, ex, moduleName);
                break;
            }
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketProcessor"}, null, moduleName);
    }
}

