/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.receiver;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tcp.receiver.PEvent;
import com.ibm.rmm.ptl.tcp.receiver.PReceiver;
import com.ibm.rmm.ptl.tcp.receiver.Packet;
import com.ibm.rmm.ptl.tcp.receiver.SocketDataHandler;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

class PacketReceiver
extends Thread {
    static final String moduleName = "PTL_TCP_R";
    PReceiver pRec;
    Selector theSelector;
    ServerSocketChannel serverSocketChannel;
    boolean isSleeping = false;
    ObjCyclQueue packetPool;
    ObjCyclQueue packetQueue;
    long lastExceptionTime;
    Object registerMutex;
    LinkedList registerRequests;
    boolean wakeupCalled;
    volatile int nRot;
    volatile int curPos;
    volatile int nWfb;
    volatile boolean threadStopped = false;
    private boolean goOn = true;

    PacketReceiver(PReceiver prc) throws Exception {
        this.pRec = prc;
        try {
            this.theSelector = Selector.open();
        }
        catch (IOException e2) {
            this.pRec.rmmLogger.baseError("Failed to open Selector", e2, moduleName);
            throw e2;
        }
        this.registerMutex = new Object();
        this.registerRequests = new LinkedList();
        this.packetPool = new ObjCyclQueue(this.pRec.config.nBuffers);
        int i = 0;
        while (i < this.pRec.config.nBuffers) {
            Packet pack = new Packet(this.pRec.config.packetSize);
            this.packetPool.pushLast(pack);
            ++i;
        }
        this.packetQueue = new ObjCyclQueue(this.pRec.config.nBuffers);
        if (this.pRec.config.serverPort == 0) {
            int local_port;
            this.serverSocketChannel = this.pRec.rmmAddress.getServerSocketChannel();
            if (!this.serverSocketChannel.isOpen()) {
                this.pRec.rmmLogger.baseError("PacketReceiver found serverPort = 0 but serverSocketChannel of rmmAddress is closed", null, moduleName);
                throw new Exception("PacketReceiver found null serverSocketChannel");
            }
            this.pRec.config.serverPort = local_port = this.pRec.rmmAddress.getServerSocketChannel().socket().getLocalPort();
            this.pRec.rmmLogger.baseWarn("PacketReceiver found serverPort = 0; will use port from rmmAddress, ServerPort = " + local_port, null, moduleName);
        } else {
            try {
                this.serverSocketChannel = ServerSocketChannel.open();
                this.serverSocketChannel.configureBlocking(false);
            }
            catch (IOException e3) {
                this.pRec.rmmLogger.baseError("Failed to open ServerSocketChannel", e3, moduleName);
                throw e3;
            }
            InetSocketAddress isa = this.pRec.config.bindAll ? new InetSocketAddress(this.pRec.config.serverPort) : new InetSocketAddress(this.pRec.rmmAddress.getInetAddress(), this.pRec.config.serverPort);
            try {
                this.serverSocketChannel.socket().bind(isa, 100);
            }
            catch (IOException e4) {
                this.pRec.rmmLogger.baseLog(414, new Object[]{"" + isa}, e4, moduleName);
                throw e4;
            }
        }
        try {
            this.pRec.rmmLogger.baseInfo("PacketReceiver started on Server port " + this.serverSocketChannel.socket().getLocalPort(), moduleName);
        }
        catch (RuntimeException e1) {
            this.pRec.rmmLogger.baseError("Failed to print local port", e1, moduleName);
        }
        try {
            this.serverSocketChannel.register(this.theSelector, 16);
        }
        catch (ClosedChannelException e5) {
            this.pRec.rmmLogger.baseError("Failed to register ServerSocket with Selector", e5, moduleName);
            throw e5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewConnection(UnicastConnection ucon, int port2) throws Exception {
        SocketChannel sc = ucon.getSocketChannel();
        if (sc == null || !sc.isOpen()) {
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxWarn("registerNewConnection called with closed socket " + sc.socket().getInetAddress() + " port " + port2, null, moduleName);
            }
            throw new IOException("registerNewConnection called with closed socket");
        }
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("registerNewConnection called socket " + sc.socket().getInetAddress() + " port " + port2 + ", ucon " + ucon, moduleName);
        }
        if (this.pRec.config.socketBufferSize > 0) {
            try {
                sc.socket().setReceiveBufferSize(this.pRec.config.socketBufferSize);
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseLog(413, new Object[]{"TCP ReceiveBufferSize", "" + this.pRec.config.socketBufferSize}, ex, moduleName);
            }
            int real_size = 0;
            try {
                real_size = sc.socket().getReceiveBufferSize();
            }
            catch (IOException ex) {
                this.pRec.rmmLogger.baseError("Failed to measure Socket RecBuffer", ex, moduleName);
            }
            if (real_size < this.pRec.config.socketBufferSize) {
                this.pRec.rmmLogger.baseWarn("Socket RecBufferSize set to " + real_size / 1024 + " Kbytes", null, moduleName);
                this.pRec.rmmLogger.baseLog(413, new Object[]{"TCP ReceiveBufferSize", "" + this.pRec.config.socketBufferSize}, null, moduleName);
            }
        }
        sc.configureBlocking(false);
        SocketDataHandler sdh = new SocketDataHandler();
        sdh.unicastConnection = ucon;
        sdh.socketChannel = sc;
        sdh.remoteIA = sc.socket().getInetAddress();
        if (sdh.remoteIA == null) {
            this.pRec.rmmLogger.baseWarn("Cannot retrieve a remote address. Incoming SocketChannel: " + sdh.socketChannel + ". Socket: " + sdh.socketChannel.socket() + ". Remote conn: " + sdh.socketChannel.socket().getRemoteSocketAddress(), null, moduleName);
        }
        if (port2 > 0) {
            sdh.remotePort = port2;
            sdh.unicastConnection.remoteServerPort = port2;
            sdh.gotRemotePort = true;
            boolean wait = sdh.unicastConnection.getRegisterStatus() == 2;
            sdh.unicastConnection.setRegisterStatus(1);
            Object ex = this.registerMutex;
            synchronized (ex) {
                this.registerRequests.addLast(sdh);
                this.wakeupSelector();
            }
            if (wait) {
                int counter = 0;
                int n_rots = this.nRot;
                while (sdh.unicastConnection.getRegisterStatus() == 1 && counter++ < 100) {
                    Thread.sleep(10L);
                    this.wakeupSelector();
                }
                if (sdh.unicastConnection.getRegisterStatus() != 4) {
                    this.pRec.rmmLogger.baseError("Failed to properly register Socket Channel after " + counter + " tries. PacketReciver nRot " + n_rots + " " + this.nRot + " curPos " + this.curPos, null, moduleName);
                    try {
                        sdh.socketChannel.socket().close();
                        sdh.socketChannel.close();
                    }
                    catch (IOException ex2) {
                        this.pRec.rmmLogger.baseError("Failed to properly close sdh.socketchannel after register failed (counter =" + counter + ").", ex2, moduleName);
                    }
                    catch (Throwable exp) {
                        this.pRec.rmmLogger.baseError("Error when closing sdh.socketchannel after register failed (counter =" + counter + ").", exp, moduleName);
                    }
                    throw new IOException("registerNewConnection failed to properly register Socket Channel after " + counter + " tries.");
                }
            }
        } else {
            SelectionKey sck = sc.register(this.theSelector, 1);
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("Register Inbound NewConnection socket " + sc.socket().getInetAddress() + " port " + port2, moduleName);
            }
            sck.attach(sdh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupSelector() {
        Object object = this.registerMutex;
        synchronized (object) {
            this.wakeupCalled = true;
            this.theSelector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerGobalSC() {
        SelectionKey sck = null;
        int n = 0;
        while (true) {
            SocketDataHandler tmpSdh;
            Object object = this.registerMutex;
            synchronized (object) {
                this.wakeupCalled = false;
                if (this.registerRequests.isEmpty()) {
                    break;
                }
                tmpSdh = (SocketDataHandler)this.registerRequests.removeFirst();
            }
            ++n;
            SocketChannel tmpSc = tmpSdh.unicastConnection.getSocketChannel();
            if (tmpSc == null) {
                this.pRec.rmmLogger.baseWarn("PacketReceiver.registerGobalSC: globalSc is null!", null, moduleName);
                tmpSdh.unicastConnection.setRegisterStatus(-1);
                continue;
            }
            if (!tmpSdh.unicastConnection.isValid()) {
                this.pRec.rmmLogger.baseWarn("PacketReceiver.registerGobalSC: unicastConnection.isValid() is false! " + tmpSdh.unicastConnection, null, moduleName);
                tmpSdh.unicastConnection.setRegisterStatus(-1);
                continue;
            }
            try {
                sck = tmpSc.register(this.theSelector, 1);
            }
            catch (Exception ex) {
                this.pRec.rmmLogger.baseError("PacketReceiver: Failed to register Outbound NewConnection socket " + tmpSc.socket().getInetAddress() + " port " + tmpSc.socket().getPort(), ex, moduleName);
                sck = null;
                tmpSdh.unicastConnection.setRegisterStatus(-1);
            }
            if (sck == null) continue;
            if (this.pRec.rmmLogger.isMaxLogLevel()) {
                this.pRec.rmmLogger.maxInfo("PacketReceiver: register Outbound NewConnection socket " + tmpSc.socket().getInetAddress() + " port " + tmpSc.socket().getPort(), moduleName);
            }
            sck.attach(tmpSdh);
            tmpSdh.unicastConnection.setRegisterStatus(4);
        }
        return n;
    }

    private boolean onFirstPacket(int n_total, SocketDataHandler sdh) {
        int rmm_signature = sdh.byteBuffer.getInt(0);
        if (rmm_signature != 1562696995) {
            this.pRec.rmmLogger.baseError("Invalid RMM_SIGNATURE " + rmm_signature + " (" + 1562696995 + ") extracted from first packet", null, moduleName);
            sdh.remotePort = 0;
            return false;
        }
        sdh.remotePort = sdh.byteBuffer.getInt(4);
        sdh.gotRemotePort = true;
        if (sdh.remotePort < 0 || sdh.remotePort > 65535) {
            this.pRec.rmmLogger.baseError("Invalid Remote ServerSocketPort (" + sdh.remotePort + ") extracted from first packet", null, moduleName);
            sdh.remotePort = 0;
            return false;
        }
        sdh.unicastConnection.setRemoteServerPort(sdh.remotePort);
        sdh.byteBuffer.position(8);
        sdh.byteBuffer.compact();
        sdh.byteBuffer.position(n_total);
        if (this.pRec.rmmLogger.isMaxLogLevel()) {
            this.pRec.rmmLogger.maxInfo("Resolved remote ServerPort (" + sdh.remotePort + "), for TCP connection from " + Sutils.printIsa((InetSocketAddress)sdh.socketChannel.socket().getRemoteSocketAddress()) + " ucon " + sdh.unicastConnection.toString(), moduleName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPackets(int n_total, SocketDataHandler sdh) throws InterruptedException {
        int offset = 4;
        int n_remaining = n_total - 4;
        while (sdh.gotLength && sdh.packetLength <= n_remaining) {
            Packet pack;
            if (this.packetPool.qSize() == 0) {
                PacketReceiver.yield();
            }
            ObjCyclQueue objCyclQueue = this.packetPool;
            synchronized (objCyclQueue) {
                while ((pack = (Packet)this.packetPool.popFirst()) == null) {
                    ++this.nWfb;
                    this.curPos = 71;
                    this.isSleeping = true;
                    this.packetPool.wait();
                    this.isSleeping = false;
                }
            }
            if (sdh.packetLength > this.pRec.config.packetSize || sdh.packetLength <= 0) {
                try {
                    String source = sdh.socketChannel.socket().getRemoteSocketAddress() + "/" + sdh.remotePort;
                    this.pRec.rmmLogger.baseLog(415, new Object[]{"" + sdh.packetLength, source}, null, moduleName);
                    this.pRec.rmmLogger.baseError("Packet with bad length received from " + Sutils.printIsa((InetSocketAddress)sdh.socketChannel.socket().getRemoteSocketAddress()) + ", packet length " + sdh.packetLength + ", config length " + this.pRec.config.packetSize, null, moduleName);
                    this.pRec.packetProcessor.returnBuffer(pack);
                    sdh.unicastConnection.closeConnection(0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            System.arraycopy(sdh.byteArray, offset, pack.buffer, 0, sdh.packetLength);
            pack.length = sdh.packetLength;
            pack.source = sdh.socketChannel;
            pack.ucon = sdh.unicastConnection;
            pack.sourceAddr = sdh.remoteIA;
            pack.sourcePort = sdh.remotePort;
            objCyclQueue = this.packetQueue;
            synchronized (objCyclQueue) {
                this.packetQueue.pushLast(pack);
                if (this.pRec.packetProcessor.isSleeping) {
                    this.packetQueue.notify();
                }
            }
            offset += sdh.packetLength;
            if ((n_remaining -= sdh.packetLength) >= 4) {
                sdh.packetLength = sdh.byteBuffer.getInt(offset);
                offset += 4;
                n_remaining -= 4;
                continue;
            }
            sdh.gotLength = false;
        }
        this.curPos = 72;
        if (sdh.gotLength) {
            offset -= 4;
            n_remaining += 4;
        }
        System.arraycopy(sdh.byteArray, offset, sdh.byteArray, 0, n_remaining);
        sdh.byteBuffer.position(n_remaining);
    }

    private boolean replaceSelector() {
        try {
            Set<SelectionKey> selector_keys = this.theSelector.keys();
            Iterator<SelectionKey> iter = selector_keys.iterator();
            while (iter.hasNext()) {
                SocketChannel sc;
                SelectionKey key = iter.next();
                SocketDataHandler handler2 = (SocketDataHandler)key.attachment();
                if (handler2 == null || (sc = handler2.socketChannel) == null) continue;
                handler2.unicastConnection.closeConnection(0);
                this.pRec.rmmLogger.baseInfo("RacketReceiver.replaceSelector: Closing SocketChannel to " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + ".\n", moduleName);
                try {
                    sc.socket().close();
                    sc.close();
                }
                catch (IOException e1) {
                    this.pRec.rmmLogger.baseError("RacketReceiver.replaceSelector: failed to close serverSocketChannel", e1, moduleName);
                }
            }
        }
        catch (Throwable e2) {
            this.pRec.rmmLogger.baseError("RacketReceiver.replaceSelector: error when closing SocketChannels", e2, moduleName);
        }
        try {
            this.theSelector.close();
        }
        catch (Exception e1) {
            this.pRec.rmmLogger.baseError("PacketReceiver failed to close selector after detected broken", e1, moduleName);
            return false;
        }
        try {
            this.theSelector = Selector.open();
        }
        catch (Exception e2) {
            this.pRec.rmmLogger.baseError("PacketReceiver failed to open new selector after old selector detected broken", e2, moduleName);
            return false;
        }
        try {
            this.serverSocketChannel.register(this.theSelector, 16);
        }
        catch (Exception e3) {
            this.pRec.rmmLogger.baseError("PacketReceiver failed to register serverSocketChannel on new selector", e3, moduleName);
            return false;
        }
        return true;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.pRec.rmmLogger.baseLog(1, new Object[]{"PacketReceiver"}, null, "PTL_TCP_R");
        exc_count = 0;
        emptySelectAttempts = 0;
        selectorBreakTime = 0L;
        socket_closed = false;
        this.pRec.rmmLogger.baseInfo("PacketReceiver: waiting for StreamSets.", "PTL_TCP_R");
        loops = 200;
        while (this.pRec.packetProcessor == null || this.pRec.packetProcessor != null && this.pRec.packetProcessor.getSetNumber() == 0) {
            if (--loops <= 0) break;
            try {
                PacketReceiver.sleep(50L);
            }
            catch (InterruptedException e1) {
                break;
            }
        }
        try {
            PacketReceiver.sleep(50L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (this.pRec.packetProcessor != null) {
            this.pRec.rmmLogger.baseInfo("PacketReceiver: starting main loop, nSets " + this.pRec.packetProcessor.getSetNumber(), "PTL_TCP_R");
        } else {
            this.pRec.rmmLogger.baseWarn("PacketReceiver: starting main loop, packetProcessor is null.", null, "PTL_TCP_R");
        }
        while (this.goOn) {
            ++this.nRot;
            try {
                this.curPos = 1;
                try {
                    this.theSelector.select();
                }
                catch (IOException ex) {
                    this.pRec.rmmLogger.baseError("PacketReceiver: IOException in theSelector.select.", ex, "PTL_TCP_R");
                }
                catch (NullPointerException ex1) {
                    this.pRec.rmmLogger.baseWarn("PacketReceiver: NullPointer at sun.nio.ch.WindowsSelectorImpl, Bug: 4729342. Ignoring", ex1, "PTL_TCP_R");
                    continue;
                }
                catch (Exception ex2) {
                    this.pRec.rmmLogger.baseError("PacketReceiver: Exception in theSelector.select.", ex2, "PTL_TCP_R");
                }
                ready_keys = this.theSelector.selectedKeys();
                this.curPos = 11;
                if (ready_keys.isEmpty() && !this.wakeupCalled) {
                    this.curPos = 12;
                    if (emptySelectAttempts++ == 3) {
                        selectorBreakTime = System.currentTimeMillis();
                    }
                    if (emptySelectAttempts <= 200) continue;
                    this.curPos = 13;
                    diff = System.currentTimeMillis() - selectorBreakTime;
                    PacketReceiver.sleep(10L);
                    if (diff > 100L || diff < 0L) {
                        this.pRec.rmmLogger.baseWarn("PacketReceiver: selector possible problem, not replacing selector " + emptySelectAttempts + " " + diff, null, "PTL_TCP_R");
                        emptySelectAttempts = 0;
                    } else {
                        ex1 = new Exception("PacketReceiver: selector problem! replacing selectorr " + emptySelectAttempts + " " + diff);
                        this.pRec.rmmLogger.baseLog(421, new Object[]{"PacketReceiver"}, ex1, "PTL_TCP_R");
                        this.curPos = 14;
                        this.pRec.rmmLogger.baseError("PacketReceiver: selector problem, replacing selector " + emptySelectAttempts + " " + diff, null, "PTL_TCP_R");
                        if (this.replaceSelector()) {
                            this.pRec.rmmLogger.baseWarn("PacketReceiver: selector replaced after problem " + emptySelectAttempts + " " + diff, null, "PTL_TCP_R");
                            ex = new Exception("PacketReceiver: selector problem, replacing selector " + emptySelectAttempts + " " + diff);
                            this.pRec.rmmLogger.baseLog(421, new Object[]{this.pRec.rmmAddress.toString()}, ex, "PTL_TCP_R");
                        } else {
                            this.pRec.rmmLogger.baseError("PacketReceiver: could not replace broken selector " + emptySelectAttempts + " " + diff, null, "PTL_TCP_R");
                            ex = new Exception("PacketReceiver: could not replace broken selector " + emptySelectAttempts + " " + diff);
                            this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketReceiver"}, ex, "PTL_TCP_R");
                            break;
                        }
                    }
                    emptySelectAttempts = 0;
                    continue;
                }
                this.curPos = 2;
                this.registerGobalSC();
                iter = ready_keys.iterator();
                this.curPos = 21;
                try lbl-1000:
                // 14 sources

                {
                    while (iter.hasNext()) {
                        block59: {
                            this.registerGobalSC();
                            key = iter.next();
                            iter.remove();
                            if (key == null || !key.isValid()) continue;
                            if (key.isAcceptable()) {
                                try {
                                    sc = this.serverSocketChannel.accept();
                                }
                                catch (IOException ex) {
                                    this.pRec.rmmLogger.baseError("Error in PacketReceiver accept()", ex, "PTL_TCP_R");
                                    continue;
                                }
                                this.curPos = 3;
                                if (sc == null) continue;
                                try {
                                    ucon = new UnicastConnection(sc.socket().getInetAddress(), sc.socket().getPort(), sc.socket().getLocalPort(), 1, sc, false);
                                    this.registerNewConnection(ucon, -1);
                                }
                                catch (Exception ex) {
                                    if (ex instanceof InterruptedException) {
                                        throw ex;
                                    }
                                    this.pRec.rmmLogger.baseError("Failed to register new connection from " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + ", closing socket.", ex, "PTL_TCP_R");
                                    try {
                                        sc.close();
                                    }
                                    catch (IOException e1) {
                                        this.pRec.rmmLogger.baseError("Failed to close sc after register failed.", e1, "PTL_TCP_R");
                                    }
                                    continue;
                                }
                                this.pRec.rmmLogger.baseInfo("Got TCP connection from " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()), "PTL_TCP_R");
                                continue;
                            }
                            if (!key.isReadable()) continue;
                            this.curPos = 4;
                            sc = (SocketChannel)key.channel();
                            sdh = (SocketDataHandler)key.attachment();
                            if (sdh == null) continue;
                            try {
                                read_bytes = sc.read(sdh.byteBuffer);
                            }
                            catch (Exception ex) {
                                socket_closed = true;
                                this.pRec.rmmLogger.baseWarn("Connection closed by " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + "||" + sdh.remotePort + ".\n" + ex, null, "PTL_TCP_R");
                                read_bytes = 0;
                            }
                            if (read_bytes < 0) {
                                socket_closed = true;
                                this.pRec.rmmLogger.baseWarn("Connection closed by " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + "||" + sdh.remotePort + " (read_bytes " + read_bytes + ").\n", null, "PTL_TCP_R");
                            }
                            this.curPos = 5;
                            if (!socket_closed) break block59;
                            if (this.pRec.myPTransmitter != null) {
                                this.pRec.myPTransmitter.receiverReportConnection(null, null, true, sdh.unicastConnection);
                            }
                            this.curPos = 51;
                            key.cancel();
                            this.pRec.packetProcessor.connectionsHT.remove(sc);
                            streams = this.pRec.packetProcessor.streamHash.getValues();
                            i = 0;
                            if (true) ** GOTO lbl196
                        }
                        this.curPos = 6;
                        n_total = sdh.byteBuffer.position();
                        if (!sdh.gotRemotePort) {
                            if (n_total < 8) continue;
                            this.onFirstPacket(n_total -= 8, sdh);
                        }
                        this.curPos = 61;
                        if (!sdh.gotLength) {
                            if (n_total < 4) continue;
                            sdh.packetLength = sdh.byteBuffer.getInt(0);
                            sdh.gotLength = true;
                            if (sdh.packetLength > this.pRec.config.packetSize || sdh.packetLength <= 0) {
                                source = sdh.socketChannel.socket().getRemoteSocketAddress() + "/" + sdh.remotePort;
                                this.pRec.rmmLogger.baseLog(415, new Object[]{"" + sdh.packetLength, source}, null, "PTL_TCP_R");
                                this.pRec.rmmLogger.baseError("Connection closed to " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + "||" + sdh.remotePort + ", due to invalid packet length " + sdh.packetLength + ", config length " + this.pRec.config.packetSize, null, "PTL_TCP_R");
                                if (this.pRec.myPTransmitter != null) {
                                    this.pRec.myPTransmitter.receiverReportConnection(null, null, true, sdh.unicastConnection);
                                }
                                key.cancel();
                                try {
                                    sc.socket().close();
                                    sc.close();
                                }
                                catch (Throwable ex) {
                                    this.pRec.rmmLogger.baseWarn("PacketReceiver Failed to close socket channel" + ex, null, "PTL_TCP_R");
                                }
                                sdh.unicastConnection.closeConnection(0);
                                continue;
                            }
                        }
                        this.curPos = 7;
                        if (sdh.packetLength <= n_total - 4) {
                            this.extractPackets(n_total, sdh);
                        }
                        this.curPos = 8;
                    }
                    continue;
                }
                catch (CancelledKeyException ex) {
                    this.pRec.rmmLogger.baseWarn("PacketReceiver: CancelledKeyException", ex, "PTL_TCP_R");
                    selected_keys = this.theSelector.selectedKeys();
                    itr = selected_keys.iterator();
                    if (true) ** GOTO lbl212
                }
                catch (NoSuchElementException ex1) {
                    this.pRec.rmmLogger.baseWarn("PacketReceiver: NoSuchElementException", ex1, "PTL_TCP_R");
                    continue;
                }
            }
            catch (Throwable ex) {
                if (!this.pRec.isRunning || this.isInterrupted() || ex instanceof InterruptedException || ex instanceof InterruptedIOException) {
                    if (!this.pRec.isRunning) break;
                    this.pRec.rmmLogger.baseLog(406, new Object[]{"PacketReceiver"}, ex, "PTL_TCP_R");
                    break;
                }
                this.pRec.rmmLogger.baseError("PacketReceiver: Exception in thread loop, curPos " + this.curPos, ex, "PTL_TCP_R");
                time = Clock.getTime();
                if (time - this.lastExceptionTime > 500L) {
                    exc_count = 0;
                }
                this.lastExceptionTime = time;
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pRec.rmmLogger.baseError("Too many exceptions. Stop PacketReceiver", null, "PTL_TCP_R");
                this.pRec.rmmLogger.baseLog(416, new Object[]{"PacketReceiver"}, ex, "PTL_TCP_R");
                break;
            }
            do {
                if (streams[i].socketChannel.equals(sc)) {
                    ev = new PEvent(5, streams[i]);
                    streams[i].mySet.packetListener.onEvent(ev);
                    streams[i].heartbeatTimeout = true;
                }
                ++i;
lbl196:
                // 2 sources

            } while (i < streams.length);
            this.curPos = 52;
            try {
                sc.socket().close();
                sc.close();
            }
            catch (Throwable ex) {
                this.pRec.rmmLogger.baseWarn("PacketReceiver Failed to close socket channel after socket_closed." + ex, null, "PTL_TCP_R");
            }
            sdh.unicastConnection.closeConnection(0);
            socket_closed = false;
            ** GOTO lbl-1000
            do {
                itr.next();
                itr.remove();
lbl212:
                // 2 sources

            } while (itr.hasNext());
        }
        try {
            selector_keys = this.theSelector.keys();
            iter = selector_keys.iterator();
            while (iter.hasNext()) {
                key = iter.next();
                handler = (SocketDataHandler)key.attachment();
                if (handler == null || (sc = handler.socketChannel) == null) continue;
                this.pRec.rmmLogger.baseInfo("Receiver Exit: Closing SocketChannel to " + Sutils.printIsa((InetSocketAddress)sc.socket().getRemoteSocketAddress()) + ".\n", "PTL_TCP_R");
                try {
                    sc.socket().close();
                    sc.close();
                }
                catch (IOException e1) {
                    this.pRec.rmmLogger.baseError("PacketReceiver (on exit): failed to close serverSocketChannel", e1, "PTL_TCP_R");
                }
            }
        }
        catch (Throwable e2) {
            this.pRec.rmmLogger.baseError("PacketReceiver (on exit): error when closing SocketChannels", e2, "PTL_TCP_R");
        }
        try {
            this.theSelector.close();
            this.pRec.rmmLogger.maxInfo("PacketReceiver closed selector on Exit", "PTL_TCP_R");
        }
        catch (Throwable e) {
            this.pRec.rmmLogger.baseError("PacketReceiver: failed to close selector", e, "PTL_TCP_R");
        }
        try {
            this.serverSocketChannel.socket().close();
            this.serverSocketChannel.close();
        }
        catch (Throwable e) {
            this.pRec.rmmLogger.baseError("PacketReceiver: failed to close serverSocketChannel", e, "PTL_TCP_R");
        }
        this.threadStopped = true;
        this.pRec.rmmLogger.baseLog(2, new Object[]{"PacketReceiver"}, null, "PTL_TCP_R");
    }
}

