/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tcp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tcp.transmitter.StreamT;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedList;

class CheckConnectionPending
extends Thread {
    static final String moduleName = "PTL_TCP_T";
    private PTransmitter pTrans;
    volatile int nRot;
    volatile int nPos;
    private boolean goOn;
    private int exc_count;
    private ArrayList recheck = new ArrayList();

    CheckConnectionPending(PTransmitter ptr) {
        this.pTrans = ptr;
        this.goOn = true;
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"CheckConnectionPending"}, null, moduleName);
        StreamT stream = null;
        long lastcheck = Clock.getTime();
        while (this.goOn) {
            ++this.nRot;
            try {
                this.nPos = 0;
                LinkedList linkedList = this.pTrans.pendingConnectionStreams;
                synchronized (linkedList) {
                    int i;
                    if (this.recheck.size() > 0 && Clock.getTime() > lastcheck + 1000L) {
                        i = 0;
                        while (i < this.recheck.size()) {
                            this.pTrans.pendingConnectionStreams.addLast(this.recheck.get(i));
                            ++i;
                        }
                        this.recheck.clear();
                        lastcheck = Clock.getTime();
                    }
                    while (this.goOn && this.pTrans.pendingConnectionStreams.isEmpty()) {
                        if (this.recheck.size() > 0) {
                            i = 0;
                            while (i < this.recheck.size()) {
                                this.pTrans.pendingConnectionStreams.addLast(this.recheck.get(i));
                                ++i;
                            }
                            this.recheck.clear();
                            lastcheck = Clock.getTime();
                            this.pTrans.pendingConnectionStreams.wait(1000L);
                            continue;
                        }
                        this.pTrans.pendingConnectionStreams.wait();
                    }
                    if (!this.goOn) {
                        break;
                    }
                    stream = (StreamT)this.pTrans.pendingConnectionStreams.removeFirst();
                }
                this.nPos = 1;
                if (stream == null) continue;
                UnicastConnection ucon = stream.unicastConnection;
                if (!stream.pendingConnection || ucon == null) continue;
                boolean connected = false;
                try {
                    this.nPos = 2;
                    connected = ucon.getRegisterStatus() == 0 ? this.finishConnect(stream) : true;
                }
                catch (Exception e2) {
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("Finish connect threw an exception when trying to connect to " + Sutils.printIsa(ucon.inetSocketAddress) + " stream " + stream.longId + " exception: " + e2, moduleName);
                    }
                    this.nPos = 3;
                    this.cleanAfterFailure(ucon, stream, false);
                    if (!(e2 instanceof InterruptedException)) continue;
                    break;
                }
                this.nPos = 4;
                if (connected && ucon.getRegisterStatus() == 4) {
                    stream.pendingConnection = false;
                    ucon.updateLocalPort();
                    this.nPos = 5;
                    ucon.createConnectionListener.onSuccess();
                    if (!stream.isActive) {
                        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                            this.pTrans.rmmLogger.maxInfo("stream closed from onSuccess " + stream.longId + ", ucon " + ucon, moduleName);
                        }
                        this.nPos = 6;
                        this.pTrans.closeConnection(ucon);
                        continue;
                    }
                    this.nPos = 7;
                    this.pTrans.gdAdd(ucon);
                    stream.destination = ucon.socketChannel;
                    stream.openTime = Clock.getTime();
                    this.pTrans.sendSnp = 5;
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("Finish establishing a TCP Connection.  stream " + stream.longId + ", ucon " + ucon, moduleName);
                    }
                    this.pTrans.streamFireout.wakeUp(stream);
                    continue;
                }
                if (ucon.timeout > 0 && Clock.getTime() > ucon.timeCreated + (long)ucon.timeout) {
                    this.pTrans.rmmLogger.baseWarn("Timeout on connection establishment stream " + stream.longId + ". Connection timeout " + ucon.timeout + " regStatus " + ucon.getRegisterStatus() + " " + ucon, null, moduleName);
                    this.nPos = 8;
                    this.cleanAfterFailure(ucon, stream, true);
                    continue;
                }
                this.recheck.add(stream);
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"CheckConnectionPending"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("CheckConnectionPending: Exception in thread loop", ex, moduleName);
                ++this.exc_count;
                if (this.exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop CheckConnectionPending", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"CheckConnectionPending"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"CheckConnectionPending"}, null, moduleName);
    }

    private boolean finishConnect(StreamT stream) throws Exception {
        boolean connected = false;
        if (stream == null) {
            return false;
        }
        UnicastConnection ucon = stream.unicastConnection;
        if (ucon == null) {
            return false;
        }
        SocketChannel sock = ucon.socketChannel;
        InetSocketAddress dest = ucon.inetSocketAddress;
        if (sock == null) {
            return false;
        }
        connected = sock.finishConnect();
        if (connected) {
            if (ucon.timeout > 0) {
                ucon.timeCreated = Clock.getTime();
            }
            if (!this.pTrans.setConnectionProperties(sock, dest)) {
                this.pTrans.rmmLogger.baseError("Failed to setConnectionProperties after establishing a TCP connection to " + Sutils.printIsa(dest), null, moduleName);
                IOException ioex = new IOException("Failed to setConnectionProperties");
                throw ioex;
            }
            try {
                this.pTrans.writeServerPort(sock);
            }
            catch (IOException e1) {
                this.pTrans.rmmLogger.baseWarn("Failed to write Port number after establishing a TCP connection to " + Sutils.printIsa(dest), e1, moduleName);
                throw e1;
            }
            if (this.pTrans.myPReceiver != null) {
                try {
                    ucon.setRegisterStatus(3);
                    this.pTrans.myPReceiver.registerNewConnection(ucon, dest.getAddress(), dest.getPort());
                }
                catch (Exception ex) {
                    if (ex instanceof InterruptedException) {
                        this.pTrans.rmmLogger.baseError("Interrupted while trying to register new TCP connection with PacketReceiver (" + Sutils.printIsa(dest) + ", Local port: " + sock.socket().getLocalPort() + ").", ex, moduleName);
                    } else {
                        this.pTrans.rmmLogger.baseError("Failed to register new TCP connection with PacketReceiver (" + Sutils.printIsa(dest) + ", Local port: " + sock.socket().getLocalPort() + ").", ex, moduleName);
                    }
                    throw ex;
                }
            }
            if (stream.connectionClosed) {
                this.pTrans.rmmLogger.baseWarn("found closed stream in finish connect (" + Sutils.printIsa(dest) + ", Local port: " + sock.socket().getLocalPort() + ").", null, moduleName);
                IOException ioex = new IOException("found closed stream in finish connect");
                throw ioex;
            }
        }
        return connected;
    }

    private void cleanAfterFailure(UnicastConnection ucon, StreamT stream, boolean timeout) {
        long s_id = stream.getId();
        boolean res = ucon.createConnectionListener.closeTopic();
        if (!res) {
            this.pTrans.rmmLogger.baseError("Failed to close stream when trying to remove, stream id " + s_id + " (timeout " + timeout + ")", null, moduleName);
        }
        ucon.createConnectionListener.onFailure();
        stream.pendingConnection = false;
        ucon.closeConnection(0);
        try {
            ucon.socketChannel.socket().close();
            ucon.socketChannel.close();
        }
        catch (IOException exp) {
            this.pTrans.rmmLogger.baseError("Failed to close Socket Channel (timeout " + timeout + ")" + Sutils.printIsa(ucon.inetSocketAddress), exp, moduleName);
        }
        catch (Throwable ex) {
            this.pTrans.rmmLogger.baseError("Error when closing Socket Channel (timeout " + timeout + ")" + Sutils.printIsa(ucon.inetSocketAddress), ex, moduleName);
        }
    }

    public int getWaiting() {
        return this.pTrans.pendingConnectionStreams.size() + this.recheck.size();
    }
}

