/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.PacManOut;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tcp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tcp.transmitter.StreamT;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

class ControlPacketSender
extends Thread {
    static final String moduleName = "PTL_TCP_T";
    PTransmitter pTrans;
    volatile int nRot;
    volatile int curPos;
    int bytes_read = 0;
    ByteBuffer bb;
    private boolean goOn = true;

    ControlPacketSender(PTransmitter ptr) {
        this.pTrans = ptr;
        this.bb = ByteBuffer.allocate(4);
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exc_count = 0;
        ArrayList<SocketChannel> dests = new ArrayList<SocketChannel>();
        PacManOut pmo = new PacManOut();
        UnicastConnection[] ucons = null;
        int m = 0;
        int ncons = 0;
        int npos = 0;
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"ControlPacketSender"}, null, moduleName);
        this.curPos = 1;
        int sleep_time = this.pTrans.config.heartbeatInterval;
        while (this.goOn) {
            ++this.nRot;
            this.curPos = 2;
            try {
                StreamT stream;
                ControlPacketSender.sleep(sleep_time);
                this.curPos = 25;
                if (!this.pTrans.config.tcpKeepAlive) {
                    if (this.pTrans.config.perConnectionHB) {
                        boolean isSnp;
                        boolean bl = isSnp = this.pTrans.sendSnp > 0 || this.pTrans.myPReceiver != null && this.pTrans.myPReceiver.updSendSnp(0) > 0;
                        if (isSnp) {
                            --this.pTrans.sendSnp;
                            if (this.pTrans.myPReceiver != null) {
                                this.pTrans.myPReceiver.updSendSnp(-1);
                            }
                            ++this.pTrans.snpCount;
                        }
                        ++this.pTrans.ccpCount;
                        ArrayList arrayList = this.pTrans.globalDestinations;
                        synchronized (arrayList) {
                            if (this.pTrans.gdUpdated) {
                                ncons = this.pTrans.globalDestinations.size();
                                if (ucons == null || ucons.length < ncons) {
                                    ucons = new UnicastConnection[(ncons + 15) / 16 * 16];
                                }
                                int i = 0;
                                while (i < ncons) {
                                    ucons[i] = (UnicastConnection)this.pTrans.globalDestinations.get(i);
                                    ++i;
                                }
                                this.pTrans.gdUpdated = false;
                            }
                        }
                        int i = 0;
                        while (i < ncons) {
                            block58: {
                                UnicastConnection ucon = ucons[i];
                                if (ucon != null) {
                                    if (!ucon.isValid) {
                                        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                                            this.pTrans.rmmLogger.baseWarn("SendControlPacket: Found invalid ucon: " + ucon, null, moduleName);
                                        }
                                        this.pTrans.streamFireout.closedConnections.add(ucon);
                                        this.pTrans.streamFireout.wakeUp(null);
                                    } else {
                                        try {
                                            pmo.reset();
                                            pmo.writeInt(0);
                                            pmo.writeByte(100);
                                            pmo.writeByte(5);
                                            if (!this.pTrans.config.tcpKeepAlive) {
                                                pmo.writeShort(this.pTrans.config.cpTimeout / 1000);
                                            } else {
                                                pmo.writeShort(-1);
                                            }
                                            if (isSnp) {
                                                pmo.writeByte(6);
                                                npos = pmo.getPosition();
                                                pmo.writeInt(0);
                                            }
                                            int n = 0;
                                            boolean cp_pending = false;
                                            StreamT send_stream = null;
                                            int j = this.pTrans.nStreams - 1;
                                            while (j >= 0) {
                                                stream = this.pTrans.streamList[j];
                                                if (stream != null && stream.destination != null && !stream.isClosed && stream.unicastConnection == ucon) {
                                                    if (stream.controlPacket != null) {
                                                        this.pTrans.streamFireout.wakeUp(stream);
                                                        cp_pending = true;
                                                        if (!this.pTrans.rmmLogger.isMaxLogLevel()) break;
                                                        this.pTrans.rmmLogger.baseWarn("SendControlPacket: Could not send CP, stream.controlPacket != null , stream= " + stream.longId + " dest= " + Sutils.printIsa(ucon.inetSocketAddress), null, moduleName);
                                                        break;
                                                    }
                                                    if (send_stream == null) {
                                                        send_stream = stream;
                                                    }
                                                    if (!isSnp) break;
                                                    pmo.writeLong(stream.longId);
                                                    ++n;
                                                }
                                                --j;
                                            }
                                            if (cp_pending) break block58;
                                            if (send_stream == null) {
                                                if (ucon.isValid()) {
                                                    this.pTrans.rmmLogger.baseWarn("SendControlPacket: No active streams on a valid connection to destination " + ucon, null, moduleName);
                                                }
                                                break block58;
                                            }
                                            if (isSnp) {
                                                if (n <= 0) {
                                                    this.pTrans.rmmLogger.baseWarn("SendControlPacket: No active streams on a valid connection ucon " + ucon, null, moduleName);
                                                    break block58;
                                                }
                                                int mpos = pmo.getPosition();
                                                pmo.setPosition(npos);
                                                pmo.writeInt(n);
                                                pmo.setPosition(mpos);
                                                m = 0;
                                                if (this.pTrans.myPReceiver != null) {
                                                    m = this.pTrans.myPReceiver.getConnStreams(ucon, pmo);
                                                    if (m < 0) {
                                                        this.pTrans.rmmLogger.baseError("SendControlPacket: myPReceiver.getConnStreams failed for destination " + Sutils.printIsa(ucon.inetSocketAddress), null, moduleName);
                                                        break block58;
                                                    }
                                                } else {
                                                    pmo.writeInt(0);
                                                }
                                            }
                                            int len = pmo.getPosition() - 4;
                                            pmo.reset();
                                            pmo.writeInt(len);
                                            pmo.safeSkip(len);
                                            send_stream.controlPacket = new RmmBuffer(pmo.toByteArray());
                                            this.pTrans.streamFireout.wakeUp(send_stream);
                                            if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                                                if (isSnp) {
                                                    this.pTrans.rmmLogger.maxInfo("Connection HB Packet written with " + n + " T_streams and " + m + " R_streams for destination " + Sutils.printIsa(ucon.inetSocketAddress) + " , stream " + send_stream, moduleName);
                                                } else {
                                                    this.pTrans.rmmLogger.maxInfo("Connection HB Packet written for destination " + Sutils.printIsa(ucon.inetSocketAddress) + " , stream " + send_stream, moduleName);
                                                }
                                            }
                                        }
                                        catch (Exception ex) {
                                            this.pTrans.rmmLogger.baseError("SendControlPacket: Exception while building HB for destination " + Sutils.printIsa(ucon.inetSocketAddress), ex, moduleName);
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        SocketChannel schan = null;
                        dests.clear();
                        int i = this.pTrans.nStreams - 1;
                        while (i >= 0) {
                            stream = this.pTrans.streamList[i];
                            if (stream != null && stream.destination != null && !stream.isClosed) {
                                this.curPos = 31;
                                if (stream.controlPacket != null) {
                                    this.pTrans.streamFireout.wakeUp(stream);
                                } else {
                                    boolean send_cp;
                                    schan = stream.destination;
                                    boolean bl = send_cp = !this.pTrans.config.perConnectionHB;
                                    if (schan != null && !dests.contains(schan)) {
                                        dests.add(schan);
                                        send_cp = true;
                                    }
                                    if (send_cp && stream.bytesTransmitted - stream.last_bytesTransmitted <= 0L) {
                                        if (!stream.isClosed && stream.controlPacket == null) {
                                            this.curPos = 4;
                                            stream.writeCP(this.pTrans.config.perConnectionHB);
                                            if (schan != null && this.pTrans.rmmLogger.isMaxLogLevel()) {
                                                InetSocketAddress cp_dest = (InetSocketAddress)schan.socket().getRemoteSocketAddress();
                                                this.pTrans.rmmLogger.maxInfo("Connection HB Packet written for destination " + Sutils.printIsa(cp_dest), moduleName);
                                            }
                                        } else if (stream.controlPacket != null && this.pTrans.rmmLogger.isMaxLogLevel()) {
                                            this.pTrans.rmmLogger.maxWarn("Could not send CP, stream.controlPacket != null, stream " + stream.longId, null, moduleName);
                                        }
                                        this.curPos = 41;
                                    } else if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                                        if (send_cp) {
                                            this.pTrans.rmmLogger.maxInfo("Avoid sending CP, data sent on stream " + stream.longId, moduleName);
                                        } else {
                                            this.pTrans.rmmLogger.maxInfo("Avoid sending CP, heartbeat sent on connection, stream " + stream.longId, moduleName);
                                        }
                                    }
                                    stream.last_bytesTransmitted = stream.bytesTransmitted;
                                }
                            }
                            --i;
                        }
                        dests.clear();
                    }
                }
                this.curPos = 42;
                if (!this.pTrans.config.tcpKeepAlive || !this.pTrans.config.oneWayConnections) continue;
                int i = this.pTrans.nStreams - 1;
                while (i >= 0) {
                    stream = this.pTrans.streamList[i];
                    if (stream != null && stream.destination != null) {
                        this.curPos = 51;
                        SocketChannel destination = stream.destination;
                        this.bb.rewind();
                        try {
                            this.curPos = 6;
                            this.bytes_read = destination.read(this.bb);
                        }
                        catch (IOException ex) {
                            InetSocketAddress dest = (InetSocketAddress)destination.socket().getRemoteSocketAddress();
                            this.pTrans.rmmLogger.baseWarn("Exception when reading from socket (" + this.bytes_read + ") for connection to " + Sutils.printIsa(dest) + ".\n", ex, moduleName);
                            stream.writeCP(false);
                            this.bytes_read = 0;
                        }
                        this.curPos = 7;
                        if (this.bytes_read < 0) {
                            InetSocketAddress dest = (InetSocketAddress)destination.socket().getRemoteSocketAddress();
                            this.pTrans.rmmLogger.baseWarn("Failed to read from socket (" + this.bytes_read + ") for connection to " + Sutils.printIsa(dest) + ".\n", null, moduleName);
                            stream.writeCP(false);
                        }
                    }
                    --i;
                }
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"ControlPacketSender"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("ControlPacketSender: Exception in thread loop", ex, moduleName);
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop ControlPacketSender", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"ControlPacketSender"}, ex, moduleName);
                break;
            }
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"ControlPacketSender"}, null, moduleName);
    }
}

