/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.BufferPool;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TaskIf;
import com.ibm.rmm.intrn.util.TaskManager;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.receiver.PReceiverIf;
import com.ibm.rmm.ptl.ifc.transmitter.PTransmitterIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.tcp.transmitter.CheckConnectionPending;
import com.ibm.rmm.ptl.tcp.transmitter.Config;
import com.ibm.rmm.ptl.tcp.transmitter.ControlPacketSender;
import com.ibm.rmm.ptl.tcp.transmitter.PacketFireout;
import com.ibm.rmm.ptl.tcp.transmitter.StreamT;
import com.ibm.rmm.ptl.tcp.transmitter.TEvent;
import com.ibm.rmm.ptl.tcp.transmitter.TimingThread;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.RmmAddress;
import com.ibm.rmm.util.RmmLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class PTransmitter
implements PTransmitterIf {
    static final String moduleName = "PTL_TCP_T";
    PReceiverIf myPReceiver;
    RmmLogger rmmLogger;
    RmmAddress rmmAddress;
    TaskManager taskMan;
    Config config;
    byte[] ipAddress;
    BufferPool bufferPool;
    Object pendingWaitMutex = new Object();
    boolean logError;
    int packetSize;
    int ptlHeaderSize;
    int tracingLevel;
    TokenBucket tokenBucket;
    int maxTrans;
    int nPending;
    int nPendingMax;
    InetAddress localInterf;
    Object streamListLock;
    private int nStreamsMax;
    StreamT[] streamList;
    int nStreams;
    ArrayList globalDestinations;
    boolean gdUpdated;
    Object globalLock;
    LinkedList pendingConnectionStreams;
    Vector pendingClosedStreams;
    Vector rateLimitStreams;
    RemoveClosedStreams rcsTask;
    CheckConnectionPending checkConnectionPending;
    CheckLostMsg clmTask;
    CheckLimitedStreams clsTask;
    int nUpd;
    boolean isRunning;
    private short idSeed;
    int nackPort;
    PacketFireout streamFireout;
    ControlPacketSender controlPacketSender;
    TimingThread timingThrd;
    int sendSnp;
    int snpCount = 0;
    int ccpCount = 0;
    byte[] heartbeatPacket;

    public boolean init(RmmAddress radr, RmmLogger rlog, TaskManager tman, Properties config_props, Map config_map, short max_packet_size, InetAddress interf) {
        try {
            this.rmmAddress = radr;
            this.rmmLogger = rlog;
            this.taskMan = tman;
            this.packetSize = max_packet_size;
            this.ptlHeaderSize = 24;
            this.config = new Config(rlog, config_props);
            if (!this.config.isOK) {
                return false;
            }
            this.nPendingMax = this.config.maxPendingSize / this.packetSize;
            this.bufferPool = new BufferPool((int)(1.1 * (double)this.nPendingMax), this.packetSize + 100);
            if (this.nPendingMax < 100) {
                this.rmmLogger.baseWarn("Very low buffer space allocated for TCP transmitter Pending Queue " + this.nPendingMax, null, moduleName);
            }
            this.maxTrans = 16;
            this.idSeed = Short.MIN_VALUE;
            this.idSeed = (short)(System.currentTimeMillis() / 1000L);
            this.rmmLogger.baseInfo("PTransmitter idSeed set to " + this.idSeed, moduleName);
            if (this.config.limitRate != 0) {
                this.tokenBucket = new TokenBucket(this.config.transmissionRateKbps, this.rmmLogger, this.taskMan);
            }
            this.localInterf = interf;
            this.nackPort = this.rmmAddress.getPort();
            byte[] addr = this.rmmAddress.getInetAddress().getAddress();
            if (addr.length == 4) {
                this.ipAddress = addr;
                this.rmmLogger.baseInfo("Building GSI I - use IPV4 address", moduleName);
            } else {
                String host_name = this.rmmAddress.getInetAddress().getCanonicalHostName();
                int host_name_hash = host_name.hashCode();
                this.ipAddress = new byte[4];
                Sutils.insertInt(this.ipAddress, 0, host_name_hash);
                this.rmmLogger.baseInfo("Building GSI I - Address length - " + addr.length + ". Not IPv4. Using hash of the Canonical host name " + host_name, moduleName);
            }
            this.rmmLogger.baseInfo("GSI I: " + this.ipAddress[0] + ":" + this.ipAddress[1] + ":" + this.ipAddress[2] + ":" + this.ipAddress[3], moduleName);
            this.streamListLock = new Object();
            this.nStreamsMax = 100;
            this.streamList = new StreamT[this.nStreamsMax];
            this.nStreams = 0;
            this.globalDestinations = new ArrayList();
            this.gdUpdated = true;
            this.globalLock = new Object();
            this.pendingConnectionStreams = new LinkedList();
            this.pendingClosedStreams = new Vector();
            this.rateLimitStreams = new Vector();
            this.streamFireout = new PacketFireout(this);
            this.streamFireout.setName("Ptl_Tcp_Fireout");
            this.streamFireout.setPriority(10);
            this.controlPacketSender = new ControlPacketSender(this);
            this.controlPacketSender.setName("Ptl_Tcp_ControlPacketSender");
            this.controlPacketSender.setPriority(10);
            this.timingThrd = new TimingThread(this);
            this.timingThrd.setName("Ptl_Tcp_TimingThread");
            this.timingThrd.setPriority(10);
            this.checkConnectionPending = new CheckConnectionPending(this);
            this.checkConnectionPending.setName("Ptl_Tcp_CheckConnectionPending");
            this.checkConnectionPending.setPriority(10);
            this.start();
            this.rcsTask = new RemoveClosedStreams(1000L);
            this.taskMan.addTask(this.rcsTask);
            this.clmTask = new CheckLostMsg(1000L);
            this.taskMan.addTask(this.clmTask);
            this.clsTask = new CheckLimitedStreams(50L);
            this.taskMan.addTask(this.clsTask);
        }
        catch (Exception e2) {
            this.rmmLogger.baseError("Failed to init PTransmitter", e2, moduleName);
            return false;
        }
        return true;
    }

    public synchronized StreamTIf createStreamTransmitter(boolean reliable, InetAddress address, int port2, byte[] tag, boolean lj_enabled) {
        short sid = this.idSeed;
        while ((sid = (short)(sid + 1)) != this.idSeed) {
            if (this.getStream(sid) != null) continue;
        }
        if (sid == this.idSeed) {
            this.rmmLogger.baseError("Could not assign a unique stream id for a new stream", null, moduleName);
            return null;
        }
        this.idSeed = sid;
        StreamT str = new StreamT(this);
        if (!str.init(tag, sid, reliable, address, lj_enabled)) {
            return null;
        }
        this.addStream(str);
        ++this.nUpd;
        return str;
    }

    UnicastConnection establishConnection(InetSocketAddress remote) {
        SocketChannel sock = null;
        UnicastConnection ucon = null;
        InetSocketAddress isa = null;
        try {
            sock = SocketChannel.open();
            if (!this.config.bindAll) {
                isa = new InetSocketAddress(this.rmmAddress.getInetAddress(), 0);
                sock.socket().bind(isa);
            }
        }
        catch (IOException ex) {
            this.rmmLogger.baseLog(421, new Object[]{"" + isa}, ex, moduleName);
            try {
                if (sock != null && sock.socket() != null) {
                    sock.socket().close();
                }
                if (sock != null) {
                    sock.close();
                }
            }
            catch (Throwable exp) {
                this.rmmLogger.baseError("Failed to close Socket Channel after bind failed", exp, moduleName);
            }
            return null;
        }
        boolean res = true;
        try {
            sock.connect(remote);
        }
        catch (IOException ex) {
            this.rmmLogger.baseWarn("Failed to establish TCP connection to " + Sutils.printIsa(remote), null, moduleName);
            res = false;
        }
        if (res) {
            try {
                sock.configureBlocking(false);
            }
            catch (IOException e2) {
                this.rmmLogger.baseError("Failed to configure non-blocking SockeChannel to " + Sutils.printIsa(remote), e2, moduleName);
                res = false;
            }
        }
        if (res) {
            res = this.setConnectionProperties(sock, remote);
        }
        if (res) {
            try {
                ucon = new UnicastConnection(remote.getAddress(), sock.socket().getPort(), sock.socket().getLocalPort(), remote.getPort(), sock, true);
                this.writeServerPort(sock);
            }
            catch (Exception ex) {
                this.rmmLogger.baseWarn("Failed to write Port number after establishing a TCP connection to " + Sutils.printIsa(remote), ex, moduleName);
                res = false;
            }
        }
        if (res && this.myPReceiver != null) {
            try {
                ucon.setRegisterStatus(2);
                this.myPReceiver.registerNewConnection(ucon, ucon.inetAddress, ucon.remoteServerPort);
            }
            catch (Exception ex) {
                this.rmmLogger.baseError("Failed to register new TCP connection with PacketReceiver (" + Sutils.printIsa(remote) + ", Local port: " + sock.socket().getLocalPort() + ").", ex, moduleName);
                res = false;
            }
        }
        if (!res) {
            if (ucon != null) {
                try {
                    ucon.closeConnection(0);
                }
                catch (Exception exp1) {
                    this.rmmLogger.baseWarn("Failed to close Selector after establishing blocking connection failed", exp1, moduleName);
                }
            }
            if (sock.isOpen()) {
                try {
                    sock.socket().shutdownOutput();
                }
                catch (IOException exp2) {
                    this.rmmLogger.baseWarn("Failed to shutdownOutput of Socket after establishing blocking connection failed", exp2, moduleName);
                }
            }
            try {
                sock.socket().close();
                sock.close();
            }
            catch (Throwable exp3) {
                this.rmmLogger.baseError("Failed to close Socket Channel after establishing blocking connection failed", exp3, moduleName);
            }
            return null;
        }
        this.gdAdd(ucon);
        this.rmmLogger.baseInfo("Established a new TCP connection to " + Sutils.printIsa(remote) + ". Local port: " + sock.socket().getLocalPort() + " ucon " + ucon, moduleName);
        return ucon;
    }

    UnicastConnection establishConnectionNonBlocking(InetSocketAddress remote) {
        SocketChannel sock = null;
        boolean connected = false;
        InetSocketAddress isa = null;
        try {
            sock = SocketChannel.open();
            if (!this.config.bindAll) {
                isa = new InetSocketAddress(this.rmmAddress.getInetAddress(), 0);
                sock.socket().bind(isa);
            }
        }
        catch (Exception ex) {
            this.rmmLogger.baseLog(421, new Object[]{"" + isa}, ex, moduleName);
            try {
                if (sock != null) {
                    sock.close();
                }
                if (sock != null && sock.socket() != null) {
                    sock.socket().close();
                }
            }
            catch (Throwable exp) {
                this.rmmLogger.baseError("Failed to close Socket Channel after bind failed", exp, moduleName);
            }
            return null;
        }
        try {
            sock.configureBlocking(false);
        }
        catch (IOException e2) {
            this.rmmLogger.baseError("Failed to configure non-blocking SockeChannel to " + Sutils.printIsa(remote), e2, moduleName);
            try {
                sock.socket().close();
                sock.close();
            }
            catch (Throwable exp) {
                this.rmmLogger.baseError("Failed to close Socket Channel after configureBlocking(false) failed", exp, moduleName);
            }
            return null;
        }
        int maxTries = 1;
        int tries = 0;
        while (!connected && tries < maxTries) {
            try {
                connected = tries == 0 ? sock.connect(remote) : sock.finishConnect();
            }
            catch (IOException ex) {
                this.rmmLogger.baseWarn("Failed to establish TCP connection to " + Sutils.printIsa(remote), null, moduleName);
                try {
                    sock.socket().close();
                    sock.close();
                }
                catch (IOException exp) {
                    this.rmmLogger.baseError("Failed to close Socket Channel after connect failed", exp, moduleName);
                }
                return null;
            }
            if (connected || ++tries >= maxTries) break;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e1) {
                break;
            }
        }
        UnicastConnection ucon = new UnicastConnection(remote.getAddress(), sock.socket().getPort(), sock.socket().getLocalPort(), remote.getPort(), sock, true);
        if (connected) {
            this.rmmLogger.baseInfo("Established a new (non-blocking) TCP connection to " + Sutils.printIsa(remote) + ". Local port: " + sock.socket().getLocalPort() + ", ucon " + ucon, moduleName);
        } else {
            this.rmmLogger.baseInfo("Non-blocking new TCP connection to " + Sutils.printIsa(remote) + " initialized. Local port: " + sock.socket().getLocalPort() + ", ucon " + ucon, moduleName);
        }
        return ucon;
    }

    boolean setConnectionProperties(SocketChannel connection, InetSocketAddress remote) {
        if (this.config.socketBufferSize > 0) {
            try {
                connection.socket().setSendBufferSize(this.config.socketBufferSize);
            }
            catch (SocketException e2) {
                this.rmmLogger.baseError("Failed to set Socket SendBuffer size", e2, moduleName);
                this.rmmLogger.baseLog(413, new Object[]{"TCP SendBufferSize", "" + this.config.socketBufferSize}, e2, moduleName);
            }
            try {
                if (connection.socket().getSendBufferSize() < this.config.socketBufferSize) {
                    this.rmmLogger.baseWarn("Socket SendBuffer size set to " + connection.socket().getSendBufferSize(), null, moduleName);
                    this.rmmLogger.baseLog(413, new Object[]{"TCP SendBufferSize", "" + this.config.socketBufferSize}, null, moduleName);
                }
            }
            catch (IOException ex) {
                this.rmmLogger.baseError("Failed to measure Socket SendBuffer size", ex, moduleName);
            }
        }
        if (this.config.tcpKeepAlive) {
            try {
                connection.socket().setKeepAlive(true);
            }
            catch (IOException e3) {
                this.rmmLogger.baseError("Failed to configure TCP KeepAlive on socket to " + Sutils.printIsa(remote), e3, moduleName);
                this.rmmLogger.baseLog(419, new Object[]{"TCP KeepAlive", "true"}, e3, moduleName);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAndRemoveConnection(UnicastConnection ucon, boolean check) {
        if (ucon == null || ucon.socketChannel == null) {
            return;
        }
        if (check) {
            Object object = this.globalLock;
            synchronized (object) {
                boolean needed = false;
                int i = this.nStreams - 1;
                while (i >= 0) {
                    StreamT str = this.streamList[i];
                    if (str != null && str.unicastConnection != null && str.unicastConnection.equals(ucon)) {
                        needed = true;
                        break;
                    }
                    --i;
                }
                if (!needed) {
                    this.gdRemove(ucon);
                }
                if (!needed && this.myPReceiver != null) {
                    needed = this.myPReceiver.checkOrRemoveConnection(ucon.socketChannel, ucon.inetSocketAddress, true);
                }
                if (needed) {
                    return;
                }
                this.rmmLogger.baseInfo("Removing TCP connection to " + Sutils.printIsa(ucon.inetSocketAddress), moduleName);
            }
        }
        this.closeConnection(ucon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClosedConnection(UnicastConnection ucon) {
        InetSocketAddress remoteAdd = null;
        SocketChannel chan = null;
        if (ucon == null) {
            this.rmmLogger.baseWarn("removeClosedConnection: parameter ucon is null!", null, moduleName);
            return;
        }
        remoteAdd = ucon.inetSocketAddress;
        chan = ucon.socketChannel;
        Object object = this.globalLock;
        synchronized (object) {
            this.rmmLogger.baseInfo("Removing closed TCP connection to " + Sutils.printIsa(remoteAdd) + ", ucon " + ucon, moduleName);
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT str = this.streamList[i];
                if (str != null && !str.isClosed && str.destination != null && str.destination.equals(chan)) {
                    if (str.unicastConnection != ucon) {
                        this.rmmLogger.baseError("removeClosedConnection: str.unicastConnection != ucon : " + str.unicastConnection + " , " + ucon, null, moduleName);
                    }
                    str.connectionClosed = true;
                    str.destination = null;
                    this.sendSnp = 5;
                    str.cpRetries = 100;
                    TEvent ev = new TEvent(3, 0L, 0, null, str.longId, remoteAdd.getAddress(), remoteAdd.getPort());
                    str.eventListener.onEvent(ev);
                }
                --i;
            }
            this.closeConnection(ucon);
            this.gdRemove(ucon);
            ucon.isTxClosed = true;
            if (this.rmmLogger.isMaxLogLevel()) {
                this.rmmLogger.maxInfo("removeClosedConnection: set isTxClosed = true for " + ucon, moduleName);
            }
        }
    }

    void closeConnection(UnicastConnection ucon) {
        if (ucon == null) {
            return;
        }
        ucon.closeConnection(0);
        SocketChannel chan = ucon.socketChannel;
        if (chan != null) {
            try {
                try {
                    if (chan.isOpen() && chan.socket().isConnected()) {
                        chan.socket().shutdownOutput();
                        chan.socket().shutdownInput();
                    }
                }
                catch (IOException e2) {
                    this.rmmLogger.baseWarn("Failed to shutdownOutput TCP channel/socket to " + ucon, e2, moduleName);
                }
                try {
                    chan.socket().close();
                }
                catch (IOException e3) {
                    this.rmmLogger.baseError("Failed to close TCP socket to " + Sutils.printIsa(ucon.inetSocketAddress), e3, moduleName);
                }
                try {
                    chan.close();
                }
                catch (IOException e4) {
                    this.rmmLogger.baseError("Failed to close TCP socket channel to " + Sutils.printIsa(ucon.inetSocketAddress), e4, moduleName);
                }
            }
            catch (Throwable e5) {
                this.rmmLogger.baseError("Failed to close TCP channel/socket to " + ucon, e5, moduleName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            if (this.nStreams == this.nStreamsMax) {
                StreamT[] tmp = new StreamT[2 * this.nStreamsMax];
                int i = 0;
                while (i < this.nStreamsMax) {
                    tmp[i] = this.streamList[i];
                    ++i;
                }
                this.nStreamsMax *= 2;
                this.streamList = tmp;
            }
            this.streamList[this.nStreams] = stream;
            ++this.nStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(StreamT stream) {
        Object object = this.streamListLock;
        synchronized (object) {
            int i = 0;
            while (i < this.nStreams) {
                if (this.streamList[i] == stream) break;
                ++i;
            }
            if (i == this.nStreams) {
                this.rmmLogger.baseWarn("Removing stream: not found!", null, moduleName);
                return;
            }
            --this.nStreams;
            this.streamList[i] = this.streamList[this.nStreams];
            this.streamList[this.nStreams] = null;
        }
        if (this.rmmLogger.isMaxLogLevel()) {
            this.rmmLogger.maxInfo("Removing stream from Transmitter list " + stream, moduleName);
        }
    }

    public int bufferStatus() {
        return this.bufferPool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RmmBuffer getBuffer(StreamT stream) {
        RmmBuffer res;
        Object object = this.pendingWaitMutex;
        synchronized (object) {
            while (this.bufferPool.getUtilization() > 80) {
                if (!stream.isActive) {
                    return null;
                }
                if (this.nStreams * stream.pendingPackets.qSize() <= this.bufferPool.fullSize()) break;
                try {
                    this.pendingWaitMutex.wait(50L);
                }
                catch (InterruptedException ex) {
                    this.rmmLogger.baseLog(406, new Object[]{"Waiting on stream buffers."}, ex, moduleName);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            while (true) {
                try {
                    res = this.bufferPool.getBuffer();
                    if (res != null) break;
                    if (!stream.isActive) {
                        return null;
                    }
                    try {
                        this.pendingWaitMutex.wait(50L);
                    }
                    catch (InterruptedException ex) {
                        this.rmmLogger.baseLog(406, new Object[]{"Waiting on empty buffer pool."}, ex, moduleName);
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                catch (Throwable e2) {
                    this.rmmLogger.baseError("getBuffer: failed to allocate new buffer, more memory is probably needed.", e2, moduleName);
                    res = null;
                    break;
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnBuffer(RmmBuffer buffer) {
        this.bufferPool.returnBuffer(buffer);
        Object object = this.pendingWaitMutex;
        synchronized (object) {
            this.pendingWaitMutex.notifyAll();
        }
    }

    public synchronized void changeTransmissionRate(int new_rate_Kbps) {
        this.tokenBucket.setRate(new_rate_Kbps);
    }

    public double getAverageRetransmissionRate() {
        return 0.0;
    }

    public long getPendingQueueSize() {
        int n_pend = 0;
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && !stream.isClosed) {
                n_pend += stream.pendingPackets.qSize();
            }
            --i;
        }
        this.nPending = n_pend;
        return this.nPending * this.packetSize;
    }

    public String getProtocolVersion() {
        return "100";
    }

    public String getStatusLog() {
        StringBuffer stat = new StringBuffer();
        try {
            stat.append("Fireout: p").append(this.streamFireout.curPos).append(" r").append(this.streamFireout.nRot).append(" nQ0 ").append(this.streamFireout.nQ0).append(" nQ1 ").append(this.streamFireout.nQ1).append(" nWt ").append(this.streamFireout.nWt);
            stat.append(". HBSender: p").append(this.controlPacketSender.curPos).append(" r").append(this.controlPacketSender.nRot);
            stat.append(" ccp").append(this.ccpCount).append(" snp").append(this.snpCount);
            stat.append(". TimingThrd: p").append(this.timingThrd.curPos).append(" r").append(this.timingThrd.nRot);
            stat.append(". ConnPending: r").append(this.checkConnectionPending.nRot).append(" p").append(this.checkConnectionPending.nPos).append(" np").append(this.checkConnectionPending.getWaiting()).append('\n');
            stat.append("_RMM_STATS_ Buffer pool size: ").append(this.bufferPool.size()).append(" nStreams ").append(this.nStreams).append(" nConns ").append(this.globalDestinations.size()).append('\n');
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = this.streamList[i];
                if (stream != null && stream.busyRetries != 0) {
                    stat.append("_RMM_STATS_ Stream ").append(stream.getId()).append(". status: front ").append(stream.pendFrontSeqN).append("(").append(stream.sentFrontSeqN).append("), rt ").append(stream.busyRetries).append('\n');
                }
                --i;
            }
            return stat.toString();
        }
        catch (NullPointerException ex) {
            return "Not started";
        }
    }

    public StreamTIf getStream(byte[] tag) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && Sutils.compareByteArrays(stream.getTag(), tag)) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public StreamT getStream(short key) {
        int i = this.nStreams - 1;
        while (i >= 0) {
            StreamT stream = this.streamList[i];
            if (stream != null && stream.shortId == key) {
                return stream;
            }
            --i;
        }
        return null;
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration listStreams() {
        Object object = this.streamListLock;
        synchronized (object) {
            Vector<StreamT> tmp = new Vector<StreamT>(this.nStreams);
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = this.streamList[i];
                if (stream != null) {
                    tmp.add(stream);
                }
                --i;
            }
            return tmp.elements();
        }
    }

    public void addFullBufferListener(FullBufferListener list) {
        this.rmmLogger.baseWarn("Setting FullBufferListener on TCP stream", null, moduleName);
    }

    public void removeFullBufferListener(FullBufferListener list) {
    }

    private void start() {
        this.isRunning = true;
        this.streamFireout.start();
        this.controlPacketSender.start();
        this.timingThrd.start();
        this.checkConnectionPending.start();
    }

    public synchronized boolean stop(boolean soft) {
        this.rmmLogger.baseLog(2, new Object[]{"PTransmitter"}, null, moduleName);
        int i2 = this.nStreams - 1;
        while (i2 >= 0) {
            StreamT stream = this.streamList[i2];
            if (stream != null) {
                stream.close(soft);
            }
            --i2;
        }
        if (soft && this.nStreams > 0) {
            this.rmmLogger.baseInfo("Waiting for " + this.config.closeWaitTime / 1000 + "sec (control packet timeout)\n" + "to let transmitter send pending packets and receivers complete the reception", moduleName);
            try {
                Thread.sleep(this.config.closeWaitTime);
            }
            catch (InterruptedException i2) {}
        } else {
            this.rmmLogger.baseInfo("Fast PTL Transmitter Stop", moduleName);
        }
        this.taskMan.removeTask(this.rcsTask);
        this.taskMan.removeTask(this.clmTask);
        this.taskMan.removeTask(this.clsTask);
        this.isRunning = false;
        if (this.streamFireout != null) {
            this.streamFireout.interrupt();
        }
        if (this.controlPacketSender != null) {
            this.controlPacketSender.interrupt();
        }
        if (this.timingThrd != null) {
            this.timingThrd.interrupt();
        }
        if (this.checkConnectionPending != null) {
            this.checkConnectionPending.interrupt();
        }
        UnicastConnection ucon = null;
        SocketChannel chan = null;
        int i3 = 0;
        while (i3 < this.globalDestinations.size()) {
            block28: {
                try {
                    ucon = (UnicastConnection)this.globalDestinations.get(i3);
                    if (ucon == null) break block28;
                    chan = ucon.socketChannel;
                    ucon.closeConnection(0);
                }
                catch (Exception exp) {
                    this.rmmLogger.baseError("Transmitter stop: exception when processing entry of globalDestinationHash", exp, moduleName);
                }
                if (chan != null) {
                    try {
                        try {
                            if (chan.isOpen() && chan.socket().isConnected()) {
                                chan.socket().shutdownOutput();
                                chan.socket().shutdownInput();
                            }
                        }
                        catch (IOException e2) {
                            this.rmmLogger.baseWarn("Transmitter stop: Failed to shutdownOutPut TCP socket for connection " + Sutils.printIsa(ucon.inetSocketAddress), e2, moduleName);
                        }
                        try {
                            chan.socket().close();
                        }
                        catch (Throwable e3) {
                            this.rmmLogger.baseError("Transmitter stop: Failed to close TCP socket for connection " + Sutils.printIsa(ucon.inetSocketAddress), e3, moduleName);
                        }
                        try {
                            chan.close();
                        }
                        catch (IOException e4) {
                            this.rmmLogger.baseError("Failed to close SocketChannel for connection " + Sutils.printIsa(ucon.inetSocketAddress), e4, moduleName);
                        }
                    }
                    catch (Throwable exp) {
                        this.rmmLogger.baseError("Error when closing SocketChannel for connection " + Sutils.printIsa(ucon.inetSocketAddress), exp, moduleName);
                    }
                }
            }
            ++i3;
        }
        try {
            i3 = this.nStreams - 1;
            while (i3 >= 0) {
                StreamT stream = this.streamList[i3];
                if (stream != null) {
                    stream.cleanAfterClose();
                }
                --i3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.tokenBucket != null) {
            this.tokenBucket.stop();
        }
        return true;
    }

    public synchronized void setPreceiver(PReceiverIf pReceiver) {
        this.myPReceiver = pReceiver;
    }

    public boolean receiverReportConnection(InetSocketAddress remoteISA, Object socket, boolean close, Object connection) {
        if (connection == null) {
            this.rmmLogger.baseError("receiverReportConnection parameter Error: connection arg is null, close " + close, null, moduleName);
            return false;
        }
        UnicastConnection ucon = (UnicastConnection)connection;
        if (close) {
            if (this.rmmLogger.isMaxLogLevel()) {
                this.rmmLogger.maxInfo("receiverReportConnection: close connection to " + Sutils.printIsa(ucon.inetSocketAddress), moduleName);
            }
            this.streamFireout.closedConnections.add(ucon);
            this.streamFireout.wakeUp(null);
            return true;
        }
        this.rmmLogger.baseError("receiverReportConnection: add connection not allowed remoteISA " + Sutils.printIsa(remoteISA), null, moduleName);
        return true;
    }

    public void writeServerPort(SocketChannel sock) throws IOException {
        int tries;
        ByteBuffer portByteBuffer = ByteBuffer.allocate(8);
        portByteBuffer.clear();
        portByteBuffer.putInt(1562696995);
        if (this.myPReceiver != null) {
            portByteBuffer.putInt(this.myPReceiver.getServerSocketPort());
        } else {
            portByteBuffer.putInt(0);
        }
        portByteBuffer.rewind();
        int to_write = 8;
        int max_tries = 10;
        for (tries = 0; to_write > 0 && tries < max_tries; to_write -= sock.write(portByteBuffer), ++tries) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e2) {
                tries = max_tries;
                break;
            }
        }
        if (tries == max_tries) {
            throw new IOException("Failed to write ServerPort after max_tries");
        }
    }

    public int getHeaderSize() {
        return this.ptlHeaderSize;
    }

    public void gotConnStreams(Object socket, long[] stream_ids, int nstreams) {
        try {
            if (socket == null) {
                this.rmmLogger.baseError("gotConnStreams: given 1st arg is null", null, moduleName);
                return;
            }
            if (stream_ids == null) {
                this.rmmLogger.baseError("getConnStreams: given 2nd arg is null", null, moduleName);
                return;
            }
            UnicastConnection ucon = (UnicastConnection)socket;
            int i = this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = this.streamList[i];
                if (stream != null && stream.destination != null && stream.isActive && !stream.isClosed && stream.eventListener != null && Clock.getTime() >= stream.openTime + 120000L && stream.snpEvent < 2 && stream.unicastConnection == ucon) {
                    int n = nstreams;
                    while (n-- > 0) {
                        if (stream.longId == stream_ids[n]) break;
                    }
                    if (n < 0 && ++stream.snpEvent >= 2) {
                        this.rmmLogger.baseInfo("gotConnStreams: put STREAM_NOT_PRESENT_AT_DESTINATION event for stream " + stream.longId, moduleName);
                        TEvent ev = new TEvent(5, 0L, 0, ucon, stream.longId, ucon.inetAddress, ucon.remoteServerPort);
                        stream.eventListener.onEvent(ev);
                    }
                }
                --i;
            }
        }
        catch (Throwable ex) {
            this.rmmLogger.baseError("gotConnStreams got Exception Transmitter", ex, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gdAdd(UnicastConnection ucon) {
        boolean ok;
        ArrayList arrayList = this.globalDestinations;
        synchronized (arrayList) {
            boolean bl = ok = !this.globalDestinations.contains(ucon);
            if (ok) {
                this.globalDestinations.add(ucon);
                this.gdUpdated = true;
            }
        }
        if (this.rmmLogger.isMaxLogLevel() && ok) {
            this.rmmLogger.maxInfo("gdAdd: Adding ucon to globalDestination table, ucon: " + ucon, moduleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gdRemove(UnicastConnection ucon) {
        boolean ok;
        ArrayList arrayList = this.globalDestinations;
        synchronized (arrayList) {
            ok = this.globalDestinations.remove(ucon);
            if (ok) {
                this.gdUpdated = true;
            }
        }
        if (this.rmmLogger.isMaxLogLevel() && ok) {
            this.rmmLogger.maxInfo("gdRemove: Removing ucon from globalDestination table, ucon: " + ucon, moduleName);
        }
    }

    public boolean stopChfw() {
        return false;
    }

    class RemoveClosedStreams
    implements TaskIf {
        private long next_time;
        private long interval;

        public RemoveClosedStreams(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.pendingClosedStreams.size() - 1;
            while (i >= 0) {
                StreamT stream = (StreamT)PTransmitter.this.pendingClosedStreams.get(i);
                if (stream.closeTime == 0L) {
                    if (stream.controlPacket != null && stream.cpRetries++ < 2) {
                        PTransmitter.this.streamFireout.wakeUp(stream);
                        this.next_time = curTime + 10L;
                    } else if (stream.controlPacket == null) {
                        stream.writeCP(false);
                        stream.closeTime = curTime;
                    } else if (stream.destination != null) {
                        if (stream.cpRetries++ < 100) {
                            if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                                PTransmitter.this.rmmLogger.maxWarn("removeClosedStreams: could not write control packet with FIN indication, stream " + stream.longId + " cpRetries " + stream.cpRetries + ", will try agian", null, PTransmitter.moduleName);
                            }
                        } else {
                            PTransmitter.this.rmmLogger.baseError("removeClosedStreams: failed to write control packet with FIN indication, stream " + stream.longId + " Destination " + stream.destination + " cpRetries " + stream.cpRetries, null, PTransmitter.moduleName);
                            stream.closeTime = curTime;
                        }
                    } else {
                        stream.cpRetries = 100;
                        stream.closeTime = curTime;
                    }
                } else if (curTime - stream.closeTime > (long)PTransmitter.this.config.closeWaitTime) {
                    if (!stream.isClosed) {
                        stream.isClosed = true;
                        if (stream.destination != null) {
                            PTransmitter.this.sendSnp = 5;
                        }
                    } else {
                        PTransmitter.this.removeStream(stream);
                        if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                            PTransmitter.this.rmmLogger.maxInfo("Removing stream " + stream + ".  Remaining: " + PTransmitter.this.nStreams, PTransmitter.moduleName);
                        }
                        stream.cleanAfterClose();
                        PTransmitter.this.pendingClosedStreams.remove(i);
                    }
                }
                --i;
            }
        }
    }

    class CheckLostMsg
    implements TaskIf {
        private long next_time;
        private long interval;

        public CheckLostMsg(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.nStreams - 1;
            while (i >= 0) {
                StreamT stream = PTransmitter.this.streamList[i];
                if (stream != null && stream.destination != null && !stream.isClosed) {
                    if (!(stream.inPS || stream.controlPacket == null && stream.pendingPackets.qSize() <= 0)) {
                        PTransmitter.this.streamFireout.wakeUp(stream);
                    }
                    if (!stream.inZD && stream.mtlSize > 0 && stream.pendingPackets.qSize() == 0) {
                        PTransmitter.this.timingThrd.wakeUp(stream);
                    }
                }
                --i;
            }
        }
    }

    class CheckLimitedStreams
    implements TaskIf {
        private long next_time;
        private long interval;

        public CheckLimitedStreams(long chk_period) {
            this.interval = chk_period;
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            this.next_time = curTime + this.interval;
            int i = PTransmitter.this.rateLimitStreams.size() - 1;
            while (i >= 0) {
                StreamT stream = (StreamT)PTransmitter.this.rateLimitStreams.get(i);
                if (stream == null || !stream.limitRate || stream.oDataBucket == null || stream.isClosed) {
                    PTransmitter.this.rateLimitStreams.remove(i);
                } else {
                    try {
                        if (stream.oDataBucket.getToken(0, false, false, false)) {
                            PTransmitter.this.rateLimitStreams.remove(i);
                            PTransmitter.this.streamFireout.wakeUp(stream);
                        }
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
                --i;
            }
        }
    }

    class SendControlPacket
    implements TaskIf {
        private long next_time;
        private long interval;
        private ArrayList dests;

        public SendControlPacket(long chk_period) {
            this.interval = chk_period;
            this.dests = new ArrayList();
        }

        public long getNextTime() {
            return this.next_time;
        }

        public void timerExpired(long curTime) {
            SocketChannel schan = null;
            this.next_time = curTime + this.interval;
            this.dests.clear();
            int i = PTransmitter.this.nStreams - 1;
            while (i >= 0) {
                block10: {
                    boolean send_cp;
                    StreamT stream;
                    block13: {
                        block12: {
                            block11: {
                                stream = PTransmitter.this.streamList[i];
                                if (stream == null || stream.destination == null || stream.isClosed) break block10;
                                if (stream.controlPacket == null) break block11;
                                PTransmitter.this.streamFireout.wakeUp(stream);
                                break block10;
                            }
                            if (!PTransmitter.this.config.perConnectionHB) break block12;
                            schan = stream.destination;
                            if (schan == null) break block10;
                            if (this.dests.contains(schan)) {
                                send_cp = false;
                            } else {
                                this.dests.add(schan);
                                send_cp = true;
                            }
                            break block13;
                        }
                        send_cp = true;
                        schan = null;
                    }
                    if (send_cp && stream.bytesTransmitted - stream.last_bytesTransmitted <= 0L) {
                        if (!stream.isClosed && stream.controlPacket == null) {
                            stream.writeCP(PTransmitter.this.config.perConnectionHB);
                            if (schan != null && PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                                InetSocketAddress cp_dest = (InetSocketAddress)schan.socket().getRemoteSocketAddress();
                                PTransmitter.this.rmmLogger.maxInfo("Connection HB Packet written for destination " + Sutils.printIsa(cp_dest), PTransmitter.moduleName);
                            }
                        }
                    } else if (PTransmitter.this.rmmLogger.isMaxLogLevel()) {
                        if (send_cp) {
                            PTransmitter.this.rmmLogger.maxInfo("Avoid sending CP, data sent on stream " + stream.longId, PTransmitter.moduleName);
                        } else {
                            PTransmitter.this.rmmLogger.maxInfo("Avoid sending CP, heartbeat sent on connection, stream " + stream.longId, PTransmitter.moduleName);
                        }
                    }
                    stream.last_bytesTransmitted = stream.bytesTransmitted;
                }
                --i;
            }
            this.dests.clear();
        }
    }
}

