/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.ObjCyclQueue;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.tcp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tcp.transmitter.StreamT;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Vector;

class PacketFireout
extends Thread {
    static final String moduleName = "PTL_TCP_T";
    PTransmitter pTrans;
    ArrayList quarantinedStreams;
    Vector closedConnections;
    boolean rmvCC;
    ObjCyclQueue pendingStreams;
    long lastExceptionTime;
    boolean cp_sent;
    volatile int nRot;
    volatile int curPos;
    volatile int nQ0;
    volatile int nQ1;
    volatile int nWt;
    private boolean goOn = true;
    private Selector writeSelector;
    private int selErrors;
    private long selErrorTime;

    PacketFireout(PTransmitter ptr) {
        this.pTrans = ptr;
        this.quarantinedStreams = new ArrayList();
        this.closedConnections = new Vector();
        this.pendingStreams = new ObjCyclQueue(1024);
    }

    private boolean processQuarantinedStream(StreamT stream) throws InterruptedException {
        boolean done;
        int bytes_written;
        block26: {
            bytes_written = 0;
            done = true;
            try {
                if (this.writeSelector == null) {
                    this.writeSelector = Selector.open();
                }
                if (stream.unicastConnection.selKey == null || !stream.unicastConnection.selKey.isValid()) {
                    stream.unicastConnection.selKey = stream.unicastConnection.socketChannel.register(this.writeSelector, 4);
                } else {
                    stream.unicastConnection.selKey.interestOps(4);
                }
                this.writeSelector.select(1L);
                stream.unicastConnection.selKey.interestOps(0);
            }
            catch (Exception ex) {
                if (!(ex instanceof CancelledKeyException) && !(ex instanceof ClosedChannelException)) {
                    if (this.selErrors++ == 3) {
                        // empty if block
                    }
                    this.selErrorTime = System.currentTimeMillis();
                }
                if (this.selErrors > 100) {
                    long diff = System.currentTimeMillis() - this.selErrorTime;
                    if (diff > 0L && diff < 1000L) {
                        this.pTrans.rmmLogger.baseError("PacketFireout selector: too many exceptions, replacing the selector", ex, moduleName);
                        try {
                            this.writeSelector.close();
                        }
                        catch (Exception e2) {
                            this.pTrans.rmmLogger.baseError("PacketFireout selector: failed to close", e2, moduleName);
                        }
                        this.writeSelector = null;
                    }
                    this.selErrors = 0;
                }
                if (!this.pTrans.rmmLogger.isMaxLogLevel()) break block26;
                this.pTrans.rmmLogger.maxWarn("PacketFireout select exception, selErrors " + this.selErrors + ", stream " + stream.longId + ", ucon: " + stream.unicastConnection, ex, moduleName);
            }
        }
        int to_write = stream.quarantineBuffer.bb.remaining();
        int trial = 0;
        while (trial < 1) {
            try {
                bytes_written = stream.quarantineDest.write(stream.quarantineBuffer.bb);
            }
            catch (Exception ex) {
                int rport = -1;
                if (stream.unicastConnection != null) {
                    rport = stream.unicastConnection.remoteServerPort;
                }
                InetSocketAddress dest = (InetSocketAddress)stream.quarantineDest.socket().getRemoteSocketAddress();
                this.pTrans.rmmLogger.baseWarn("Connection closed to " + dest + "||" + rport + " (quarantined).\n" + ex, null, moduleName);
                this.pTrans.removeClosedConnection(stream.unicastConnection);
                to_write = 0;
                break;
            }
            if ((to_write -= bytes_written) == 0) break;
            ++trial;
        }
        if (bytes_written == 0 && to_write > 0) {
            ++stream.busyRetries;
            if (stream.busyRetries % 500 == 0) {
                if (stream.busyRetriesTime == 0L) {
                    stream.busyRetriesTime = Clock.getTime();
                }
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("Destination not ready . N trials: " + stream.busyRetries + ". Stream: " + stream.getId() + " sc status isConnected " + stream.destination.isConnected() + " isOpen " + stream.destination.isOpen() + " isOutSht " + stream.destination.socket().isOutputShutdown(), moduleName);
                }
                stream.checkDestinationsConnected();
                this.curPos = 104;
                this.removeClosedConnections();
                int time_diff = (int)(Clock.getTime() - stream.busyRetriesTime);
                if (time_diff > 90000) {
                    if (time_diff <= 0) {
                        time_diff = (int)(System.currentTimeMillis() - stream.busyRetriesTime);
                    }
                    this.curPos = 105;
                    InetSocketAddress dest = (InetSocketAddress)stream.destination.socket().getRemoteSocketAddress();
                    this.pTrans.rmmLogger.baseError("PacketFireout: too many busyRetries on stream " + stream.longId + " closing connection to " + Sutils.printIsa(dest) + ", tries " + stream.busyRetries + ", time_diff " + time_diff, null, moduleName);
                    this.pTrans.removeClosedConnection(stream.unicastConnection);
                    Exception ex = new Exception("Write timeout on connection " + stream.unicastConnection + ", stream " + stream.longId + ". Could not write data in " + time_diff + " milliseconds.");
                    this.pTrans.rmmLogger.baseLog(421, new Object[]{"" + dest}, ex, moduleName);
                }
            }
        } else {
            stream.busyRetries = 0;
            stream.busyRetriesTime = 0L;
        }
        if (to_write != 0) {
            done = false;
        } else {
            stream.unicastConnection.quarantine = false;
            stream.quarantineBuffer.bb.rewind();
            stream.quarantine = false;
            if (stream.quarantineIsCP) {
                stream.controlPacket = null;
            } else {
                this.pTrans.returnBuffer(stream.quarantineBuffer);
            }
            done = true;
        }
        return done;
    }

    private void removeClosedConnections() {
        if (this.closedConnections.isEmpty()) {
            return;
        }
        int i = this.closedConnections.size() - 1;
        while (i >= 0) {
            UnicastConnection ucon = (UnicastConnection)this.closedConnections.get(i);
            if (ucon != null) {
                this.pTrans.removeClosedConnection(ucon);
                this.closedConnections.remove(i);
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp(StreamT stream) {
        ObjCyclQueue objCyclQueue = this.pendingStreams;
        synchronized (objCyclQueue) {
            if (stream == null) {
                this.rmvCC = true;
                this.pendingStreams.notify();
            } else if (!stream.inPS) {
                stream.inPS = true;
                this.pendingStreams.pushLast(stream);
                this.pendingStreams.notify();
            }
        }
    }

    public void interrupt() {
        this.goOn = false;
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.pTrans.rmmLogger.baseLog(1, new Object[]{"PacketFireout"}, null, moduleName);
        int n_max = this.pTrans.maxTrans;
        StreamT stream = null;
        boolean streamOk = false;
        int exc_count = 0;
        int lastRot = this.nRot;
        while (this.goOn) {
            ++this.nRot;
            try {
                this.curPos = 1;
                ObjCyclQueue objCyclQueue = this.pendingStreams;
                synchronized (objCyclQueue) {
                    int i;
                    if (streamOk && stream != null && !stream.inPS) {
                        stream.inPS = true;
                        this.pendingStreams.pushLast(stream);
                    }
                    if (this.quarantinedStreams.size() > 0) {
                        if (this.nRot > lastRot + 5) {
                            i = 0;
                            while (i < this.quarantinedStreams.size()) {
                                stream = (StreamT)this.quarantinedStreams.get(i);
                                if (stream != null && !stream.inPS) {
                                    stream.inPS = true;
                                    this.pendingStreams.pushLast(stream);
                                }
                                ++i;
                            }
                            this.quarantinedStreams.clear();
                            lastRot = this.nRot;
                        }
                    } else {
                        lastRot = this.nRot;
                    }
                    stream = null;
                    while (!this.rmvCC && (stream = (StreamT)this.pendingStreams.popFirst()) == null) {
                        if (this.quarantinedStreams.size() > 0) {
                            i = 0;
                            while (i < this.quarantinedStreams.size()) {
                                stream = (StreamT)this.quarantinedStreams.get(i);
                                if (stream != null && !stream.inPS) {
                                    stream.inPS = true;
                                    this.pendingStreams.pushLast(stream);
                                }
                                ++i;
                            }
                            this.quarantinedStreams.clear();
                            lastRot = this.nRot;
                            continue;
                        }
                        this.pendingStreams.wait();
                    }
                    if (stream != null) {
                        stream.inPS = false;
                    }
                }
                if (this.rmvCC) {
                    this.rmvCC = false;
                    this.removeClosedConnections();
                }
                streamOk = false;
                if (stream == null || stream.isClosed || stream.destination == null || stream.connectionClosed) continue;
                if (stream.unicastConnection != null && !stream.unicastConnection.isValid) {
                    this.pTrans.rmmLogger.baseWarn("FireOut found a stream with invalid unicastConnection " + stream.longId + " removing connection, destination " + Sutils.printIsa(stream.unicastConnection.inetSocketAddress), null, moduleName);
                    this.closedConnections.add(stream.unicastConnection);
                    this.rmvCC = true;
                    continue;
                }
                this.curPos = 4;
                this.curPos = 5;
                if (stream.unicastConnection.quarantine && !stream.quarantine) {
                    this.quarantinedStreams.add(stream);
                    continue;
                }
                this.curPos = 6;
                if (stream.limitRate && !stream.oDataBucket.hasToken()) {
                    if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                        this.pTrans.rmmLogger.maxInfo("Continue 1" + stream, moduleName);
                    }
                    this.pTrans.rateLimitStreams.add(stream);
                    continue;
                }
                if (stream.quarantine) {
                    ++this.nQ0;
                    if (this.processQuarantinedStream(stream)) {
                        ++this.nQ1;
                        streamOk = true;
                        continue;
                    }
                    this.quarantinedStreams.add(stream);
                    continue;
                }
                int n_trans = 0;
                n_trans = stream.pendingPackets.qSize();
                if (n_trans > n_max) {
                    n_trans = n_max;
                }
                if (stream.controlPacket != null) {
                    ++n_trans;
                    this.cp_sent = false;
                }
                if (n_trans == 0) {
                    this.curPos = 62;
                    if (stream.mtlSize <= 0) continue;
                    this.pTrans.timingThrd.wakeUp(stream);
                    continue;
                }
                this.curPos = 7;
                this.curPos = 8;
                streamOk = true;
                int j = 0;
                while (j < n_trans) {
                    boolean is_control_packet;
                    int packet_length;
                    RmmBuffer packet;
                    if (stream.limitRate && !stream.oDataBucket.hasToken()) {
                        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                            this.pTrans.rmmLogger.maxInfo("Break 1" + stream, moduleName);
                        }
                        this.pTrans.rateLimitStreams.add(stream);
                        streamOk = false;
                        break;
                    }
                    this.curPos = 9;
                    this.curPos = 10;
                    this.curPos = 12;
                    BufferCyclQueue bufferCyclQueue = stream.pendingPackets;
                    synchronized (bufferCyclQueue) {
                        this.curPos = 13;
                        if (stream.controlPacket != null) {
                            packet = stream.controlPacket;
                            packet_length = packet.dataLength;
                            is_control_packet = true;
                        } else {
                            packet = stream.pendingPackets.popFirst();
                            packet_length = packet.dataLength;
                            packet.bb.position(packet_length);
                            packet.bb.flip();
                            is_control_packet = false;
                            if (stream.limitRate) {
                                stream.oDataBucket.commitToken(packet_length);
                            }
                        }
                    }
                    if (this.pTrans.config.limitRate != 0) {
                        this.pTrans.tokenBucket.waitForToken(packet_length);
                    }
                    this.curPos = 14;
                    int n_dest = stream.destination == null ? 0 : 1;
                    SocketChannel destination = stream.destination;
                    int k = 0;
                    while (k < n_dest) {
                        int bytes_written;
                        int to_write = packet_length;
                        this.curPos = 15;
                        try {
                            bytes_written = destination.write(packet.bb);
                        }
                        catch (IOException ex) {
                            int rport = -1;
                            if (stream.unicastConnection != null) {
                                rport = stream.unicastConnection.remoteServerPort;
                            }
                            InetSocketAddress dest = (InetSocketAddress)destination.socket().getRemoteSocketAddress();
                            this.pTrans.rmmLogger.baseWarn("Connection closed to " + Sutils.printIsa(dest) + "||" + rport + ", ucon " + stream.unicastConnection + ".\n" + ex, null, moduleName);
                            this.curPos = 151;
                            this.pTrans.removeClosedConnection(stream.unicastConnection);
                            this.curPos = 152;
                            streamOk = false;
                            break;
                        }
                        this.curPos = 16;
                        if (is_control_packet && this.pTrans.rmmLogger.isMaxLogLevel()) {
                            InetSocketAddress cp_dest = (InetSocketAddress)destination.socket().getRemoteSocketAddress();
                            this.pTrans.rmmLogger.maxInfo("Sent heartbeat for connection to " + Sutils.printIsa(cp_dest) + ",  sent on stream " + stream.longId, moduleName);
                        }
                        if ((to_write -= bytes_written) != 0) {
                            stream.unicastConnection.quarantine = true;
                            this.quarantinedStreams.add(stream);
                            stream.quarantine = true;
                            stream.quarantineDest = destination;
                            stream.quarantineFailedDest = k;
                            stream.quarantineBuffer = packet;
                            stream.quarantineIsCP = is_control_packet;
                            streamOk = false;
                            break;
                        }
                        this.curPos = 17;
                        packet.bb.rewind();
                        if (is_control_packet) {
                            this.cp_sent = true;
                        }
                        ++k;
                    }
                    if (!is_control_packet) {
                        ++stream.sentFrontSeqN;
                    }
                    this.curPos = 18;
                    if (stream.quarantine) break;
                    if (!is_control_packet) {
                        this.pTrans.returnBuffer(packet);
                    } else if (this.cp_sent) {
                        stream.controlPacket = null;
                    }
                    ++j;
                }
                this.curPos = 19;
                this.curPos = 22;
            }
            catch (Throwable ex) {
                if (!this.pTrans.isRunning || this.isInterrupted() || ex instanceof InterruptedException) {
                    if (!this.pTrans.isRunning) break;
                    this.pTrans.rmmLogger.baseLog(406, new Object[]{"PacketFireout"}, ex, moduleName);
                    break;
                }
                this.pTrans.rmmLogger.baseError("PacketFireout: Exception in thread loop", ex, moduleName);
                long time = Clock.getTime();
                if (time - this.lastExceptionTime > 500L) {
                    exc_count = 0;
                }
                this.lastExceptionTime = time;
                if (++exc_count <= 0 && !(ex instanceof Error)) continue;
                this.pTrans.rmmLogger.baseError("Too many exceptions. Stop PacketFireout", null, moduleName);
                this.pTrans.rmmLogger.baseLog(416, new Object[]{"PacketFireout"}, ex, moduleName);
                break;
            }
        }
        try {
            if (this.writeSelector != null && this.writeSelector.isOpen()) {
                this.writeSelector.close();
                this.pTrans.rmmLogger.maxInfo("Fireout closed selector on Exit", moduleName);
            }
        }
        catch (Exception e2) {
            this.pTrans.rmmLogger.baseError("Exception when trying to close writeSlector", e2, moduleName);
        }
        this.pTrans.rmmLogger.baseLog(2, new Object[]{"PacketFireout"}, null, moduleName);
    }
}

