/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.BufferCyclQueue;
import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.PersistByteArrayOutputStream;
import com.ibm.rmm.intrn.util.RmmBuffer;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.intrn.util.TokenBucket;
import com.ibm.rmm.ptl.ifc.transmitter.BufferRequestListener;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.ptl.ifc.transmitter.EventListener;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTIf;
import com.ibm.rmm.ptl.ifc.transmitter.StreamTUpcalls;
import com.ibm.rmm.ptl.ifc.util.AdminLayerListener;
import com.ibm.rmm.ptl.tcp.transmitter.PTransmitter;
import com.ibm.rmm.ptl.tcp.transmitter.UnicastConnection;
import com.ibm.rmm.util.StackTracer;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

public class StreamT
implements StreamTIf {
    static final String moduleName = "PTL_TCP_T";
    PTransmitter pTrans;
    short shortId;
    long longId;
    byte[] tag;
    short tagLength;
    long cpTimestamp;
    int pendFrontSeqN;
    int sentFrontSeqN;
    RmmBuffer controlPacket;
    Object cpLock;
    BufferCyclQueue pendingPackets;
    int oldFront;
    boolean isActive;
    boolean isClosed;
    boolean inPS;
    boolean inZD;
    long openTime;
    long closeTime;
    private DataOutputStream dos;
    private DataOutputStream cpDos;
    private DataOutputStream miscDos;
    private ByteArrayOutputStream cpBaos;
    private ByteArrayOutputStream miscBaos;
    private PersistByteArrayOutputStream pbaos;
    private BufferRequestListener bufferRequestListener;
    AdminLayerListener adminListener;
    TokenBucket oDataBucket;
    StreamTUpcalls mCleanUp;
    boolean limitRate = false;
    byte[] optionsField;
    private Hashtable controlOptions;
    int noReListContr;
    SocketChannel destination;
    UnicastConnection unicastConnection;
    Vector pendingConnections;
    EventListener eventListener;
    boolean pendingConnection;
    boolean quarantine;
    SocketChannel quarantineDest;
    int quarantineFailedDest;
    RmmBuffer quarantineBuffer;
    boolean quarantineIsCP;
    long bytesTransmitted;
    long bytesRetransmitted;
    long last_bytesTransmitted;
    int mtlSize;
    boolean sendPartial;
    Object sendPartialMutex;
    int busyRetries = 0;
    long busyRetriesTime = 0L;
    int cpRetries = 0;
    int snpEvent;
    volatile boolean connectionClosed = false;

    StreamT(PTransmitter ptr) {
        this.pTrans = ptr;
    }

    boolean init(byte[] tag, short id, boolean is_reliable, InetAddress mcast_address, boolean lj_enabled) {
        this.tag = tag;
        this.tagLength = (short)tag.length;
        this.shortId = id;
        this.optionsField = new byte[1];
        this.optionsField[0] = 0;
        this.controlOptions = new Hashtable();
        this.pendingConnections = new Vector();
        this.noReListContr = 0;
        this.isActive = true;
        this.isClosed = false;
        this.pbaos = new PersistByteArrayOutputStream();
        this.dos = new DataOutputStream(this.pbaos);
        this.cpBaos = new ByteArrayOutputStream();
        this.cpDos = new DataOutputStream(this.cpBaos);
        this.miscBaos = new ByteArrayOutputStream();
        this.miscDos = new DataOutputStream(this.miscBaos);
        this.sendPartialMutex = new Object();
        this.sendPartial = false;
        this.pendingConnection = false;
        this.pendFrontSeqN = 0;
        this.sentFrontSeqN = this.pendFrontSeqN - 1;
        try {
            this.miscDos.writeShort(this.shortId);
            this.miscDos.write(this.pTrans.ipAddress, 0, 4);
            this.miscDos.writeShort(this.pTrans.nackPort);
            ByteArrayInputStream bais1 = new ByteArrayInputStream(this.miscBaos.toByteArray());
            DataInputStream dis1 = new DataInputStream(bais1);
            this.longId = dis1.readLong();
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write stream id", ex, moduleName);
            return false;
        }
        this.miscBaos.reset();
        this.cpLock = new Object();
        this.pendingPackets = new BufferCyclQueue(128);
        return this.writeCP(false);
    }

    public synchronized boolean close(boolean soft) {
        if (!this.isActive) {
            return true;
        }
        this.pTrans.rmmLogger.baseInfo(String.valueOf(soft ? "Soft " : "") + "Closing Transmitter Stream: " + this.longId, moduleName);
        this.isActive = false;
        if (soft) {
            this.closeTime = 0L;
        } else {
            this.isClosed = true;
            if (this.destination == null) {
                this.closeTime = Clock.getTime() - (long)this.pTrans.config.closeWaitTime + 5000L;
            } else {
                this.closeTime = Clock.getTime();
                this.pTrans.sendSnp = 5;
            }
        }
        this.pTrans.pendingClosedStreams.add(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanAfterClose() {
        if (this.oDataBucket != null) {
            this.oDataBucket.stop();
        }
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            int sps = this.pendingPackets.qSize();
            int i = 0;
            while (i < sps) {
                this.pTrans.returnBuffer(this.pendingPackets.popFirst());
                ++i;
            }
        }
        try {
            this.pTrans.checkAndRemoveConnection(this.unicastConnection, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unicastConnection = null;
        if (this.mCleanUp != null) {
            this.mCleanUp.cleanAfterClose();
        }
        this.mCleanUp = null;
        this.bufferRequestListener = null;
    }

    public int cleanBuffer(int new_trail) {
        this.pTrans.rmmLogger.baseWarn("Cleaning TcpStream buffer: No effect", null, moduleName);
        return 0;
    }

    public int getFrontSeqNum() {
        return this.pendFrontSeqN;
    }

    public int getTrailSeqNum() {
        this.pTrans.rmmLogger.baseWarn("Getting trail of TcpStream: Returns 0", null, moduleName);
        return 0;
    }

    public int getPossibleJoin() {
        return this.getFrontSeqNum();
    }

    public InetAddress getMulticastGroup() {
        return null;
    }

    public long getId() {
        return this.longId;
    }

    public int getPort() {
        return -1;
    }

    public long getBytesTransmitted() {
        return this.bytesTransmitted;
    }

    public long getPendingQueueSize() {
        return this.pendingPackets.qSize() * this.pTrans.packetSize;
    }

    public long getBytesRetransmitted() {
        return -1L;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public short getTagLength() {
        return this.tagLength;
    }

    public long lastNackTime() {
        this.pTrans.rmmLogger.baseWarn("Getting lastNackTime of TcpStream: Returns 0", null, moduleName);
        return 0L;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isReliable() {
        return true;
    }

    public boolean isQuarantined() {
        return this.quarantine;
    }

    public boolean isConnected(String address, int port2) {
        InetAddress itmp = null;
        if (port2 < 0 || port2 > 65535) {
            return false;
        }
        try {
            itmp = InetAddress.getByName(address);
        }
        catch (UnknownHostException e2) {
            return false;
        }
        return this.unicastConnection.remoteServerPort == port2 && this.unicastConnection.inetAddress.equals(itmp);
    }

    boolean requestPartialPacket() {
        boolean ret;
        if (this.bufferRequestListener != null) {
            ret = this.bufferRequestListener.onRequest();
        } else {
            ++this.noReListContr;
            if (this.noReListContr > 5) {
                this.pTrans.rmmLogger.baseWarn("StreamT:requestPartialPacket bufferRequestListener is null. Stream: " + this.toString(), null, moduleName);
            }
            ret = false;
        }
        return ret;
    }

    public void setBufReqListener(BufferRequestListener listener) {
        if (this.bufferRequestListener != null) {
            this.pTrans.rmmLogger.baseWarn("Replacing bufferRequestListener. Stream: " + this.toString(), new StackTracer(), moduleName);
        }
        this.bufferRequestListener = listener;
    }

    public void setAdminListener(AdminLayerListener fl) {
        this.adminListener = fl;
        if (this.adminListener == null) {
            return;
        }
    }

    public void setCleanUpListener(StreamTUpcalls mcu) {
        this.mCleanUp = mcu;
    }

    public void setEventListener(EventListener el) {
        this.eventListener = el;
    }

    public synchronized void setLjMarker() {
        this.advanceLjMarker(this.pendFrontSeqN);
    }

    public boolean addP2Pdestination(UnicastConnectionIf connection) {
        UnicastConnection ucon = null;
        try {
            ucon = (UnicastConnection)connection;
        }
        catch (Throwable ex) {
            this.pTrans.rmmLogger.baseError("addP2Pdestination invalid connection object", ex, moduleName);
            return false;
        }
        if (ucon == null || !ucon.isValid) {
            this.pTrans.rmmLogger.baseWarn("addP2Pdestination invalid connection object " + ucon, null, moduleName);
            return false;
        }
        this.unicastConnection = ucon;
        this.destination = ucon.socketChannel;
        this.openTime = Clock.getTime();
        this.pTrans.sendSnp = 5;
        this.pTrans.gdAdd(ucon);
        this.pTrans.streamFireout.wakeUp(this);
        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
            this.pTrans.rmmLogger.maxInfo("addP2Pdestination created stream " + this.longId + " on ucon " + ucon.toString() + " dest " + Sutils.printIsa(ucon.inetSocketAddress), moduleName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addP2Pdestination(InetSocketAddress dest, boolean useExisting) {
        UnicastConnection foundCon = null;
        if (dest == null) {
            return false;
        }
        if (useExisting) {
            int found = 0;
            ArrayList arrayList = this.pTrans.globalDestinations;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.pTrans.globalDestinations.size()) {
                    UnicastConnection ucon = (UnicastConnection)this.pTrans.globalDestinations.get(i);
                    if (ucon != null && ucon.isValid && ucon.inetSocketAddress.equals(dest)) {
                        foundCon = ucon;
                        ++found;
                        break;
                    }
                    ++i;
                }
            }
            if (found == 1) {
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("addP2Pdestination with useExisting (" + Sutils.printIsa(dest) + "), found ucon " + foundCon.toString(), moduleName);
                }
                return this.addP2Pdestination(foundCon);
            }
            if (found > 1) {
                this.pTrans.rmmLogger.baseError("Failed to addP2Pdestination with useExisting (" + Sutils.printIsa(dest) + "), found = " + found, null, moduleName);
                return false;
            }
        }
        Object object = this.pTrans.globalLock;
        synchronized (object) {
            UnicastConnection ucon;
            block16: {
                block15: {
                    ucon = this.pTrans.establishConnection(dest);
                    if (ucon != null) break block15;
                    return false;
                }
                if (ucon.socketChannel != null) break block16;
                this.pTrans.rmmLogger.baseError("(addP2Pdestination) could not assign selector for stream " + this.longId, null, moduleName);
                return false;
            }
            this.unicastConnection = ucon;
            this.destination = ucon.socketChannel;
            this.openTime = Clock.getTime();
            this.pTrans.sendSnp = 5;
            this.pTrans.streamFireout.wakeUp(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addP2PdestinationNonBlocking(InetSocketAddress dest, CreateConnectionListener listener, int timeout) {
        UnicastConnection ucon;
        SocketChannel sock;
        block25: {
            sock = null;
            ucon = null;
            boolean return_value = false;
            if (dest == null) {
                return false;
            }
            Object object = this.pTrans.globalLock;
            synchronized (object) {
                block26: {
                    block23: {
                        block24: {
                            ucon = this.pTrans.establishConnectionNonBlocking(dest);
                            if (ucon == null) return false;
                            if (ucon.socketChannel == null) {
                                return false;
                            }
                            sock = ucon.socketChannel;
                            boolean res = true;
                            boolean completeConnectOnThisThread = false;
                            if (!completeConnectOnThisThread || !sock.isConnected()) break block23;
                            res = this.pTrans.setConnectionProperties(sock, dest);
                            if (res) {
                                try {
                                    this.pTrans.writeServerPort(sock);
                                }
                                catch (IOException ex) {
                                    this.pTrans.rmmLogger.baseWarn("Failed to write Port number after establishing a TCP connection to " + Sutils.printIsa(dest), ex, moduleName);
                                    res = false;
                                }
                            }
                            if (this.pTrans.myPReceiver != null && res) {
                                try {
                                    ucon.setRegisterStatus(2);
                                    this.pTrans.myPReceiver.registerNewConnection(ucon, dest.getAddress(), dest.getPort());
                                }
                                catch (Exception ex) {
                                    this.pTrans.rmmLogger.baseError("Failed to register new TCP connection with PacketReceiver (" + Sutils.printIsa(dest) + ", Local port: " + sock.socket().getLocalPort() + ").", ex, moduleName);
                                    res = false;
                                }
                            }
                            if (!res) break block24;
                            this.unicastConnection = ucon;
                            this.pTrans.gdAdd(ucon);
                            return_value = true;
                            if (return_value) break block25;
                            break block26;
                        }
                        ucon.closeConnection(0);
                        try {
                            sock.socket().close();
                            sock.close();
                        }
                        catch (IOException ex) {
                            this.pTrans.rmmLogger.baseWarn("Failed to close socket after NB establish connection failed " + Sutils.printIsa(dest), ex, moduleName);
                        }
                        catch (Throwable exp) {
                            this.pTrans.rmmLogger.baseWarn("Error when closing socket after NB establish connection failed " + Sutils.printIsa(dest), exp, moduleName);
                        }
                        return false;
                    }
                    ucon.createConnectionListener = listener;
                    ucon.timeout = timeout;
                    this.unicastConnection = ucon;
                    this.pendingConnection = true;
                    LinkedList linkedList = this.pTrans.pendingConnectionStreams;
                    synchronized (linkedList) {
                        this.pTrans.pendingConnectionStreams.addLast(this);
                        this.pTrans.pendingConnectionStreams.notify();
                    }
                    if (!this.pTrans.rmmLogger.isMaxLogLevel()) return true;
                    this.pTrans.rmmLogger.maxInfo("Created connection object to finish QueueT creation (will timeout in " + timeout + " ms). Stream " + this.longId, moduleName);
                    return true;
                }
                this.pTrans.rmmLogger.baseError("addP2PdestinationNonBlocking error, return_value is " + return_value + " should be true. New TCP connection to (" + Sutils.printIsa(dest) + ", Local port: " + sock.socket().getLocalPort() + ").", null, moduleName);
                return false;
            }
        }
        if (!this.connectionClosed) {
            listener.onSuccess();
            if (this.isActive) {
                this.destination = ucon.socketChannel;
                this.openTime = Clock.getTime();
                this.pTrans.sendSnp = 5;
                this.pTrans.streamFireout.wakeUp(this);
                return true;
            }
            if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                this.pTrans.rmmLogger.maxInfo("stream closed from onSuccess " + this.longId + ", ucon " + ucon, moduleName);
            }
            this.pTrans.gdRemove(ucon);
            this.pTrans.closeConnection(ucon);
            return true;
        }
        ucon.closeConnection(0);
        listener.closeTopic();
        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
            this.pTrans.rmmLogger.maxWarn("addP2PdestinationNonBlocking: found closed topic on stream " + this.longId, null, moduleName);
        }
        try {
            sock.close();
            return false;
        }
        catch (Throwable ex) {
            this.pTrans.rmmLogger.baseWarn("addP2PdestinationNonBlocking exception after finding connectionClosed " + Sutils.printIsa(dest), ex, moduleName);
        }
        return false;
    }

    public boolean checkDestinationsConnected() {
        if (!this.destination.isOpen() || !this.destination.isConnected() || this.destination.socket().isOutputShutdown()) {
            this.pTrans.rmmLogger.baseWarn("checkDestinationsConnected found unconnected destination.", null, moduleName);
            InetSocketAddress dest = (InetSocketAddress)this.destination.socket().getRemoteSocketAddress();
            if (dest != null) {
                this.pTrans.rmmLogger.baseWarn("Connection closed to " + Sutils.printIsa(dest) + ".\n", null, moduleName);
            }
            this.pTrans.removeClosedConnection(this.unicastConnection);
        }
        return true;
    }

    public void removeP2Pdestination(InetSocketAddress dest) {
    }

    public boolean removeDestination(InetSocketAddress dest, SocketChannel schannel) {
        boolean found = false;
        return found;
    }

    public synchronized void advanceLjMarker(int pack_n) {
        this.pTrans.rmmLogger.baseError("Calling StreamT.advanceLjMarker on unicast stream", null, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitPacketData(byte[] mtlhdr, int off1, int len1, byte[] mtldat, int off2, int len2) {
        RmmBuffer packet = this.pTrans.getBuffer(this);
        if (packet == null) {
            return false;
        }
        this.pbaos.setBuffer(packet.dataBuffer);
        byte[] options = this.optionsField;
        try {
            int len = 14 + options.length + 2 + this.tagLength + len1 + len2;
            if (len + 4 > this.pTrans.packetSize) {
                this.pTrans.rmmLogger.baseLog(415, new Object[]{"" + (len + 4), "submitPacketData: len > packetSize: " + len + " " + 14 + " " + options.length + " " + this.tagLength + " " + len1 + " " + len2}, null, moduleName);
                this.pTrans.rmmLogger.baseError("submitPacketData: len > packetSize: " + len + " " + 14 + " " + options.length + " " + this.tagLength + " " + len1 + " " + len2, null, moduleName);
            }
            this.dos.writeInt(len);
            this.dos.writeByte(100);
            this.dos.writeByte(1);
            this.dos.writeLong(this.longId);
            this.dos.writeInt(this.pendFrontSeqN);
            this.dos.write(options);
            this.dos.writeShort(this.tagLength);
            this.dos.write(this.tag, 0, this.tagLength);
            this.dos.write(mtlhdr, off1, len1);
            this.dos.write(mtldat, off2, len2);
        }
        catch (IOException ex) {
            this.pTrans.rmmLogger.baseError("Failed to write data packet. Stream: " + this.toString(), ex, moduleName);
            this.pTrans.returnBuffer(packet);
            return false;
        }
        packet.dataLength = this.pbaos.getPosition();
        BufferCyclQueue bufferCyclQueue = this.pendingPackets;
        synchronized (bufferCyclQueue) {
            block8: {
                if (!this.isClosed) break block8;
                this.pTrans.rmmLogger.baseWarn("submitPacketData called on closed stream " + this.longId + " pending queue size " + this.getPendingQueueSize(), null, moduleName);
                this.pTrans.returnBuffer(packet);
                return false;
            }
            this.pendingPackets.pushLast(packet);
        }
        this.pTrans.streamFireout.wakeUp(this);
        this.bytesTransmitted += (long)this.pbaos.getPosition();
        ++this.pendFrontSeqN;
        return true;
    }

    public boolean isCongested() {
        return this.pTrans.bufferPool.size() < 20;
    }

    public void wakeUp() {
        if (!this.inZD && this.pendingPackets.qSize() == 0) {
            this.pTrans.timingThrd.wakeUp(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeCP(boolean heartbeatOnly) {
        Object object = this.cpLock;
        synchronized (object) {
            this.cpBaos.reset();
            if (heartbeatOnly) {
                try {
                    int len = 4;
                    this.cpDos.writeInt(len);
                    this.cpDos.writeByte(100);
                    this.cpDos.writeByte(5);
                    if (!this.pTrans.config.tcpKeepAlive) {
                        this.cpDos.writeShort((short)(this.pTrans.config.cpTimeout / 1000));
                    } else {
                        this.cpDos.writeShort(-1);
                    }
                }
                catch (IOException ex) {
                    this.pTrans.rmmLogger.baseError("Failed to write Connection HB packet.", ex, moduleName);
                    return false;
                }
                this.controlPacket = new RmmBuffer(this.cpBaos.toByteArray());
            } else {
                try {
                    this.writeOptions();
                    int len = 18 + this.tagLength + this.optionsField.length;
                    this.cpDos.writeInt(len);
                    this.cpDos.writeByte(100);
                    this.cpDos.writeByte(2);
                    this.cpDos.writeLong(this.longId);
                    this.cpDos.writeInt(this.sentFrontSeqN);
                    this.cpDos.write(this.optionsField);
                    this.cpDos.writeShort(this.tagLength);
                    this.cpDos.write(this.tag, 0, this.tagLength);
                    if (!this.pTrans.config.tcpKeepAlive) {
                        this.cpDos.writeShort((short)(this.pTrans.config.cpTimeout / 1000));
                    } else {
                        this.cpDos.writeShort(-1);
                    }
                }
                catch (IOException ex) {
                    this.pTrans.rmmLogger.baseError("Failed to write ControlPacket. Stream: " + this.toString(), ex, moduleName);
                    return false;
                }
                this.controlPacket = new RmmBuffer(this.cpBaos.toByteArray());
                if (this.pTrans.rmmLogger.isMaxLogLevel()) {
                    this.pTrans.rmmLogger.maxInfo("ControlPacket written for stream: " + this.toString(), moduleName);
                }
            }
            this.pTrans.streamFireout.wakeUp(this);
            this.cpBaos.reset();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOptions() {
        ByteArrayOutputStream byteArrayOutputStream = this.miscBaos;
        synchronized (byteArrayOutputStream) {
            this.miscBaos.reset();
            int n_options = this.isActive ? 0 : 1;
            try {
                this.miscDos.writeByte(n_options);
                if (!this.isActive) {
                    this.miscDos.writeByte(2);
                    int opt_len = 0;
                    this.miscDos.writeShort(opt_len);
                }
            }
            catch (IOException ex) {
                this.pTrans.rmmLogger.baseError("Failed to write options. Stream: " + this.toString(), ex, moduleName);
                return;
            }
            this.optionsField = this.miscBaos.toByteArray();
        }
    }

    public void setTransmissionRate(int rate_kbps) {
        if (this.oDataBucket == null) {
            this.oDataBucket = new TokenBucket(rate_kbps, this.pTrans.rmmLogger, this.pTrans.taskMan);
            this.limitRate = true;
        }
    }

    public void startCongestionControl(int rate_kbps) {
        this.pTrans.rmmLogger.baseWarn("Setting congestion control in TCP stream. Has no effect", null, moduleName);
    }

    public void stopCongestionControl() {
        this.pTrans.rmmLogger.baseWarn("Stopping congestion control in TCP stream. Has no effect", null, moduleName);
    }

    public void setAdminOption(byte type, byte[] option) {
        if (this.controlOptions.size() > 64) {
            this.pTrans.rmmLogger.baseWarn("StreamT.setControlOption: failed: too many options set. Stream: " + this.toString(), null, moduleName);
            return;
        }
        this.controlOptions.put(new Byte(type), option);
        this.writeCP(false);
    }

    public synchronized void setRedLine(int pack_seq_n) {
        this.pTrans.rmmLogger.baseWarn("Setting red line of TcpStream: No effect", null, moduleName);
    }

    public synchronized void removeRedLine() {
        this.pTrans.rmmLogger.baseWarn("Removing red line of TcpStream: No effect", null, moduleName);
    }

    public synchronized int getRedLine() {
        this.pTrans.rmmLogger.baseWarn("No red line for TcpStream.", null, moduleName);
        return -1;
    }

    public void removeAdminOption(byte type) {
        this.controlOptions.remove(new Byte(type));
        this.writeCP(false);
    }

    public String toString() {
        return "" + this.longId;
    }

    public boolean sendHeartbeat() {
        boolean res = false;
        if (this.controlPacket == null) {
            res = this.writeCP(false);
        }
        if (this.pTrans.rmmLogger.isMaxLogLevel()) {
            this.pTrans.rmmLogger.maxInfo("sendHeartbeat called on stream " + this.longId + ", return value " + res, moduleName);
        }
        return res;
    }

    public UnicastConnectionIf getUnicastConnection() {
        return this.unicastConnection;
    }

    public void setMtlSize(int size) {
        this.mtlSize = size;
    }
}

