/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.ptl.tcp.transmitter;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.transmitter.CreateConnectionListener;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class UnicastConnection
implements UnicastConnectionIf {
    volatile boolean isValid = true;
    InetAddress inetAddress;
    int localPort;
    int remotePort;
    public int remoteServerPort;
    SocketChannel socketChannel;
    boolean isOutbound;
    public InetSocketAddress inetSocketAddress;
    public boolean hbTimeoutDetected;
    public boolean reportTimeout;
    public boolean requestClose;
    public boolean quarantine;
    public SelectionKey selKey;
    CreateConnectionListener createConnectionListener;
    public long timeCreated;
    public int timeout;
    public boolean isRxClosed;
    public boolean isTxClosed;
    public int registerStatus;
    private Object closeMutex;
    public static final int REG_STAT_FAILED = -1;
    public static final int REG_STAT_NOT_SET = 0;
    public static final int REG_STAT_PENDING = 1;
    public static final int REG_STAT_WAIT = 2;
    public static final int REG_STAT_NOWAIT = 3;
    public static final int REG_STAT_DONE = 4;

    public UnicastConnection(InetAddress inetAdd, int rPort, int lPort, int sPort, SocketChannel sChannel, boolean isOut) {
        this.inetAddress = inetAdd;
        this.localPort = lPort;
        this.remotePort = rPort;
        this.remoteServerPort = sPort;
        this.socketChannel = sChannel;
        this.isOutbound = isOut;
        this.inetSocketAddress = new InetSocketAddress(this.inetAddress, this.remoteServerPort);
        this.timeCreated = Clock.getTime();
        this.timeout = 0;
        this.reportTimeout = true;
        this.requestClose = false;
        this.hbTimeoutDetected = false;
        this.isRxClosed = false;
        this.isTxClosed = false;
        this.closeMutex = new Object();
        this.registerStatus = 0;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public InetAddress getRemoteAddress() {
        return this.inetAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.inetSocketAddress;
    }

    public void setRemoteServerPort(int sPort) {
        this.remoteServerPort = sPort;
        this.inetSocketAddress = new InetSocketAddress(this.inetAddress, this.remoteServerPort);
    }

    public void updateLocalPort() {
        int lport = 0;
        try {
            if (this.socketChannel != null) {
                this.localPort = lport = this.socketChannel.socket().getLocalPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "UnicastConnection@" + this.hashCode() + ", address: " + Sutils.printIsa(this.inetSocketAddress) + " |" + this.localPort + ", isOutbound: " + this.isOutbound + ", isValid: " + this.isValid + " (" + this.isRxClosed + " " + this.isTxClosed + ")" + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnection(int timeout_milli) {
        Object object = this.closeMutex;
        synchronized (object) {
            this.isValid = false;
        }
        if (timeout_milli <= 0) {
            return false;
        }
        int max_wait = timeout_milli;
        int waited = 0;
        boolean closed = false;
        while (waited < max_wait) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                break;
            }
            Object object2 = this.closeMutex;
            synchronized (object2) {
                if (this.isRxClosed && this.isTxClosed) {
                    closed = true;
                    break;
                }
            }
            waited += 20;
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeMutex;
        synchronized (object) {
            return this.isRxClosed && this.isTxClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalid() {
        Object object = this.closeMutex;
        synchronized (object) {
            return !this.isValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRegisterStatus() {
        Object object = this.closeMutex;
        synchronized (object) {
            return this.registerStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisterStatus(int stat) {
        Object object = this.closeMutex;
        synchronized (object) {
            this.registerStatus = stat;
        }
    }
}

