/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.receiver;

import com.ibm.rmm.intrn.util.Sutils;
import com.ibm.rmm.ptl.ifc.receiver.REventIf;
import com.ibm.rmm.ptl.ifc.receiver.StreamRIf;
import com.ibm.rmm.receiver.RMReceiver;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;

public class Event {
    private StreamRIf stream;
    private InetAddress sourceAddress;
    private int sourcePort;
    private REventIf pEvent;
    private int intField;
    private int type;
    private Object objField;
    private long longField;
    public static final int PACKET_LOSS = 1;
    public static final int HEARTBEAT_TIMEOUT = 2;
    public static final int VERSION_CONFLICT = 3;
    public static final int RELIABILITY = 4;
    public static final int CLOSED_TRANS = 5;
    public static final int NEW_SOURCE = 10;
    public static final int SUSPEND_NACK = 12;
    public static final int SUSPEND_REC = 11;
    public static final int RESUME_DATA = 14;
    public static final int RESUME_REC = 13;
    public static final int NO_SOURCE = 17;
    public static final int NACK_SEND_FAILURE = 18;
    public static final int STREAM_NOT_PRESENT_AT_SOURCE = 20;
    public static final int BUFFER_OVERFLOW = 100;
    public static final int MEMORY_ALERT_ON = 101;
    public static final int MEMORY_ALERT_OFF = 102;
    public static final int MESSAGE_OUT_OF_MEMORY = 103;
    public static final int CONNECTION_HEARTBEAT_TIMEOUT = 19;

    public Event(REventIf pev) {
        this.pEvent = pev;
        this.stream = pev.getStream();
        if (this.stream != null) {
            this.sourceAddress = pev.getStream().getSourceAddress();
            this.sourcePort = pev.getStream().getSourcePort();
        }
        this.intField = this.pEvent.getIntField();
        this.objField = this.pEvent.getObjectField();
        this.type = this.pEvent.getType();
    }

    public Event(int type, long long_f, int int_f, Object obj_f, InetAddress s_addr, int s_port) {
        this.sourceAddress = s_addr;
        this.sourcePort = s_port;
        this.longField = long_f;
        this.intField = int_f;
        this.objField = obj_f;
        this.type = type;
    }

    public int getIntField() {
        return this.intField;
    }

    public Object getObjectField() {
        return this.objField;
    }

    public int getType() {
        return this.type;
    }

    public long getLongField() {
        return this.longField;
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public long getStreamId() {
        if (this.stream == null) {
            return 0L;
        }
        return this.stream.getId();
    }

    public byte[] getStreamTag() {
        if (this.stream == null) {
            return new byte[1];
        }
        return this.stream.getTag();
    }

    public String getTopicName() throws UnsupportedEncodingException {
        if (this.stream == null) {
            return null;
        }
        String tmp = Sutils.bytesToString(this.stream.getTag());
        return Sutils.toPrintableString(tmp);
    }

    public String getDescription() {
        return RMReceiver.eventDescription(this.type);
    }
}

