/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.receiver;

import com.ibm.rmm.admin.RMAdmin;
import com.ibm.rmm.ifc.channel.ChannelIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.receiver.MReceiver;
import com.ibm.rmm.mtl.receiver.MStreamSetR;
import com.ibm.rmm.mtl.receiver.MTopicR;
import com.ibm.rmm.receiver.QueueR;
import com.ibm.rmm.receiver.StreamSelector;
import com.ibm.rmm.receiver.StreamSetR;
import com.ibm.rmm.receiver.TopicR;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.MemoryReport;
import com.ibm.rmm.util.RmmAddressIf;
import java.util.List;
import java.util.Properties;

public class RMReceiver {
    protected MReceiver mReceiver;
    protected AdminClient adminClient;
    boolean isRunning;

    public static synchronized RMReceiver getInstance() {
        RMReceiver instance = new RMReceiver();
        if (instance == null) {
            return null;
        }
        instance.mReceiver = MReceiver.getInstance();
        if (instance.mReceiver == null) {
            return null;
        }
        if (instance.mReceiver.config.enableAdmin) {
            instance.adminClient = AdminClient.getInstance(instance.mReceiver);
        }
        return instance;
    }

    public static synchronized RMReceiver getInstance(Properties config_props, int log_level, int debug_level, LogEventListener listener) {
        RMReceiver instance = new RMReceiver();
        if (instance == null) {
            return null;
        }
        instance.mReceiver = MReceiver.getInstance(config_props, log_level, debug_level, listener);
        if (instance.mReceiver == null) {
            return null;
        }
        if (instance.mReceiver.config.enableAdmin) {
            instance.adminClient = AdminClient.getInstance(instance.mReceiver);
        }
        return instance;
    }

    public RMAdmin getAdmin() {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        return this.adminClient;
    }

    public RmmAddressIf getRmmAddress() {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        return this.mReceiver.rmmAddress;
    }

    public List getTopicList() {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        return this.mReceiver.getTopicList();
    }

    public synchronized TopicR createTopicReceiver(String topic, boolean reliable, boolean ordered) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        MTopicR t = this.mReceiver.createTopicReceiver(topic, reliable, ordered);
        if (t == null) {
            return null;
        }
        return new TopicR(t);
    }

    public synchronized QueueR createQueueReceiver(String topic) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        MTopicR t = this.mReceiver.createQueueReceiver(topic);
        if (t == null) {
            return null;
        }
        return new QueueR(t);
    }

    public synchronized TopicR createTopicReceiver(String topic, boolean reliable) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        return this.createTopicReceiver(topic, reliable, true);
    }

    public synchronized StreamSetR createStreamSetReceiver(StreamSelector selector, boolean reliable, boolean ordered) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        MStreamSetR mss = this.mReceiver.createStreamSetReceiver(selector, reliable, ordered);
        if (mss == null) {
            return null;
        }
        return new StreamSetR(mss);
    }

    public synchronized StreamSetR createStreamSetReceiver(StreamSelector selector, boolean reliable) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        MStreamSetR mss = this.mReceiver.createStreamSetReceiver(selector, reliable, true);
        if (mss == null) {
            return null;
        }
        return new StreamSetR(mss);
    }

    public synchronized QueueR createQueueReceiver(StreamSelector selector) {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        MStreamSetR mss = this.mReceiver.createQueueReceiver(selector);
        if (mss == null) {
            return null;
        }
        return new QueueR(mss);
    }

    public synchronized boolean setExternalChannel(ChannelIf channel) {
        if (!this.mReceiver.isRunning()) {
            return false;
        }
        this.adminClient.connectTcpChannel(channel);
        return true;
    }

    public static String eventDescription(int event_type) {
        return MReceiver.eventDescription(event_type);
    }

    public synchronized boolean stop() {
        if (!this.mReceiver.isRunning()) {
            return false;
        }
        if (this.adminClient != null) {
            this.adminClient.stop();
        }
        this.mReceiver.stop();
        return true;
    }

    public String getVersion() {
        return this.mReceiver.getVersion();
    }

    public synchronized boolean joinMulticastGroup(String address) {
        if (!this.mReceiver.isRunning()) {
            return false;
        }
        return this.mReceiver.joinMulticastGroup(address, -1, true);
    }

    public synchronized boolean leaveMulticastGroup(String address) {
        if (!this.mReceiver.isRunning()) {
            return false;
        }
        return this.mReceiver.leaveMulticastGroup(address, -1, true);
    }

    public synchronized MemoryReport checkMemoryConsumption() {
        if (!this.mReceiver.isRunning()) {
            return null;
        }
        return this.mReceiver.checkMemoryConsumption();
    }

    public synchronized void setLogDebugLevels(int log_level, int debug_level) {
        if (!this.mReceiver.isRunning()) {
            return;
        }
        if (this.mReceiver.rmmLogger != null) {
            this.mReceiver.rmmLogger.changeLevels(log_level, debug_level);
        }
    }

    public synchronized String getStatusSnapshot() {
        if (!this.mReceiver.isRunning()) {
            return "_RMM_STATS_ Receiver Snapshot: Receiver is not running";
        }
        return this.mReceiver.currentStatusLog(false);
    }
}

