/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.transmitter;

import com.ibm.rmm.admin.RMAdmin;
import com.ibm.rmm.ifc.channel.ChannelIf;
import com.ibm.rmm.mtl.admin.AdminClient;
import com.ibm.rmm.mtl.admin.VerifyTopicInterest;
import com.ibm.rmm.mtl.transmitter.MLJETopicT;
import com.ibm.rmm.mtl.transmitter.MTopicT;
import com.ibm.rmm.mtl.transmitter.MTransmitter;
import com.ibm.rmm.transmitter.CreateQueueTListener;
import com.ibm.rmm.transmitter.LJETopicT;
import com.ibm.rmm.transmitter.QueueT;
import com.ibm.rmm.transmitter.TopicT;
import com.ibm.rmm.util.FullBufferListener;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.RmmAddressIf;
import com.ibm.rmm.util.TopicInterestListener;
import com.ibm.rmm.util.UnicastConnectionIf;
import java.util.Map;
import java.util.Properties;

public class RMTransmitter {
    protected MTransmitter mrmTransmitter;
    protected AdminClient adminClient;

    public static synchronized RMTransmitter getInstance() {
        RMTransmitter instance = new RMTransmitter();
        if (instance == null) {
            return null;
        }
        instance.mrmTransmitter = MTransmitter.getInstance();
        if (instance.mrmTransmitter == null) {
            return null;
        }
        if (instance.mrmTransmitter.config.enableAdmin) {
            instance.adminClient = AdminClient.getInstance(instance.mrmTransmitter);
        }
        return instance;
    }

    public static synchronized RMTransmitter getInstance(Properties config_props, int log_level, int debug_level, LogEventListener listener) {
        RMTransmitter instance = new RMTransmitter();
        if (instance == null) {
            return null;
        }
        instance.mrmTransmitter = MTransmitter.getInstance(config_props, null, log_level, debug_level, listener);
        if (instance.mrmTransmitter == null) {
            return null;
        }
        if (instance.mrmTransmitter.config.enableAdmin) {
            instance.adminClient = AdminClient.getInstance(instance.mrmTransmitter);
        }
        return instance;
    }

    public static synchronized RMTransmitter getInstance(Properties config_props, Map config_map, int log_level, int debug_level, LogEventListener listener) {
        RMTransmitter instance = new RMTransmitter();
        if (instance == null) {
            return null;
        }
        instance.mrmTransmitter = MTransmitter.getInstance(config_props, config_map, log_level, debug_level, listener);
        if (instance.mrmTransmitter == null) {
            return null;
        }
        if (instance.mrmTransmitter.config.enableAdmin) {
            instance.adminClient = AdminClient.getInstance(instance.mrmTransmitter);
        }
        return instance;
    }

    public Double getAverageRetransmissionRate() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return new Double(this.mrmTransmitter.getAverageRetransmissionRate());
    }

    public Long getPendingQueueSize() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return new Long(this.mrmTransmitter.getPendingQueueSize());
    }

    public RMAdmin getAdmin() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return this.adminClient;
    }

    public RmmAddressIf getRmmAddress() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return this.mrmTransmitter.rmmAddress;
    }

    public Map getTopicList() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return this.mrmTransmitter.getTopicList();
    }

    public synchronized TopicT createTopicTransmitter(String topic, boolean reliable, String address) {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        MTopicT t = this.mrmTransmitter.createTopicTransmitter(topic, reliable, address);
        if (t == null) {
            return null;
        }
        return new TopicT(t);
    }

    public synchronized QueueT createQueueTransmitter(String queue, String address, int port2) {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        MTopicT t = this.mrmTransmitter.createQueueTransmitter(queue, null, address, port2, false, null, -1);
        if (t == null) {
            return null;
        }
        return new QueueT(t);
    }

    public synchronized QueueT createQueueTransmitter(String queue, String address, int port2, boolean useExisting) {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        MTopicT t = this.mrmTransmitter.createQueueTransmitter(queue, null, address, port2, useExisting, null, -1);
        if (t == null) {
            return null;
        }
        return new QueueT(t);
    }

    public synchronized boolean createQueueTransmitter(String queue, String address, int port2, CreateQueueTListener listener, int timeout) {
        if (listener == null) {
            return false;
        }
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        MTopicT t = this.mrmTransmitter.createQueueTransmitter(queue, null, address, port2, false, listener, timeout);
        return t != null;
    }

    public synchronized boolean createQueueTransmitter(byte[] tag, String address, int port2, CreateQueueTListener listener, int timeout) {
        if (listener == null) {
            return false;
        }
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        MTopicT t = this.mrmTransmitter.createQueueTransmitter(null, tag, address, port2, false, listener, timeout);
        return t != null;
    }

    public synchronized QueueT createQueueTransmitter(String queue, byte[] tag, UnicastConnectionIf connection) {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        MTopicT t = this.mrmTransmitter.createQueueTransmitter(queue, tag, connection);
        if (t == null) {
            return null;
        }
        return new QueueT(t);
    }

    public synchronized void addFullBufferListener(FullBufferListener fbl) {
        if (!this.mrmTransmitter.isRunning()) {
            return;
        }
        this.mrmTransmitter.addFullBufferListener(fbl);
    }

    public synchronized void removeFullBufferListener(FullBufferListener fbl) {
        if (!this.mrmTransmitter.isRunning()) {
            return;
        }
        this.mrmTransmitter.removeFullBufferListener(fbl);
    }

    public synchronized LJETopicT createLJETopicTransmitter(String topic, String address) {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        MLJETopicT t = this.mrmTransmitter.createLJETopicTransmitter(topic, address);
        if (t == null) {
            return null;
        }
        return new LJETopicT(t);
    }

    public static String getVersion() {
        return "1.9.8.19 - 16/03/09";
    }

    public Integer getLocalPort() {
        if (!this.mrmTransmitter.isRunning()) {
            return null;
        }
        return new Integer(this.mrmTransmitter.getLocalPort());
    }

    public synchronized Boolean isRunning() {
        return new Boolean(this.mrmTransmitter.isRunning());
    }

    public synchronized boolean setTransmissionRate(int new_rate_Kbps) {
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        return this.mrmTransmitter.setTransmissionRate(new_rate_Kbps);
    }

    public boolean setExternalChannel(ChannelIf channel) {
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        this.adminClient.connectTcpChannel(channel);
        return true;
    }

    public boolean verifyInterest(String topicName, TopicInterestListener listener, int timeout) {
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        new VerifyTopicInterest(topicName, 0L, this.mrmTransmitter.rmmAddress.getInetAddress().getHostAddress(), this.mrmTransmitter.rmmAddress.getPort(), listener, timeout);
        return true;
    }

    public synchronized boolean stop() {
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        if (this.adminClient != null) {
            this.adminClient.stop();
        }
        boolean res = this.mrmTransmitter.stop(true);
        return res;
    }

    public synchronized boolean stop(boolean soft) {
        if (!this.mrmTransmitter.isRunning()) {
            return false;
        }
        if (this.adminClient != null) {
            this.adminClient.stop();
        }
        boolean res = this.mrmTransmitter.stop(soft);
        return res;
    }

    public synchronized void setLogDebugLevels(int log_level, int debug_level) {
        if (!this.mrmTransmitter.isRunning()) {
            return;
        }
        if (this.mrmTransmitter.rmmLogger != null) {
            this.mrmTransmitter.rmmLogger.changeLevels(log_level, debug_level);
        }
    }

    public synchronized String getStatusSnapshot() {
        if (!this.mrmTransmitter.isRunning()) {
            return "_RMM_STATS_ Transmitter Snapshot: Transmitter is not running";
        }
        return this.mrmTransmitter.currentStatusLog(false);
    }
}

