/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.util;

import com.ibm.rmm.intrn.util.Sutils;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MemoryReport {
    private final long staticMemoryLimit;
    private final long dynamicMemoryLimit;
    private MemoryUsed totalMemoryUsed;
    private Map report = new HashMap();
    private MemorySource maxMemorySource = null;
    private MemoryUsed maxMemoryUsed = null;

    public MemoryReport(long staticMemoryLimit, long dynamicMemoryLimit) {
        this.staticMemoryLimit = staticMemoryLimit;
        this.dynamicMemoryLimit = dynamicMemoryLimit;
    }

    public void addEntryToReport(long srcStreamId, String srcTopicName, InetAddress srcAddress, int srcPort, long currentUsageFifoQ, long currentUsageMessageQ) {
        MemorySource src = new MemorySource(new Long(srcStreamId), srcTopicName, srcAddress, srcPort);
        MemoryUsed used = new MemoryUsed(currentUsageFifoQ, currentUsageMessageQ);
        this.report.put(src, used);
        if (this.maxMemoryUsed == null || used.compareTo(this.maxMemoryUsed) > 0) {
            this.maxMemorySource = src;
            this.maxMemoryUsed = used;
        }
    }

    public long getDynamicMemoryLimit() {
        return this.dynamicMemoryLimit;
    }

    public long getStaticMemoryLimit() {
        return this.staticMemoryLimit;
    }

    public MemoryUsed getTotalMemoryUsed() {
        return this.totalMemoryUsed;
    }

    public void setTotalMemoryUsed(MemoryUsed used) {
        this.totalMemoryUsed = used;
    }

    public String toString() {
        String str = "\nMemory Report:\n";
        str = String.valueOf(str) + "Config Receiver Nominal Memory is " + this.staticMemoryLimit;
        str = String.valueOf(str) + "\nConfig Receiver Max Memory " + this.dynamicMemoryLimit;
        str = String.valueOf(str) + "\nMaximum source " + this.maxMemorySource + " used " + this.maxMemoryUsed + "\n";
        return String.valueOf(str) + this.getSortedEntrySet(this.report).toString();
    }

    private Set getSortedEntrySet(Map map) {
        Set set = map.entrySet();
        TreeSet tSet = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                return ((MemoryUsed)e1.getValue()).compareTo((MemoryUsed)e2.getValue());
            }
        });
        tSet.addAll(set);
        return set;
    }

    public MemorySource getHeaviestUser(String topicName) {
        MemoryUsed maxPerTopicUsed = null;
        MemorySource maxPerTopicSource = null;
        Iterator iter = this.report.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            MemorySource src = (MemorySource)element.getKey();
            MemoryUsed used = (MemoryUsed)element.getValue();
            if (!src.topicName.equals(topicName) || used.compareTo(maxPerTopicUsed) <= 0) continue;
            maxPerTopicSource = src;
            maxPerTopicUsed = used;
        }
        return maxPerTopicSource;
    }

    public MemorySource getHeaviestUser() {
        return this.maxMemorySource;
    }

    public MemoryUsed getHeaviestUserMemory() {
        return this.maxMemoryUsed;
    }

    public class MemorySource {
        private final Long streamId;
        private final String topicName;
        private final InetAddress address;
        private final int port;

        public MemorySource(Long streamId, String topicName, InetAddress address, int port2) {
            this.streamId = streamId;
            this.topicName = topicName;
            this.address = address;
            this.port = port2;
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public Long getStreamId() {
            return this.streamId;
        }

        public String getTopicName() {
            return this.topicName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MemorySource) {
                MemorySource src = (MemorySource)obj;
                return this.streamId.equals(src.getStreamId());
            }
            return false;
        }

        public int hashCode() {
            return this.streamId.hashCode();
        }

        public String toString() {
            return "Memory user Address is " + this.address + ":" + this.port + "\nStream id is " + this.streamId + "\nTopic Name is " + Sutils.toPrintableString(this.topicName);
        }
    }

    public class MemoryUsed
    implements Comparable {
        private final long currentUsageFifoQ;
        private final long currentUsageMessageQ;
        private final long currentUsageTotal;

        public MemoryUsed(long currentUsageFifoQ, long currentUsageMessageQ) {
            this.currentUsageFifoQ = currentUsageFifoQ;
            this.currentUsageMessageQ = currentUsageMessageQ;
            this.currentUsageTotal = currentUsageFifoQ + currentUsageMessageQ;
        }

        public long getCurrentUsageFifoQ() {
            return this.currentUsageFifoQ;
        }

        public long getCurrentUsageMessageQ() {
            return this.currentUsageMessageQ;
        }

        public long getCurrentUsageTotal() {
            return this.currentUsageTotal;
        }

        /*
         * WARNING - void declaration
         */
        public int compareTo(Object o) {
            void var2_2;
            if (!(o instanceof MemoryUsed)) {
                return -1;
            }
            MemoryUsed inMem = (MemoryUsed)o;
            Long thisMemory = new Long(this.currentUsageTotal);
            Long inMemory = new Long(var2_2.currentUsageTotal);
            return thisMemory.compareTo(inMemory);
        }

        public String toString() {
            return "\nTotal Memory " + this.currentUsageTotal + "\nMemory used in FifoQ " + this.currentUsageFifoQ + "\nMemory used in MsgQ " + this.currentUsageMessageQ;
        }
    }
}

