/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.util;

import com.ibm.rmm.util.RmmAddressIf;
import com.ibm.rmm.util.RmmLogger;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Enumeration;
import java.util.Random;

public class RmmAddress
implements RmmAddressIf {
    private static final String mn = "Util";
    private ServerSocket sSocket;
    private DatagramSocket uSocket;
    private InetSocketAddress isa;
    private int port;
    private InetAddress address;
    private ServerSocketChannel sSocketChannel;
    private boolean isOK;

    public RmmAddress() {
    }

    public RmmAddress(RmmLogger rlog, InetAddress mc_interface, int data_port, boolean create_sockets) {
        this.isOK = true;
        if (mc_interface != null) {
            this.address = mc_interface;
        } else {
            try {
                this.address = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e1) {
                rlog.baseError("Failed to get Local Host address. Trying NetworkInterface", e1, mn);
                rlog.baseLog(412, new Object[]{"local"}, e1, mn);
            }
            boolean search = false;
            search = this.address == null ? true : this.address.isLoopbackAddress();
            if (search) {
                try {
                    Enumeration<NetworkInterface> nws = NetworkInterface.getNetworkInterfaces();
                    boolean found = false;
                    while (nws.hasMoreElements()) {
                        Enumeration<InetAddress> adrs = nws.nextElement().getInetAddresses();
                        while (adrs.hasMoreElements()) {
                            this.address = adrs.nextElement();
                            if (this.address.isLoopbackAddress()) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e2) {
                    rlog.baseError("Failed to init RMM Address", e2, mn);
                    this.isOK = false;
                }
            }
        }
        int retries = 0;
        if (create_sockets) {
            int prev_nack_port = 0;
            Random rn = new Random(System.currentTimeMillis());
            int i = 0;
            while (i < 30000) {
                block30: {
                    int tmp = rn.nextInt(65535);
                    if (tmp >= 32768 && tmp != data_port && tmp != prev_nack_port) {
                        try {
                            this.sSocket = new ServerSocket(tmp);
                            this.uSocket = new DatagramSocket(tmp);
                            try {
                                this.isa = new InetSocketAddress(tmp + 1);
                            }
                            catch (NoClassDefFoundError ex) {
                                rlog.baseWarn("Failed to init InetSocketAddress in RmmAddress", null, mn);
                            }
                            if (this.isa != null) {
                                this.sSocketChannel = ServerSocketChannel.open();
                                this.sSocketChannel.configureBlocking(false);
                                this.sSocketChannel.socket().bind(this.isa, 100);
                            }
                            this.port = tmp;
                            break;
                        }
                        catch (IOException ex) {
                            ++retries;
                            if (this.sSocket != null) {
                                try {
                                    this.sSocket.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.uSocket != null) {
                                try {
                                    this.uSocket.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.sSocketChannel == null) break block30;
                            try {
                                this.sSocketChannel.socket().close();
                                this.sSocketChannel.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++i;
            }
        } else {
            rlog.baseInfo("RMM address did not create sockets", mn);
            this.port = data_port;
        }
        rlog.baseInfo("The node identity (RmmAddress) is " + this.address + ":" + this.port + "\n Established after " + retries + " re-trials", mn);
        if (this.address.isLoopbackAddress()) {
            rlog.baseWarn("Loopback Address", null, mn);
        }
    }

    public ServerSocket getServerSocket() {
        return this.sSocket;
    }

    public DatagramSocket getUdpSocket() {
        return this.uSocket;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public boolean isValid() {
        return this.isOK;
    }

    public ServerSocketChannel getServerSocketChannel() {
        return this.sSocketChannel;
    }

    public String toString() {
        return String.valueOf(this.address.getHostAddress()) + ":" + this.port;
    }

    public boolean closeUnicastSockets() {
        boolean rc = true;
        if (this.sSocket != null) {
            try {
                this.sSocket.close();
            }
            catch (Throwable excep) {
                rc = false;
            }
        }
        if (this.sSocketChannel != null) {
            try {
                this.sSocketChannel.socket().close();
                this.sSocketChannel.close();
            }
            catch (Throwable excep) {
                rc = false;
            }
        }
        return rc;
    }
}

