/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmm.util;

import com.ibm.rmm.intrn.util.Clock;
import com.ibm.rmm.util.ExtendedLogEventListener;
import com.ibm.rmm.util.LogEventListener;
import com.ibm.rmm.util.exceptions.RmmServiceTerminated;

public class RmmLogger {
    public static final boolean DEBUG_ON = false;
    public static final boolean ENABLE_API_EXCEPTIONS = false;
    private LogEventListener eventListener;
    private int logLevel;
    private int debugLevel;
    private boolean maxLogLevel;
    private boolean checkLevels;
    private long levelUpdateTime;
    private static final long LEVEL_UPDATE_PERIOD = 5000L;
    private boolean isRmmServiceTerminated;
    private RmmServiceTerminated rmmDownExc;
    public static final String[] rmmLogMessages = new String[1000];
    public static final int L_I_GENERAL_INFO = 0;
    public static final int L_I_START_SERVICE = 1;
    public static final int L_I_STOP_SERVICE = 2;
    public static final int L_I_NACK = 3;
    public static final int L_I_BUFFER_CLEAN = 100;
    public static final int L_I_CONTROL_DATA_RECEIVED = 101;
    public static final int L_W_GENERAL_WARNING = 200;
    public static final int L_E_GENERAL_ERROR = 400;
    public static final int L_E_FILE_NOT_FOUND = 401;
    public static final int L_E_CONFIG_ENTRY = 402;
    public static final int L_E_BAD_PARAMETER = 403;
    public static final int L_E_SOCKET_CREATE = 404;
    public static final int L_E_SET_MCAST_INTERF = 405;
    public static final int L_E_INTERRUPT = 406;
    public static final int L_E_TTL = 407;
    public static final int L_E_MCAST_JOIN = 408;
    public static final int L_E_MCAST_LEAVE = 409;
    public static final int L_E_MEMORY_ALLOCATE = 410;
    public static final int L_E_UNSUPPORTED_ENCODING = 411;
    public static final int L_E_UNRESOLVED_ADDRESS = 412;
    public static final int L_E_SOCKET_BUFFER_SIZE = 413;
    public static final int L_E_FAILED_SOCKET_BIND = 414;
    public static final int L_E_INSUFF_PACKET_BUFFER = 415;
    public static final int L_E_SERVICE_TERMINATION = 416;
    public static final int L_E_PACKET_SEND = 417;
    public static final int L_E_CLOCK_PROBLEM = 418;
    public static final int L_E_SOCKET_CONFIG_PROBLEM = 419;
    public static final int L_E_EXCESSIVE_TAG_LENGTH = 420;
    public static final int L_E_NETWORK_PROBLEM = 421;
    public static final int L_E_RAW_IP_PERMISSION = 422;
    public static final int L_E_NATIVE_LIB_NOT_FOUND = 423;
    public static final int L_E_BAD_CONTROL_DATA = 501;
    public static final int L_E_BAD_CONTROL_DATA_CREATION = 502;
    public static final int D_GENERAL = 700;
    public static final int D_METHOD_ENTRY = 701;
    public static final int D_METHOD_EXIT = 702;

    static {
        RmmLogger.rmmLogMessages[1] = "RMM Info: Starting RMM Service: {0}";
        RmmLogger.rmmLogMessages[2] = "RMM Info: Stopping RMM Service: {0}";
        RmmLogger.rmmLogMessages[0] = "RMM Info: {0}";
        RmmLogger.rmmLogMessages[3] = "RMM Info: Nack for {0} packet(s) from {1}";
        RmmLogger.rmmLogMessages[100] = "RMM Info: Clean memory buffer: Erasing {0} packet(s)";
        RmmLogger.rmmLogMessages[101] = "RMM Info: received control information from: {0}. Data: {1}";
        RmmLogger.rmmLogMessages[200] = "RMM Warning: {0}";
        RmmLogger.rmmLogMessages[401] = "RMM Error: File not found: {0}";
        RmmLogger.rmmLogMessages[402] = "RMM Error: Missing configuration entry: {0}";
        RmmLogger.rmmLogMessages[403] = "RMM Error: Bad agrument. Parameter {0}, value: {1}";
        RmmLogger.rmmLogMessages[400] = "RMM Error: {0}";
        RmmLogger.rmmLogMessages[404] = "RMM Error: Socket creation failed. Port:{0}";
        RmmLogger.rmmLogMessages[405] = "RMM Error: Multicast interface setting to {0} failed";
        RmmLogger.rmmLogMessages[406] = "RMM Error: Service {0} interrupted";
        RmmLogger.rmmLogMessages[407] = "RMM Error: Failed to set TimeToLive to: {0}";
        RmmLogger.rmmLogMessages[501] = "RMM Error: bad control data received {0}. Expecting: {1}";
        RmmLogger.rmmLogMessages[502] = "RMM Error: problem when writing {0} control data";
        RmmLogger.rmmLogMessages[408] = "RMM Error: Failed to join multicast group {0}";
        RmmLogger.rmmLogMessages[409] = "RMM Error: Failed to leave multicast group {0}";
        RmmLogger.rmmLogMessages[410] = "RMM Error: Failed to allocate memory: {0} bytes";
        RmmLogger.rmmLogMessages[411] = "RMM Error: Encoding {0} not supported on this host";
        RmmLogger.rmmLogMessages[412] = "RMM Error: Failed to resolve addess: {0}";
        RmmLogger.rmmLogMessages[413] = "RMM Error: Failed to set socket buffer {0} to {1}";
        RmmLogger.rmmLogMessages[414] = "RMM Error: Failed to bind a socket to {0}";
        RmmLogger.rmmLogMessages[415] = "RMM Error: Received packet larger than configured PacketBufferLength {0} from {1}";
        RmmLogger.rmmLogMessages[416] = "RMM Error: Terminating Service/Thread {0} following unrecoverable problem";
        RmmLogger.rmmLogMessages[417] = "RMM Error: Failed to send a packet to {0}";
        RmmLogger.rmmLogMessages[418] = "RMM Error: Clock moved {0}";
        RmmLogger.rmmLogMessages[419] = "RMM Error: Failed to set socket parameter {0} to {1}";
        RmmLogger.rmmLogMessages[420] = "RMM Error: Stream from {0} with tag length {1} longer than configured maximum {2}";
        RmmLogger.rmmLogMessages[421] = "RMM Error: General networking problem on socket address {0}";
        RmmLogger.rmmLogMessages[422] = "RMM Error:\tFailed to create a raw IP socket, insufficient user credentials";
        RmmLogger.rmmLogMessages[423] = "RMM Error: PGM/Raw IP native library not found";
        RmmLogger.rmmLogMessages[700] = "RMM Debug: {0}";
        RmmLogger.rmmLogMessages[701] = "RMM Debug: Entering method {0}, arguments: {1}";
        RmmLogger.rmmLogMessages[702] = "RMM Debug: Exiting method {0}, return value: {1}";
    }

    public RmmLogger(LogEventListener listener, int log_level, int debug_level) {
        this.eventListener = listener;
        this.checkLevels = this.eventListener instanceof ExtendedLogEventListener;
        this.logLevel = log_level;
        this.debugLevel = debug_level;
        this.maxLogLevel = this.logLevel == 2;
    }

    public void changeLevels(int log_level, int debug_level) {
        this.logLevel = log_level;
        this.debugLevel = debug_level;
        this.maxLogLevel = this.logLevel == 2;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public static String getMsgFormat(int index) {
        if (index >= 0 && index < rmmLogMessages.length) {
            return rmmLogMessages[index];
        }
        return null;
    }

    public boolean isMaxLogLevel() {
        if (this.checkLevels && Clock.getTime() - this.levelUpdateTime > 5000L) {
            this.levelUpdateTime = Clock.getTime();
            int level = ((ExtendedLogEventListener)this.eventListener).getLogLevel();
            boolean bl = this.maxLogLevel = level == 2;
            if (level == 2 || level == 1 || level == 0) {
                this.logLevel = level;
            }
        }
        return this.maxLogLevel;
    }

    private void checkFatalProblem(int rid, Object[] rdet, Throwable exc) {
    }

    public void baseLog(int rid, Object[] rdet, Throwable exc, String module) {
        if (this.checkLevels) {
            int level = ((ExtendedLogEventListener)this.eventListener).getLogLevel();
            boolean bl = this.maxLogLevel = level == 2;
            if (level == 2 || level == 1 || level == 0) {
                this.logLevel = level;
            }
        }
        if (this.logLevel >= 1) {
            this.eventListener.onLogEvent(rid, rdet, exc, module);
        }
        this.checkFatalProblem(rid, rdet, exc);
    }

    public void maxLog(int rid, Object[] rdet, Throwable exc, String module) {
        if (this.checkLevels) {
            int level = ((ExtendedLogEventListener)this.eventListener).getLogLevel();
            boolean bl = this.maxLogLevel = level == 2;
            if (level == 2 || level == 1 || level == 0) {
                this.logLevel = level;
            }
        }
        if (this.maxLogLevel) {
            this.eventListener.onLogEvent(rid, rdet, exc, module);
        }
        this.checkFatalProblem(rid, rdet, exc);
    }

    public void baseError(String descr, Throwable ex, String module) {
        this.baseLog(400, new Object[]{descr}, ex, module);
    }

    public void baseWarn(String descr, Throwable ex, String module) {
        this.baseLog(200, new Object[]{descr}, ex, module);
    }

    public void baseInfo(String descr, String module) {
        this.baseLog(0, new Object[]{descr}, null, module);
    }

    public void baseBadParam(String name2, String value2, Throwable ex, String module) {
        this.baseLog(403, new Object[]{name2, value2}, ex, module);
    }

    public void maxError(String descr, Throwable ex, String module) {
        this.maxLog(400, new Object[]{descr}, ex, module);
    }

    public void maxWarn(String descr, Throwable ex, String module) {
        this.maxLog(200, new Object[]{descr}, ex, module);
    }

    public void maxInfo(String descr, String module) {
        this.maxLog(0, new Object[]{descr}, null, module);
    }

    public void baseDebug(int rid, Object[] rdet, Object caller, String module) {
        if (this.debugLevel >= 1) {
            this.eventListener.onDebugEvent(rid, rdet, caller, module);
        }
    }

    public void maxDebug(int rid, Object[] rdet, Object caller, String module) {
        if (this.debugLevel == 2) {
            this.eventListener.onDebugEvent(rid, rdet, caller, module);
        }
    }

    public void baseDebug(String desc, Object caller, String module) {
    }

    public void maxDebug(String desc, Object caller, String module) {
    }

    public void baseMethEntry(String method_name, String args, Object caller, String module) {
        this.baseDebug(701, new Object[]{method_name, args}, caller, module);
    }

    public void maxMethEntry(String method_name, String args, Object caller, String module) {
        this.maxDebug(701, new Object[]{method_name, args}, caller, module);
    }

    public void baseMethExit(String method_name, Object caller, String module) {
        this.baseDebug(702, new Object[]{method_name, ""}, caller, module);
    }

    public void maxMethExit(String method_name, Object caller, String module) {
        this.maxDebug(702, new Object[]{method_name, ""}, caller, module);
    }

    public boolean isRmmServiceTerminated() {
        return this.isRmmServiceTerminated;
    }

    public RmmServiceTerminated getRmmDownException() {
        return this.rmmDownExc;
    }
}

