/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.auth.subjectx;

import com.ibm.sec.auth.subjectx.SubjectAttributesHandler;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public final class SubjectAttributes {
    public static final String USER_PRINCIPAL = "user";
    public static final String GROUP_PRINCIPAL = "group";
    public static final String APPLICATION_ROLE = "application-role";
    public static final String JACC_SUBJECT_ATTRIBUTES_KEY = (class$com$ibm$sec$auth$subjectx$SubjectAttributes == null ? (class$com$ibm$sec$auth$subjectx$SubjectAttributes = SubjectAttributes.class$("com.ibm.sec.auth.subjectx.SubjectAttributes")) : class$com$ibm$sec$auth$subjectx$SubjectAttributes).getName() + ".container";
    private final Map handlerMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$ibm$sec$auth$subjectx$SubjectAttributes;

    public SubjectAttributes() {
        this.registerHandler(USER_PRINCIPAL, new DefaultSubjectAttributesHandlerImpl(), true);
    }

    public Object getAttribute(Subject subject, String string) {
        SubjectAttributesHandler subjectAttributesHandler = (SubjectAttributesHandler)this.handlerMap.get(string);
        if (subjectAttributesHandler == null) {
            return null;
        }
        return subjectAttributesHandler.getAttribute(subject, string);
    }

    public void registerHandler(String string, SubjectAttributesHandler subjectAttributesHandler, boolean bl) {
        if (subjectAttributesHandler.supports(string)) {
            if (bl) {
                this.handlerMap.put(string, subjectAttributesHandler);
            } else {
                if (this.handlerMap.containsKey(string)) {
                    throw new IllegalArgumentException("handler exists");
                }
                this.handlerMap.put(string, subjectAttributesHandler);
            }
        } else {
            throw new IllegalArgumentException("handler does not support the attribute name");
        }
    }

    public Set getAttributeNames() {
        Set set = this.handlerMap.keySet();
        return Collections.unmodifiableSet(set);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DefaultSubjectAttributesHandlerImpl
    implements SubjectAttributesHandler {
        private static final String[] attributeNames = new String[]{"user"};

        DefaultSubjectAttributesHandlerImpl() {
        }

        public Object getAttribute(Subject subject, String string) {
            if (subject == null) {
                return null;
            }
            if (string.equals(SubjectAttributes.USER_PRINCIPAL)) {
                Set<Principal> set = subject.getPrincipals();
                if (set == null) {
                    return null;
                }
                if (set.size() == 1) {
                    return set.iterator().next();
                }
                return null;
            }
            return null;
        }

        public String[] getAttributeNames() {
            return attributeNames;
        }

        public boolean supports(String string) {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (!string.equals(attributeNames[i])) continue;
                return true;
            }
            return false;
        }
    }
}

