/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.auth.subjectx.SubjectAttributes;
import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.RequestContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import java.io.Serializable;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;

public final class AttributeName
implements Serializable {
    private static final long serialVersionUID = -833813027563453827L;
    private static final String SUBJECT_KEY = "javax.security.auth.Subject.container";
    public static final int SUBJECT = 1;
    public static final int REQUEST_CONTEXT = 2;
    public static final int RESOURCE_CONTEXT = 3;
    private final int source;
    private final String attributeName;

    public AttributeName(int n, String string) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("an invalid source identifier.");
        }
        this.source = n;
        this.attributeName = string;
    }

    public Object getAttribute(EvaluationContext evaluationContext) {
        try {
            switch (this.source) {
                case 1: {
                    Subject subject = (Subject)evaluationContext.getContext(SUBJECT_KEY);
                    SubjectAttributes subjectAttributes = (SubjectAttributes)evaluationContext.getContext(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY);
                    return subjectAttributes.getAttribute(subject, this.attributeName);
                }
                case 2: {
                    RequestContext requestContext = (RequestContext)evaluationContext.getContext(RequestContext.JACC_REQUEST_CONTEXT_KEY);
                    return requestContext.getAttribute(this.attributeName);
                }
                case 3: {
                    Resource resource = (Resource)evaluationContext.getContext(Resource.JACC_RESOURCE_KEY);
                    ResourceContext resourceContext = (ResourceContext)evaluationContext.getContext(ResourceContext.JACC_RESOURCE_CONTEXT_KEY);
                    return resourceContext.getAttribute(resource, this.attributeName, null);
                }
            }
            return null;
        }
        catch (PolicyContextException policyContextException) {
            return null;
        }
    }

    public int getSource() {
        return this.source;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.source) {
            case 1: {
                stringBuffer.append("SUBJECT: ");
                break;
            }
            case 2: {
                stringBuffer.append("REQUEST_CONTEXT: ");
                break;
            }
            case 3: {
                stringBuffer.append("RESOURCE_CONTEXT: ");
                break;
            }
            default: {
                return null;
            }
        }
        stringBuffer.append(this.attributeName);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeName) {
            AttributeName attributeName = (AttributeName)object;
            return this.source == attributeName.source && this.attributeName.equals(attributeName.attributeName);
        }
        return false;
    }

    public int hashCode() {
        return this.attributeName.hashCode() + this.source;
    }
}

