/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.condition.Condition;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public final class ComparisonCondition
implements Condition,
Serializable {
    private static final long serialVersionUID = 7425784315579164948L;
    private final int operator;
    private final AttributeName attributeName;
    private final AttributeName anotherAttributeName;
    private final Object value;
    public static final int EQUAL = 0;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int GREATER_THAN_OR_EQUAL = 3;
    public static final int LESS_THAN_OR_EQUAL = 4;

    public ComparisonCondition(int n, AttributeName attributeName, Object object) {
        this.operator = n;
        this.attributeName = attributeName;
        this.value = object;
        this.anotherAttributeName = null;
    }

    public ComparisonCondition(int n, AttributeName[] attributeNameArray) {
        this.operator = n;
        this.attributeName = attributeNameArray[0];
        this.value = null;
        this.anotherAttributeName = attributeNameArray[1];
    }

    public boolean evaluate(EvaluationContext evaluationContext) {
        Object object = this.attributeName.getAttribute(evaluationContext);
        if (this.operator != 0 && !(object instanceof Comparable)) {
            throw new RuntimeException(object + " does not implement the Comparable interface.");
        }
        if (this.value != null) {
            switch (this.operator) {
                case 0: {
                    return object.equals(this.value);
                }
                case 1: {
                    return ((Comparable)object).compareTo(this.value) > 0;
                }
                case 2: {
                    return ((Comparable)object).compareTo(this.value) < 0;
                }
                case 3: {
                    return ((Comparable)object).compareTo(this.value) >= 0;
                }
                case 4: {
                    return ((Comparable)object).compareTo(this.value) <= 0;
                }
            }
            return false;
        }
        Object object2 = this.anotherAttributeName.getAttribute(evaluationContext);
        switch (this.operator) {
            case 0: {
                return object.equals(object2);
            }
            case 1: {
                return ((Comparable)object).compareTo(object2) > 0;
            }
            case 2: {
                return ((Comparable)object).compareTo(object2) < 0;
            }
            case 3: {
                return ((Comparable)object).compareTo(object2) >= 0;
            }
            case 4: {
                return ((Comparable)object).compareTo(object2) <= 0;
            }
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(this.attributeName);
        switch (this.operator) {
            case 0: {
                stringBuffer.append(" =? ");
                break;
            }
            case 1: {
                stringBuffer.append(" >? ");
                break;
            }
            case 2: {
                stringBuffer.append(" <? ");
                break;
            }
            case 3: {
                stringBuffer.append(" >=? ");
                break;
            }
            case 4: {
                stringBuffer.append(" <=? ");
                break;
            }
            default: {
                return null;
            }
        }
        if (this.value != null) {
            stringBuffer.append(this.value);
        } else {
            stringBuffer.append(this.anotherAttributeName);
        }
        return stringBuffer.toString();
    }

    public int getOperator() {
        return this.operator;
    }

    public AttributeName getAttributeName() {
        return this.attributeName;
    }

    public AttributeName getAnotherAttributeName() {
        return this.anotherAttributeName;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof ComparisonCondition) {
            ComparisonCondition comparisonCondition = (ComparisonCondition)object;
            if (this.value != null) {
                return this.operator == comparisonCondition.operator && this.attributeName.equals(comparisonCondition.attributeName) && this.value.equals(comparisonCondition.value);
            }
            return this.operator == comparisonCondition.operator && this.attributeName.equals(comparisonCondition.attributeName) && this.anotherAttributeName.equals(comparisonCondition.anotherAttributeName);
        }
        return false;
    }

    public int hashCode() {
        if (this.value != null) {
            return this.operator + this.attributeName.hashCode() + this.value.hashCode();
        }
        return this.operator + this.attributeName.hashCode() + this.anotherAttributeName.hashCode();
    }

    public Set getReferencedAttributeNames() {
        HashSet<AttributeName> hashSet = new HashSet<AttributeName>();
        hashSet.add(this.attributeName);
        if (this.anotherAttributeName != null) {
            hashSet.add(this.anotherAttributeName);
        }
        return hashSet;
    }
}

