/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.PolicyContextWrapper;
import com.ibm.sec.authz.jaccx.condition.Condition;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Set;

public class ConditionalPermission
extends Permission {
    private static final long serialVersionUID = -7885551885203251875L;
    protected final Permission permission;
    protected final Condition condition;

    public ConditionalPermission(Permission permission, Condition condition) {
        super(permission.getName());
        if (permission instanceof ConditionalPermission) {
            throw new IllegalArgumentException("ConditionalPermission can not have a ConditionalPermission instance as the wrapped permission.");
        }
        this.permission = permission;
        this.condition = condition;
    }

    public boolean implies(Permission permission) {
        return this.implies(permission, PolicyContextWrapper.POLICY_CONTEXT);
    }

    public boolean implies(Permission permission, EvaluationContext evaluationContext) {
        return this.permission.implies(permission) && this.condition.evaluate(evaluationContext);
    }

    public final String getActions() {
        return this.permission.getActions();
    }

    public final Permission getWrappedPermission() {
        return this.permission;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionalPermission) {
            ConditionalPermission conditionalPermission = (ConditionalPermission)object;
            return this.permission.equals(conditionalPermission.permission) && ((Object)this.condition).equals(conditionalPermission.condition);
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("\nPermssion: ");
        stringBuffer.append(this.permission.toString());
        stringBuffer.append("\nCondition: ");
        stringBuffer.append(this.condition.toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.permission.hashCode() + ((Object)this.condition).hashCode();
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    public Set getReferencedAttributeNames() {
        return this.condition.getReferencedAttributeNames();
    }
}

