/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.condition.Condition;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ContainmentCondition
implements Condition,
Serializable {
    private static final long serialVersionUID = 1100218413807593280L;
    private final AttributeName attributeName;
    private final Object value;

    public ContainmentCondition(AttributeName attributeName, Object object) {
        this.attributeName = attributeName;
        this.value = object;
    }

    public boolean evaluate(EvaluationContext evaluationContext) {
        Object object = this.attributeName.getAttribute(evaluationContext);
        if (object instanceof Set) {
            return ((Set)object).contains(this.value);
        }
        return false;
    }

    public AttributeName getAttributeName() {
        return this.attributeName;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(this.attributeName);
        stringBuffer.append(" contains? ");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ContainmentCondition) {
            ContainmentCondition containmentCondition = (ContainmentCondition)object;
            return this.attributeName.equals(containmentCondition.attributeName) && this.value.equals(containmentCondition.value);
        }
        return false;
    }

    public int hashCode() {
        return this.attributeName.hashCode() + this.value.hashCode();
    }

    public Set getReferencedAttributeNames() {
        HashSet<AttributeName> hashSet = new HashSet<AttributeName>(1);
        hashSet.add(this.attributeName);
        return hashSet;
    }
}

